/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.gamma.transactions.lean;

import org.multiverse.stms.gamma.GammaStm;
import org.multiverse.stms.gamma.Listeners;
import org.multiverse.stms.gamma.transactionalobjects.BaseGammaTxnRef;
import org.multiverse.stms.gamma.transactionalobjects.Tranlocal;
import org.multiverse.stms.gamma.transactions.GammaTxn;
import org.multiverse.stms.gamma.transactions.GammaTxnConfig;
import org.multiverse.utils.Bugshaker;

public final class LeanMonoGammaTxn
extends GammaTxn {
    public final Tranlocal tranlocal = new Tranlocal();

    public LeanMonoGammaTxn(GammaStm stm) {
        this(new GammaTxnConfig(stm));
    }

    public LeanMonoGammaTxn(GammaTxnConfig config) {
        super(config, 1);
    }

    @Override
    public final Tranlocal locate(BaseGammaTxnRef o) {
        if (this.status != 1) {
            throw this.abortLocateOnBadStatus(o);
        }
        if (o == null) {
            throw this.abortLocateOnNullArgument();
        }
        return this.getRefTranlocal(o);
    }

    @Override
    public final void commit() {
        if (this.status == 4) {
            return;
        }
        if (this.status != 1 && this.status != 2) {
            throw this.abortCommitOnBadStatus();
        }
        BaseGammaTxnRef owner = this.tranlocal.owner;
        if (owner == null) {
            this.status = 4;
            return;
        }
        if (!this.hasWrites) {
            this.tranlocal.owner = null;
            this.tranlocal.ref_value = null;
            this.status = 4;
            return;
        }
        long version = this.tranlocal.version;
        if (this.status == 1) {
            if (owner.version != version) {
                throw this.abortOnReadWriteConflict(owner);
            }
            int arriveStatus = owner.arriveAndExclusiveLock(64);
            if (arriveStatus == 0) {
                throw this.abortOnReadWriteConflict(owner);
            }
            if (owner.version != version) {
                if ((arriveStatus & 2) == 0) {
                    owner.departAfterFailureAndUnlock();
                } else {
                    owner.unlockByUnregistered();
                }
                throw this.abortOnReadWriteConflict(owner);
            }
            if ((arriveStatus & 4) != 0) {
                this.commitConflict = true;
            }
        }
        if (this.commitConflict) {
            this.config.globalConflictCounter.signalConflict();
        }
        if (SHAKE_BUGS) {
            Bugshaker.shakeBugs();
        }
        owner.ref_value = this.tranlocal.ref_value;
        owner.version = version + 1L;
        Listeners listeners = owner.listeners;
        if (listeners != null) {
            listeners = owner.___removeListenersAfterWrite();
        }
        owner.departAfterUpdateAndUnlock();
        this.tranlocal.owner = null;
        this.tranlocal.ref_value = null;
        this.tranlocal.ref_oldValue = null;
        if (listeners != null) {
            listeners.openAll(this.pool);
        }
        this.status = 4;
    }

    @Override
    public final void abort() {
        if (this.status == 3) {
            return;
        }
        if (this.status == 4) {
            throw this.failAbortOnAlreadyCommitted();
        }
        this.status = 3;
        BaseGammaTxnRef owner = this.tranlocal.owner;
        if (owner != null) {
            owner.releaseAfterFailure(this.tranlocal, this.pool);
        }
    }

    @Override
    public final void prepare() {
        if (this.status == 2) {
            return;
        }
        if (this.status != 1) {
            throw this.abortPrepareOnBadStatus();
        }
        BaseGammaTxnRef owner = this.tranlocal.owner;
        if (owner != null && !owner.prepare(this, this.tranlocal)) {
            throw this.abortOnReadWriteConflict(owner);
        }
        this.status = 2;
    }

    @Override
    public final Tranlocal getRefTranlocal(BaseGammaTxnRef ref) {
        return this.tranlocal.owner == ref ? this.tranlocal : null;
    }

    @Override
    public final void retry() {
        if (this.status != 1) {
            throw this.abortRetryOnBadStatus();
        }
        if (!this.config.isBlockingAllowed()) {
            throw this.abortRetryOnNoBlockingAllowed();
        }
        if (this.tranlocal == null) {
            throw this.abortRetryOnNoRetryPossible();
        }
        BaseGammaTxnRef owner = this.tranlocal.owner;
        if (owner == null) {
            throw this.abortRetryOnNoRetryPossible();
        }
        this.retryListener.reset();
        long listenerEra = this.retryListener.getEra();
        boolean atLeastOneRegistration = false;
        switch (this.tranlocal.owner.registerChangeListener(this.retryListener, this.tranlocal, this.pool, listenerEra)) {
            case 0: {
                atLeastOneRegistration = true;
                break;
            }
            case 1: {
                atLeastOneRegistration = true;
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        owner.releaseAfterFailure(this.tranlocal, this.pool);
        this.status = 3;
        if (!atLeastOneRegistration) {
            throw this.abortRetryOnNoRetryPossible();
        }
        throw this.newRetryError();
    }

    @Override
    public final boolean softReset() {
        if (this.attempt >= this.config.getMaxRetries()) {
            return false;
        }
        this.commitConflict = false;
        this.status = 1;
        this.hasWrites = false;
        ++this.attempt;
        return true;
    }

    @Override
    public final void hardReset() {
        this.commitConflict = false;
        this.status = 1;
        this.hasWrites = false;
        this.remainingTimeoutNs = this.config.timeoutNs;
        this.attempt = 1;
    }

    @Override
    public final boolean isReadConsistent(Tranlocal justAdded) {
        return true;
    }

    @Override
    public void initLocalConflictCounter() {
    }
}

