/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

public final class Glyphs {
    public static final String NOTDEF = ".notdef";
    public static final String[] MAC_GLYPH_NAMES = new String[]{".notdef", ".null", "CR", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "Sigma", "Pi", "pi", "integral", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "Delta", "guillemotleft", "guillemotright", "ellipsis", "nbspace", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "applelogo", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "Lslash", "lslash", "Scaron", "scaron", "Zcaron", "zcaron", "brokenbar", "Eth", "eth", "Yacute", "yacute", "Thorn", "thorn", "minus", "multiply", "onesuperior", "twosuperior", "threesuperior", "onehalf", "onequarter", "threequarters", "franc", "Gbreve", "gbreve", "Idot", "Scedilla", "scedilla", "Cacute", "cacute", "Ccaron", "ccaron", "dmacron"};
    public static final String[] TEX8R_GLYPH_NAMES = new String[]{".notdef", "dotaccent", "fi", "fl", "fraction", "hungarumlaut", "Lslash", "lslash", "ogonek", "ring", ".notdef", "breve", "minus", ".notdef", "Zcaron", "zcaron", "caron", "dotlessi", "dotlessj", "ff", "ffi", "ffl", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", "grave", "quotesingle", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", ".notdef", "Euro", ".notdef", "quotesinglbase", "florin", "quotedblbase", "ellipsis", "dagger", "daggerdbl", "circumflex", "perthousand", "Scaron", "guilsinglleft", "OE", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", "quotedblleft", "quotedblright", "bullet", "endash", "emdash", "tilde", "trademark", "scaron", "guilsinglright", "oe", ".notdef", ".notdef", "Ydieresis", ".notdef", "exclamdown", "cent", "sterling", "currency", "yen", "brokenbar", "section", "dieresis", "copyright", "ordfeminine", "guillemotleft", "logicalnot", "hyphen", "registered", "macron", "degree", "plusminus", "twosuperior", "threesuperior", "acute", "mu", "paragraph", "periodcentered", "cedilla", "onesuperior", "ordmasculine", "guillemotright", "onequarter", "onehalf", "threequarters", "questiondown", "Agrave", "Aacute", "Acircumflex", "Atilde", "Adieresis", "Aring", "AE", "Ccedilla", "Egrave", "Eacute", "Ecircumflex", "Edieresis", "Igrave", "Iacute", "Icircumflex", "Idieresis", "Eth", "Ntilde", "Ograve", "Oacute", "Ocircumflex", "Otilde", "Odieresis", "multiply", "Oslash", "Ugrave", "Uacute", "Ucircumflex", "Udieresis", "Yacute", "Thorn", "germandbls", "agrave", "aacute", "acircumflex", "atilde", "adieresis", "aring", "ae", "ccedilla", "egrave", "eacute", "ecircumflex", "edieresis", "igrave", "iacute", "icircumflex", "idieresis", "eth", "ntilde", "ograve", "oacute", "ocircumflex", "otilde", "odieresis", "divide", "oslash", "ugrave", "uacute", "ucircumflex", "udieresis", "yacute", "thorn", "ydieresis"};
    public static final char[] WINANSI_ENCODING = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '\u2018', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u2022', '\u20ac', '\u2022', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0160', '\u2039', '\u0152', '\u2022', '\u017d', '\u2022', '\u2022', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '~', '\u2122', '\u0161', '\u203a', '\u0153', '\u2022', '\u017e', '\u0178', ' ', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};
    public static final String[] UNICODE_GLYPHS = new String[]{"A", "A", "\u00c6", "AE", "\u01fc", "AEacute", "\uf7e6", "AEsmall", "\u00c1", "Aacute", "\uf7e1", "Aacutesmall", "\u0102", "Abreve", "\u00c2", "Acircumflex", "\uf7e2", "Acircumflexsmall", "\uf6c9", "Acute", "\uf7b4", "Acutesmall", "\u00c4", "Adieresis", "\uf7e4", "Adieresissmall", "\u00c0", "Agrave", "\uf7e0", "Agravesmall", "\u0391", "Alpha", "\u0386", "Alphatonos", "\u0100", "Amacron", "\u0104", "Aogonek", "\u00c5", "Aring", "\u01fa", "Aringacute", "\uf7e5", "Aringsmall", "\uf761", "Asmall", "\u00c3", "Atilde", "\uf7e3", "Atildesmall", "B", "B", "\u0392", "Beta", "\uf6f4", "Brevesmall", "\uf762", "Bsmall", "C", "C", "\u0106", "Cacute", "\uf6ca", "Caron", "\uf6f5", "Caronsmall", "\u010c", "Ccaron", "\u00c7", "Ccedilla", "\uf7e7", "Ccedillasmall", "\u0108", "Ccircumflex", "\u010a", "Cdotaccent", "\uf7b8", "Cedillasmall", "\u03a7", "Chi", "\uf6f6", "Circumflexsmall", "\uf763", "Csmall", "D", "D", "\u010e", "Dcaron", "\u0110", "Dcroat", "\u2206", "Delta", "\u0394", "Delta", "\uf6cb", "Dieresis", "\uf6cc", "DieresisAcute", "\uf6cd", "DieresisGrave", "\uf7a8", "Dieresissmall", "\uf6f7", "Dotaccentsmall", "\uf764", "Dsmall", "E", "E", "\u00c9", "Eacute", "\uf7e9", "Eacutesmall", "\u0114", "Ebreve", "\u011a", "Ecaron", "\u00ca", "Ecircumflex", "\uf7ea", "Ecircumflexsmall", "\u00cb", "Edieresis", "\uf7eb", "Edieresissmall", "\u0116", "Edotaccent", "\u00c8", "Egrave", "\uf7e8", "Egravesmall", "\u0112", "Emacron", "\u014a", "Eng", "\u0118", "Eogonek", "\u0395", "Epsilon", "\u0388", "Epsilontonos", "\uf765", "Esmall", "\u0397", "Eta", "\u0389", "Etatonos", "\u00d0", "Eth", "\uf7f0", "Ethsmall", "\u20ac", "Euro", "F", "F", "\uf766", "Fsmall", "G", "G", "\u0393", "Gamma", "\u011e", "Gbreve", "\u01e6", "Gcaron", "\u011c", "Gcircumflex", "\u0122", "Gcommaaccent", "\u0120", "Gdotaccent", "\uf6ce", "Grave", "\uf760", "Gravesmall", "\uf767", "Gsmall", "H", "H", "\u25cf", "H18533", "\u25aa", "H18543", "\u25ab", "H18551", "\u25a1", "H22073", "\u0126", "Hbar", "\u0124", "Hcircumflex", "\uf768", "Hsmall", "\uf6cf", "Hungarumlaut", "\uf6f8", "Hungarumlautsmall", "I", "I", "\u0132", "IJ", "\u00cd", "Iacute", "\uf7ed", "Iacutesmall", "\u012c", "Ibreve", "\u00ce", "Icircumflex", "\uf7ee", "Icircumflexsmall", "\u00cf", "Idieresis", "\uf7ef", "Idieresissmall", "\u0130", "Idotaccent", "\u2111", "Ifraktur", "\u00cc", "Igrave", "\uf7ec", "Igravesmall", "\u012a", "Imacron", "\u012e", "Iogonek", "\u0399", "Iota", "\u03aa", "Iotadieresis", "\u038a", "Iotatonos", "\uf769", "Ismall", "\u0128", "Itilde", "J", "J", "\u0134", "Jcircumflex", "\uf76a", "Jsmall", "K", "K", "\u039a", "Kappa", "\u0136", "Kcommaaccent", "\uf76b", "Ksmall", "L", "L", "\uf6bf", "LL", "\u0139", "Lacute", "\u039b", "Lambda", "\u013d", "Lcaron", "\u013b", "Lcommaaccent", "\u013f", "Ldot", "\u0141", "Lslash", "\uf6f9", "Lslashsmall", "\uf76c", "Lsmall", "M", "M", "\uf6d0", "Macron", "\uf7af", "Macronsmall", "\uf76d", "Msmall", "\u039c", "Mu", "N", "N", "\u0143", "Nacute", "\u0147", "Ncaron", "\u0145", "Ncommaaccent", "\uf76e", "Nsmall", "\u00d1", "Ntilde", "\uf7f1", "Ntildesmall", "\u039d", "Nu", "O", "O", "\u0152", "OE", "\uf6fa", "OEsmall", "\u00d3", "Oacute", "\uf7f3", "Oacutesmall", "\u014e", "Obreve", "\u00d4", "Ocircumflex", "\uf7f4", "Ocircumflexsmall", "\u00d6", "Odieresis", "\uf7f6", "Odieresissmall", "\uf6fb", "Ogoneksmall", "\u00d2", "Ograve", "\uf7f2", "Ogravesmall", "\u01a0", "Ohorn", "\u0150", "Ohungarumlaut", "\u014c", "Omacron", "\u2126", "Omega", "\u03a9", "Omega", "\u038f", "Omegatonos", "\u039f", "Omicron", "\u038c", "Omicrontonos", "\u00d8", "Oslash", "\u01fe", "Oslashacute", "\uf7f8", "Oslashsmall", "\uf76f", "Osmall", "\u00d5", "Otilde", "\uf7f5", "Otildesmall", "P", "P", "\u03a6", "Phi", "\u03a0", "Pi", "\u03a8", "Psi", "\uf770", "Psmall", "Q", "Q", "\uf771", "Qsmall", "R", "R", "\u0154", "Racute", "\u0158", "Rcaron", "\u0156", "Rcommaaccent", "\u211c", "Rfraktur", "\u03a1", "Rho", "\uf6fc", "Ringsmall", "\uf772", "Rsmall", "S", "S", "\u250c", "SF010000", "\u2514", "SF020000", "\u2510", "SF030000", "\u2518", "SF040000", "\u253c", "SF050000", "\u252c", "SF060000", "\u2534", "SF070000", "\u251c", "SF080000", "\u2524", "SF090000", "\u2500", "SF100000", "\u2502", "SF110000", "\u2561", "SF190000", "\u2562", "SF200000", "\u2556", "SF210000", "\u2555", "SF220000", "\u2563", "SF230000", "\u2551", "SF240000", "\u2557", "SF250000", "\u255d", "SF260000", "\u255c", "SF270000", "\u255b", "SF280000", "\u255e", "SF360000", "\u255f", "SF370000", "\u255a", "SF380000", "\u2554", "SF390000", "\u2569", "SF400000", "\u2566", "SF410000", "\u2560", "SF420000", "\u2550", "SF430000", "\u256c", "SF440000", "\u2567", "SF450000", "\u2568", "SF460000", "\u2564", "SF470000", "\u2565", "SF480000", "\u2559", "SF490000", "\u2558", "SF500000", "\u2552", "SF510000", "\u2553", "SF520000", "\u256b", "SF530000", "\u256a", "SF540000", "\u015a", "Sacute", "\u0160", "Scaron", "\uf6fd", "Scaronsmall", "\u015e", "Scedilla", "\uf6c1", "Scedilla", "\u015c", "Scircumflex", "\u0218", "Scommaaccent", "\u03a3", "Sigma", "\uf773", "Ssmall", "T", "T", "\u03a4", "Tau", "\u0166", "Tbar", "\u0164", "Tcaron", "\u0162", "Tcommaaccent", "\u021a", "Tcommaaccent", "\u0398", "Theta", "\u00de", "Thorn", "\uf7fe", "Thornsmall", "\uf6fe", "Tildesmall", "\uf774", "Tsmall", "U", "U", "\u00da", "Uacute", "\uf7fa", "Uacutesmall", "\u016c", "Ubreve", "\u00db", "Ucircumflex", "\uf7fb", "Ucircumflexsmall", "\u00dc", "Udieresis", "\uf7fc", "Udieresissmall", "\u00d9", "Ugrave", "\uf7f9", "Ugravesmall", "\u01af", "Uhorn", "\u0170", "Uhungarumlaut", "\u016a", "Umacron", "\u0172", "Uogonek", "\u03a5", "Upsilon", "\u03d2", "Upsilon1", "\u03ab", "Upsilondieresis", "\u038e", "Upsilontonos", "\u016e", "Uring", "\uf775", "Usmall", "\u0168", "Utilde", "V", "V", "\uf776", "Vsmall", "W", "W", "\u1e82", "Wacute", "\u0174", "Wcircumflex", "\u1e84", "Wdieresis", "\u1e80", "Wgrave", "\uf777", "Wsmall", "X", "X", "\u039e", "Xi", "\uf778", "Xsmall", "Y", "Y", "\u00dd", "Yacute", "\uf7fd", "Yacutesmall", "\u0176", "Ycircumflex", "\u0178", "Ydieresis", "\uf7ff", "Ydieresissmall", "\u1ef2", "Ygrave", "\uf779", "Ysmall", "Z", "Z", "\u0179", "Zacute", "\u017d", "Zcaron", "\uf6ff", "Zcaronsmall", "\u017b", "Zdotaccent", "\u0396", "Zeta", "\uf77a", "Zsmall", "a", "a", "\u00e1", "aacute", "\u0103", "abreve", "\u00e2", "acircumflex", "\u00b4", "acute", "\u0301", "acutecomb", "\u00e4", "adieresis", "\u00e6", "ae", "\u01fd", "aeacute", "\u2015", "afii00208", "\u0410", "afii10017", "\u0411", "afii10018", "\u0412", "afii10019", "\u0413", "afii10020", "\u0414", "afii10021", "\u0415", "afii10022", "\u0401", "afii10023", "\u0416", "afii10024", "\u0417", "afii10025", "\u0418", "afii10026", "\u0419", "afii10027", "\u041a", "afii10028", "\u041b", "afii10029", "\u041c", "afii10030", "\u041d", "afii10031", "\u041e", "afii10032", "\u041f", "afii10033", "\u0420", "afii10034", "\u0421", "afii10035", "\u0422", "afii10036", "\u0423", "afii10037", "\u0424", "afii10038", "\u0425", "afii10039", "\u0426", "afii10040", "\u0427", "afii10041", "\u0428", "afii10042", "\u0429", "afii10043", "\u042a", "afii10044", "\u042b", "afii10045", "\u042c", "afii10046", "\u042d", "afii10047", "\u042e", "afii10048", "\u042f", "afii10049", "\u0490", "afii10050", "\u0402", "afii10051", "\u0403", "afii10052", "\u0404", "afii10053", "\u0405", "afii10054", "\u0406", "afii10055", "\u0407", "afii10056", "\u0408", "afii10057", "\u0409", "afii10058", "\u040a", "afii10059", "\u040b", "afii10060", "\u040c", "afii10061", "\u040e", "afii10062", "\uf6c4", "afii10063", "\uf6c5", "afii10064", "\u0430", "afii10065", "\u0431", "afii10066", "\u0432", "afii10067", "\u0433", "afii10068", "\u0434", "afii10069", "\u0435", "afii10070", "\u0451", "afii10071", "\u0436", "afii10072", "\u0437", "afii10073", "\u0438", "afii10074", "\u0439", "afii10075", "\u043a", "afii10076", "\u043b", "afii10077", "\u043c", "afii10078", "\u043d", "afii10079", "\u043e", "afii10080", "\u043f", "afii10081", "\u0440", "afii10082", "\u0441", "afii10083", "\u0442", "afii10084", "\u0443", "afii10085", "\u0444", "afii10086", "\u0445", "afii10087", "\u0446", "afii10088", "\u0447", "afii10089", "\u0448", "afii10090", "\u0449", "afii10091", "\u044a", "afii10092", "\u044b", "afii10093", "\u044c", "afii10094", "\u044d", "afii10095", "\u044e", "afii10096", "\u044f", "afii10097", "\u0491", "afii10098", "\u0452", "afii10099", "\u0453", "afii10100", "\u0454", "afii10101", "\u0455", "afii10102", "\u0456", "afii10103", "\u0457", "afii10104", "\u0458", "afii10105", "\u0459", "afii10106", "\u045a", "afii10107", "\u045b", "afii10108", "\u045c", "afii10109", "\u045e", "afii10110", "\u040f", "afii10145", "\u0462", "afii10146", "\u0472", "afii10147", "\u0474", "afii10148", "\uf6c6", "afii10192", "\u045f", "afii10193", "\u0463", "afii10194", "\u0473", "afii10195", "\u0475", "afii10196", "\uf6c7", "afii10831", "\uf6c8", "afii10832", "\u04d9", "afii10846", "\u200e", "afii299", "\u200f", "afii300", "\u200d", "afii301", "\u066a", "afii57381", "\u060c", "afii57388", "\u0660", "afii57392", "\u0661", "afii57393", "\u0662", "afii57394", "\u0663", "afii57395", "\u0664", "afii57396", "\u0665", "afii57397", "\u0666", "afii57398", "\u0667", "afii57399", "\u0668", "afii57400", "\u0669", "afii57401", "\u061b", "afii57403", "\u061f", "afii57407", "\u0621", "afii57409", "\u0622", "afii57410", "\u0623", "afii57411", "\u0624", "afii57412", "\u0625", "afii57413", "\u0626", "afii57414", "\u0627", "afii57415", "\u0628", "afii57416", "\u0629", "afii57417", "\u062a", "afii57418", "\u062b", "afii57419", "\u062c", "afii57420", "\u062d", "afii57421", "\u062e", "afii57422", "\u062f", "afii57423", "\u0630", "afii57424", "\u0631", "afii57425", "\u0632", "afii57426", "\u0633", "afii57427", "\u0634", "afii57428", "\u0635", "afii57429", "\u0636", "afii57430", "\u0637", "afii57431", "\u0638", "afii57432", "\u0639", "afii57433", "\u063a", "afii57434", "\u0640", "afii57440", "\u0641", "afii57441", "\u0642", "afii57442", "\u0643", "afii57443", "\u0644", "afii57444", "\u0645", "afii57445", "\u0646", "afii57446", "\u0648", "afii57448", "\u0649", "afii57449", "\u064a", "afii57450", "\u064b", "afii57451", "\u064c", "afii57452", "\u064d", "afii57453", "\u064e", "afii57454", "\u064f", "afii57455", "\u0650", "afii57456", "\u0651", "afii57457", "\u0652", "afii57458", "\u0647", "afii57470", "\u06a4", "afii57505", "\u067e", "afii57506", "\u0686", "afii57507", "\u0698", "afii57508", "\u06af", "afii57509", "\u0679", "afii57511", "\u0688", "afii57512", "\u0691", "afii57513", "\u06ba", "afii57514", "\u06d2", "afii57519", "\u06d5", "afii57534", "\u20aa", "afii57636", "\u05be", "afii57645", "\u05c3", "afii57658", "\u05d0", "afii57664", "\u05d1", "afii57665", "\u05d2", "afii57666", "\u05d3", "afii57667", "\u05d4", "afii57668", "\u05d5", "afii57669", "\u05d6", "afii57670", "\u05d7", "afii57671", "\u05d8", "afii57672", "\u05d9", "afii57673", "\u05da", "afii57674", "\u05db", "afii57675", "\u05dc", "afii57676", "\u05dd", "afii57677", "\u05de", "afii57678", "\u05df", "afii57679", "\u05e0", "afii57680", "\u05e1", "afii57681", "\u05e2", "afii57682", "\u05e3", "afii57683", "\u05e4", "afii57684", "\u05e5", "afii57685", "\u05e6", "afii57686", "\u05e7", "afii57687", "\u05e8", "afii57688", "\u05e9", "afii57689", "\u05ea", "afii57690", "\ufb2a", "afii57694", "\ufb2b", "afii57695", "\ufb4b", "afii57700", "\ufb1f", "afii57705", "\u05f0", "afii57716", "\u05f1", "afii57717", "\u05f2", "afii57718", "\ufb35", "afii57723", "\u05b4", "afii57793", "\u05b5", "afii57794", "\u05b6", "afii57795", "\u05bb", "afii57796", "\u05b8", "afii57797", "\u05b7", "afii57798", "\u05b0", "afii57799", "\u05b2", "afii57800", "\u05b1", "afii57801", "\u05b3", "afii57802", "\u05c2", "afii57803", "\u05c1", "afii57804", "\u05b9", "afii57806", "\u05bc", "afii57807", "\u05bd", "afii57839", "\u05bf", "afii57841", "\u05c0", "afii57842", "\u02bc", "afii57929", "\u2105", "afii61248", "\u2113", "afii61289", "\u2116", "afii61352", "\u202c", "afii61573", "\u202d", "afii61574", "\u202e", "afii61575", "\u200c", "afii61664", "\u066d", "afii63167", "\u02bd", "afii64937", "\u00e0", "agrave", "\u2135", "aleph", "\u03b1", "alpha", "\u03ac", "alphatonos", "\u0101", "amacron", "&", "ampersand", "\uf726", "ampersandsmall", "\u2220", "angle", "\u2329", "angleleft", "\u232a", "angleright", "\u0387", "anoteleia", "\u0105", "aogonek", "\u2248", "approxequal", "\u00e5", "aring", "\u01fb", "aringacute", "\u2194", "arrowboth", "\u21d4", "arrowdblboth", "\u21d3", "arrowdbldown", "\u21d0", "arrowdblleft", "\u21d2", "arrowdblright", "\u21d1", "arrowdblup", "\u2193", "arrowdown", "\uf8e7", "arrowhorizex", "\u2190", "arrowleft", "\u2192", "arrowright", "\u2191", "arrowup", "\u2195", "arrowupdn", "\u21a8", "arrowupdnbse", "\uf8e6", "arrowvertex", "^", "asciicircum", "~", "asciitilde", "*", "asterisk", "\u2217", "asteriskmath", "\uf6e9", "asuperior", "@", "at", "\u00e3", "atilde", "b", "b", "\\", "backslash", "|", "bar", "\u03b2", "beta", "\u2588", "block", "\uf8f4", "braceex", "{", "braceleft", "\uf8f3", "braceleftbt", "\uf8f2", "braceleftmid", "\uf8f1", "bracelefttp", "}", "braceright", "\uf8fe", "bracerightbt", "\uf8fd", "bracerightmid", "\uf8fc", "bracerighttp", "[", "bracketleft", "\uf8f0", "bracketleftbt", "\uf8ef", "bracketleftex", "\uf8ee", "bracketlefttp", "]", "bracketright", "\uf8fb", "bracketrightbt", "\uf8fa", "bracketrightex", "\uf8f9", "bracketrighttp", "\u02d8", "breve", "\u00a6", "brokenbar", "\uf6ea", "bsuperior", "\u2022", "bullet", "c", "c", "\u0107", "cacute", "\u02c7", "caron", "\u21b5", "carriagereturn", "\u010d", "ccaron", "\u00e7", "ccedilla", "\u0109", "ccircumflex", "\u010b", "cdotaccent", "\u00b8", "cedilla", "\u00a2", "cent", "\uf6df", "centinferior", "\uf7a2", "centoldstyle", "\uf6e0", "centsuperior", "\u03c7", "chi", "\u25cb", "circle", "\u2297", "circlemultiply", "\u2295", "circleplus", "\u02c6", "circumflex", "\u2663", "club", ":", "colon", "\u20a1", "colonmonetary", ",", "comma", "\uf6c3", "commaaccent", "\uf6e1", "commainferior", "\uf6e2", "commasuperior", "\u2245", "congruent", "\u00a9", "copyright", "\uf8e9", "copyrightsans", "\uf6d9", "copyrightserif", "\u00a4", "currency", "\uf6d1", "cyrBreve", "\uf6d2", "cyrFlex", "\uf6d4", "cyrbreve", "\uf6d5", "cyrflex", "d", "d", "\u2020", "dagger", "\u2021", "daggerdbl", "\uf6d3", "dblGrave", "\uf6d6", "dblgrave", "\u010f", "dcaron", "\u0111", "dcroat", "\u00b0", "degree", "\u03b4", "delta", "\u2666", "diamond", "\u00a8", "dieresis", "\uf6d7", "dieresisacute", "\uf6d8", "dieresisgrave", "\u0385", "dieresistonos", "\u00f7", "divide", "\u2593", "dkshade", "\u2584", "dnblock", "$", "dollar", "\uf6e3", "dollarinferior", "\uf724", "dollaroldstyle", "\uf6e4", "dollarsuperior", "\u20ab", "dong", "\u02d9", "dotaccent", "\u0323", "dotbelowcomb", "\u0131", "dotlessi", "\uf6be", "dotlessj", "\u22c5", "dotmath", "\uf6eb", "dsuperior", "e", "e", "\u00e9", "eacute", "\u0115", "ebreve", "\u011b", "ecaron", "\u00ea", "ecircumflex", "\u00eb", "edieresis", "\u0117", "edotaccent", "\u00e8", "egrave", "8", "eight", "\u2088", "eightinferior", "\uf738", "eightoldstyle", "\u2078", "eightsuperior", "\u2208", "element", "\u2026", "ellipsis", "\u0113", "emacron", "\u2014", "emdash", "\u2205", "emptyset", "\u2013", "endash", "\u014b", "eng", "\u0119", "eogonek", "\u03b5", "epsilon", "\u03ad", "epsilontonos", "=", "equal", "\u2261", "equivalence", "\u212e", "estimated", "\uf6ec", "esuperior", "\u03b7", "eta", "\u03ae", "etatonos", "\u00f0", "eth", "!", "exclam", "\u203c", "exclamdbl", "\u00a1", "exclamdown", "\uf7a1", "exclamdownsmall", "\uf721", "exclamsmall", "\u2203", "existential", "f", "f", "\u2640", "female", "\ufb00", "ff", "\ufb03", "ffi", "\ufb04", "ffl", "\ufb01", "fi", "\u2012", "figuredash", "\u25a0", "filledbox", "\u25ac", "filledrect", "5", "five", "\u215d", "fiveeighths", "\u2085", "fiveinferior", "\uf735", "fiveoldstyle", "\u2075", "fivesuperior", "\ufb02", "fl", "\u0192", "florin", "4", "four", "\u2084", "fourinferior", "\uf734", "fouroldstyle", "\u2074", "foursuperior", "\u2044", "fraction", "\u2215", "fraction", "\u20a3", "franc", "g", "g", "\u03b3", "gamma", "\u011f", "gbreve", "\u01e7", "gcaron", "\u011d", "gcircumflex", "\u0123", "gcommaaccent", "\u0121", "gdotaccent", "\u00df", "germandbls", "\u2207", "gradient", "`", "grave", "\u0300", "gravecomb", ">", "greater", "\u2265", "greaterequal", "\u00ab", "guillemotleft", "\u00bb", "guillemotright", "\u2039", "guilsinglleft", "\u203a", "guilsinglright", "h", "h", "\u0127", "hbar", "\u0125", "hcircumflex", "\u2665", "heart", "\u0309", "hookabovecomb", "\u2302", "house", "\u02dd", "hungarumlaut", "-", "hyphen", "\u00ad", "hyphen", "\uf6e5", "hypheninferior", "\uf6e6", "hyphensuperior", "i", "i", "\u00ed", "iacute", "\u012d", "ibreve", "\u00ee", "icircumflex", "\u00ef", "idieresis", "\u00ec", "igrave", "\u0133", "ij", "\u012b", "imacron", "\u221e", "infinity", "\u222b", "integral", "\u2321", "integralbt", "\uf8f5", "integralex", "\u2320", "integraltp", "\u2229", "intersection", "\u25d8", "invbullet", "\u25d9", "invcircle", "\u263b", "invsmileface", "\u012f", "iogonek", "\u03b9", "iota", "\u03ca", "iotadieresis", "\u0390", "iotadieresistonos", "\u03af", "iotatonos", "\uf6ed", "isuperior", "\u0129", "itilde", "j", "j", "\u0135", "jcircumflex", "k", "k", "\u03ba", "kappa", "\u0137", "kcommaaccent", "\u0138", "kgreenlandic", "l", "l", "\u013a", "lacute", "\u03bb", "lambda", "\u013e", "lcaron", "\u013c", "lcommaaccent", "\u0140", "ldot", "<", "less", "\u2264", "lessequal", "\u258c", "lfblock", "\u20a4", "lira", "\uf6c0", "ll", "\u2227", "logicaland", "\u00ac", "logicalnot", "\u2228", "logicalor", "\u017f", "longs", "\u25ca", "lozenge", "\u0142", "lslash", "\uf6ee", "lsuperior", "\u2591", "ltshade", "m", "m", "\u00af", "macron", "\u02c9", "macron", "\u2642", "male", "\u2212", "minus", "\u2032", "minute", "\uf6ef", "msuperior", "\u00b5", "mu", "\u03bc", "mu", "\u00d7", "multiply", "\u266a", "musicalnote", "\u266b", "musicalnotedbl", "n", "n", "\u0144", "nacute", "\u0149", "napostrophe", "\u0148", "ncaron", "\u0146", "ncommaaccent", "9", "nine", "\u2089", "nineinferior", "\uf739", "nineoldstyle", "\u2079", "ninesuperior", "\u2209", "notelement", "\u2260", "notequal", "\u2284", "notsubset", "\u207f", "nsuperior", "\u00f1", "ntilde", "\u03bd", "nu", "#", "numbersign", "o", "o", "\u00f3", "oacute", "\u014f", "obreve", "\u00f4", "ocircumflex", "\u00f6", "odieresis", "\u0153", "oe", "\u02db", "ogonek", "\u00f2", "ograve", "\u01a1", "ohorn", "\u0151", "ohungarumlaut", "\u014d", "omacron", "\u03c9", "omega", "\u03d6", "omega1", "\u03ce", "omegatonos", "\u03bf", "omicron", "\u03cc", "omicrontonos", "1", "one", "\u2024", "onedotenleader", "\u215b", "oneeighth", "\uf6dc", "onefitted", "\u00bd", "onehalf", "\u2081", "oneinferior", "\uf731", "oneoldstyle", "\u00bc", "onequarter", "\u00b9", "onesuperior", "\u2153", "onethird", "\u25e6", "openbullet", "\u00aa", "ordfeminine", "\u00ba", "ordmasculine", "\u221f", "orthogonal", "\u00f8", "oslash", "\u01ff", "oslashacute", "\uf6f0", "osuperior", "\u00f5", "otilde", "p", "p", "\u00b6", "paragraph", "(", "parenleft", "\uf8ed", "parenleftbt", "\uf8ec", "parenleftex", "\u208d", "parenleftinferior", "\u207d", "parenleftsuperior", "\uf8eb", "parenlefttp", ")", "parenright", "\uf8f8", "parenrightbt", "\uf8f7", "parenrightex", "\u208e", "parenrightinferior", "\u207e", "parenrightsuperior", "\uf8f6", "parenrighttp", "\u2202", "partialdiff", "%", "percent", ".", "period", "\u00b7", "periodcentered", "\u2219", "periodcentered", "\uf6e7", "periodinferior", "\uf6e8", "periodsuperior", "\u22a5", "perpendicular", "\u2030", "perthousand", "\u20a7", "peseta", "\u03c6", "phi", "\u03d5", "phi1", "\u03c0", "pi", "+", "plus", "\u00b1", "plusminus", "\u211e", "prescription", "\u220f", "product", "\u2282", "propersubset", "\u2283", "propersuperset", "\u221d", "proportional", "\u03c8", "psi", "q", "q", "?", "question", "\u00bf", "questiondown", "\uf7bf", "questiondownsmall", "\uf73f", "questionsmall", "\"", "quotedbl", "\u201e", "quotedblbase", "\u201c", "quotedblleft", "\u201d", "quotedblright", "\u2018", "quoteleft", "\u201b", "quotereversed", "\u2019", "quoteright", "\u201a", "quotesinglbase", "'", "quotesingle", "r", "r", "\u0155", "racute", "\u221a", "radical", "\uf8e5", "radicalex", "\u0159", "rcaron", "\u0157", "rcommaaccent", "\u2286", "reflexsubset", "\u2287", "reflexsuperset", "\u00ae", "registered", "\uf8e8", "registersans", "\uf6da", "registerserif", "\u2310", "revlogicalnot", "\u03c1", "rho", "\u02da", "ring", "\uf6f1", "rsuperior", "\u2590", "rtblock", "\uf6dd", "rupiah", "s", "s", "\u015b", "sacute", "\u0161", "scaron", "\u015f", "scedilla", "\uf6c2", "scedilla", "\u015d", "scircumflex", "\u0219", "scommaaccent", "\u2033", "second", "\u00a7", "section", ";", "semicolon", "7", "seven", "\u215e", "seveneighths", "\u2087", "seveninferior", "\uf737", "sevenoldstyle", "\u2077", "sevensuperior", "\u2592", "shade", "\u03c3", "sigma", "\u03c2", "sigma1", "\u223c", "similar", "6", "six", "\u2086", "sixinferior", "\uf736", "sixoldstyle", "\u2076", "sixsuperior", "/", "slash", "\u263a", "smileface", " ", "space", "\u00a0", "space", "\u2660", "spade", "\uf6f2", "ssuperior", "\u00a3", "sterling", "\u220b", "suchthat", "\u2211", "summation", "\u263c", "sun", "t", "t", "\u03c4", "tau", "\u0167", "tbar", "\u0165", "tcaron", "\u0163", "tcommaaccent", "\u021b", "tcommaaccent", "\u2234", "therefore", "\u03b8", "theta", "\u03d1", "theta1", "\u00fe", "thorn", "3", "three", "\u215c", "threeeighths", "\u2083", "threeinferior", "\uf733", "threeoldstyle", "\u00be", "threequarters", "\uf6de", "threequartersemdash", "\u00b3", "threesuperior", "\u02dc", "tilde", "\u0303", "tildecomb", "\u0384", "tonos", "\u2122", "trademark", "\uf8ea", "trademarksans", "\uf6db", "trademarkserif", "\u25bc", "triagdn", "\u25c4", "triaglf", "\u25ba", "triagrt", "\u25b2", "triagup", "\uf6f3", "tsuperior", "2", "two", "\u2025", "twodotenleader", "\u2082", "twoinferior", "\uf732", "twooldstyle", "\u00b2", "twosuperior", "\u2154", "twothirds", "u", "u", "\u00fa", "uacute", "\u016d", "ubreve", "\u00fb", "ucircumflex", "\u00fc", "udieresis", "\u00f9", "ugrave", "\u01b0", "uhorn", "\u0171", "uhungarumlaut", "\u016b", "umacron", "_", "underscore", "\u2017", "underscoredbl", "\u222a", "union", "\u2200", "universal", "\u0173", "uogonek", "\u2580", "upblock", "\u03c5", "upsilon", "\u03cb", "upsilondieresis", "\u03b0", "upsilondieresistonos", "\u03cd", "upsilontonos", "\u016f", "uring", "\u0169", "utilde", "v", "v", "w", "w", "\u1e83", "wacute", "\u0175", "wcircumflex", "\u1e85", "wdieresis", "\u2118", "weierstrass", "\u1e81", "wgrave", "x", "x", "\u03be", "xi", "y", "y", "\u00fd", "yacute", "\u0177", "ycircumflex", "\u00ff", "ydieresis", "\u00a5", "yen", "\u1ef3", "ygrave", "z", "z", "\u017a", "zacute", "\u017e", "zcaron", "\u017c", "zdotaccent", "0", "zero", "\u2080", "zeroinferior", "\uf730", "zerooldstyle", "\u2070", "zerosuperior", "\u03b6", "zeta"};

    private Glyphs() {
    }

    public static String charToGlyphName(char ch) {
        return Glyphs.stringToGlyph(Character.toString(ch));
    }

    public static String glyphToString(String name) {
        for (int i = 0; i < UNICODE_GLYPHS.length; i += 2) {
            if (!UNICODE_GLYPHS[i + 1].equals(name)) continue;
            return UNICODE_GLYPHS[i];
        }
        return "";
    }

    public static String stringToGlyph(String name) {
        for (int i = 0; i < UNICODE_GLYPHS.length; i += 2) {
            if (!UNICODE_GLYPHS[i].equals(name)) continue;
            return UNICODE_GLYPHS[i + 1];
        }
        return "";
    }
}

