/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.molxyz;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class XyzReader
extends AtomSetCollectionReader {
    @Override
    protected boolean checkLine() throws Exception {
        int modelAtomCount = this.parseIntStr(this.line);
        if (modelAtomCount == Integer.MIN_VALUE) {
            this.continuing = false;
            return false;
        }
        this.vibrationNumber = ++this.modelNumber;
        if (this.desiredVibrationNumber <= 0 ? this.doGetModel(this.modelNumber, null) : this.doGetVibration(this.vibrationNumber)) {
            this.rd();
            this.checkCurrentLineForScript();
            this.asc.newAtomSet();
            String name = this.line.trim();
            this.readAtoms(modelAtomCount);
            this.applySymmetryAndSetTrajectory();
            this.asc.setAtomSetName(name);
            if (this.isLastModel(this.modelNumber)) {
                this.continuing = false;
                return false;
            }
        } else {
            this.skipAtomSet(modelAtomCount);
        }
        this.discardLinesUntilNonBlank();
        return false;
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.isTrajectory = false;
        this.finalizeReaderASCR();
    }

    private void skipAtomSet(int modelAtomCount) throws Exception {
        this.rd();
        int i = modelAtomCount;
        while (--i >= 0) {
            this.rd();
        }
    }

    private void readAtoms(int modelAtomCount) throws Exception {
        block9: for (int i = 0; i < modelAtomCount; ++i) {
            this.rd();
            String[] tokens = this.getTokens();
            if (tokens.length < 4) {
                Logger.warn("line cannot be read for XYZ atom data: " + this.line);
                continue;
            }
            Atom atom = this.addAtomXYZSymName(tokens, 1, null, null);
            this.setElementAndIsotope(atom, tokens[0]);
            int vpt = 4;
            switch (tokens.length) {
                case 4: {
                    continue block9;
                }
                case 5: 
                case 6: 
                case 8: 
                case 9: {
                    if (tokens[4].indexOf(".") >= 0) {
                        atom.partialCharge = this.parseFloatStr(tokens[4]);
                    } else {
                        int charge = this.parseIntStr(tokens[4]);
                        if (charge != Integer.MIN_VALUE) {
                            atom.formalCharge = charge;
                        }
                    }
                    switch (tokens.length) {
                        case 5: {
                            continue block9;
                        }
                        case 6: {
                            atom.radius = this.parseFloatStr(tokens[5]);
                            continue block9;
                        }
                        case 9: {
                            atom.atomSerial = this.parseIntStr(tokens[8]);
                        }
                    }
                }
                default: {
                    int n = ++vpt;
                    float vx = this.parseFloatStr(tokens[n]);
                    int n2 = ++vpt;
                    float vy = this.parseFloatStr(tokens[n2]);
                    int n3 = ++vpt;
                    ++vpt;
                    float vz = this.parseFloatStr(tokens[n3]);
                    if (Float.isNaN(vx) || Float.isNaN(vy) || Float.isNaN(vz)) continue block9;
                    this.asc.addVibrationVector(atom.index, vx, vy, vz);
                }
            }
        }
    }
}

