/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jnati;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import net.sf.jnati.SystemType;

public class SystemTyper {
    private static final String DEFAULT_FILENAME = "META-INF/jnati/system.txt";
    private static final SystemTyper DEFAULT_INSTANCE = new SystemTyper("META-INF/jnati/system.txt");
    private final String filename;

    public SystemTyper(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("Null argument: filename");
        }
        this.filename = filename;
    }

    public static SystemTyper getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public SystemType detectPlatform() throws IOException {
        SystemType platform;
        Enumeration<URL> enumeration = SystemType.class.getClassLoader().getResources(this.filename);
        for (URL url : Collections.list(enumeration)) {
            SystemType platform2 = this.detectPlatfrom(url);
            if (platform2 == null) continue;
            return platform2;
        }
        File file = new File(this.filename);
        if (file.isFile() && (platform = this.detectPlatfrom(file.toURL())) != null) {
            return platform;
        }
        return SystemType.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SystemType detectPlatfrom(URL url) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
        try {
            String platform = null;
            boolean matches = false;
            String line = in.readLine();
            while (line != null) {
                if ((line = line.trim()).length() == 0) {
                    if (matches) {
                        SystemType systemType = SystemType.get(platform);
                        return systemType;
                    }
                    platform = null;
                } else if (line.charAt(0) != '#') {
                    if (platform == null) {
                        platform = line;
                        matches = true;
                    } else if (matches) {
                        if (line.startsWith("file:")) {
                            boolean dir;
                            String filename = line.substring(5).trim();
                            boolean bl = dir = filename.endsWith(File.separator) || filename.endsWith("/");
                            matches = dir ? (matches &= new File(filename).isDirectory()) : (matches &= new File(filename).isFile());
                        } else {
                            int i = line.indexOf(61);
                            if (i == -1) {
                                matches = false;
                                System.err.println();
                                System.err.println("WARNING: Ignoring bad definition in " + url.toString());
                                System.err.println("  Platform: " + platform);
                                System.err.println("  Line: " + line);
                                System.err.println();
                            } else {
                                String property = line.substring(0, i).trim();
                                String regex = line.substring(i + 1).trim();
                                String value = System.getProperty(property);
                                Pattern pattern = Pattern.compile(regex, 2);
                                matches = pattern.matcher(value).matches();
                            }
                        }
                    }
                }
                line = in.readLine();
            }
            if (matches) {
                SystemType systemType = SystemType.get(platform);
                return systemType;
            }
        }
        finally {
            in.close();
        }
        return null;
    }

    private static void debug() {
        System.err.println("Properties:");
        for (Map.Entry<Object, Object> e : new TreeMap<Object, Object>(System.getProperties()).entrySet()) {
            System.err.println("  " + e.getKey() + ": " + e.getValue());
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 1 && "-debug".equals(args[0])) {
            SystemTyper.debug();
        } else {
            System.out.println(SystemTyper.getDefaultInstance().detectPlatform().getName());
        }
    }
}

