/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.jvxl.api.MeshDataServer;
import org.jmol.jvxl.api.VertexDataServer;
import org.jmol.jvxl.calc.MarchingCubes;
import org.jmol.jvxl.calc.MarchingSquares;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.Parameters;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.quantum.QuantumPlaneCalculation;
import org.jmol.util.BoxInfo;
import org.jmol.util.C;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public abstract class SurfaceReader
implements VertexDataServer {
    protected SurfaceGenerator sg;
    protected MeshDataServer meshDataServer;
    protected Parameters params;
    protected MeshData meshData;
    protected JvxlData jvxlData;
    VolumeData volumeData;
    private String edgeData;
    protected boolean haveSurfaceAtoms = false;
    protected boolean allowSigma = false;
    protected boolean isProgressive = false;
    protected boolean isXLowToHigh = false;
    private float assocCutoff = 0.3f;
    protected boolean isQuiet;
    protected boolean isPeriodic;
    boolean vertexDataOnly;
    boolean hasColorData;
    protected float dataMin = Float.MAX_VALUE;
    protected float dataMax = -3.4028235E38f;
    protected float dataMean;
    protected P3 xyzMin;
    protected P3 xyzMax;
    protected P3 center;
    protected float[] anisotropy;
    protected boolean isAnisotropic;
    protected M3 eccentricityMatrix;
    protected M3 eccentricityMatrixInverse;
    protected boolean isEccentric;
    protected float eccentricityScale;
    protected float eccentricityRatio;
    static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    static final float defaultMappedDataMin = 0.0f;
    static final float defaultMappedDataMax = 1.0f;
    static final float defaultCutoff = 0.02f;
    private int edgeCount;
    protected P3 volumetricOrigin;
    protected V3[] volumetricVectors;
    protected int[] voxelCounts;
    protected float[][][] voxelData;
    protected long nBytes;
    protected int nDataPoints;
    protected int nPointsX;
    protected int nPointsY;
    protected int nPointsZ;
    protected boolean isJvxl;
    protected int edgeFractionBase;
    protected int edgeFractionRange;
    protected int colorFractionBase;
    protected int colorFractionRange;
    protected SB jvxlFileHeaderBuffer;
    protected SB fractionData;
    protected String jvxlEdgeDataRead = "";
    protected String jvxlColorDataRead = "";
    protected BS jvxlVoxelBitSet;
    protected boolean jvxlDataIsColorMapped;
    protected boolean jvxlDataIsPrecisionColor;
    protected boolean jvxlDataIs2dContour;
    protected boolean jvxlDataIsColorDensity;
    protected float jvxlCutoff;
    protected int jvxlNSurfaceInts;
    protected char cJvxlEdgeNaN = '\u0000';
    protected int contourVertexCount;
    protected MarchingSquares marchingSquares;
    protected MarchingCubes marchingCubes;
    protected float[][] yzPlanes;
    protected int yzCount;
    protected QuantumPlaneCalculation qpc;
    protected final P3 ptTemp = new P3();
    private static final String[] colorPhases = new String[]{"_orb", "x", "y", "z", "xy", "yz", "xz", "x2-y2", "z2"};
    protected float[] minMax;
    private boolean haveSetAnisotropy;

    SurfaceReader() {
    }

    abstract void init(SurfaceGenerator var1);

    void initSR(SurfaceGenerator sg) {
        this.sg = sg;
        this.params = sg.params;
        this.assocCutoff = this.params.assocCutoff;
        this.isXLowToHigh = this.params.isXLowToHigh;
        this.center = this.params.center;
        this.anisotropy = this.params.anisotropy;
        this.isAnisotropic = this.params.isAnisotropic;
        this.eccentricityMatrix = this.params.eccentricityMatrix;
        this.eccentricityMatrixInverse = this.params.eccentricityMatrixInverse;
        this.isEccentric = this.params.isEccentric;
        this.eccentricityScale = this.params.eccentricityScale;
        this.eccentricityRatio = this.params.eccentricityRatio;
        this.marchingSquares = sg.marchingSquares;
        this.meshData = sg.meshData;
        this.jvxlData = sg.jvxlData;
        this.setVolumeDataV(sg.volumeDataTemp);
        this.meshDataServer = sg.meshDataServer;
        this.cJvxlEdgeNaN = (char)125;
    }

    protected abstract void closeReader();

    protected void setOutputChannel(OC out) {
    }

    protected void newVoxelDataCube() {
        this.voxelData = new float[this.nPointsX][this.nPointsY][this.nPointsZ];
        this.volumeData.setVoxelDataAsArray(this.voxelData);
    }

    protected void setVolumeDataV(VolumeData v) {
        this.nBytes = 0L;
        this.volumetricOrigin = v.volumetricOrigin;
        this.volumetricVectors = v.volumetricVectors;
        this.voxelCounts = v.voxelCounts;
        this.voxelData = v.getVoxelData();
        this.volumeData = v;
    }

    protected abstract boolean readVolumeParameters(boolean var1);

    protected abstract boolean readVolumeData(boolean var1);

    void jvxlUpdateInfo() {
        this.jvxlData.jvxlUpdateInfo(this.params.title, this.nBytes);
    }

    boolean readAndSetVolumeParameters(boolean isMapData) {
        if (!this.readVolumeParameters(isMapData)) {
            return false;
        }
        if (this.vertexDataOnly) {
            return true;
        }
        return this.volumeData.setUnitVectors();
    }

    boolean createIsosurface(boolean justForPlane) {
        this.resetIsosurface();
        if (this.params.showTiming) {
            Logger.startTimer("isosurface creation");
        }
        this.jvxlData.cutoff = Float.NaN;
        if (!this.readAndSetVolumeParameters(justForPlane)) {
            return false;
        }
        if (!(justForPlane || Float.isNaN(this.params.sigma) || this.allowSigma)) {
            if (this.params.sigma > 0.0f) {
                Logger.error("Reader does not support SIGMA option -- using cutoff 1.6");
            }
            this.params.cutoff = 1.6f;
        }
        if (this.params.sigma < 0.0f) {
            this.params.sigma = -this.params.sigma;
        }
        this.nPointsX = this.voxelCounts[0];
        this.nPointsY = this.voxelCounts[1];
        this.nPointsZ = this.voxelCounts[2];
        this.jvxlData.isSlabbable = (this.params.dataType & 0x400) != 0;
        this.jvxlData.insideOut = this.params.isInsideOut();
        this.jvxlData.isBicolorMap = this.params.isBicolorMap;
        this.jvxlData.nPointsX = this.nPointsX;
        this.jvxlData.nPointsY = this.nPointsY;
        this.jvxlData.nPointsZ = this.nPointsZ;
        this.jvxlData.jvxlVolumeDataXml = this.volumeData.xmlData;
        this.jvxlData.voxelVolume = this.volumeData.voxelVolume;
        if (justForPlane) {
            this.volumeData.setMappingPlane(this.params.thePlane);
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 1, null);
            }
            this.params.setMapRanges(this, false);
            this.generateSurfaceData();
            this.volumeData.setMappingPlane(null);
        } else {
            if (!this.readVolumeData(false)) {
                return false;
            }
            this.generateSurfaceData();
        }
        if (this.jvxlFileHeaderBuffer == null) {
            this.jvxlData.jvxlFileTitle = "";
            this.jvxlData.jvxlFileSource = null;
            this.jvxlData.jvxlFileMessage = null;
        } else {
            String s = this.jvxlFileHeaderBuffer.toString();
            int i = s.indexOf(10, s.indexOf(10, s.indexOf(10) + 1) + 1) + 1;
            this.jvxlData.jvxlFileTitle = s.substring(0, i);
            this.jvxlData.jvxlFileSource = this.params.fileName;
        }
        if (this.params.contactPair == null) {
            this.setBBoxAll();
        }
        boolean bl = this.jvxlData.isValid = this.xyzMin.x != Float.MAX_VALUE;
        if (!this.params.isSilent) {
            if (!this.jvxlData.isValid) {
                Logger.error("no isosurface points were found!");
            } else {
                Logger.info("boundbox corners " + Escape.eP(this.xyzMin) + " " + Escape.eP(this.xyzMax));
            }
        }
        this.jvxlData.boundingBox = new P3[]{this.xyzMin, this.xyzMax};
        this.jvxlData.dataMin = this.dataMin;
        this.jvxlData.dataMax = this.dataMax;
        this.jvxlData.cutoff = this.isJvxl ? this.jvxlCutoff : this.params.cutoff;
        this.jvxlData.isCutoffAbsolute = this.params.isCutoffAbsolute;
        this.jvxlData.isModelConnected = this.params.isModelConnected;
        this.jvxlData.pointsPerAngstrom = 1.0f / this.volumeData.volumetricVectorLengths[0];
        this.jvxlData.jvxlColorData = "";
        this.jvxlData.jvxlPlane = this.params.thePlane;
        this.jvxlData.jvxlEdgeData = this.edgeData;
        this.jvxlData.isBicolorMap = this.params.isBicolorMap;
        this.jvxlData.isContoured = this.params.isContoured;
        this.jvxlData.colorDensity = this.params.colorDensity;
        this.jvxlData.pointSize = this.params.pointSize;
        if (this.jvxlData.vContours != null) {
            this.params.nContours = this.jvxlData.vContours.length;
        }
        this.jvxlData.nContours = this.params.contourFromZero ? this.params.nContours : -1 - this.params.nContours;
        this.jvxlData.thisContour = this.params.thisContour;
        this.jvxlData.nEdges = this.edgeCount;
        this.jvxlData.edgeFractionBase = this.edgeFractionBase;
        this.jvxlData.edgeFractionRange = this.edgeFractionRange;
        this.jvxlData.colorFractionBase = this.colorFractionBase;
        this.jvxlData.colorFractionRange = this.colorFractionRange;
        this.jvxlData.jvxlDataIs2dContour = this.jvxlDataIs2dContour;
        this.jvxlData.jvxlDataIsColorMapped = this.jvxlDataIsColorMapped;
        this.jvxlData.jvxlDataIsColorDensity = this.jvxlDataIsColorDensity;
        this.jvxlData.isXLowToHigh = this.isXLowToHigh;
        this.jvxlData.vertexDataOnly = this.vertexDataOnly;
        this.jvxlData.saveVertexCount = 0;
        if (this.jvxlDataIsColorMapped || this.jvxlData.nVertexColors > 0) {
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 1, null);
                this.meshDataServer.fillMeshData(this.meshData, 2, null);
            }
            this.jvxlData.jvxlColorData = this.readColorData();
            this.updateSurfaceData();
            if (this.meshDataServer != null) {
                this.meshDataServer.notifySurfaceMappingCompleted();
            }
        }
        if (this.params.showTiming) {
            Logger.checkTimer("isosurface creation", false);
        }
        return true;
    }

    void resetIsosurface() {
        this.meshData = new MeshData();
        this.xyzMax = null;
        this.xyzMin = null;
        this.jvxlData.isBicolorMap = this.params.isBicolorMap;
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(null, 0, null);
        }
        this.contourVertexCount = 0;
        if (this.params.cutoff == Float.MAX_VALUE) {
            this.params.cutoff = 0.02f;
        }
        this.jvxlData.jvxlSurfaceData = "";
        this.jvxlData.jvxlEdgeData = "";
        this.jvxlData.jvxlColorData = "";
        this.edgeCount = 0;
        this.edgeFractionBase = 35;
        this.edgeFractionRange = 90;
        this.colorFractionBase = 35;
        this.colorFractionRange = 90;
        this.params.mappedDataMin = Float.MAX_VALUE;
    }

    void discardTempData(boolean discardAll) {
        this.discardTempDataSR(discardAll);
    }

    protected void discardTempDataSR(boolean discardAll) {
        if (!discardAll) {
            return;
        }
        this.voxelData = null;
        this.marchingSquares = null;
        this.sg.marchingSquares = null;
        this.marchingCubes = null;
    }

    void initializeVolumetricData() {
        this.nPointsX = this.voxelCounts[0];
        this.nPointsY = this.voxelCounts[1];
        this.nPointsZ = this.voxelCounts[2];
        this.setVolumeDataV(this.volumeData);
    }

    protected abstract void readSurfaceData(boolean var1) throws Exception;

    protected boolean gotoAndReadVoxelData(boolean isMapData) {
        this.initializeVolumetricData();
        if (this.nPointsX > 0 && this.nPointsY > 0 && this.nPointsZ > 0) {
            try {
                this.gotoData(this.params.fileIndex - 1, this.nPointsX * this.nPointsY * this.nPointsZ);
                this.readSurfaceData(isMapData);
            }
            catch (Exception e) {
                Logger.error(e.toString());
                return false;
            }
        }
        return true;
    }

    protected void gotoData(int n, int nPoints) throws Exception {
    }

    protected String readColorData() {
        if (this.jvxlData.vertexColors == null) {
            return "";
        }
        int vertexCount = this.jvxlData.vertexCount;
        short[] colixes = this.meshData.vcs;
        float[] vertexValues = this.meshData.vvs;
        if (colixes == null || colixes.length < vertexCount) {
            this.meshData.vcs = colixes = new short[vertexCount];
        }
        if (vertexValues == null || vertexValues.length < vertexCount) {
            this.meshData.vvs = vertexValues = new float[vertexCount];
        }
        for (int i = 0; i < vertexCount; ++i) {
            colixes[i] = C.getColix(this.jvxlData.vertexColors[i]);
        }
        return "-";
    }

    @Override
    public float[] getPlane(int x) {
        return this.getPlaneSR(x);
    }

    protected float[] getPlaneSR(int x) {
        if (this.yzCount == 0) {
            this.initPlanes();
        }
        if (this.qpc != null) {
            this.qpc.getPlane(x, this.yzPlanes[x % 2]);
        }
        return this.yzPlanes[x % 2];
    }

    void initPlanes() {
        this.yzCount = this.nPointsY * this.nPointsZ;
        if (!this.isQuiet) {
            Logger.info("reading data progressively -- yzCount = " + this.yzCount);
        }
        this.yzPlanes = AU.newFloat2(2);
        this.yzPlanes[0] = new float[this.yzCount];
        this.yzPlanes[1] = new float[this.yzCount];
    }

    @Override
    public float getValue(int x, int y, int z, int ptyz) {
        return this.getValue2(x, y, z, ptyz);
    }

    protected float getValue2(int x, int y, int z, int ptyz) {
        return this.yzPlanes == null ? this.voxelData[x][y][z] : this.yzPlanes[x % 2][ptyz];
    }

    private void generateSurfaceData() {
        this.edgeData = "";
        if (this.vertexDataOnly) {
            try {
                this.readSurfaceData(false);
            }
            catch (Exception e) {
                System.out.println(e.toString());
                Logger.error("Exception in SurfaceReader::readSurfaceData: " + e.toString());
            }
            return;
        }
        this.contourVertexCount = 0;
        int contourType = -1;
        this.marchingSquares = null;
        if (this.params.thePlane != null || this.params.isContoured) {
            this.marchingSquares = new MarchingSquares(this, this.volumeData, this.params.thePlane, this.params.contoursDiscrete, this.params.nContours, this.params.thisContour, this.params.contourFromZero);
            contourType = this.marchingSquares.contourType;
            this.marchingSquares.setMinMax(this.params.valueMappedToRed, this.params.valueMappedToBlue);
        }
        this.params.contourType = contourType;
        this.params.isXLowToHigh = this.isXLowToHigh;
        this.marchingCubes = new MarchingCubes(this, this.volumeData, this.params, this.jvxlVoxelBitSet);
        String data = this.marchingCubes.getEdgeData();
        if (this.params.thePlane == null) {
            this.edgeData = data;
        }
        this.jvxlData.setSurfaceInfoFromBitSetPts(this.marchingCubes.bsVoxels, this.params.thePlane, this.params.mapLattice);
        this.jvxlData.jvxlExcluded = this.params.bsExcluded;
        if (this.isJvxl) {
            this.edgeData = this.jvxlEdgeDataRead;
        }
        this.postProcessVertices();
    }

    protected void postProcessVertices() {
    }

    @Override
    public int getSurfacePointIndexAndFraction(float cutoff, boolean isCutoffAbsolute, int x, int y, int z, P3i offset, int vA, int vB, float valueA, float valueB, T3 pointA, V3 edgeVector, boolean isContourType, float[] fReturn) {
        int n;
        int assocVertex;
        float thisValue = this.getSurfacePointAndFraction(cutoff, isCutoffAbsolute, valueA, valueB, pointA, edgeVector, x, y, z, vA, vB, fReturn, this.ptTemp);
        if (this.marchingSquares != null && this.params.isContoured) {
            return this.marchingSquares.addContourVertex(this.ptTemp, cutoff);
        }
        int n2 = this.assocCutoff > 0.0f ? (fReturn[0] < this.assocCutoff ? vA : (fReturn[0] > 1.0f - this.assocCutoff ? vB : -1)) : (assocVertex = -1);
        if (assocVertex >= 0) {
            assocVertex = this.marchingCubes.getLinearOffset(x, y, z, assocVertex);
        }
        if ((n = this.addVertexCopy(this.ptTemp, thisValue, assocVertex, true)) >= 0 && this.params.iAddGridPoints) {
            this.marchingCubes.calcVertexPoint(x, y, z, vB, this.ptTemp);
            this.addVertexCopy(valueA < valueB ? pointA : this.ptTemp, Math.min(valueA, valueB), -3, true);
            this.addVertexCopy(valueA < valueB ? this.ptTemp : pointA, Math.max(valueA, valueB), -3, true);
        }
        return n;
    }

    protected float getSurfacePointAndFraction(float cutoff, boolean isCutoffAbsolute, float valueA, float valueB, T3 pointA, V3 edgeVector, int x, int y, int z, int vA, int vB, float[] fReturn, T3 ptReturn) {
        return this.getSPF(cutoff, isCutoffAbsolute, valueA, valueB, pointA, edgeVector, x, y, z, vA, vB, fReturn, ptReturn);
    }

    protected float getSPF(float cutoff, boolean isCutoffAbsolute, float valueA, float valueB, T3 pointA, V3 edgeVector, int x, int y, int z, int vA, int vB, float[] fReturn, T3 ptReturn) {
        float diff = valueB - valueA;
        float fraction = (cutoff - valueA) / diff;
        if (isCutoffAbsolute && (fraction < 0.0f || fraction > 1.0f)) {
            fraction = (-cutoff - valueA) / diff;
        }
        if (fraction < 0.0f || fraction > 1.0f) {
            fraction = Float.NaN;
        }
        fReturn[0] = fraction;
        ptReturn.scaleAdd2(fraction, edgeVector, pointA);
        return valueA + fraction * diff;
    }

    @Override
    public int addVertexCopy(T3 vertexXYZ, float value, int assocVertex, boolean asCopy) {
        return this.addVC(vertexXYZ, value, assocVertex, asCopy);
    }

    protected int addVC(T3 vertexXYZ, float value, int assocVertex, boolean asCopy) {
        return Float.isNaN(value) && assocVertex != -3 ? -1 : (this.meshDataServer == null ? this.meshData.addVertexCopy(vertexXYZ, value, assocVertex, asCopy) : this.meshDataServer.addVertexCopy(vertexXYZ, value, assocVertex, asCopy));
    }

    @Override
    public int addTriangleCheck(int iA, int iB, int iC, int check, int iContour, boolean isAbsolute, int color) {
        if (this.marchingSquares != null && this.params.isContoured) {
            if (color == 0) {
                return this.marchingSquares.addTriangle(iA, iB, iC, check, iContour);
            }
            color = 0;
        }
        return this.meshDataServer != null ? this.meshDataServer.addTriangleCheck(iA, iB, iC, check, iContour, isAbsolute, color) : (isAbsolute && !MeshData.checkCutoff(iA, iB, iC, this.meshData.vvs) ? -1 : this.meshData.addTriangleCheck(iA, iB, iC, check, iContour, color));
    }

    void colorIsosurface() {
        if (this.params.isSquared && this.volumeData != null) {
            this.volumeData.filterData(true, Float.NaN);
        }
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        this.jvxlData.saveVertexCount = 0;
        if (this.params.isContoured && this.marchingSquares != null) {
            this.initializeMapping();
            this.params.setMapRanges(this, false);
            this.marchingSquares.setMinMax(this.params.valueMappedToRed, this.params.valueMappedToBlue);
            this.jvxlData.saveVertexCount = this.marchingSquares.contourVertexCount;
            this.contourVertexCount = this.marchingSquares.generateContourData(this.jvxlDataIs2dContour, this.params.isSquared ? 1.0E-8f : 1.0E-4f);
            this.jvxlData.contourValuesUsed = this.marchingSquares.contourValuesUsed;
            this.minMax = this.marchingSquares.getMinMax();
            if (this.meshDataServer != null) {
                this.meshDataServer.notifySurfaceGenerationCompleted();
            }
            this.finalizeMapping();
        }
        this.applyColorScale();
        this.jvxlData.nContours = this.params.contourFromZero ? this.params.nContours : -1 - this.params.nContours;
        this.jvxlData.thisContour = this.params.thisContour;
        this.jvxlData.jvxlFileMessage = "mapped: min = " + this.params.valueMappedToRed + "; max = " + this.params.valueMappedToBlue;
    }

    void applyColorScale() {
        boolean useMeshDataValues;
        boolean saveColorData;
        this.jvxlData.colorFractionBase = 35;
        this.colorFractionBase = 35;
        this.jvxlData.colorFractionRange = 90;
        this.colorFractionRange = 90;
        if (this.params.colorPhase == 0) {
            this.params.colorPhase = 1;
        }
        if (this.meshDataServer == null) {
            this.meshData.vcs = new short[this.meshData.vc];
        } else {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
            if (this.params.contactPair == null) {
                this.meshDataServer.fillMeshData(this.meshData, 2, null);
            }
        }
        boolean bl = saveColorData = this.params.colorDensity || this.params.isBicolorMap || this.params.colorBySign || !this.params.colorByPhase;
        if (this.params.contactPair != null) {
            saveColorData = false;
        }
        this.jvxlData.isJvxlPrecisionColor = true;
        this.jvxlData.vertexCount = this.contourVertexCount > 0 ? this.contourVertexCount : this.meshData.vc;
        this.jvxlData.minColorIndex = (short)-1;
        this.jvxlData.maxColorIndex = 0;
        this.jvxlData.contourValues = this.params.contoursDiscrete;
        this.jvxlData.isColorReversed = this.params.isColorReversed;
        if (!this.params.colorDensity && (this.params.isBicolorMap && !this.params.isContoured || this.params.colorBySign)) {
            this.jvxlData.minColorIndex = C.getColixTranslucent3(C.getColix(this.params.isColorReversed ? this.params.colorPos : this.params.colorNeg), this.jvxlData.translucency != 0.0f, this.jvxlData.translucency);
            this.jvxlData.maxColorIndex = C.getColixTranslucent3(C.getColix(this.params.isColorReversed ? this.params.colorNeg : this.params.colorPos), this.jvxlData.translucency != 0.0f, this.jvxlData.translucency);
        }
        this.jvxlData.isTruncated = this.jvxlData.minColorIndex >= 0 && !this.params.isContoured;
        boolean bl2 = useMeshDataValues = this.jvxlDataIs2dContour || this.hasColorData || this.vertexDataOnly || this.params.colorDensity || this.params.isBicolorMap && !this.params.isContoured;
        if (!useMeshDataValues) {
            if (this.haveSurfaceAtoms && this.meshData.vertexSource == null) {
                this.meshData.vertexSource = new int[this.meshData.vc];
            }
            float min = Float.MAX_VALUE;
            float max = -3.4028235E38f;
            this.initializeMapping();
            int i = this.meshData.vc;
            while (--i >= this.meshData.mergeVertexCount0) {
                float value;
                if (this.params.colorBySets) {
                    value = this.meshData.vertexSets[i];
                } else if (this.params.colorByPhase) {
                    value = this.getPhase(this.meshData.vs[i]);
                } else {
                    boolean needSource = this.haveSurfaceAtoms;
                    value = this.volumeData.lookupInterpolatedVoxelValue(this.meshData.vs[i], needSource);
                    if (needSource) {
                        this.meshData.vertexSource[i] = this.getSurfaceAtomIndex();
                    }
                }
                if (value < min) {
                    min = value;
                }
                if (value > max && value != Float.MAX_VALUE) {
                    max = value;
                }
                this.meshData.vvs[i] = value;
            }
            if (this.params.rangeSelected && this.minMax == null) {
                this.minMax = new float[]{min, max};
            }
            this.finalizeMapping();
        }
        this.params.setMapRanges(this, true);
        this.jvxlData.mappedDataMin = this.params.mappedDataMin;
        this.jvxlData.mappedDataMax = this.params.mappedDataMax;
        this.jvxlData.valueMappedToRed = this.params.valueMappedToRed;
        this.jvxlData.valueMappedToBlue = this.params.valueMappedToBlue;
        if (this.params.contactPair == null && this.jvxlData.vertexColors == null) {
            this.colorData();
        }
        JvxlCoder.jvxlCreateColorData(this.jvxlData, saveColorData ? this.meshData.vvs : null);
        if (this.haveSurfaceAtoms && this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 4, null);
        }
        if (this.meshDataServer != null && this.params.colorBySets) {
            this.meshDataServer.fillMeshData(this.meshData, 3, null);
        }
    }

    private void colorData() {
        float[] vertexValues = this.meshData.vvs;
        short[] vertexColixes = this.meshData.vcs;
        this.meshData.pcs = null;
        float valueBlue = this.jvxlData.valueMappedToBlue;
        float valueRed = this.jvxlData.valueMappedToRed;
        short minColorIndex = this.jvxlData.minColorIndex;
        short maxColorIndex = this.jvxlData.maxColorIndex;
        if (this.params.colorEncoder == null) {
            this.params.colorEncoder = new ColorEncoder(null, null);
        }
        this.params.colorEncoder.setRange(this.params.valueMappedToRed, this.params.valueMappedToBlue, this.params.isColorReversed);
        int i = this.meshData.vc;
        while (--i >= 0) {
            float value = vertexValues[i];
            if (minColorIndex >= 0) {
                if (value <= 0.0f) {
                    vertexColixes[i] = minColorIndex;
                    continue;
                }
                if (!(value > 0.0f)) continue;
                vertexColixes[i] = maxColorIndex;
                continue;
            }
            if (value <= valueRed) {
                value = valueRed;
            }
            if (value >= valueBlue) {
                value = valueBlue;
            }
            vertexColixes[i] = this.params.colorEncoder.getColorIndex(value);
        }
        if ((this.params.nContours > 0 || this.jvxlData.contourValues != null) && this.jvxlData.contourColixes == null) {
            int n = this.jvxlData.contourValues == null ? this.params.nContours : this.jvxlData.contourValues.length;
            this.jvxlData.contourColixes = new short[n];
            short[] colors = this.jvxlData.contourColixes;
            float[] values = this.jvxlData.contourValues;
            if (values == null) {
                values = this.jvxlData.contourValuesUsed;
            }
            if (this.jvxlData.contourValuesUsed == null) {
                this.jvxlData.contourValuesUsed = values == null ? new float[n] : values;
            }
            float dv = (valueBlue - valueRed) / (float)(n + 1);
            this.params.colorEncoder.setRange(this.params.valueMappedToRed, this.params.valueMappedToBlue, this.params.isColorReversed);
            for (int i2 = 0; i2 < n; ++i2) {
                float v;
                this.jvxlData.contourValuesUsed[i2] = v = values == null ? valueRed + (float)(i2 + 1) * dv : values[i2];
                colors[i2] = C.getColixTranslucent(this.params.colorEncoder.getArgb(v));
            }
            this.jvxlData.contourColors = C.getHexCodes(colors);
        }
    }

    static int getColorPhaseIndex(String color) {
        int colorPhase = -1;
        for (int i = 0; i < colorPhases.length; ++i) {
            if (!color.equalsIgnoreCase(colorPhases[i])) continue;
            colorPhase = i;
            break;
        }
        return colorPhase;
    }

    private float getPhase(T3 pt) {
        switch (this.params.colorPhase) {
            case -1: 
            case 0: 
            case 1: {
                return pt.x > 0.0f ? 1 : -1;
            }
            case 2: {
                return pt.y > 0.0f ? 1 : -1;
            }
            case 3: {
                return pt.z > 0.0f ? 1 : -1;
            }
            case 4: {
                return pt.x * pt.y > 0.0f ? 1 : -1;
            }
            case 5: {
                return pt.y * pt.z > 0.0f ? 1 : -1;
            }
            case 6: {
                return pt.x * pt.z > 0.0f ? 1 : -1;
            }
            case 7: {
                return pt.x * pt.x - pt.y * pt.y > 0.0f ? 1 : -1;
            }
            case 8: {
                return pt.z * pt.z * 2.0f - pt.x * pt.x - pt.y * pt.y > 0.0f ? 1 : -1;
            }
        }
        return 1.0f;
    }

    public float[] getMinMaxMappedValues(boolean haveData) {
        if (this.minMax != null && this.minMax[0] != Float.MAX_VALUE) {
            return this.minMax;
        }
        if (this.params.colorBySets) {
            this.minMax = new float[]{0.0f, Math.max(this.meshData.nSets - 1, 0)};
            return this.minMax;
        }
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        if (this.params.usePropertyForColorRange && this.params.theProperty != null) {
            int i = this.params.theProperty.length;
            while (--i >= 0) {
                float p;
                if (this.params.rangeSelected && !this.params.bsSelected.get(i) || Float.isNaN(p = this.params.theProperty[i])) continue;
                if (p < min) {
                    min = p;
                }
                if (!(p > max)) continue;
                max = p;
            }
            this.minMax = new float[]{min, max};
            return this.minMax;
        }
        int vertexCount = this.contourVertexCount > 0 ? this.contourVertexCount : this.meshData.vc;
        T3[] vertexes = this.meshData.vs;
        boolean useVertexValue = haveData || this.jvxlDataIs2dContour || this.vertexDataOnly || this.params.colorDensity;
        for (int i = this.meshData.mergeVertexCount0; i < vertexCount; ++i) {
            float v = useVertexValue ? this.meshData.vvs[i] : this.volumeData.lookupInterpolatedVoxelValue(vertexes[i], false);
            if (v < min) {
                min = v;
            }
            if (!(v > max) || v == Float.MAX_VALUE) continue;
            max = v;
        }
        this.minMax = new float[]{min, max};
        return this.minMax;
    }

    void updateTriangles() {
        if (this.meshDataServer == null) {
            this.meshData.invalidatePolygons();
        } else {
            this.meshDataServer.invalidateTriangles();
        }
    }

    void updateSurfaceData() {
        this.meshData.setVertexSets(true);
        this.updateTriangles();
        if (this.params.bsExcluded[1] == null) {
            this.params.bsExcluded[1] = new BS();
        }
        this.meshData.updateInvalidatedVertices(this.params.bsExcluded[1]);
    }

    public void selectPocket(boolean doExclude) {
    }

    void excludeMinimumSet() {
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        this.meshData.getSurfaceSet();
        int i = this.meshData.nSets;
        while (--i >= 0) {
            BS bs = this.meshData.surfaceSet[i];
            if (bs == null || bs.cardinality() >= this.params.minSet) continue;
            this.meshData.invalidateSurfaceSet(i);
        }
        this.updateSurfaceData();
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 3, null);
        }
    }

    void excludeMaximumSet() {
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        this.meshData.getSurfaceSet();
        int i = this.meshData.nSets;
        while (--i >= 0) {
            BS bs = this.meshData.surfaceSet[i];
            if (bs == null || bs.cardinality() <= this.params.maxSet) continue;
            this.meshData.invalidateSurfaceSet(i);
        }
        this.updateSurfaceData();
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 3, null);
        }
    }

    public void slabIsosurface(Lst<Object[]> slabInfo) {
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        this.meshData.slabPolygonsList(slabInfo, true);
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 4, null);
        }
    }

    protected void setVertexAnisotropy(T3 pt) {
        pt.x *= this.anisotropy[0];
        pt.y *= this.anisotropy[1];
        pt.z *= this.anisotropy[2];
        pt.add(this.center);
    }

    protected void setVectorAnisotropy(T3 v) {
        this.haveSetAnisotropy = true;
        v.x *= this.anisotropy[0];
        v.y *= this.anisotropy[1];
        v.z *= this.anisotropy[2];
    }

    protected void setVolumetricAnisotropy() {
        if (this.haveSetAnisotropy) {
            return;
        }
        this.setVolumetricOriginAnisotropy();
        this.setVectorAnisotropy(this.volumetricVectors[0]);
        this.setVectorAnisotropy(this.volumetricVectors[1]);
        this.setVectorAnisotropy(this.volumetricVectors[2]);
    }

    protected void setVolumetricOriginAnisotropy() {
        this.volumetricOrigin.setT(this.center);
    }

    private void setBBoxAll() {
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        this.xyzMin = new P3();
        this.xyzMax = new P3();
        this.meshData.setBox(this.xyzMin, this.xyzMax);
    }

    protected void setBBox(T3 pt, float margin) {
        if (this.xyzMin == null) {
            this.xyzMin = P3.new3(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
            this.xyzMax = P3.new3(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        }
        BoxInfo.addPoint(pt, this.xyzMin, this.xyzMax, margin);
    }

    public float getValueAtPoint(T3 pt, boolean getSource) {
        return 0.0f;
    }

    void initializeMapping() {
    }

    protected void finalizeMapping() {
    }

    public int getSurfaceAtomIndex() {
        return -1;
    }
}

