/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelkit;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.SymmetryInterface;
import org.jmol.i18n.GT;
import org.jmol.modelkit.ModelKitPopup;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.MeasurementPending;
import org.jmol.modelset.ModelSet;
import org.jmol.script.SV;
import org.jmol.script.ScriptEval;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;
import org.jmol.viewer.MouseState;
import org.jmol.viewer.Viewer;

public class ModelKit {
    static Constraint locked = new Constraint(null, 6, null);
    static Constraint none = new Constraint(null, 0, null);
    private Viewer vwr;
    private ModelKitPopup menu;
    public static final String MODE_OPTIONS = ";view;edit;molecular;";
    public static final String SYMMETRY_OPTIONS = ";none;applylocal;retainlocal;applyfull;";
    public static final String UNITCELL_OPTIONS = ";packed;extend;";
    public static final String BOOLEAN_OPTIONS = ";autobond;hidden;showsymopinfo;clicktosetelement;addhydrogen;addhydrogens;";
    public static final String SET_OPTIONS = ";element;";
    static final int STATE_MOLECULAR = 0;
    static final int STATE_XTALVIEW = 1;
    static final int STATE_XTALEDIT = 2;
    static final int STATE_BITS_XTAL = 3;
    static final int STATE_BITS_SYM_VIEW = 28;
    static final int STATE_SYM_NONE = 0;
    static final int STATE_SYM_SHOW = 8;
    static final int STATE_BITS_SYM_EDIT = 224;
    static final int STATE_SYM_APPLYLOCAL = 32;
    static final int STATE_SYM_RETAINLOCAL = 64;
    static final int STATE_SYM_APPLYFULL = 128;
    static final int STATE_BITS_UNITCELL = 1792;
    static final int STATE_UNITCELL_PACKED = 0;
    static final int STATE_UNITCELL_EXTEND = 256;
    private static final P3 Pt000 = new P3();
    int state = 0;
    float rotationDeg;
    String atomHoverLabel = "C";
    String bondHoverLabel = GT.$("increase order");
    String xtalHoverLabel;
    boolean hasUnitCell;
    String[] allOperators;
    int currentModelIndex = -1;
    boolean alertedNoEdit;
    protected ModelSet lastModelSet;
    String pickAtomAssignType = "C";
    String lastElementType = "C";
    char pickBondAssignType = (char)112;
    boolean isPickAtomAssignCharge;
    BS bsHighlight = new BS();
    int bondIndex = -1;
    int bondAtomIndex1 = -1;
    int bondAtomIndex2 = -1;
    BS bsRotateBranch;
    int branchAtomIndex;
    boolean isRotateBond;
    int[] screenXY = new int[2];
    boolean showSymopInfo = true;
    boolean addXtalHydrogens = true;
    boolean clickToSetElement = true;
    boolean autoBond = false;
    P3 centerPoint;
    P3 spherePoint;
    P3 viewOffset;
    float centerDistance;
    Object symop;
    int centerAtomIndex = -1;
    int secondAtomIndex = -1;
    int atomIndexSphere = -1;
    String drawData;
    String drawScript;
    int iatom0;
    String bondRotationName = ".modelkitMenu.bondMenu.rotateBondP!RD";
    String lastCenter = "0 0 0";
    String lastOffset = "0 0 0";
    private Atom a0;
    private Atom a3;
    private Constraint constraint;
    private Constraint[] atomConstraints;
    private static int GET = 0;
    private static int GET_CREATE = 1;
    private static int GET_DELETE = 2;

    public void setMenu(ModelKitPopup menu) {
        this.menu = menu;
        this.vwr = menu.vwr;
        menu.modelkit = this;
        this.initializeForModel();
    }

    public void initializeForModel() {
        this.resetBondFields();
        this.allOperators = null;
        this.currentModelIndex = -999;
        this.iatom0 = 0;
        this.secondAtomIndex = -1;
        this.centerAtomIndex = -1;
        this.atomIndexSphere = -1;
        this.spherePoint = null;
        this.centerPoint = null;
        this.symop = null;
        this.setDefaultState(0);
    }

    public void showMenu(int x, int y) {
        this.menu.jpiShow(x, y);
    }

    public String getDefaultModel() {
        return this.addXtalHydrogens ? "5\n\nC 0 0 0\nH .63 .63 .63\nH -.63 -.63 .63\nH -.63 .63 -.63\nH .63 -.63 -.63" : "1\n\nC 0 0 0\n";
    }

    public void updateMenu() {
        this.menu.jpiUpdateComputedMenus();
    }

    public void dispose() {
        this.menu.jpiDispose();
        this.menu.modelkit = null;
        this.menu = null;
        this.vwr = null;
    }

    public boolean isPickAtomAssignCharge() {
        return this.isPickAtomAssignCharge;
    }

    public boolean isHidden() {
        return this.menu.hidden;
    }

    public String getActiveMenu() {
        return this.menu.activeMenu;
    }

    public int getRotateBondIndex() {
        return this.getMKState() == 0 && this.isRotateBond ? this.bondIndex : -1;
    }

    public Object getProperty(String name) {
        if ((name = name.toLowerCase().intern()) == "constraint") {
            return this.constraint;
        }
        if (name == "ismolecular") {
            return this.getMKState() == 0;
        }
        if (name == "alloperators") {
            return this.allOperators;
        }
        if (name == "data") {
            return this.getinfo();
        }
        return this.setProperty(name, null);
    }

    public synchronized Object setProperty(String key, Object value) {
        try {
            key = key.toLowerCase().intern();
            if (key == "constraint") {
                this.constraint = null;
                this.clearAtomConstraints();
                Object[] o = (Object[])value;
                if (o != null) {
                    P3 v1 = (P3)o[0];
                    P3 v2 = (P3)o[1];
                    P4 plane = (P4)o[2];
                    if (v1 != null && v2 != null) {
                        this.constraint = new Constraint(null, 4, new Object[]{v1, v2});
                    } else if (plane != null) {
                        this.constraint = new Constraint(null, 5, new Object[]{plane});
                    } else if (v1 != null) {
                        this.constraint = new Constraint(null, 6, null);
                    }
                }
                return null;
            }
            if (key == "reset") {
                return null;
            }
            if (key == "addhydrogen" || key == "addhydrogens") {
                if (value != null) {
                    this.addXtalHydrogens = ModelKit.isTrue(value);
                }
                return this.addXtalHydrogens;
            }
            if (key == "autobond") {
                if (value != null) {
                    this.autoBond = ModelKit.isTrue(value);
                }
                return this.autoBond;
            }
            if (key == "clicktosetelement") {
                if (value != null) {
                    this.clickToSetElement = ModelKit.isTrue(value);
                }
                return this.clickToSetElement;
            }
            if (key == "hidden") {
                if (value != null) {
                    this.menu.hidden = ModelKit.isTrue(value);
                    this.vwr.setBooleanProperty("modelkitMode", true);
                }
                return this.menu.hidden;
            }
            if (key == "showsymopinfo") {
                if (value != null) {
                    this.showSymopInfo = ModelKit.isTrue(value);
                }
                return this.showSymopInfo;
            }
            if (key == "symop") {
                this.setDefaultState(1);
                if (value != null) {
                    this.symop = value;
                    this.showSymop(this.symop);
                }
                return this.symop;
            }
            if (key == "atomtype") {
                if (value != null) {
                    this.pickAtomAssignType = (String)value;
                    boolean bl = this.isPickAtomAssignCharge = this.pickAtomAssignType.equals("pl") || this.pickAtomAssignType.equals("mi");
                    if (!this.isPickAtomAssignCharge && !"X".equals(this.pickAtomAssignType)) {
                        this.lastElementType = this.pickAtomAssignType;
                    }
                }
                return this.pickAtomAssignType;
            }
            if (key == "bondtype") {
                if (value != null) {
                    String s = ((String)value).substring(0, 1).toLowerCase();
                    if (" 012345pm".indexOf(s) > 0) {
                        this.pickBondAssignType = s.charAt(0);
                    }
                    this.isRotateBond = false;
                }
                return "" + this.pickBondAssignType;
            }
            if (key == "bondindex") {
                if (value != null) {
                    this.setBondIndex((Integer)value, false);
                }
                return this.bondIndex < 0 ? null : Integer.valueOf(this.bondIndex);
            }
            if (key == "rotatebondindex") {
                if (value != null) {
                    this.setBondIndex((Integer)value, true);
                }
                return this.bondIndex < 0 ? null : Integer.valueOf(this.bondIndex);
            }
            if (key == "offset") {
                if (value == "none") {
                    this.viewOffset = null;
                } else if (value != null) {
                    P3 p3 = this.viewOffset = value instanceof P3 ? (P3)value : ModelKit.pointFromTriad(value.toString());
                    if (this.viewOffset != null) {
                        this.setSymViewState(8);
                    }
                }
                this.showXtalSymmetry();
                return this.viewOffset;
            }
            if (key == "screenxy") {
                if (value != null) {
                    this.screenXY = (int[])value;
                }
                return this.screenXY;
            }
            if (key == "bondatomindex") {
                int i = (Integer)value;
                if (i != this.bondAtomIndex2) {
                    this.bondAtomIndex1 = i;
                }
                this.bsRotateBranch = null;
                return null;
            }
            if (key == "highlight") {
                this.bsHighlight = value == null ? new BS() : (BS)value;
                return null;
            }
            if (key == "mode") {
                boolean isEdit = "edit".equals(value);
                this.setMKState("view".equals(value) ? 1 : (isEdit ? 2 : 0));
                if (isEdit) {
                    this.addXtalHydrogens = false;
                }
                return null;
            }
            if (key == "symmetry") {
                this.setDefaultState(2);
                key = ((String)value).toLowerCase().intern();
                this.setSymEdit(key == "applylocal" ? 32 : (key == "retainlocal" ? 64 : (key == "applyfull" ? 128 : 0)));
                this.showXtalSymmetry();
                return null;
            }
            if (key == "unitcell") {
                boolean isPacked = "packed".equals(value);
                this.setUnitCell(isPacked ? 0 : 256);
                this.viewOffset = isPacked ? Pt000 : null;
                return null;
            }
            if (key == "center") {
                this.setDefaultState(1);
                this.centerPoint = (P3)value;
                this.lastCenter = this.centerPoint.x + " " + this.centerPoint.y + " " + this.centerPoint.z;
                this.centerAtomIndex = this.centerPoint instanceof Atom ? ((Atom)this.centerPoint).i : -1;
                this.atomIndexSphere = -1;
                this.secondAtomIndex = -1;
                this.processAtomClick(this.centerAtomIndex);
                return null;
            }
            if (key == "scriptassignbond") {
                this.appRunScript("modelkit assign bond [{" + value + "}] \"" + this.pickBondAssignType + "\"");
                return null;
            }
            if (key == "hoverlabel") {
                return this.getHoverLabel((Integer)value);
            }
            if (key == "invariant") {
                int iatom = value instanceof BS ? ((BS)value).nextSetBit(0) : -1;
                Atom atom = this.vwr.ms.getAtom(iatom);
                return atom == null ? null : this.vwr.getSymmetryInfo(iatom, null, -1, null, atom, atom, 1275068418, null, 0.0f, 0, 0);
            }
            if (key == "distance") {
                float d;
                this.setDefaultState(2);
                float f = value == null ? Float.NaN : (d = value instanceof Float ? ((Float)value).floatValue() : PT.parseFloat((String)value));
                if (!Float.isNaN(d)) {
                    ModelKit.notImplemented("setProperty: distance");
                    this.centerDistance = d;
                }
                return Float.valueOf(this.centerDistance);
            }
            if (key == "point") {
                if (value != null) {
                    ModelKit.notImplemented("setProperty: point");
                    this.setDefaultState(2);
                    this.spherePoint = (P3)value;
                    this.atomIndexSphere = this.spherePoint instanceof Atom ? ((Atom)this.spherePoint).i : -1;
                }
                return this.spherePoint;
            }
            if (key == "addconstraint") {
                ModelKit.notImplemented("setProperty: addConstraint");
                return null;
            }
            if (key == "removeconstraint") {
                ModelKit.notImplemented("setProperty: removeConstraint");
                return null;
            }
            if (key == "removeallconstraints") {
                ModelKit.notImplemented("setProperty: removeAllConstraints");
                return null;
            }
            System.err.println("ModelKitPopup.setProperty? " + key + " " + value);
        }
        catch (Exception e) {
            return "?";
        }
        return null;
    }

    public MeasurementPending setBondMeasure(int bi, MeasurementPending mp) {
        if (this.branchAtomIndex < 0) {
            return null;
        }
        Bond b = this.vwr.ms.bo[bi];
        Atom a1 = b.atom1;
        Atom a2 = b.atom2;
        this.a3 = null;
        this.a0 = null;
        if (a1.getCovalentBondCount() == 1 || a2.getCovalentBondCount() == 1) {
            return null;
        }
        this.a0 = this.getOtherAtomIndex(a1, a2);
        mp.addPoint(this.a0.i, null, true);
        mp.addPoint(a1.i, null, true);
        mp.addPoint(a2.i, null, true);
        this.a3 = this.getOtherAtomIndex(a2, a1);
        mp.addPoint(this.a3.i, null, true);
        mp.mad = 50;
        mp.inFront = true;
        return mp;
    }

    public void actionRotateBond(int deltaX, int deltaY, int x, int y, boolean forceFull) {
        Atom atomFix;
        Atom atomMove;
        if (this.bondIndex < 0) {
            return;
        }
        BS bsBranch = this.bsRotateBranch;
        ModelSet ms = this.vwr.ms;
        Bond b = ms.bo[this.bondIndex];
        if (forceFull) {
            bsBranch = null;
            this.branchAtomIndex = -1;
        }
        if (bsBranch == null) {
            atomMove = this.branchAtomIndex == b.atom1.i ? b.atom1 : b.atom2;
            atomFix = atomMove == b.atom1 ? b.atom2 : b.atom1;
            this.vwr.undoMoveActionClear(atomFix.i, 2, true);
            if (this.branchAtomIndex >= 0) {
                bsBranch = this.vwr.getBranchBitSet(atomMove.i, atomFix.i, true);
            }
            if (bsBranch != null) {
                int n = 0;
                int i = atomFix.bonds.length;
                while (--i >= 0) {
                    if (!bsBranch.get(atomFix.getBondedAtomIndex(i)) || ++n != 2) continue;
                    bsBranch = null;
                    break;
                }
            }
            if (bsBranch == null) {
                bsBranch = ms.getMoleculeBitSetForAtom(atomFix.i);
                forceFull = true;
            }
            this.bsRotateBranch = bsBranch;
            this.bondAtomIndex1 = atomFix.i;
            this.bondAtomIndex2 = atomMove.i;
        } else {
            atomFix = ms.at[this.bondAtomIndex1];
            atomMove = ms.at[this.bondAtomIndex2];
        }
        V3 v1 = V3.new3(atomMove.sX - atomFix.sX, atomMove.sY - atomFix.sY, 0.0f);
        v1.scale(1.0f / v1.length());
        V3 v2 = V3.new3(deltaX, deltaY, 0.0f);
        v1.cross(v1, v2);
        float f = v1.z > 0.0f ? 1 : -1;
        float degrees = f * (float)((int)v2.length() / 2 + 1);
        if (!forceFull && this.a0 != null) {
            float ang0 = Measure.computeTorsion(this.a0, b.atom1, b.atom2, this.a3, true);
            float ang1 = Math.round(ang0 + degrees);
            degrees = ang1 - ang0;
        }
        BS bs = BSUtil.copy(bsBranch);
        bs.andNot(this.vwr.slm.getMotionFixedAtoms());
        this.vwr.rotateAboutPointsInternal(null, atomFix, atomMove, 0.0f, degrees, false, bs, null, null, null, null);
    }

    public boolean handleAssignNew(MouseState pressed, MouseState dragged, MeasurementPending mp, int dragAtomIndex) {
        boolean inRange = pressed.inRange(10, dragged.x, dragged.y);
        if (inRange) {
            dragged.x = pressed.x;
            dragged.y = pressed.y;
        }
        if (this.handleDragAtom(pressed, dragged, mp.countPlusIndices)) {
            return true;
        }
        boolean isCharge = this.isPickAtomAssignCharge;
        String atomType = this.pickAtomAssignType;
        if (mp.count == 2) {
            this.vwr.undoMoveActionClear(-1, 4146, true);
            if (((Atom)mp.getAtom(1)).isBonded((Atom)mp.getAtom(2))) {
                this.appRunScript("modelkit assign bond " + mp.getMeasurementScript(" ", false) + "'p'");
            } else {
                this.appRunScript("modelkit connect " + mp.getMeasurementScript(" ", false));
            }
        } else {
            if (atomType.equals("Xx")) {
                atomType = this.lastElementType;
            }
            if (inRange) {
                String s = "modelkit assign atom ({" + dragAtomIndex + "}) \"" + atomType + "\" true";
                if (isCharge) {
                    s = s + ";{atomindex=" + dragAtomIndex + "}.label='%C'; ";
                    this.vwr.undoMoveActionClear(dragAtomIndex, 4, true);
                } else {
                    this.vwr.undoMoveActionClear(-1, 4146, true);
                }
                this.appRunScript(s);
            } else if (!isCharge) {
                this.vwr.undoMoveActionClear(-1, 4146, true);
                Atom a = this.vwr.ms.at[dragAtomIndex];
                if (a.getElementNumber() == 1) {
                    this.assignAtomClick(dragAtomIndex, "X", null);
                } else {
                    int x = dragged.x;
                    int y = dragged.y;
                    if (this.vwr.antialiased) {
                        x <<= 1;
                        y <<= 1;
                    }
                    P3 ptNew = P3.new3(x, y, a.sZ);
                    this.vwr.tm.unTransformPoint(ptNew, ptNew);
                    this.assignAtomClick(dragAtomIndex, atomType, ptNew);
                }
            }
        }
        return true;
    }

    boolean isXtalState() {
        return (this.state & 3) != 0;
    }

    void setMKState(int bits) {
        this.state = this.state & 0xFFFFFFFC | (this.hasUnitCell ? bits : 0);
    }

    int getMKState() {
        return this.state & 3;
    }

    void setSymEdit(int bits) {
        this.state = this.state & 0xFFFFFF1F | bits;
    }

    int getSymEditState() {
        return this.state & 0xE0;
    }

    void setSymViewState(int bits) {
        this.state = this.state & 0xFFFFFFE3 | bits;
    }

    int getSymViewState() {
        return this.state & 0x1C;
    }

    void setUnitCell(int bits) {
        this.state = this.state & 0xFFFFF8FF | bits;
    }

    int getUnitCellState() {
        return this.state & 0x700;
    }

    void exitBondRotation(String text) {
        this.isRotateBond = false;
        if (text != null) {
            this.bondHoverLabel = text;
        }
        this.vwr.highlight(null);
        this.vwr.setPickingMode(null, 33);
    }

    void resetBondFields() {
        this.bsRotateBranch = null;
        this.bondAtomIndex2 = -1;
        this.bondAtomIndex1 = -1;
        this.branchAtomIndex = -1;
    }

    void processXtalClick(String id, String action) {
        if (this.processSymop(id, false)) {
            return;
        }
        if ((action = action.intern()).startsWith("mkmode_")) {
            if (!this.alertedNoEdit && action == "mkmode_edit") {
                this.alertedNoEdit = true;
                this.vwr.alert("ModelKit xtal edit has not been implemented");
                return;
            }
            this.processModeClick(action);
        } else if (action.startsWith("mksel_")) {
            this.processSelClick(action);
        } else if (action.startsWith("mkselop_")) {
            while (action != null) {
                action = this.processSelOpClick(action);
            }
        } else if (action.startsWith("mksymmetry_")) {
            this.processSymClick(action);
        } else if (action.startsWith("mkunitcell_")) {
            this.processUCClick(action);
        } else {
            ModelKit.notImplemented("XTAL click " + action);
        }
        this.menu.updateAllXtalMenuOptions();
    }

    boolean processSymop(String id, boolean isFocus) {
        int pt = id.indexOf(".mkop_");
        if (pt >= 0) {
            Object op = this.symop;
            this.symop = Integer.valueOf(id.substring(pt + 6));
            this.showSymop(this.symop);
            if (isFocus) {
                this.symop = op;
            }
            return true;
        }
        return false;
    }

    void setDefaultState(int mode) {
        if (!this.hasUnitCell) {
            mode = 0;
        }
        if (!this.hasUnitCell || this.isXtalState() != this.hasUnitCell) {
            this.setMKState(mode);
            switch (mode) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.getSymViewState() != 0) break;
                    this.setSymViewState(8);
                    break;
                }
            }
        }
    }

    String[] getAllOperators() {
        if (this.allOperators != null) {
            return this.allOperators;
        }
        String data = this.runScriptBuffered("show symop");
        this.allOperators = PT.split(data.trim().replace('\t', ' '), "\n");
        return this.allOperators;
    }

    boolean setHasUnitCell() {
        this.hasUnitCell = this.vwr.getOperativeSymmetry() != null;
        return this.hasUnitCell;
    }

    boolean checkNewModel() {
        boolean isNew = false;
        if (this.vwr.ms != this.lastModelSet) {
            this.lastModelSet = this.vwr.ms;
            isNew = true;
        }
        this.currentModelIndex = Math.max(this.vwr.am.cmi, 0);
        this.iatom0 = this.vwr.ms.am[this.currentModelIndex].firstAtomIndex;
        return isNew;
    }

    String getSymopText() {
        return this.symop == null || this.allOperators == null ? null : (this.symop instanceof Integer ? this.allOperators[(Integer)this.symop - 1] : this.symop.toString());
    }

    String getCenterText() {
        return this.centerAtomIndex < 0 && this.centerPoint == null ? null : (this.centerAtomIndex >= 0 ? this.vwr.getAtomInfo(this.centerAtomIndex) : this.centerPoint.toString());
    }

    void resetAtomPickType() {
        this.pickAtomAssignType = this.lastElementType;
    }

    void setHoverLabel(String activeMenu, String text) {
        if (text == null) {
            return;
        }
        if (activeMenu == "bondMenu") {
            this.bondHoverLabel = text;
        } else if (activeMenu == "atomMenu") {
            this.atomHoverLabel = text;
        } else if (activeMenu == "xtalMenu") {
            this.xtalHoverLabel = this.atomHoverLabel = text;
        }
    }

    String getElementFromUser() {
        String element = this.promptUser(GT.$("Element?"), "");
        return element == null || Elements.elementNumberFromSymbol(element, true) == 0 ? null : element;
    }

    void processMKPropertyItem(String name, boolean TF) {
        int pt = (name = name.substring(2)).indexOf("_");
        if (pt > 0) {
            this.setProperty(name.substring(0, pt), name.substring(pt + 1));
        } else {
            this.setProperty(name, TF);
        }
    }

    private int assignAtom(int atomIndex, String type, boolean autoBond, boolean addHsAndBond, boolean isClick, BS bsAtoms) {
        boolean wasH;
        if (isClick) {
            if (this.isVwrRotateBond()) {
                this.bondAtomIndex1 = atomIndex;
                return -1;
            }
            if (this.processAtomClick(atomIndex) || !this.clickToSetElement && this.vwr.ms.getAtom(atomIndex).getElementNumber() != 1) {
                return -1;
            }
        }
        if (bsAtoms != null) {
            int n = -1;
            int i = bsAtoms.nextSetBit(0);
            while (i >= 0) {
                n = this.assignAtom(i, type, autoBond, addHsAndBond, isClick, null);
                i = bsAtoms.nextSetBit(i + 1);
            }
            return n;
        }
        Atom atom = this.vwr.ms.at[atomIndex];
        if (atom == null) {
            return -1;
        }
        this.vwr.ms.clearDB(atomIndex);
        if (type == null) {
            type = "C";
        }
        BS bs = new BS();
        boolean bl = wasH = atom.getElementNumber() == 1;
        int atomicNumber = type.equals("X") ? -1 : (type.equals("Xx") ? 0 : (PT.isUpperCase(type.charAt(0)) ? Elements.elementNumberFromSymbol(type, true) : -1));
        boolean isDelete = false;
        if (atomicNumber >= 0) {
            boolean doTaint = atomicNumber > 1 || !addHsAndBond;
            this.vwr.ms.setElement(atom, atomicNumber, doTaint);
            this.vwr.shm.setShapeSizeBs(0, 0, this.vwr.rd, BSUtil.newAndSetBit(atomIndex));
            this.vwr.ms.setAtomName(atomIndex, type + atom.getAtomNumber(), doTaint);
            if (this.vwr.getBoolean(603983903)) {
                this.vwr.ms.am[atom.mi].isModelKit = true;
            }
            if (!this.vwr.ms.am[atom.mi].isModelKit || atomicNumber > 1) {
                this.vwr.ms.taintAtom(atomIndex, 0);
            }
        } else if (type.toLowerCase().equals("pl")) {
            atom.setFormalCharge(atom.getFormalCharge() + 1);
        } else if (type.toLowerCase().equals("mi")) {
            atom.setFormalCharge(atom.getFormalCharge() - 1);
        } else if (type.equals("X")) {
            isDelete = true;
        } else if (!type.equals(".") || !this.addXtalHydrogens) {
            return -1;
        }
        if (!addHsAndBond) {
            return atomicNumber;
        }
        this.vwr.ms.removeUnnecessaryBonds(atom, isDelete);
        float dx = 0.0f;
        if (atom.getCovalentBondCount() == 1) {
            if (wasH) {
                dx = 1.5f;
            } else if (!wasH && atomicNumber == 1) {
                dx = 1.0f;
            }
        }
        if (dx != 0.0f) {
            V3 v = V3.newVsub(atom, this.vwr.ms.at[atom.getBondedAtomIndex(0)]);
            float d = v.length();
            v.normalize();
            v.scale(dx - d);
            this.vwr.ms.setAtomCoordRelative(atomIndex, v.x, v.y, v.z);
        }
        BS bsA = BSUtil.newAndSetBit(atomIndex);
        if (isDelete) {
            this.vwr.deleteAtoms(bsA, false);
        }
        if (atomicNumber != 1 && autoBond) {
            this.vwr.ms.validateBspf(false);
            bs = this.vwr.ms.getAtomsWithinRadius(1.0f, bsA, false, null, null);
            bs.andNot(bsA);
            if (bs.nextSetBit(0) >= 0) {
                this.vwr.deleteAtoms(bs, false);
            }
            bs = this.vwr.getModelUndeletedAtomsBitSet(atom.mi);
            bs.andNot(this.vwr.ms.getAtomBitsMDa(1612709900, null, new BS()));
            this.vwr.ms.makeConnections2(0.1f, 1.8f, 1, 0x40000050, bsA, bs, null, false, false, 0.0f);
        }
        if (this.addXtalHydrogens) {
            this.vwr.addHydrogens(bsA, 1);
        }
        return atomicNumber;
    }

    public String cmdAssignSpaceGroup(BS bs, String name, int mi) {
        boolean isP1 = name.equalsIgnoreCase("P1") || name.equals("1");
        this.clearAtomConstraints();
        try {
            BS basis;
            String ita;
            T3[] oabc;
            P3 supercell;
            Map sg;
            T3 m;
            SymmetryInterface sym;
            BS bsCell;
            if (bs != null && bs.isEmpty()) {
                return "";
            }
            BS bsAtoms = mi < 0 ? this.vwr.getThisModelAtoms() : this.vwr.getModelUndeletedAtomsBitSet(mi);
            BS bS = bsCell = isP1 ? bsAtoms : SV.getBitSet(this.vwr.evaluateExpressionAsVariable("{within(unitcell)}"), true);
            if (bs == null) {
                bs = bsAtoms;
            }
            if (bs != null) {
                bsAtoms.and(bs);
                if (!isP1) {
                    bsAtoms.and(bsCell);
                }
            }
            boolean noAtoms = bsAtoms.isEmpty();
            if (mi < 0) {
                int n = mi = noAtoms ? 0 : this.vwr.ms.at[bsAtoms.nextSetBit(0)].getModelIndex();
            }
            if ((sym = this.vwr.ms.getUnitCell(mi)) == null) {
                sym = this.vwr.getSymTemp().setUnitCell(new float[]{10.0f, 10.0f, 10.0f, 90.0f, 90.0f, 90.0f}, false);
            }
            if ((m = sym.getUnitCellMultiplier()) != null && m.z == 1.0f) {
                m.z = 0.0f;
            }
            Map map = sg = noAtoms || isP1 ? null : (Map)this.vwr.findSpaceGroup(bsAtoms, null, false);
            if (sg == null) {
                name = "P1";
                supercell = P3.new3(1.0f, 1.0f, 1.0f);
                oabc = sym.getUnitCellVectors();
                ita = "1";
                basis = null;
            } else {
                supercell = (P3)sg.get("supercell");
                oabc = (P3[])sg.get("unitcell");
                name = (String)sg.get("name");
                ita = (String)sg.get("itaFull");
                basis = (BS)sg.get("basis");
            }
            sym.getUnitCell(oabc, false, null);
            sym.setSpaceGroupTo(ita);
            sym.setSpaceGroupName(name);
            if (basis == null) {
                basis = sym.removeDuplicates(this.vwr.ms, bsAtoms);
            }
            this.vwr.ms.setSpaceGroup(mi, sym, basis);
            P4 pt = SimpleUnitCell.ptToIJK(supercell, 1);
            ModelSet.setUnitCellOffset(sym, pt, 0);
            return name + " basis=" + basis;
        }
        catch (Exception e) {
            if (!Viewer.isJS) {
                e.printStackTrace();
            }
            return e.getMessage();
        }
    }

    public int cmdAssignDeleteAtoms(BS bs) {
        this.clearAtomConstraints();
        bs.and(this.vwr.getThisModelAtoms());
        bs = this.vwr.ms.getSymmetryEquivAtoms(bs);
        if (!bs.isEmpty()) {
            this.vwr.deleteAtoms(bs, false);
        }
        return bs.cardinality();
    }

    private void setBondIndex(int index, boolean isRotate) {
        boolean haveBond;
        if (!isRotate && this.isVwrRotateBond()) {
            this.vwr.setModelKitRotateBondIndex(index);
            return;
        }
        boolean bl = haveBond = this.bondIndex >= 0;
        if (!haveBond && index < 0) {
            return;
        }
        if (index < 0) {
            this.resetBondFields();
            return;
        }
        this.bsRotateBranch = null;
        this.branchAtomIndex = -1;
        this.bondIndex = index;
        this.isRotateBond = isRotate;
        this.bondAtomIndex1 = this.vwr.ms.bo[index].getAtomIndex1();
        this.bondAtomIndex2 = this.vwr.ms.bo[index].getAtomIndex2();
        this.menu.setActiveMenu("bondMenu");
    }

    private boolean handleDragAtom(MouseState pressed, MouseState dragged, int[] countPlusIndices) {
        switch (this.getMKState()) {
            case 0: {
                return false;
            }
            case 2: {
                if (countPlusIndices[0] > 2) {
                    return true;
                }
                ModelKit.notImplemented("drag atom for XTAL edit");
                break;
            }
            case 1: {
                if (this.getSymViewState() == 0) {
                    this.setSymViewState(8);
                }
                switch (countPlusIndices[0]) {
                    case 1: {
                        this.centerAtomIndex = countPlusIndices[1];
                        this.secondAtomIndex = -1;
                        break;
                    }
                    case 2: {
                        this.centerAtomIndex = countPlusIndices[1];
                        this.secondAtomIndex = countPlusIndices[2];
                    }
                }
                this.showXtalSymmetry();
                return true;
            }
        }
        return true;
    }

    private void showSymop(Object symop) {
        this.secondAtomIndex = -1;
        this.symop = symop;
        this.showXtalSymmetry();
    }

    private void showXtalSymmetry() {
        String script = null;
        switch (this.getSymViewState()) {
            case 0: {
                script = "draw * delete";
                break;
            }
            default: {
                P3 offset = null;
                if (this.secondAtomIndex >= 0) {
                    script = "draw ID sym symop " + (this.centerAtomIndex < 0 ? this.centerPoint : " {atomindex=" + this.centerAtomIndex + "}") + " {atomindex=" + this.secondAtomIndex + "}";
                } else {
                    offset = this.viewOffset;
                    if (this.symop == null) {
                        this.symop = 1;
                    }
                    int iatom = this.centerAtomIndex >= 0 ? this.centerAtomIndex : (this.centerPoint != null ? -1 : this.iatom0);
                    script = "draw ID sym symop " + (this.symop == null ? "1" : (this.symop instanceof String ? "'" + this.symop + "'" : PT.toJSON(null, this.symop))) + (iatom < 0 ? this.centerPoint : " {atomindex=" + iatom + "}") + (offset == null ? "" : " offset " + offset);
                }
                this.drawData = this.runScriptBuffered(script);
                this.drawScript = script;
                this.drawData = this.showSymopInfo ? this.drawData.substring(0, this.drawData.indexOf("\n") + 1) : "";
                this.appRunScript(";refresh;set echo top right;echo " + this.drawData.replace('\t', ' '));
            }
        }
    }

    private Object getinfo() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        this.addInfo(info, "addHydrogens", this.addXtalHydrogens);
        this.addInfo(info, "autobond", this.autoBond);
        this.addInfo(info, "clickToSetElement", this.clickToSetElement);
        this.addInfo(info, "hidden", this.menu.hidden);
        this.addInfo(info, "showSymopInfo", this.showSymopInfo);
        this.addInfo(info, "centerPoint", this.centerPoint);
        this.addInfo(info, "centerAtomIndex", this.centerAtomIndex);
        this.addInfo(info, "secondAtomIndex", this.secondAtomIndex);
        this.addInfo(info, "symop", this.symop);
        this.addInfo(info, "offset", this.viewOffset);
        this.addInfo(info, "drawData", this.drawData);
        this.addInfo(info, "drawScript", this.drawScript);
        this.addInfo(info, "isMolecular", this.getMKState() == 0);
        return info;
    }

    private void addInfo(Map<String, Object> info, String key, Object value) {
        if (value != null) {
            info.put(key, value);
        }
    }

    private boolean processAtomClick(int atomIndex) {
        switch (this.getMKState()) {
            case 0: {
                return this.isVwrRotateBond();
            }
            case 1: {
                this.centerAtomIndex = atomIndex;
                if (this.getSymViewState() == 0) {
                    this.setSymViewState(8);
                }
                this.showXtalSymmetry();
                return true;
            }
            case 2: {
                if (atomIndex == this.centerAtomIndex) {
                    return true;
                }
                ModelKit.notImplemented("edit click");
                return false;
            }
        }
        ModelKit.notImplemented("atom click unknown XTAL state");
        return false;
    }

    private void processModeClick(String action) {
        this.processMKPropertyItem(action, false);
    }

    private void processSelClick(String action) {
        if (action == "mksel_atom") {
            this.centerPoint = null;
            this.centerAtomIndex = -1;
            this.secondAtomIndex = -1;
        } else if (action == "mksel_position") {
            String pos = this.promptUser("Enter three fractional coordinates", this.lastCenter);
            if (pos == null) {
                return;
            }
            this.lastCenter = pos;
            P3 p = ModelKit.pointFromTriad(pos);
            if (p == null) {
                this.processSelClick(action);
                return;
            }
            this.centerAtomIndex = -2147483647;
            this.centerPoint = p;
            this.showXtalSymmetry();
        }
    }

    private String processSelOpClick(String action) {
        this.secondAtomIndex = -1;
        if (action == "mkselop_addoffset") {
            String pos = this.promptUser("Enter i j k for an offset for viewing the operator - leave blank to clear", this.lastOffset);
            if (pos == null) {
                return null;
            }
            this.lastOffset = pos;
            if (pos.length() == 0 || pos == "none") {
                this.setProperty("offset", "none");
                return null;
            }
            P3 p = ModelKit.pointFromTriad(pos);
            if (p == null) {
                return action;
            }
            this.setProperty("offset", p);
        } else if (action == "mkselop_atom2") {
            ModelKit.notImplemented(action);
        }
        return null;
    }

    private void processSymClick(String action) {
        if (action == "mksymmetry_none") {
            this.setSymEdit(0);
        } else {
            this.processMKPropertyItem(action, false);
        }
    }

    private void processUCClick(String action) {
        this.processMKPropertyItem(action, false);
        this.showXtalSymmetry();
    }

    private String getHoverLabel(int atomIndex) {
        int state = this.getMKState();
        String msg = null;
        block0 : switch (state) {
            case 1: {
                if (this.symop == null) {
                    this.symop = 1;
                }
                msg = "view symop " + this.symop + " for " + this.vwr.getAtomInfo(atomIndex);
                break;
            }
            case 2: {
                msg = "start editing for " + this.vwr.getAtomInfo(atomIndex);
                break;
            }
            case 0: {
                Atom[] atoms = this.vwr.ms.at;
                if (this.isRotateBond) {
                    if (atomIndex == this.bondAtomIndex1 || atomIndex == this.bondAtomIndex2) {
                        msg = "rotate branch " + atoms[atomIndex].getAtomName();
                        this.branchAtomIndex = atomIndex;
                        this.bsRotateBranch = null;
                    } else {
                        msg = "rotate bond" + this.getBondLabel(atoms);
                        this.bsRotateBranch = null;
                        this.branchAtomIndex = -1;
                    }
                }
                if (this.bondIndex < 0) {
                    if (this.atomHoverLabel.length() <= 2) {
                        msg = this.atomHoverLabel = "Click to change to " + this.atomHoverLabel + " or drag to add " + this.atomHoverLabel;
                        break;
                    }
                    msg = atoms[atomIndex].getAtomName() + ": " + this.atomHoverLabel;
                    this.vwr.highlight(BSUtil.newAndSetBit(atomIndex));
                    break;
                }
                if (msg != null) break;
                switch (this.bsHighlight.cardinality()) {
                    case 0: {
                        this.vwr.highlight(BSUtil.newAndSetBit(atomIndex));
                    }
                    case 1: {
                        if (!this.isRotateBond) {
                            this.menu.setActiveMenu("atomMenu");
                        }
                        if (this.atomHoverLabel.indexOf("charge") >= 0) {
                            int ch = this.vwr.ms.at[atomIndex].getFormalCharge();
                            msg = this.atomHoverLabel + " to " + ((ch += this.atomHoverLabel.indexOf("increase") >= 0 ? 1 : -1) > 0 ? "+" : "") + ch;
                        } else {
                            msg = this.atomHoverLabel;
                        }
                        msg = atoms[atomIndex].getAtomName() + ": " + msg;
                        break block0;
                    }
                    case 2: {
                        msg = this.bondHoverLabel + this.getBondLabel(atoms);
                    }
                }
            }
        }
        return msg;
    }

    private String getBondLabel(Atom[] atoms) {
        return " for " + atoms[Math.min(this.bondAtomIndex1, this.bondAtomIndex2)].getAtomName() + "-" + atoms[Math.max(this.bondAtomIndex1, this.bondAtomIndex2)].getAtomName();
    }

    private Atom getOtherAtomIndex(Atom a1, Atom a2) {
        Bond[] b = a1.bonds;
        Atom ret = null;
        int zmin = Integer.MAX_VALUE;
        int i = -1;
        while (++i < b.length) {
            Atom a;
            if (b[i] == null || !b[i].isCovalent() || (a = b[i].getOtherAtom(a1)) == a2 || a.sZ >= zmin) continue;
            zmin = a.sZ;
            ret = a;
        }
        return ret;
    }

    private boolean isVwrRotateBond() {
        return this.vwr.acm.getBondPickingMode() == 34;
    }

    private String promptUser(String msg, String def) {
        return this.vwr.prompt(msg, def, null, false);
    }

    private void appRunScript(String script) {
        this.vwr.runScript(script);
    }

    private String runScriptBuffered(String script) {
        SB sb = new SB();
        try {
            ((ScriptEval)this.vwr.eval).runBufferedSafely(script, sb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private static boolean isTrue(Object value) {
        return Boolean.valueOf(value.toString()) == Boolean.TRUE;
    }

    private static P3 pointFromTriad(String pos) {
        float[] a = PT.parseFloatArray(PT.replaceAllCharacters(pos, "{,}", " "));
        return a.length == 3 && !Float.isNaN(a[2]) ? P3.new3(a[0], a[1], a[2]) : null;
    }

    private static void notImplemented(String action) {
        System.err.println("ModelKit.notImplemented(" + action + ")");
    }

    public void cmdAssignAtom(int atomIndex, P3 pt, String type, String cmd, boolean isClick) {
        BS bs = atomIndex < 0 ? null : BSUtil.newAndSetBit(atomIndex);
        this.assignAtoms(pt, pt != null, -1, type, cmd, isClick, bs, 0, 0, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignAtoms(P3 pt, boolean newPoint, int atomIndex, String type, String cmd, boolean isClick, BS bs, int atomicNo, int site, SymmetryInterface uc, Lst<P3> points, String packing) {
        float bd;
        boolean haveAtom;
        boolean bl = haveAtom = atomIndex >= 0;
        if (bs == null) {
            bs = new BS();
        }
        int nIgnored = 0;
        int np = 0;
        if (!haveAtom) {
            atomIndex = bs.nextSetBit(0);
        }
        Atom atom = atomIndex < 0 ? null : this.vwr.ms.at[atomIndex];
        float f = bd = pt != null && atom != null ? pt.distance(atom) : -1.0f;
        if (points != null) {
            nIgnored = points.size();
            np = nIgnored++;
            uc.toFractional(pt, true);
            points.addLast(pt);
            if (!newPoint || haveAtom) {
                // empty if block
            }
            uc.getEquivPointList(points, nIgnored, packing + (newPoint && atomIndex < 0 ? "newpt" : ""));
        }
        BS bsEquiv = atom == null ? null : this.vwr.ms.getSymmetryEquivAtoms(bs);
        BS bs0 = BSUtil.copy(bsEquiv);
        int mi = atom == null ? this.vwr.am.cmi : atom.mi;
        int ac = this.vwr.ms.ac;
        int state = this.getMKState();
        boolean isDelete = type.equals("X");
        boolean isXtal = this.vwr.getOperativeSymmetry() != null;
        try {
            P3[] pts;
            if (isDelete) {
                if (isClick) {
                    this.vwr.setModelKitRotateBondIndex(-1);
                }
                this.getConstraint(null, atomIndex, GET_DELETE);
            }
            if (pt == null && points == null) {
                if (atom == null) {
                    return;
                }
                this.vwr.sm.setStatusStructureModified(atomIndex, mi, 1, cmd, 1, bsEquiv);
                this.assignAtom(atomIndex, type, this.autoBond, !isXtal, true, bsEquiv);
                if (!PT.isOneOf(type, ";Mi;Pl;X;")) {
                    this.vwr.ms.setAtomNamesAndNumbers(atomIndex, -ac, null, true);
                }
                this.vwr.sm.setStatusStructureModified(atomIndex, mi, -1, "OK", 1, bsEquiv);
                this.vwr.refresh(3, "assignAtom");
                return;
            }
            this.setMKState(0);
            if (points == null) {
                pts = new P3[]{pt};
            } else {
                pts = new P3[Math.max(0, points.size() - np)];
                int i = pts.length;
                while (--i >= 0) {
                    pts[i] = (P3)points.get(np + i);
                }
            }
            Lst<Atom> vConnections = new Lst<Atom>();
            boolean isConnected = false;
            if (site == 0) {
                if (atom != null) {
                    if (bs.cardinality() <= 1) {
                        vConnections.addLast(atom);
                        isConnected = true;
                    } else if (uc != null) {
                        P3 p = P3.newP(atom);
                        uc.toFractional(p, true);
                        bs.or(bsEquiv);
                        Lst<P3> list = uc.getEquivPoints(null, p, packing);
                        int n = list.size();
                        for (int j = 0; j < n; ++j) {
                            int i = bs.nextSetBit(0);
                            while (i >= 0) {
                                if (this.vwr.ms.at[i].distanceSquared((T3)list.get(j)) < 0.001f) {
                                    vConnections.addLast(this.vwr.ms.at[i]);
                                    bs.clear(i);
                                }
                                i = bs.nextSetBit(i + 1);
                            }
                        }
                    }
                    boolean bl2 = isConnected = vConnections.size() == pts.length;
                    if (isConnected) {
                        float d = Float.MAX_VALUE;
                        int i = pts.length;
                        while (--i >= 0) {
                            float d1 = ((Atom)vConnections.get(i)).distance(pts[i]);
                            if (d == Float.MAX_VALUE) {
                                d1 = d;
                                continue;
                            }
                            if (!(Math.abs(d1 - d) > 0.001f)) continue;
                            isConnected = false;
                            break;
                        }
                    }
                    if (!isConnected) {
                        vConnections.clear();
                    }
                    this.vwr.sm.setStatusStructureModified(atomIndex, mi, 3, cmd, 1, null);
                }
                if (pt != null || points != null) {
                    BS bsM = this.vwr.getThisModelAtoms();
                    int i = bsM.nextSetBit(0);
                    while (i >= 0) {
                        int as = this.vwr.ms.at[i].getAtomSite();
                        if (as > site) {
                            site = as;
                        }
                        i = bsM.nextSetBit(i + 1);
                    }
                    ++site;
                }
            }
            int pickingMode = this.vwr.acm.getAtomPickingMode();
            boolean wasHidden = this.menu.hidden;
            boolean isMK = this.vwr.getBoolean(603983903);
            if (!isMK) {
                this.vwr.setBooleanProperty("modelkitmode", true);
                this.menu.hidden = true;
                this.menu.allowPopup = false;
            }
            Hashtable<String, Object> htParams = new Hashtable<String, Object>();
            if (site > 0) {
                htParams.put("fixedSite", site);
            }
            bs = this.vwr.addHydrogensInline(bs, vConnections, pts, htParams);
            if (bd > 0.0f && !isConnected && vConnections.isEmpty()) {
                this.appRunScript("connect " + (bd - 0.1f) + " " + (bd + 0.01f) + " " + bs0 + " " + bs);
            }
            if (!isMK) {
                this.vwr.setBooleanProperty("modelkitmode", false);
                this.menu.hidden = wasHidden;
                this.menu.allowPopup = true;
                this.vwr.acm.setPickingMode(pickingMode);
                this.menu.hidePopup();
            }
            int atomIndexNew = bs.nextSetBit(0);
            if (points == null) {
                this.assignAtom(atomIndexNew, type, false, atomIndex >= 0 && !isXtal, true, null);
                if (atomIndex >= 0) {
                    this.assignAtom(atomIndex, ".", false, !isXtal, isClick, null);
                }
                this.vwr.ms.setAtomNamesAndNumbers(atomIndexNew, -ac, null, true);
                this.vwr.sm.setStatusStructureModified(atomIndexNew, mi, -3, "OK", 1, bs);
                return;
            }
            if (atomIndexNew >= 0) {
                int i = atomIndexNew;
                while (i >= 0) {
                    this.assignAtom(i, type, false, false, true, null);
                    this.vwr.ms.setSite(this.vwr.ms.at[i], -1, false);
                    this.vwr.ms.setSite(this.vwr.ms.at[i], site, true);
                    i = bs.nextSetBit(i + 1);
                }
                this.vwr.ms.updateBasisFromSite(mi);
            }
            int firstAtom = this.vwr.ms.am[mi].firstAtomIndex;
            if (atomicNo >= 0) {
                atomicNo = Elements.elementNumberFromSymbol(type, true);
                BS bsM = this.vwr.getThisModelAtoms();
                int i = bsM.nextSetBit(0);
                while (i >= 0) {
                    if (this.vwr.ms.at[i].getAtomSite() == site) {
                        this.vwr.ms.setElement(this.vwr.ms.at[i], atomicNo, true);
                    }
                    i = bsM.nextSetBit(i + 1);
                }
            }
            this.vwr.ms.setAtomNamesAndNumbers(firstAtom, -ac, null, true);
            this.vwr.sm.setStatusStructureModified(-1, mi, -3, "OK", 1, bs);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.setMKState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cmdAssignBond(int bondIndex, char type, String cmd) {
        int modelIndex = -1;
        int state = this.getMKState();
        try {
            this.setMKState(0);
            if (type == '-') {
                type = this.pickBondAssignType;
            }
            Atom a1 = this.vwr.ms.bo[bondIndex].atom1;
            modelIndex = a1.mi;
            int ac = this.vwr.ms.ac;
            BS bsAtoms = BSUtil.newAndSetBit(a1.i);
            bsAtoms.set(this.vwr.ms.bo[bondIndex].atom2.i);
            this.vwr.sm.setStatusStructureModified(bondIndex, modelIndex, 6, cmd, 1, bsAtoms);
            boolean ok = this.assignBond(bondIndex, type, bsAtoms);
            this.vwr.ms.setAtomNamesAndNumbers(a1.i, -ac, null, true);
            if (!ok || type == '0') {
                this.vwr.refresh(3, "setBondOrder");
            }
            this.vwr.sm.setStatusStructureModified(bondIndex, modelIndex, -6, "" + type, 1, bsAtoms);
        }
        catch (Exception ex) {
            Logger.error("assignBond failed");
            this.vwr.sm.setStatusStructureModified(bondIndex, modelIndex, -2, "ERROR " + ex, 1, null);
        }
        finally {
            this.setMKState(state);
        }
    }

    private boolean assignBond(int bondIndex, char type, BS bsAtoms) {
        int bondOrder = type - 48;
        Bond bond = this.vwr.ms.bo[bondIndex];
        this.vwr.ms.clearDB(bond.atom1.i);
        switch (type) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                break;
            }
            case 'm': 
            case 'p': {
                bondOrder = Edge.getBondOrderNumberFromOrder(bond.getCovalentOrder()).charAt(0) - 48 + (type == 'p' ? 1 : -1);
                if (bondOrder > 3) {
                    bondOrder = 1;
                    break;
                }
                if (bondOrder >= 0) break;
                bondOrder = 3;
                break;
            }
            default: {
                return false;
            }
        }
        try {
            if (bondOrder == 0) {
                BS bs = new BS();
                bs.set(bond.index);
                this.vwr.ms.deleteBonds(bs, false);
            } else {
                bond.setOrder(bondOrder | 0x20000);
                if (bond.atom1.getElementNumber() != 1 && bond.atom2.getElementNumber() != 1) {
                    this.vwr.ms.removeUnnecessaryBonds(bond.atom1, false);
                    this.vwr.ms.removeUnnecessaryBonds(bond.atom2, false);
                }
            }
        }
        catch (Exception e) {
            Logger.error("Exception in seBondOrder: " + e.toString());
        }
        if (type != '0' && this.addXtalHydrogens) {
            this.vwr.addHydrogens(bsAtoms, 1);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cmdAssignConnect(int index, int index2, char type, String cmd) {
        Atom[] atoms = this.vwr.ms.at;
        if (index < 0 || index2 < 0 || index >= atoms.length || index2 >= atoms.length || atoms[index] == null || atoms[index2] == null) {
            return;
        }
        int state = this.getMKState();
        try {
            float[][] connections = AU.newFloat2(1);
            connections[0] = new float[]{index, index2};
            short modelIndex = atoms[index].mi;
            BS bs = BSUtil.newAndSetBit(index);
            bs.set(index2);
            BS bsBonds = this.vwr.ms.getBondsForSelectedAtoms(bs, false);
            this.vwr.sm.setStatusStructureModified(-1, modelIndex, 6, cmd, 1, bs);
            this.vwr.ms.connect(connections);
            int ac = this.vwr.ms.ac;
            this.assignAtom(index, ".", true, true, false, null);
            this.assignAtom(index2, ".", true, true, false, null);
            this.vwr.ms.setAtomNamesAndNumbers(index, -ac, null, true);
            bsBonds = this.vwr.ms.getBondsForSelectedAtoms(bs, false);
            this.vwr.sm.setStatusStructureModified(bsBonds.nextSetBit(0), modelIndex, -6, "OK", 1, bs);
            if (type != '1') {
                bs = this.vwr.getBondsForSelectedAtoms(bs);
                int bondIndex = bs.nextSetBit(0);
                this.cmdAssignBond(bondIndex, type, cmd);
            }
            this.vwr.refresh(3, "assignConnect");
        }
        catch (Exception exception) {
        }
        finally {
            this.setMKState(state);
        }
    }

    public void assignAtomClick(int atomIndex, String element, P3 ptNew) {
        this.appRunScript("modelkit " + (this.vwr.getOperativeSymmetry() == null ? "assign atom" : "ADD") + " ({" + atomIndex + "}) \"" + element + "\" " + (ptNew == null ? "" : Escape.eP(ptNew)) + " true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cmdAssignAddAtoms(String type, P3[] pts, BS bsAtoms, String packing, String cmd, boolean isClick) {
        try {
            int atomIndex;
            this.vwr.pushHoldRepaintWhy("modelkit");
            boolean isPoint = bsAtoms == null;
            int n = atomIndex = isPoint ? -1 : bsAtoms.nextSetBit(0);
            if (!isPoint && atomIndex < 0) {
                int n2 = 0;
                return n2;
            }
            SymmetryInterface uc = this.vwr.getOperativeSymmetry();
            if (uc == null) {
                int i;
                if (isPoint) {
                    for (i = 0; i < pts.length; ++i) {
                        this.assignAtoms(pts[i], true, -1, type, cmd, false, null, 1, -1, null, null, "");
                    }
                }
                i = isPoint ? pts.length : 0;
                return i;
            }
            BS bsM = this.vwr.getThisModelAtoms();
            int n3 = bsM.cardinality();
            if (n3 == 0) {
                packing = "zapped;" + packing;
            }
            String stype = "" + type;
            Lst<P3> list = new Lst<P3>();
            int atomicNo = -1;
            int site = 0;
            P3 pf = null;
            if (pts.length == 1) {
                pf = P3.newP(pts[0]);
                uc.toFractional(pf, true);
            }
            int i = bsM.nextSetBit(0);
            while (i >= 0) {
                P3 p = P3.newP(this.vwr.ms.at[i]);
                uc.toFractional(p, true);
                if (pf != null && pf.distanceSquared(p) < 1.96E-6f) {
                    site = this.vwr.ms.at[i].getAtomSite();
                    if (type == null) {
                        type = this.vwr.ms.at[i].getElementSymbolIso(true);
                    }
                }
                list.addLast(p);
                i = bsM.nextSetBit(i + 1);
            }
            int nIgnored = list.size();
            packing = "fromfractional;tocartesian;" + packing;
            if (type != null) {
                atomicNo = Elements.elementNumberFromSymbol(type, true);
            }
            if (isPoint) {
                BS bsEquiv = bsAtoms == null ? null : this.vwr.ms.getSymmetryEquivAtoms(bsAtoms);
                for (int i2 = 0; i2 < pts.length; ++i2) {
                    this.assignAtoms(P3.newP(pts[i2]), true, atomIndex, stype, null, false, bsEquiv, atomicNo, site, uc, list, packing);
                }
            } else {
                BS sites = new BS();
                int i3 = bsAtoms.nextSetBit(0);
                while (i3 >= 0) {
                    Atom a = this.vwr.ms.at[i3];
                    site = a.getAtomSite();
                    if (!sites.get(site)) {
                        sites.set(site);
                        stype = type == null ? a.getElementSymbolIso(true) : stype;
                        this.assignAtoms(P3.newP(a), false, -1, stype, null, false, null, atomicNo, site, uc, list, packing);
                        int j = list.size();
                        while (--j >= nIgnored) {
                            list.removeItemAt(j);
                        }
                    }
                    i3 = bsAtoms.nextSetBit(i3 + 1);
                }
            }
            if (isClick) {
                this.vwr.setPickingMode("dragAtom", 0);
            }
            int n4 = n3 = this.vwr.getThisModelAtoms().cardinality() - n3;
            return n4;
        }
        catch (Exception e) {
            e.printStackTrace();
            int n = 0;
            return n;
        }
        finally {
            this.vwr.popHoldRepaint("modelkit");
        }
    }

    public int cmdAssignMoveAtoms(BS bsSelected, int iatom, P3 p, boolean allowProjection) {
        SymmetryInterface sym = this.vwr.getOperativeSymmetry();
        if (sym == null) {
            return 0;
        }
        int nAtoms = bsSelected.cardinality();
        if (bsSelected.intersects(this.vwr.getMotionFixedAtoms()) || nAtoms > 1 && (this.constraint != null || sym.getSpaceGroupOperationCount() > 1)) {
            p.x = Float.NaN;
            return 0;
        }
        if (nAtoms > 1) {
            return 0;
        }
        int n = 0;
        BS bsOcc = new BS();
        boolean checkOcc = false;
        Atom a = this.vwr.ms.at[iatom];
        if (!checkOcc || this.vwr.ms.getOccupancyFloat(a.i) == 100.0f) {
            bsOcc.set(a.i);
        } else {
            this.vwr.getAtomsNearPt(1.0E-4f, a, bsOcc);
            int i = bsOcc.nextSetBit(0);
            while (i >= 0) {
                if (this.vwr.ms.getOccupancyFloat(i) == 100.0f) {
                    bsOcc.clear(i);
                }
                i = bsOcc.nextSetBit(i + 1);
            }
        }
        boolean isOccSet = bsOcc.cardinality() > 1;
        n = this.moveConstrained(iatom, p, !isOccSet, allowProjection);
        if (n == 0 || Float.isNaN(p.x) || !isOccSet) {
            this.vwr.setStatusAtomMoved(true, bsOcc);
            return n;
        }
        int i = bsOcc.nextSetBit(0);
        while (i >= 0) {
            iatom = this.constraint == null ? this.vwr.ms.getBasisAtom((int)i).i : i;
            n += this.assignMoveAtom(iatom, p, null);
            i = bsOcc.nextSetBit(i + 1);
        }
        this.vwr.setStatusAtomMoved(true, bsOcc);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int assignMoveAtom(int iatom, P3 pt, BS bsFixed) {
        if (Float.isNaN(pt.x) || iatom < 0) {
            return 0;
        }
        if (iatom < 0) {
            return 0;
        }
        BS bs = BSUtil.newAndSetBit(iatom);
        bs.and(this.vwr.getThisModelAtoms());
        if (bs.isEmpty()) {
            return 0;
        }
        int state = this.getMKState();
        this.setMKState(0);
        try {
            int n;
            BS bseq = this.vwr.ms.getSymmetryEquivAtoms(bs);
            SymmetryInterface sg = this.vwr.getCurrentUnitCell();
            if (this.getConstraint((SymmetryInterface)sg, (int)bseq.nextSetBit((int)0), (int)ModelKit.GET_CREATE).type == 6) {
                int n2 = 0;
                return n2;
            }
            if (bsFixed != null) {
                bseq.andNot(bsFixed);
            }
            if ((n = bseq.cardinality()) == 0) {
                int n3 = 0;
                return n3;
            }
            Atom a = this.vwr.ms.at[iatom];
            int[] v0 = sg.getInvariantSymops(a, null);
            int[] v1 = sg.getInvariantSymops(pt, v0);
            if (v1 == null != (v0 == null) || !Arrays.equals(v0, v1)) {
                int n4 = 0;
                return n4;
            }
            P3[] points = new P3[n];
            int ia0 = bseq.nextSetBit(0);
            if (!this.fillPointsForMove(sg, bseq, ia0, a, pt, points)) {
                int n5 = 0;
                return n5;
            }
            short mi = this.vwr.ms.at[ia0].mi;
            this.vwr.sm.setStatusStructureModified(ia0, mi, 3, "dragatom", n, bseq);
            int k = 0;
            int ia = bseq.nextSetBit(0);
            while (ia >= 0) {
                P3 p = points[k++];
                this.vwr.ms.setAtomCoord(ia, p.x, p.y, p.z);
                ia = bseq.nextSetBit(ia + 1);
            }
            this.vwr.sm.setStatusStructureModified(ia0, mi, -3, "dragatom", n, bseq);
            int n6 = n;
            return n6;
        }
        finally {
            this.setMKState(state);
        }
    }

    private boolean fillPointsForMove(SymmetryInterface sg, BS bseq, int i0, P3 a, P3 pt, P3[] points) {
        float d = a.distance(pt);
        P3 fa = P3.newP(a);
        P3 fb = P3.newP(pt);
        sg.toFractional(fa, true);
        sg.toFractional(fb, true);
        int k = 0;
        int i = i0;
        while (i >= 0) {
            P3 p = P3.newP(this.vwr.ms.at[i]);
            sg.toFractional(p, true);
            M4 m = sg.getTransform(fa, p, false);
            if (m == null) {
                return false;
            }
            P3 p2 = P3.newP(fb);
            m.rotTrans(p2);
            sg.toCartesian(p2, true);
            if (Math.abs(d - this.vwr.ms.at[i].distance(p2)) > 0.001f) {
                return false;
            }
            points[k++] = p2;
            i = bseq.nextSetBit(i + 1);
        }
        fa.setT(points[0]);
        sg.toFractional(fa, true);
        k = points.length;
        while (--k >= 0) {
            fb.setT(points[k]);
            sg.toFractional(fb, true);
            M4 m = sg.getTransform(fa, fb, false);
            if (m == null) {
                return false;
            }
            int i2 = points.length;
            while (--i2 > k) {
                if (!(points[i2].distance(points[k]) < 0.1f)) continue;
                return false;
            }
        }
        return true;
    }

    public void clearAtomConstraints() {
        if (this.atomConstraints != null) {
            int i = this.atomConstraints.length;
            while (--i >= 0) {
                this.atomConstraints[i] = null;
            }
        }
    }

    public boolean hasConstraint(int iatom, boolean ignoreGeneral, boolean addNew) {
        Constraint c = this.getConstraint(this.vwr.getOperativeSymmetry(), iatom, addNew ? GET_CREATE : GET);
        return c != null && (!ignoreGeneral || c.type != 7);
    }

    public int moveConstrained(int iatom, P3 ptNew, boolean doAssign, boolean allowProjection) {
        SymmetryInterface sym;
        int n = 0;
        if (iatom < 0 || (sym = this.vwr.getOperativeSymmetry()) == null) {
            return 0;
        }
        Atom a = this.vwr.ms.at[iatom];
        Constraint c = this.constraint;
        if (c == null) {
            c = this.getConstraint(sym, iatom, GET_CREATE);
            if (c.type == 6) {
                iatom = -1;
            } else {
                Atom b = this.vwr.ms.getBasisAtom(iatom);
                P3 fa = P3.newP(a);
                sym.toFractional(fa, true);
                P3 fb = P3.newP(b);
                sym.toFractional(fb, true);
                M4 m = sym.getTransform(fa, fb, true);
                if (m == null) {
                    System.err.println("ModelKit - null matrix for " + iatom + " " + a + " to " + b);
                    iatom = -1;
                } else {
                    sym.toFractional(ptNew, true);
                    m.rotTrans(ptNew);
                    sym.toCartesian(ptNew, true);
                    c.constrain(b, ptNew, allowProjection);
                    iatom = b.i;
                }
            }
        } else {
            c.constrain(this.vwr.ms.at[iatom], ptNew, allowProjection);
        }
        if (iatom >= 0 && !Float.isNaN(ptNew.x)) {
            if (!doAssign) {
                return 1;
            }
            n = this.assignMoveAtom(iatom, ptNew, null);
        }
        ptNew.x = Float.NaN;
        return n;
    }

    private Constraint getConstraint(SymmetryInterface sym, int ia, int mode) {
        Constraint ac;
        if (ia < 0) {
            return null;
        }
        Atom a = this.vwr.ms.getBasisAtom(ia);
        int iatom = a.i;
        Constraint constraint = ac = this.atomConstraints != null && iatom < this.atomConstraints.length ? this.atomConstraints[iatom] : null;
        if (ac != null || mode != GET_CREATE) {
            if (ac != null && mode == GET_DELETE) {
                this.atomConstraints[iatom] = null;
            }
            return ac;
        }
        if (sym == null) {
            return this.addConstraint(iatom, new Constraint(a, 0, null));
        }
        int[] ops = sym.getInvariantSymops(a, null);
        if (Logger.debugging) {
            System.out.println("MK.getConstraint atomIndex=" + iatom + " symops=" + Arrays.toString(ops));
        }
        if (ops.length == 0) {
            return this.addConstraint(iatom, new Constraint(a, 7, null));
        }
        P4 plane1 = null;
        Object[] line1 = null;
        int i = ops.length;
        while (--i >= 0) {
            Object[] line2 = null;
            Object c = sym.getSymmetryInfoAtom(this.vwr.ms, iatom, null, ops[i], null, a, null, "invariant", 1275068418, 0.0f, -1, 0);
            if (c instanceof String) {
                return locked;
            }
            if (c instanceof P4) {
                P4 plane = (P4)c;
                if (plane1 == null) {
                    plane1 = plane;
                    continue;
                }
                Lst<Object> line = Measure.getIntersectionPP(plane1, plane);
                if (line == null || line.size() == 0) {
                    return locked;
                }
                line2 = new Object[]{line.get(0), line.get(1)};
            } else {
                if (c instanceof P3) {
                    return locked;
                }
                line2 = (Object[])c;
            }
            if (line2 == null) continue;
            if (line1 == null) {
                line1 = line2;
            } else {
                T3 v1 = (T3)line1[1];
                if (Math.abs(v1.dot((T3)line2[1])) < 0.999f) {
                    return locked;
                }
            }
            if (plane1 == null || !(Math.abs(plane1.dot((T3)line2[1])) > 0.001f)) continue;
            return locked;
        }
        if (line1 != null) {
            line1[0] = P3.newP(a);
        }
        return this.addConstraint(iatom, line1 != null ? new Constraint(a, 4, line1) : (plane1 != null ? new Constraint(a, 5, new Object[]{plane1}) : new Constraint(a, 7, null)));
    }

    private Constraint addConstraint(int iatom, Constraint c) {
        if (c == null) {
            if (this.atomConstraints != null && this.atomConstraints.length > iatom) {
                this.atomConstraints[iatom] = null;
            }
            return null;
        }
        if (this.atomConstraints == null) {
            this.atomConstraints = new Constraint[this.vwr.ms.ac + 10];
        }
        if (this.atomConstraints.length < iatom + 10) {
            Constraint[] a = new Constraint[this.vwr.ms.ac + 10];
            System.arraycopy(this.atomConstraints, 0, a, 0, this.atomConstraints.length);
            this.atomConstraints = a;
        }
        this.atomConstraints[iatom] = c;
        return this.atomConstraints[iatom];
    }

    public void addLockedAtoms(BS bs) {
        SymmetryInterface sg = this.vwr.getOperativeSymmetry();
        if (sg == null) {
            return;
        }
        BS bsm = this.vwr.getThisModelAtoms();
        int i = bsm.nextSetBit(0);
        while (i >= 0) {
            if (this.getConstraint((SymmetryInterface)sg, (int)i, (int)ModelKit.GET_CREATE).type == 6) {
                bs.set(i);
            }
            i = bsm.nextSetBit(i + 1);
        }
    }

    private static class Constraint {
        public static final int TYPE_NONE = 0;
        public static final int TYPE_DISTANCE = 1;
        public static final int TYPE_ANGLE = 2;
        public static final int TYPE_DIHEDRAL = 3;
        public static final int TYPE_VECTOR = 4;
        public static final int TYPE_PLANE = 5;
        public static final int TYPE_LOCKED = 6;
        public static final int TYPE_GENERAL = 7;
        int type;
        private P3 pt;
        private P3 offset;
        private P4 plane;
        private V3 unitVector;
        private P3[] points;
        private double value;

        public Constraint(P3 pt, int type, Object[] params) throws IllegalArgumentException {
            this.pt = pt;
            this.type = type;
            switch (type) {
                case 0: 
                case 6: 
                case 7: {
                    break;
                }
                case 4: {
                    this.offset = (P3)params[0];
                    this.unitVector = V3.newV((T3)params[1]);
                    this.unitVector.normalize();
                    break;
                }
                case 5: {
                    this.plane = (P4)params[0];
                    break;
                }
                case 1: {
                    this.value = (Double)params[0];
                    this.points = new P3[]{(P3)params[1], null};
                    break;
                }
                case 2: {
                    this.value = (Double)params[0];
                    this.points = new P3[]{(P3)params[1], (P3)params[2], null};
                    break;
                }
                case 3: {
                    this.value = (Double)params[0];
                    this.points = new P3[]{(P3)params[1], (P3)params[2], (P3)params[3], null};
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public void constrain(P3 ptOld, P3 ptNew, boolean allowProjection) {
            V3 v = new V3();
            P3 p = P3.newP(ptOld);
            float d = 0.0f;
            switch (this.type) {
                case 0: {
                    return;
                }
                case 7: {
                    return;
                }
                case 6: {
                    ptNew.x = Float.NaN;
                    return;
                }
                case 4: {
                    if (this.pt == null && (d = Measure.projectOntoAxis(p, this.offset, this.unitVector, v)) * d >= 1.96E-6f) {
                        ptNew.x = Float.NaN;
                        return;
                    }
                    d = Measure.projectOntoAxis(ptNew, this.offset, this.unitVector, v);
                    break;
                }
                case 5: {
                    if (this.pt == null && Math.abs(Measure.getPlaneProjection(p, this.plane, v, v)) > 0.01f) {
                        ptNew.x = Float.NaN;
                        return;
                    }
                    d = Measure.getPlaneProjection(ptNew, this.plane, v, v);
                    ptNew.setT(v);
                }
            }
            if (!allowProjection && (double)Math.abs(d) > 1.0E-10) {
                ptNew.x = Float.NaN;
            }
        }
    }
}

