/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGUniverse;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GuiSizesHelper;
import org.openstreetmap.josm.tools.HiDPISupport;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageOverlay;
import org.openstreetmap.josm.tools.ImageResizeMode;
import org.openstreetmap.josm.tools.ImageResource;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Mediawiki;
import org.openstreetmap.josm.tools.OsmPrimitiveImageProvider;
import org.openstreetmap.josm.tools.ResourceProvider;
import org.openstreetmap.josm.tools.SAXReturnException;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ImageProvider {
    private static final String HTTP_PROTOCOL = "http://";
    private static final String HTTPS_PROTOCOL = "https://";
    private static final String WIKI_PROTOCOL = "wiki://";
    public static final String PROP_TRANSPARENCY_FORCED = "josm.transparency.forced";
    public static final String PROP_TRANSPARENCY_COLOR = "josm.transparency.color";
    protected Collection<String> dirs;
    protected String id;
    protected String subdir;
    protected final String name;
    protected File archive;
    protected String inArchiveDir;
    protected int virtualWidth = -1;
    protected int virtualHeight = -1;
    protected int virtualMaxWidth = -1;
    protected int virtualMaxHeight = -1;
    protected boolean optional;
    protected boolean suppressWarnings;
    protected List<ImageOverlay> overlayInfo;
    protected boolean isDisabled;
    protected boolean multiResolution = true;
    private static SVGUniverse svgUniverse;
    private static final Map<String, ImageResource> cache;
    private static final Map<OsmPrimitiveType, ImageIcon> osmPrimitiveTypeCache;
    private static final ExecutorService IMAGE_FETCHER;
    private static final Pattern dataUrlPattern;
    protected static final int CURSOR_SIZE_HOTSPOT_IS_RELATIVE_TO = 32;
    private static final Point DEFAULT_HOTSPOT;
    private static final Point CROSSHAIR_HOTSPOT;

    public ImageProvider(String subdir, String name) {
        this.subdir = subdir;
        this.name = Objects.requireNonNull(name, "name");
    }

    public ImageProvider(String name) {
        this.name = Objects.requireNonNull(name, "name");
    }

    public ImageProvider(ImageProvider image) {
        this.dirs = image.dirs;
        this.id = image.id;
        this.subdir = image.subdir;
        this.name = image.name;
        this.archive = image.archive;
        this.inArchiveDir = image.inArchiveDir;
        this.virtualWidth = image.virtualWidth;
        this.virtualHeight = image.virtualHeight;
        this.virtualMaxWidth = image.virtualMaxWidth;
        this.virtualMaxHeight = image.virtualMaxHeight;
        this.optional = image.optional;
        this.suppressWarnings = image.suppressWarnings;
        this.overlayInfo = image.overlayInfo;
        this.isDisabled = image.isDisabled;
        this.multiResolution = image.multiResolution;
    }

    public ImageProvider setDirs(Collection<String> dirs) {
        this.dirs = dirs;
        return this;
    }

    public ImageProvider setId(String id) {
        this.id = id;
        return this;
    }

    public ImageProvider setArchive(File archive) {
        this.archive = archive;
        return this;
    }

    public ImageProvider setInArchiveDir(String inArchiveDir) {
        this.inArchiveDir = inArchiveDir;
        return this;
    }

    public ImageProvider addOverlay(ImageOverlay overlay) {
        if (this.overlayInfo == null) {
            this.overlayInfo = new LinkedList<ImageOverlay>();
        }
        this.overlayInfo.add(overlay);
        return this;
    }

    public ImageProvider setSize(Dimension size) {
        this.virtualWidth = size.width;
        this.virtualHeight = size.height;
        return this;
    }

    public ImageProvider setSize(ImageSizes size) {
        return this.setSize(size.getImageDimension());
    }

    public ImageProvider setSize(int width, int height) {
        this.virtualWidth = width;
        this.virtualHeight = height;
        return this;
    }

    public ImageProvider setWidth(int width) {
        this.virtualWidth = width;
        return this;
    }

    public ImageProvider setHeight(int height) {
        this.virtualHeight = height;
        return this;
    }

    public ImageProvider setMaxSize(Dimension maxSize) {
        this.virtualMaxWidth = maxSize.width;
        this.virtualMaxHeight = maxSize.height;
        return this;
    }

    public ImageProvider resetMaxSize(Dimension maxSize) {
        if (this.virtualMaxWidth == -1 || maxSize.width < this.virtualMaxWidth) {
            this.virtualMaxWidth = maxSize.width;
        }
        if (this.virtualMaxHeight == -1 || maxSize.height < this.virtualMaxHeight) {
            this.virtualMaxHeight = maxSize.height;
        }
        return this;
    }

    public ImageProvider setMaxSize(ImageSizes size) {
        return this.setMaxSize(size.getImageDimension());
    }

    public ImageProvider setMaxSize(int maxSize) {
        return this.setMaxSize(new Dimension(maxSize, maxSize));
    }

    public ImageProvider setMaxWidth(int maxWidth) {
        this.virtualMaxWidth = maxWidth;
        return this;
    }

    public ImageProvider setMaxHeight(int maxHeight) {
        this.virtualMaxHeight = maxHeight;
        return this;
    }

    public ImageProvider setOptional(boolean optional) {
        this.optional = optional;
        return this;
    }

    public ImageProvider setSuppressWarnings(boolean suppressWarnings) {
        this.suppressWarnings = suppressWarnings;
        return this;
    }

    public ImageProvider setDisabled(boolean disabled) {
        this.isDisabled = disabled;
        return this;
    }

    public ImageProvider setMultiResolution(boolean multiResolution) {
        this.multiResolution = multiResolution;
        return this;
    }

    public boolean isRemote() {
        return this.name.startsWith(HTTP_PROTOCOL) || this.name.startsWith(HTTPS_PROTOCOL) || this.name.startsWith(WIKI_PROTOCOL);
    }

    public ImageIcon get() {
        ImageResource ir = this.getResource();
        if (ir == null) {
            return null;
        }
        if (Logging.isTraceEnabled()) {
            Logging.trace("get {0} from {1}", this, Thread.currentThread());
        }
        if (this.virtualMaxWidth != -1 || this.virtualMaxHeight != -1) {
            return ir.getImageIcon(new Dimension(this.virtualMaxWidth, this.virtualMaxHeight), this.multiResolution, null);
        }
        return ir.getImageIcon(new Dimension(this.virtualWidth, this.virtualHeight), this.multiResolution, ImageResizeMode.AUTO);
    }

    public String getDataURL() {
        ImageIcon ii = this.get();
        if (ii != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                Image i = ii.getImage();
                if (i instanceof RenderedImage) {
                    ImageIO.write((RenderedImage)((Object)i), "png", os);
                    return "data:image/png;base64," + Base64.getEncoder().encodeToString(os.toByteArray());
                }
            }
            catch (IOException ioe) {
                return null;
            }
        }
        return null;
    }

    public CompletableFuture<Void> getAsync(Consumer<? super ImageIcon> action) {
        return this.isRemote() ? CompletableFuture.supplyAsync(this::get, IMAGE_FETCHER).thenAcceptAsync(action, (Executor)IMAGE_FETCHER) : CompletableFuture.completedFuture(this.get()).thenAccept(action);
    }

    public ImageResource getResource() {
        ImageResource ir = this.getIfAvailableImpl();
        if (ir == null) {
            if (!this.optional) {
                String ext = this.name.indexOf(46) != -1 ? "" : ".???";
                throw new JosmRuntimeException(I18n.tr("Fatal: failed to locate image ''{0}''. This is a serious configuration problem. JOSM will stop working.", this.name + ext));
            }
            if (!this.suppressWarnings) {
                Logging.error(I18n.tr("Failed to locate image ''{0}''", this.name));
            }
            return null;
        }
        if (this.overlayInfo != null) {
            ir = new ImageResource(ir, this.overlayInfo);
        }
        if (this.isDisabled) {
            ir.setDisabled(true);
        }
        return ir;
    }

    public CompletableFuture<Void> getResourceAsync(Consumer<? super ImageResource> action) {
        return this.isRemote() ? CompletableFuture.supplyAsync(this::getResource, IMAGE_FETCHER).thenAcceptAsync(action, (Executor)IMAGE_FETCHER) : CompletableFuture.completedFuture(this.getResource()).thenAccept(action);
    }

    public static ImageIcon get(String subdir, String name) {
        return new ImageProvider(subdir, name).get();
    }

    public static ImageIcon get(String name) {
        return new ImageProvider(name).get();
    }

    public static ImageIcon get(String subdir, String name, ImageSizes size) {
        return new ImageProvider(subdir, name).setSize(size).get();
    }

    public static ImageIcon getEmpty(ImageSizes size) {
        Dimension iconRealSize = GuiSizesHelper.getDimensionDpiAdjusted(size.getImageDimension());
        return new ImageIcon(new BufferedImage(iconRealSize.width, iconRealSize.height, 2));
    }

    public static ImageIcon getIfAvailable(String subdir, String name) {
        return new ImageProvider(subdir, name).setOptional(true).get();
    }

    public static ImageIcon get(String name, ImageSizes size) {
        return new ImageProvider(name).setSize(size).get();
    }

    public static ImageIcon getIfAvailable(String name) {
        return new ImageProvider(name).setOptional(true).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        cache.clear();
        Map<OsmPrimitiveType, ImageIcon> map = osmPrimitiveTypeCache;
        synchronized (map) {
            osmPrimitiveTypeCache.clear();
        }
    }

    private ImageResource getIfAvailableImpl() {
        ImageType type;
        String prefix;
        String string = prefix = this.isDisabled ? "dis:" : "";
        if (this.name.startsWith("data:")) {
            String url = this.name;
            ImageResource ir = cache.get(prefix + url);
            if (ir != null) {
                return ir;
            }
            ir = ImageProvider.getIfAvailableDataUrl(url);
            if (ir != null) {
                cache.put(prefix + url, ir);
            }
            return ir;
        }
        ImageType imageType = type = Utils.hasExtension(this.name, "svg") ? ImageType.SVG : ImageType.OTHER;
        if (this.name.startsWith(HTTP_PROTOCOL) || this.name.startsWith(HTTPS_PROTOCOL)) {
            String url = this.name;
            ImageResource ir = cache.get(prefix + url);
            if (ir != null) {
                return ir;
            }
            ir = ImageProvider.getIfAvailableHttp(url, type);
            if (ir != null) {
                cache.put(prefix + url, ir);
            }
            return ir;
        }
        if (this.name.startsWith(WIKI_PROTOCOL)) {
            ImageResource ir = cache.get(prefix + this.name);
            if (ir != null) {
                return ir;
            }
            ir = ImageProvider.getIfAvailableWiki(this.name, type);
            if (ir != null) {
                cache.put(prefix + this.name, ir);
            }
            return ir;
        }
        if (this.subdir == null) {
            this.subdir = "";
        } else if (!this.subdir.isEmpty() && !this.subdir.endsWith("/")) {
            this.subdir = this.subdir + '/';
        }
        String[] extensions = this.name.indexOf(46) != -1 ? new String[]{""} : new String[]{".png", ".svg"};
        boolean typeArchive = false;
        boolean typeLocal = true;
        Integer[] integerArray = new Integer[]{0, 1};
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int place = integerArray[i];
            block5: for (String ext : extensions) {
                if (".svg".equals(ext)) {
                    type = ImageType.SVG;
                } else if (".png".equals(ext)) {
                    type = ImageType.OTHER;
                }
                String fullName = this.subdir + this.name + ext;
                String cacheName = prefix + fullName;
                if (!Utils.isEmpty(this.dirs)) {
                    cacheName = "id:" + this.id + ':' + fullName;
                    if (this.archive != null) {
                        cacheName = cacheName + ':' + this.archive.getName();
                    }
                }
                switch (place) {
                    case 0: {
                        if (this.archive == null) continue block5;
                        cacheName = "zip:" + this.archive.hashCode() + ':' + cacheName;
                        ImageResource ir = cache.get(cacheName);
                        if (ir != null) {
                            return ir;
                        }
                        ir = ImageProvider.getIfAvailableZip(fullName, this.archive, this.inArchiveDir, type);
                        if (ir == null) continue block5;
                        cache.put(cacheName, ir);
                        return ir;
                    }
                    case 1: {
                        ImageResource ir = cache.get(cacheName);
                        if (ir != null) {
                            return ir;
                        }
                        URL path = this.getImageUrl(fullName);
                        if (path == null || (ir = ImageProvider.getIfAvailableLocalURL(path, type)) == null) continue block5;
                        cache.put(cacheName, ir);
                        return ir;
                    }
                }
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static ImageResource getIfAvailableHttp(String url, ImageType type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 15[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageResource getIfAvailableDataUrl(String url) {
        Matcher m = dataUrlPattern.matcher(url);
        if (m.matches()) {
            byte[] bytes;
            String base64 = m.group(2);
            String data = m.group(3);
            try {
                bytes = ";base64".equals(base64) ? Base64.getDecoder().decode(data) : Utils.decodeUrl(data).getBytes(StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException ex) {
                Logging.log(Logging.LEVEL_WARN, "Unable to decode URL data part: " + ex.getMessage() + " (" + data + ')', ex);
                return null;
            }
            String mediatype = m.group(1);
            if ("image/svg+xml".equals(mediatype)) {
                SVGDiagram svg;
                String s = new String(bytes, StandardCharsets.UTF_8);
                if (s.length() > 4 && "PNG".equals(s.substring(1, 4))) {
                    Logging.warn("url contains PNG file " + url);
                    return null;
                }
                SVGUniverse sVGUniverse = ImageProvider.getSvgUniverse();
                synchronized (sVGUniverse) {
                    URI uri = ImageProvider.getSvgUniverse().loadSVG(new StringReader(s), Utils.encodeUrl(s));
                    svg = ImageProvider.getSvgUniverse().getDiagram(uri);
                }
                if (svg == null) {
                    Logging.warn("Unable to process svg: " + s);
                    return null;
                }
                return new ImageResource(svg);
            }
            try {
                BufferedImage img = ImageProvider.read(new ByteArrayInputStream(bytes), false, true);
                return img == null ? null : new ImageResource(img);
            }
            catch (IOException | UnsatisfiedLinkError e) {
                Logging.log(Logging.LEVEL_WARN, "Exception while reading image:", e);
            }
        }
        return null;
    }

    private static ImageResource getIfAvailableWiki(String name, ImageType type) {
        List<String> defaultBaseUrls = Arrays.asList("https://wiki.openstreetmap.org/w/images/", "https://upload.wikimedia.org/wikipedia/commons/", "https://wiki.openstreetmap.org/wiki/File:");
        List<String> baseUrls = Config.getPref().getList("image-provider.wiki.urls", defaultBaseUrls);
        String fn = name.substring(name.lastIndexOf(47) + 1);
        ImageResource result = null;
        for (String b : baseUrls) {
            String url;
            if (b.endsWith(":")) {
                url = ImageProvider.getImgUrlFromWikiInfoPage(b, fn);
                if (url == null) {
                    continue;
                }
            } else {
                url = Mediawiki.getImageUrl(b, fn);
            }
            if ((result = ImageProvider.getIfAvailableHttp(url, type)) == null) continue;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ImageResource getIfAvailableZip(String fullName, File archive, String inArchiveDir, ImageType type) {
        try (ZipFile zipFile = new ZipFile(archive, StandardCharsets.UTF_8);){
            int size;
            if (inArchiveDir == null || ".".equals(inArchiveDir)) {
                inArchiveDir = "";
            } else if (!inArchiveDir.isEmpty()) {
                inArchiveDir = inArchiveDir + '/';
            }
            String entryName = inArchiveDir + fullName;
            ZipEntry entry = zipFile.getEntry(entryName);
            if (entry == null) return null;
            int offs = 0;
            byte[] buf = new byte[size];
            try (InputStream is = zipFile.getInputStream(entry);){
                switch (type) {
                    case SVG: {
                        SVGDiagram svg = null;
                        Object object = ImageProvider.getSvgUniverse();
                        synchronized (object) {
                            URI uri = ImageProvider.getSvgUniverse().loadSVG(is, entryName, true);
                            svg = ImageProvider.getSvgUniverse().getDiagram(uri);
                        }
                        object = svg == null ? null : new ImageResource(svg);
                        return object;
                    }
                    case OTHER: {
                        int l;
                        for (size = (int)entry.getSize(); size > 0; offs += l, size -= l) {
                            l = is.read(buf, offs, size);
                        }
                        BufferedImage img = null;
                        try {
                            img = ImageProvider.read(new ByteArrayInputStream(buf), false, false);
                        }
                        catch (IOException | UnsatisfiedLinkError e) {
                            Logging.warn(e);
                        }
                        ImageResource imageResource = img == null ? null : new ImageResource(img);
                        return imageResource;
                    }
                }
                throw new AssertionError((Object)("Unknown ImageType: " + (Object)((Object)type)));
            }
        }
        catch (IOException | UnsatisfiedLinkError e) {
            Logging.log(Logging.LEVEL_WARN, I18n.tr("Failed to handle zip file ''{0}''. Exception was: {1}", archive.getName(), e.toString()), e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageResource getIfAvailableLocalURL(URL path, ImageType type) {
        switch (type) {
            case SVG: {
                SVGDiagram svg = null;
                SVGUniverse sVGUniverse = ImageProvider.getSvgUniverse();
                synchronized (sVGUniverse) {
                    try {
                        URL betterPath;
                        URI uri = null;
                        try {
                            uri = ImageProvider.getSvgUniverse().loadSVG(path);
                        }
                        catch (InvalidPathException e) {
                            Logging.error("Cannot open {0}: {1}", path, e.getMessage());
                            Logging.trace(e);
                        }
                        if (uri == null && "jar".equals(path.getProtocol()) && (betterPath = Utils.betterJarUrl(path)) != null) {
                            uri = ImageProvider.getSvgUniverse().loadSVG(betterPath);
                        }
                        svg = ImageProvider.getSvgUniverse().getDiagram(uri);
                    }
                    catch (IOException | SecurityException e) {
                        Logging.log(Logging.LEVEL_WARN, "Unable to read SVG", e);
                    }
                }
                return svg == null ? null : new ImageResource(svg);
            }
            case OTHER: {
                BufferedImage img = null;
                try {
                    img = ImageProvider.read(path, false, true);
                    if (Logging.isDebugEnabled() && ImageProvider.isTransparencyForced(img)) {
                        Logging.debug("Transparency has been forced for image {0}", path);
                    }
                }
                catch (IOException | UnsatisfiedLinkError e) {
                    Logging.log(Logging.LEVEL_WARN, "Unable to read image", e);
                    Logging.debug(e);
                }
                return img == null ? null : new ImageResource(img);
            }
        }
        throw new AssertionError();
    }

    private static URL getImageUrl(String path, String name) {
        if (path != null && path.startsWith("resource://")) {
            return ResourceProvider.getResource(path.substring("resource://".length()) + name);
        }
        File f = new File(path, name);
        try {
            if ((path != null || f.isAbsolute()) && f.exists()) {
                return Utils.fileToURL(f);
            }
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to access image", e);
        }
        return null;
    }

    private URL getImageUrl(String imageName) {
        URL u;
        if (this.dirs != null) {
            for (String name : this.dirs) {
                try {
                    u = ImageProvider.getImageUrl(name, imageName);
                    if (u == null) continue;
                    return u;
                }
                catch (SecurityException e) {
                    Logging.log(Logging.LEVEL_WARN, I18n.tr("Failed to access directory ''{0}'' for security reasons. Exception was: {1}", name, e.toString()), e);
                }
            }
        }
        if (Config.getDirs() != null) {
            File file = new File(Config.getDirs().getUserDataDirectory(false), "images");
            String dir = file.getPath();
            try {
                dir = file.getAbsolutePath();
            }
            catch (SecurityException e) {
                Logging.debug(e);
            }
            try {
                u = ImageProvider.getImageUrl(dir, imageName);
                if (u != null) {
                    return u;
                }
            }
            catch (SecurityException e) {
                Logging.log(Logging.LEVEL_WARN, I18n.tr("Failed to access directory ''{0}'' for security reasons. Exception was: {1}", dir, e.toString()), e);
            }
        }
        if ((u = ImageProvider.getImageUrl(null, imageName)) != null) {
            return u;
        }
        u = ImageProvider.getImageUrl("resource://images/", imageName);
        if (u != null) {
            return u;
        }
        for (String location : Preferences.getAllPossiblePreferenceDirs()) {
            u = ImageProvider.getImageUrl(location + "images", imageName);
            if (u != null) {
                return u;
            }
            u = ImageProvider.getImageUrl(location, imageName);
            if (u == null) continue;
            return u;
        }
        return null;
    }

    private static String getImgUrlFromWikiInfoPage(String base, final String fn) {
        try {
            XMLReader parser = XmlUtils.newSafeSAXParser().getXMLReader();
            parser.setContentHandler(new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                    String val;
                    if ("img".equalsIgnoreCase(localName) && (val = atts.getValue("src")).endsWith(fn)) {
                        throw new SAXReturnException(val);
                    }
                }
            });
            parser.setEntityResolver((publicId, systemId) -> new InputSource(new ByteArrayInputStream(new byte[0])));
            try (CachedFile cf = new CachedFile(base + fn).setDestDir(new File(Config.getDirs().getUserDataDirectory(true), "images").getPath());
                 InputStream is = cf.getInputStream();){
                parser.parse(new InputSource(is));
            }
        }
        catch (SAXReturnException e) {
            Logging.trace(e);
            return e.getResult();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Logging.warn("Parsing " + base + fn + " failed:\n" + e);
            return null;
        }
        Logging.warn("Parsing " + base + fn + " failed: Unexpected content.");
        return null;
    }

    public static Cursor getCursor(String name, String overlay) {
        if (GraphicsEnvironment.isHeadless()) {
            Logging.debug("Cursors are not available in headless mode. Returning null for ''{0}''", name);
            return null;
        }
        Point hotSpot = new Point();
        Image image = ImageProvider.getCursorImage(name, overlay, dim -> Toolkit.getDefaultToolkit().getBestCursorSize(dim.width, dim.height), hotSpot);
        return Toolkit.getDefaultToolkit().createCustomCursor(image, hotSpot, name);
    }

    static Image getCursorImage(String name, String overlay, UnaryOperator<Dimension> bestCursorSizeFunction, Point hotSpot) {
        ImageProvider imageProvider = new ImageProvider("cursor", name);
        if (overlay != null) {
            imageProvider.setMaxSize(ImageSizes.CURSOR).addOverlay(new ImageOverlay(new ImageProvider("cursor/modifier/" + overlay).setMaxSize(ImageSizes.CURSOROVERLAY)));
        }
        ImageIcon imageIcon = imageProvider.get();
        Image image = imageIcon.getImage();
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        Dimension bestCursorSize = (Dimension)bestCursorSizeFunction.apply(new Dimension(width, height));
        if (bestCursorSize.width != 0 && bestCursorSize.height != 0 && (bestCursorSize.width != (image = HiDPISupport.getResolutionVariant(image, bestCursorSize.width, bestCursorSize.height)).getWidth(null) || bestCursorSize.height != image.getHeight(null))) {
            image = image.getScaledInstance(bestCursorSize.width, bestCursorSize.height, 1);
        }
        hotSpot.setLocation("crosshair".equals(name) ? CROSSHAIR_HOTSPOT : DEFAULT_HOTSPOT);
        hotSpot.x = hotSpot.x * image.getWidth(null) / 32;
        hotSpot.y = hotSpot.y * image.getHeight(null) / 32;
        return image;
    }

    public static Image createBoundedImage(Image img, int maxSize) {
        return new ImageResource(img).getImageIconBounded(new Dimension(maxSize, maxSize)).getImage();
    }

    public static BufferedImage createScaledImage(BufferedImage img, int targetWidth, int targetHeight, Object hint) {
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        do {
            if (w > targetWidth) {
                w /= 2;
            }
            if (w < targetWidth) {
                w = targetWidth;
            }
            if (h > targetHeight) {
                h /= 2;
            }
            if (h < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon get(OsmPrimitiveType type) {
        CheckParameterUtil.ensureParameterNotNull((Object)type, "type");
        Map<OsmPrimitiveType, ImageIcon> map = osmPrimitiveTypeCache;
        synchronized (map) {
            return osmPrimitiveTypeCache.computeIfAbsent(type, t -> ImageProvider.get("data", t.getAPIName()));
        }
    }

    public static ImageIcon getPadded(OsmPrimitive primitive, Dimension iconSize) {
        if (iconSize.width <= 0 || iconSize.height <= 0) {
            return null;
        }
        ImageResource resource = OsmPrimitiveImageProvider.getResource(primitive, OsmPrimitiveImageProvider.Options.DEFAULT);
        return resource != null ? resource.getPaddedIcon(iconSize) : null;
    }

    static BufferedImage createImageFromSvg(SVGDiagram svg, Dimension dim, ImageResizeMode resizeMode) {
        if (Logging.isTraceEnabled()) {
            Logging.trace("createImageFromSvg: {0} {1}", svg.getXMLBase(), dim);
        }
        float sourceWidth = svg.getWidth();
        float sourceHeight = svg.getHeight();
        if (sourceWidth <= 0.0f || sourceHeight <= 0.0f) {
            Logging.error("createImageFromSvg: {0} {1} sourceWidth={2} sourceHeight={3}", svg.getXMLBase(), dim, Float.valueOf(sourceWidth), Float.valueOf(sourceHeight));
            return null;
        }
        return resizeMode.createBufferedImage(dim, new Dimension((int)sourceWidth, (int)sourceHeight), g -> {
            try {
                SVGUniverse sVGUniverse = ImageProvider.getSvgUniverse();
                synchronized (sVGUniverse) {
                    svg.render((Graphics2D)g);
                }
            }
            catch (SVGException ex) {
                Logging.log(Logging.LEVEL_ERROR, "Unable to load svg:", ex);
            }
        }, null);
    }

    private static synchronized SVGUniverse getSvgUniverse() {
        if (svgUniverse == null) {
            svgUniverse = new SVGUniverse();
            svgUniverse.setImageDataInlineOnly(true);
        }
        return svgUniverse;
    }

    public static BufferedImage read(File input, boolean readMetadata, boolean enforceTransparency) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(input, "input");
        if (!input.canRead()) {
            throw new IIOException("Can't read input file!");
        }
        ImageInputStream stream = ImageProvider.createImageInputStream(input);
        if (stream == null) {
            throw new IIOException("Can't create an ImageInputStream!");
        }
        BufferedImage bi = ImageProvider.read(stream, readMetadata, enforceTransparency);
        if (bi == null) {
            stream.close();
        }
        return bi;
    }

    public static BufferedImage read(InputStream input, boolean readMetadata, boolean enforceTransparency) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(input, "input");
        ImageInputStream stream = ImageProvider.createImageInputStream(input);
        BufferedImage bi = ImageProvider.read(stream, readMetadata, enforceTransparency);
        if (bi == null) {
            stream.close();
        }
        return bi;
    }

    public static BufferedImage read(URL input, boolean readMetadata, boolean enforceTransparency) throws IOException {
        return ImageProvider.read(input, readMetadata, enforceTransparency, ImageReader::getDefaultReadParam);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage read(URL input, boolean readMetadata, boolean enforceTransparency, Function<ImageReader, ImageReadParam> readParamFunction) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(input, "input");
        try (InputStream istream = Utils.openStream(input);){
            ImageInputStream stream = ImageProvider.createImageInputStream(istream);
            BufferedImage bi = ImageProvider.read(stream, readMetadata, enforceTransparency, readParamFunction);
            if (bi == null) {
                stream.close();
            }
            BufferedImage bufferedImage = bi;
            return bufferedImage;
        }
        catch (SecurityException e) {
            throw new IOException(e);
        }
    }

    public static BufferedImage read(ImageInputStream stream, boolean readMetadata, boolean enforceTransparency) throws IOException {
        return ImageProvider.read(stream, readMetadata, enforceTransparency, ImageReader::getDefaultReadParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage read(ImageInputStream stream, boolean readMetadata, boolean enforceTransparency, Function<ImageReader, ImageReadParam> readParamFunction) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(stream, "stream");
        Iterator<ImageReader> iter = ImageIO.getImageReaders(stream);
        if (!iter.hasNext()) {
            return null;
        }
        ImageReader reader = iter.next();
        reader.setInput(stream, true, !readMetadata && !enforceTransparency);
        ImageReadParam param = readParamFunction.apply(reader);
        BufferedImage bi = null;
        try {
            Color color;
            bi = reader.read(0, param);
            if (bi.getTransparency() != 3 && (readMetadata || enforceTransparency) && Utils.getJavaVersion() < 11 && (color = ImageProvider.getTransparentColor(bi.getColorModel(), reader)) != null) {
                Hashtable<String, Color> properties = new Hashtable<String, Color>(1);
                properties.put(PROP_TRANSPARENCY_COLOR, color);
                bi = new BufferedImage(bi.getColorModel(), bi.getRaster(), bi.isAlphaPremultiplied(), properties);
                if (enforceTransparency) {
                    Logging.trace("Enforcing image transparency of {0} for {1}", stream, color);
                    bi = ImageProvider.makeImageTransparent(bi, color);
                }
            }
        }
        catch (LinkageError e) {
            Logging.error(e);
        }
        finally {
            reader.dispose();
            stream.close();
        }
        return bi;
    }

    public static Color getTransparentColor(ColorModel model, ImageReader reader) throws IOException {
        block6: {
            try {
                String[] formats;
                IIOMetadata metadata = reader.getImageMetadata(0);
                if (metadata == null || (formats = metadata.getMetadataFormatNames()) == null) break block6;
                for (String f : formats) {
                    String value;
                    Node item;
                    NodeList list;
                    if (!"javax_imageio_1.0".equals(f)) continue;
                    Node root = metadata.getAsTree(f);
                    if (root instanceof Element && (list = ((Element)root).getElementsByTagName("TransparentColor")).getLength() > 0 && (item = list.item(0)) instanceof Element && !(value = ((Element)item).getAttribute("value")).isEmpty()) {
                        String[] s = value.split(" ", -1);
                        if (s.length == 3) {
                            return ImageProvider.parseRGB(s);
                        }
                        if (s.length == 1) {
                            int pixel = Integer.parseInt(s[0]);
                            int r = model.getRed(pixel);
                            int g = model.getGreen(pixel);
                            int b = model.getBlue(pixel);
                            return new Color(r, g, b);
                        }
                        Logging.warn("Unable to translate TransparentColor '" + value + "' with color model " + model);
                    }
                    break;
                }
            }
            catch (NumberFormatException | IIOException e) {
                Logging.warn(e);
            }
        }
        return null;
    }

    private static Color parseRGB(String ... s) {
        try {
            int[] rgb = IntStream.range(0, 3).map(i -> Integer.parseInt(s[i])).toArray();
            return new Color(rgb[0], rgb[1], rgb[2]);
        }
        catch (IllegalArgumentException e) {
            Logging.error(e);
            return null;
        }
    }

    public static BufferedImage makeImageTransparent(BufferedImage bi, Color color) {
        final int markerRGB = color.getRGB() | 0xFF000000;
        RGBImageFilter filter = new RGBImageFilter(){

            @Override
            public int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(bi.getSource(), filter);
        Image img = Toolkit.getDefaultToolkit().createImage(ip);
        ColorModel colorModel = ColorModel.getRGBdefault();
        WritableRaster raster = colorModel.createCompatibleWritableRaster(img.getWidth(null), img.getHeight(null));
        String[] names = bi.getPropertyNames();
        Hashtable<String, Object> properties = new Hashtable<String, Object>(1 + (names != null ? names.length : 0));
        if (names != null) {
            for (String name : names) {
                properties.put(name, bi.getProperty(name));
            }
        }
        properties.put(PROP_TRANSPARENCY_FORCED, Boolean.TRUE);
        BufferedImage result = new BufferedImage(colorModel, raster, false, properties);
        Graphics2D g2 = result.createGraphics();
        g2.drawImage(img, 0, 0, null);
        g2.dispose();
        return result;
    }

    public static boolean isTransparencyForced(BufferedImage bi) {
        return bi != null && !bi.getProperty(PROP_TRANSPARENCY_FORCED).equals(Image.UndefinedProperty);
    }

    public static boolean hasTransparentColor(BufferedImage bi) {
        return bi != null && !bi.getProperty(PROP_TRANSPARENCY_COLOR).equals(Image.UndefinedProperty);
    }

    public static void shutdown(boolean now) {
        try {
            if (now) {
                IMAGE_FETCHER.shutdownNow();
            } else {
                IMAGE_FETCHER.shutdown();
            }
        }
        catch (SecurityException ex) {
            Logging.log(Logging.LEVEL_ERROR, "Failed to shutdown background image fetcher.", ex);
        }
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage buffImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2 = buffImage.createGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return buffImage;
    }

    public static BufferedImage toBufferedImage(Image image, Rectangle cropArea) {
        BufferedImage buffImage = null;
        Rectangle r = new Rectangle(image.getWidth(null), image.getHeight(null));
        if (r.intersection(cropArea).equals(cropArea)) {
            buffImage = new BufferedImage(cropArea.width, cropArea.height, 2);
            Graphics2D g2 = buffImage.createGraphics();
            g2.drawImage(image, 0, 0, cropArea.width, cropArea.height, cropArea.x, cropArea.y, cropArea.x + cropArea.width, cropArea.y + cropArea.height, null);
            g2.dispose();
        }
        return buffImage;
    }

    private static ImageInputStream createImageInputStream(Object input) throws IOException {
        try {
            return ImageIO.createImageInputStream(input);
        }
        catch (SecurityException e) {
            if (ImageIO.getUseCache()) {
                ImageIO.setUseCache(false);
                return ImageIO.createImageInputStream(input);
            }
            throw new IOException(e);
        }
    }

    public static ImageIcon createBlankIcon(ImageSizes size) {
        return new ImageIcon(new BufferedImage(size.getAdjustedWidth(), size.getAdjustedHeight(), 2));
    }

    public String toString() {
        return ("ImageProvider [" + (!Utils.isEmpty(this.dirs) ? "dirs=" + this.dirs + ", " : "") + (this.id != null ? "id=" + this.id + ", " : "") + (!Utils.isEmpty(this.subdir) ? "subdir=" + this.subdir + ", " : "") + "name=" + this.name + ", " + (this.archive != null ? "archive=" + this.archive + ", " : "") + (!Utils.isEmpty(this.inArchiveDir) ? "inArchiveDir=" + this.inArchiveDir : "") + ']').replaceAll(", \\]", "]");
    }

    static {
        cache = new ConcurrentHashMap<String, ImageResource>();
        osmPrimitiveTypeCache = new EnumMap<OsmPrimitiveType, ImageIcon>(OsmPrimitiveType.class);
        IMAGE_FETCHER = Executors.newSingleThreadExecutor(Utils.newThreadFactory("image-fetcher-%d", 5));
        dataUrlPattern = Pattern.compile("^data:([a-zA-Z]+/[a-zA-Z+]+)?(;base64)?,(.+)$");
        DEFAULT_HOTSPOT = new Point(3, 2);
        CROSSHAIR_HOTSPOT = new Point(10, 10);
    }

    public static enum ImageSizes {
        SMALLICON(Config.getPref().getInt("iconsize.smallicon", 16)),
        LARGEICON(Config.getPref().getInt("iconsize.largeicon", 24)),
        MAP(Config.getPref().getInt("iconsize.map", 16)),
        MAPMAX(Config.getPref().getInt("iconsize.mapmax", 48)),
        CURSOR(Config.getPref().getInt("iconsize.cursor", 32)),
        CURSOROVERLAY(CURSOR),
        MENU(SMALLICON),
        POPUPMENU(LARGEICON),
        LAYER(Config.getPref().getInt("iconsize.layer", 16)),
        TABLE(SMALLICON),
        TOOLBAR(LARGEICON),
        SIDEBUTTON(Config.getPref().getInt("iconsize.sidebutton", 20)),
        SETTINGS_TAB(Config.getPref().getInt("iconsize.settingstab", 48)),
        DEFAULT(Config.getPref().getInt("iconsize.default", 24)),
        SPLASH_LOGO(128, 128),
        ABOUT_LOGO(256, 256),
        STATUSLINE(18, 18),
        HTMLINLINE(24, 24);

        private final int virtualWidth;
        private final int virtualHeight;

        private ImageSizes(int imageSize) {
            this.virtualWidth = imageSize;
            this.virtualHeight = imageSize;
        }

        private ImageSizes(int width, int height) {
            this.virtualWidth = width;
            this.virtualHeight = height;
        }

        private ImageSizes(ImageSizes that) {
            this.virtualWidth = that.virtualWidth;
            this.virtualHeight = that.virtualHeight;
        }

        public int getVirtualWidth() {
            return this.virtualWidth;
        }

        public int getVirtualHeight() {
            return this.virtualHeight;
        }

        public int getAdjustedWidth() {
            return GuiSizesHelper.getSizeDpiAdjusted(this.virtualWidth);
        }

        public int getAdjustedHeight() {
            return GuiSizesHelper.getSizeDpiAdjusted(this.virtualHeight);
        }

        public Dimension getImageDimension() {
            return new Dimension(this.virtualWidth, this.virtualHeight);
        }
    }

    public static enum ImageType {
        SVG,
        OTHER;

    }
}

