/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.lang.reflect.AccessibleObject;
import java.security.AccessController;
import java.util.Collection;
import java.util.function.Function;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.Logging;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static void setObjectsAccessible(AccessibleObject ... objects) {
        if (objects != null && objects.length > 0) {
            AccessController.doPrivileged(() -> {
                for (AccessibleObject o : objects) {
                    if (o == null) continue;
                    o.setAccessible(true);
                }
                return null;
            });
        }
    }

    public static Class<?> findCallerClass(Collection<Class<?>> exclusions) {
        return ReflectionUtils.findCaller(x -> {
            try {
                return Class.forName(x.getClassName());
            }
            catch (ClassNotFoundException e) {
                for (ClassLoader classLoader : PluginHandler.getPluginClassLoaders()) {
                    try {
                        return Class.forName(x.getClassName(), true, classLoader);
                    }
                    catch (ClassNotFoundException ex) {
                        Logging.trace(ex);
                    }
                }
                Logging.error(e);
                return null;
            }
        }, exclusions);
    }

    private static <T> T findCaller(Function<StackTraceElement, T> getter, Collection<T> exclusions) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        for (int i = 3; i < stack.length; ++i) {
            T t = getter.apply(stack[i]);
            if (exclusions != null && exclusions.contains(t)) continue;
            return t;
        }
        return null;
    }
}

