/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.SRP6Group;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoException;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsDHDomain;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsECDomain;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.tls.crypto.TlsNonceGenerator;
import org.bouncycastle.tls.crypto.TlsSRP6Client;
import org.bouncycastle.tls.crypto.TlsSRP6Server;
import org.bouncycastle.tls.crypto.TlsSRP6VerifierGenerator;
import org.bouncycastle.tls.crypto.TlsSRPConfig;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.tls.crypto.TlsStreamVerifier;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipher;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipher;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsEncryptor;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsNullCipher;
import org.bouncycastle.tls.crypto.impl.jcajce.DHUtil;
import org.bouncycastle.tls.crypto.impl.jcajce.ECUtil;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaNonceGenerator;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaSSL3HMAC;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCertificate;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsHash;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsStreamSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsStreamVerifier;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaUtils;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaVerifyingStreamSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JceAEADCipherImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.JceBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.JceBlockCipherWithCBCImplicitIVImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.JceChaCha20Poly1305;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsDHDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsECDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsHMAC;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.JceX25519Domain;
import org.bouncycastle.tls.crypto.impl.jcajce.JceX448Domain;
import org.bouncycastle.tls.crypto.impl.jcajce.RSAUtil;
import org.bouncycastle.tls.crypto.impl.jcajce.srp.SRP6Client;
import org.bouncycastle.tls.crypto.impl.jcajce.srp.SRP6Server;
import org.bouncycastle.tls.crypto.impl.jcajce.srp.SRP6VerifierGenerator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JcaTlsCrypto
extends AbstractTlsCrypto {
    private final JcaJceHelper helper;
    private final SecureRandom entropySource;
    private final SecureRandom nonceEntropySource;
    private final Hashtable supportedEncryptionAlgorithms = new Hashtable();
    private final Hashtable supportedNamedGroups = new Hashtable();
    private final Hashtable supportedOther = new Hashtable();

    protected JcaTlsCrypto(JcaJceHelper jcaJceHelper, SecureRandom secureRandom, SecureRandom secureRandom2) {
        this.helper = jcaJceHelper;
        this.entropySource = secureRandom;
        this.nonceEntropySource = secureRandom2;
    }

    JceTlsSecret adoptLocalSecret(byte[] byArray) {
        return new JceTlsSecret(this, byArray);
    }

    Cipher createRSAEncryptionCipher() throws GeneralSecurityException {
        try {
            return this.getHelper().createCipher("RSA/NONE/PKCS1Padding");
        }
        catch (GeneralSecurityException generalSecurityException) {
            return this.getHelper().createCipher("RSA/ECB/PKCS1Padding");
        }
    }

    @Override
    public TlsNonceGenerator createNonceGenerator(byte[] byArray) {
        return new JcaNonceGenerator(this.nonceEntropySource, byArray);
    }

    @Override
    public SecureRandom getSecureRandom() {
        return this.entropySource;
    }

    public byte[] calculateKeyAgreement(String string, PrivateKey privateKey, PublicKey publicKey, String string2) throws GeneralSecurityException {
        KeyAgreement keyAgreement = this.helper.createKeyAgreement(string);
        keyAgreement.init(privateKey);
        keyAgreement.doPhase(publicKey, true);
        try {
            return keyAgreement.generateSecret(string2).getEncoded();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if ("X25519".equals(string) || "X448".equals(string)) {
                return keyAgreement.generateSecret();
            }
            throw noSuchAlgorithmException;
        }
    }

    @Override
    public TlsCertificate createCertificate(byte[] byArray) throws IOException {
        return new JcaTlsCertificate(this, byArray);
    }

    @Override
    public TlsCipher createCipher(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException {
        try {
            switch (n) {
                case 7: {
                    return this.createDESedeCipher(tlsCryptoParameters, n2);
                }
                case 8: {
                    return this.createAESCipher(tlsCryptoParameters, 16, n2);
                }
                case 15: {
                    return this.createCipher_AES_CCM(tlsCryptoParameters, 16, 16);
                }
                case 16: {
                    return this.createCipher_AES_CCM(tlsCryptoParameters, 16, 8);
                }
                case 10: {
                    return this.createCipher_AES_GCM(tlsCryptoParameters, 16, 16);
                }
                case 9: {
                    return this.createAESCipher(tlsCryptoParameters, 32, n2);
                }
                case 17: {
                    return this.createCipher_AES_CCM(tlsCryptoParameters, 32, 16);
                }
                case 18: {
                    return this.createCipher_AES_CCM(tlsCryptoParameters, 32, 8);
                }
                case 11: {
                    return this.createCipher_AES_GCM(tlsCryptoParameters, 32, 16);
                }
                case 22: {
                    return this.createARIACipher(tlsCryptoParameters, 16, n2);
                }
                case 24: {
                    return this.createCipher_ARIA_GCM(tlsCryptoParameters, 16, 16);
                }
                case 23: {
                    return this.createARIACipher(tlsCryptoParameters, 32, n2);
                }
                case 25: {
                    return this.createCipher_ARIA_GCM(tlsCryptoParameters, 32, 16);
                }
                case 12: {
                    return this.createCamelliaCipher(tlsCryptoParameters, 16, n2);
                }
                case 19: {
                    return this.createCipher_Camellia_GCM(tlsCryptoParameters, 16, 16);
                }
                case 13: {
                    return this.createCamelliaCipher(tlsCryptoParameters, 32, n2);
                }
                case 20: {
                    return this.createCipher_Camellia_GCM(tlsCryptoParameters, 32, 16);
                }
                case 21: {
                    return this.createChaCha20Poly1305(tlsCryptoParameters);
                }
                case 0: {
                    return this.createNullCipher(tlsCryptoParameters, n2);
                }
                case 14: {
                    return this.createSEEDCipher(tlsCryptoParameters, n2);
                }
            }
            throw new TlsFatalAlert(80);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsCryptoException("cannot create cipher: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    @Override
    public TlsHMAC createHMAC(short s) {
        return this.createHMAC(this.getHMACAlgorithmName(s));
    }

    @Override
    public TlsHMAC createHMAC(int n) {
        return this.createHMAC(TlsUtils.getHashAlgorithmForHMACAlgorithm(n));
    }

    protected TlsHMAC createHMAC_SSL(int n) throws GeneralSecurityException, IOException {
        switch (n) {
            case 1: {
                return new JcaSSL3HMAC(this.createHash(this.getDigestName((short)1)), 16, 64);
            }
            case 2: {
                return new JcaSSL3HMAC(this.createHash(this.getDigestName((short)2)), 20, 64);
            }
            case 3: {
                return new JcaSSL3HMAC(this.createHash(this.getDigestName((short)4)), 32, 64);
            }
            case 4: {
                return new JcaSSL3HMAC(this.createHash(this.getDigestName((short)5)), 48, 128);
            }
            case 5: {
                return new JcaSSL3HMAC(this.createHash(this.getDigestName((short)6)), 64, 128);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsHMAC createMAC(TlsCryptoParameters tlsCryptoParameters, int n) throws GeneralSecurityException, IOException {
        if (TlsImplUtils.isSSL(tlsCryptoParameters)) {
            return this.createHMAC_SSL(n);
        }
        return this.createHMAC(n);
    }

    @Override
    public TlsSRP6Client createSRP6Client(TlsSRPConfig tlsSRPConfig) {
        final SRP6Client sRP6Client = new SRP6Client();
        BigInteger[] bigIntegerArray = tlsSRPConfig.getExplicitNG();
        SRP6Group sRP6Group = new SRP6Group(bigIntegerArray[0], bigIntegerArray[1]);
        sRP6Client.init(sRP6Group, this.createHash((short)2), this.getSecureRandom());
        return new TlsSRP6Client(){

            @Override
            public BigInteger calculateSecret(BigInteger bigInteger) throws TlsFatalAlert {
                try {
                    return sRP6Client.calculateSecret(bigInteger);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new TlsFatalAlert(47, (Throwable)illegalArgumentException);
                }
            }

            @Override
            public BigInteger generateClientCredentials(byte[] byArray, byte[] byArray2, byte[] byArray3) {
                return sRP6Client.generateClientCredentials(byArray, byArray2, byArray3);
            }
        };
    }

    @Override
    public TlsSRP6Server createSRP6Server(TlsSRPConfig tlsSRPConfig, BigInteger bigInteger) {
        final SRP6Server sRP6Server = new SRP6Server();
        BigInteger[] bigIntegerArray = tlsSRPConfig.getExplicitNG();
        SRP6Group sRP6Group = new SRP6Group(bigIntegerArray[0], bigIntegerArray[1]);
        sRP6Server.init(sRP6Group, bigInteger, this.createHash((short)2), this.getSecureRandom());
        return new TlsSRP6Server(){

            @Override
            public BigInteger generateServerCredentials() {
                return sRP6Server.generateServerCredentials();
            }

            @Override
            public BigInteger calculateSecret(BigInteger bigInteger) throws IOException {
                try {
                    return sRP6Server.calculateSecret(bigInteger);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new TlsFatalAlert(47, (Throwable)illegalArgumentException);
                }
            }
        };
    }

    @Override
    public TlsSRP6VerifierGenerator createSRP6VerifierGenerator(TlsSRPConfig tlsSRPConfig) {
        BigInteger[] bigIntegerArray = tlsSRPConfig.getExplicitNG();
        final SRP6VerifierGenerator sRP6VerifierGenerator = new SRP6VerifierGenerator();
        sRP6VerifierGenerator.init(bigIntegerArray[0], bigIntegerArray[1], this.createHash((short)2));
        return new TlsSRP6VerifierGenerator(){

            @Override
            public BigInteger generateVerifier(byte[] byArray, byte[] byArray2, byte[] byArray3) {
                return sRP6VerifierGenerator.generateVerifier(byArray, byArray2, byArray3);
            }
        };
    }

    public String getHMACAlgorithmName(short s) {
        switch (s) {
            case 1: {
                return "HmacMD5";
            }
            case 2: {
                return "HmacSHA1";
            }
            case 3: {
                return "HmacSHA224";
            }
            case 4: {
                return "HmacSHA256";
            }
            case 5: {
                return "HmacSHA384";
            }
            case 6: {
                return "HmacSHA512";
            }
        }
        throw new IllegalArgumentException("invalid HashAlgorithm: " + HashAlgorithm.getText(s));
    }

    public AlgorithmParameters getNamedGroupAlgorithmParameters(int n) throws GeneralSecurityException {
        if (NamedGroup.refersToAnXDHCurve(n)) {
            switch (n) {
                case 29: 
                case 30: {
                    return null;
                }
            }
        } else {
            if (NamedGroup.refersToAnECDSACurve(n)) {
                return ECUtil.getAlgorithmParameters(this, NamedGroup.getName(n));
            }
            if (NamedGroup.refersToASpecificFiniteField(n)) {
                return DHUtil.getAlgorithmParameters(this, TlsDHUtils.getNamedDHGroup(n));
            }
        }
        throw new IllegalArgumentException("NamedGroup not supported: " + NamedGroup.getText(n));
    }

    public AlgorithmParameters getSignatureSchemeAlgorithmParameters(int n) throws GeneralSecurityException {
        switch (n) {
            case 2052: 
            case 2053: 
            case 2054: 
            case 2057: 
            case 2058: 
            case 2059: {
                short s = SignatureScheme.getRSAPSSHashAlgorithm(n);
                String string = this.getDigestName(s);
                String string2 = RSAUtil.getDigestSigAlgName(string) + "WITHRSAANDMGF1";
                AlgorithmParameterSpec algorithmParameterSpec = RSAUtil.getPSSParameterSpec(s, string, this.getHelper());
                Signature signature = this.getHelper().createSignature(string2);
                signature.setParameter(algorithmParameterSpec);
                return signature.getParameters();
            }
        }
        return null;
    }

    @Override
    public boolean hasAllRawSignatureAlgorithms() {
        return !JcaUtils.isSunMSCAPIProviderActive() && !this.hasSignatureAlgorithm((short)7) && !this.hasSignatureAlgorithm((short)8);
    }

    @Override
    public boolean hasDHAgreement() {
        return true;
    }

    @Override
    public boolean hasECDHAgreement() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasEncryptionAlgorithm(int n) {
        Serializable serializable;
        Integer n2 = Integers.valueOf((int)n);
        Serializable serializable2 = this.supportedEncryptionAlgorithms;
        synchronized (serializable2) {
            serializable = (Boolean)this.supportedEncryptionAlgorithms.get(n2);
            if (serializable != null) {
                return serializable;
            }
        }
        serializable2 = this.isSupportedEncryptionAlgorithm(n);
        if (null == serializable2) {
            return false;
        }
        serializable = this.supportedEncryptionAlgorithms;
        synchronized (serializable) {
            Boolean bl = (Boolean)((Object)this.supportedEncryptionAlgorithms.put(n2, serializable2));
            if (null != bl && serializable2 != bl) {
                this.supportedEncryptionAlgorithms.put(n2, bl);
                serializable2 = bl;
            }
        }
        return (Boolean)serializable2;
    }

    @Override
    public boolean hasHashAlgorithm(short s) {
        return true;
    }

    @Override
    public boolean hasMacAlgorithm(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNamedGroup(int n) {
        Serializable serializable;
        Integer n2 = Integers.valueOf((int)n);
        Serializable serializable2 = this.supportedNamedGroups;
        synchronized (serializable2) {
            serializable = (Boolean)this.supportedNamedGroups.get(n2);
            if (null != serializable) {
                return serializable;
            }
        }
        serializable2 = this.isSupportedNamedGroup(n);
        if (null == serializable2) {
            return false;
        }
        serializable = this.supportedNamedGroups;
        synchronized (serializable) {
            Boolean bl = (Boolean)((Object)this.supportedNamedGroups.put(n2, serializable2));
            if (null != bl && serializable2 != bl) {
                this.supportedNamedGroups.put(n2, bl);
                serializable2 = bl;
            }
        }
        return (Boolean)serializable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRSAEncryption() {
        Serializable serializable;
        Serializable serializable2 = this.supportedOther;
        synchronized (serializable2) {
            serializable = (Boolean)this.supportedOther.get("KE_RSA");
            if (serializable != null) {
                return serializable;
            }
        }
        try {
            this.createRSAEncryptionCipher();
            serializable2 = Boolean.TRUE;
        }
        catch (GeneralSecurityException generalSecurityException) {
            serializable2 = Boolean.FALSE;
        }
        serializable = this.supportedOther;
        synchronized (serializable) {
            Boolean bl = (Boolean)((Object)this.supportedOther.put("KE_RSA", serializable2));
            if (null != bl && serializable2 != bl) {
                this.supportedOther.put("KE_RSA", bl);
                serializable2 = bl;
            }
        }
        return (Boolean)serializable2;
    }

    @Override
    public boolean hasSignatureAlgorithm(short s) {
        switch (s) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        if (signatureAndHashAlgorithm.getHash() == 3 && JcaUtils.isSunMSCAPIProviderActive()) {
            return false;
        }
        return this.hasSignatureAlgorithm(signatureAndHashAlgorithm.getSignature());
    }

    @Override
    public boolean hasSignatureScheme(int n) {
        if (n >>> 8 == 3 && JcaUtils.isSunMSCAPIProviderActive()) {
            return false;
        }
        return this.hasSignatureAlgorithm((short)(n & 0xFF));
    }

    @Override
    public boolean hasSRPAuthentication() {
        return true;
    }

    @Override
    public TlsSecret createSecret(byte[] byArray) {
        return this.adoptLocalSecret(Arrays.clone((byte[])byArray));
    }

    @Override
    public TlsSecret generateRSAPreMasterSecret(ProtocolVersion protocolVersion) {
        byte[] byArray = new byte[48];
        this.getSecureRandom().nextBytes(byArray);
        TlsUtils.writeVersion(protocolVersion, byArray, 0);
        return this.adoptLocalSecret(byArray);
    }

    @Override
    public TlsHash createHash(short s) {
        try {
            return this.createHash(this.getDigestName(s));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Exceptions.illegalArgumentException("unable to create message digest:" + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    @Override
    public TlsDHDomain createDHDomain(TlsDHConfig tlsDHConfig) {
        return new JceTlsDHDomain(this, tlsDHConfig);
    }

    @Override
    public TlsECDomain createECDomain(TlsECConfig tlsECConfig) {
        switch (tlsECConfig.getNamedGroup()) {
            case 29: {
                return new JceX25519Domain(this);
            }
            case 30: {
                return new JceX448Domain(this);
            }
        }
        return new JceTlsECDomain(this, tlsECConfig);
    }

    @Override
    public TlsEncryptor createEncryptor(TlsCertificate tlsCertificate) throws IOException {
        JcaTlsCertificate jcaTlsCertificate = JcaTlsCertificate.convert(this, tlsCertificate);
        jcaTlsCertificate.validateKeyUsageBit(2);
        final PublicKey publicKey = jcaTlsCertificate.getPubKeyRSA();
        return new TlsEncryptor(){

            @Override
            public byte[] encrypt(byte[] byArray, int n, int n2) throws IOException {
                try {
                    Cipher cipher = JcaTlsCrypto.this.createRSAEncryptionCipher();
                    try {
                        cipher.init(3, (Key)publicKey, JcaTlsCrypto.this.getSecureRandom());
                        return cipher.wrap(new SecretKeySpec(byArray, n, n2, "TLS"));
                    }
                    catch (Exception exception) {
                        try {
                            cipher.init(1, (Key)publicKey, JcaTlsCrypto.this.getSecureRandom());
                            return cipher.doFinal(byArray, n, n2);
                        }
                        catch (Exception exception2) {
                            throw new TlsFatalAlert(80, (Throwable)exception);
                        }
                    }
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new TlsFatalAlert(80, (Throwable)generalSecurityException);
                }
            }
        };
    }

    @Override
    public TlsSecret hkdfInit(short s) {
        return this.adoptLocalSecret(new byte[HashAlgorithm.getOutputSize(s)]);
    }

    protected TlsAEADCipherImpl createAEADCipher(String string, String string2, int n, boolean bl) throws GeneralSecurityException {
        return new JceAEADCipherImpl(this.helper, string, string2, n, bl);
    }

    protected TlsBlockCipherImpl createBlockCipher(String string, String string2, int n, boolean bl) throws GeneralSecurityException {
        return new JceBlockCipherImpl(this.helper.createCipher(string), string2, n, bl);
    }

    protected TlsBlockCipherImpl createBlockCipherWithCBCImplicitIV(String string, String string2, int n, boolean bl) throws GeneralSecurityException {
        return new JceBlockCipherWithCBCImplicitIVImpl(this.helper.createCipher(string), string2, bl);
    }

    protected TlsHMAC createHMAC(String string) {
        try {
            return new JceTlsHMAC(this.helper.createMac(string), string);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("cannot create HMAC: " + string, generalSecurityException);
        }
    }

    protected TlsHash createHash(String string) throws GeneralSecurityException {
        return new JcaTlsHash(this.helper.createDigest(string));
    }

    protected TlsNullCipher createNullCipher(TlsCryptoParameters tlsCryptoParameters, int n) throws IOException, GeneralSecurityException {
        return new TlsNullCipher(tlsCryptoParameters, this.createMAC(tlsCryptoParameters, n), this.createMAC(tlsCryptoParameters, n));
    }

    protected TlsStreamSigner createStreamSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm, PrivateKey privateKey, boolean bl) throws IOException {
        String string = JcaUtils.getJcaAlgorithmName(signatureAndHashAlgorithm);
        return this.createStreamSigner(string, null, privateKey, bl);
    }

    protected TlsStreamSigner createStreamSigner(String string, AlgorithmParameterSpec algorithmParameterSpec, PrivateKey privateKey, boolean bl) throws IOException {
        try {
            Signature signature = this.getHelper().createSignature(string);
            if (null != algorithmParameterSpec) {
                signature.setParameter(algorithmParameterSpec);
            }
            signature.initSign(privateKey, bl ? this.getSecureRandom() : null);
            return new JcaTlsStreamSigner(signature);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsFatalAlert(80, (Throwable)generalSecurityException);
        }
    }

    protected TlsStreamVerifier createStreamVerifier(DigitallySigned digitallySigned, PublicKey publicKey) throws IOException {
        String string = JcaUtils.getJcaAlgorithmName(digitallySigned.getAlgorithm());
        return this.createStreamVerifier(string, null, digitallySigned.getSignature(), publicKey);
    }

    protected TlsStreamVerifier createStreamVerifier(String string, AlgorithmParameterSpec algorithmParameterSpec, byte[] byArray, PublicKey publicKey) throws IOException {
        try {
            Signature signature = this.getHelper().createSignature(string);
            if (null != algorithmParameterSpec) {
                signature.setParameter(algorithmParameterSpec);
            }
            signature.initVerify(publicKey);
            return new JcaTlsStreamVerifier(signature, byArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsFatalAlert(80, (Throwable)generalSecurityException);
        }
    }

    protected TlsStreamSigner createVerifyingStreamSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm, PrivateKey privateKey, boolean bl, PublicKey publicKey) throws IOException {
        String string = JcaUtils.getJcaAlgorithmName(signatureAndHashAlgorithm);
        return this.createVerifyingStreamSigner(string, null, privateKey, bl, publicKey);
    }

    protected TlsStreamSigner createVerifyingStreamSigner(String string, AlgorithmParameterSpec algorithmParameterSpec, PrivateKey privateKey, boolean bl, PublicKey publicKey) throws IOException {
        try {
            Signature signature = this.getHelper().createSignature(string);
            Signature signature2 = this.getHelper().createSignature(string);
            if (null != algorithmParameterSpec) {
                signature.setParameter(algorithmParameterSpec);
                signature2.setParameter(algorithmParameterSpec);
            }
            signature.initSign(privateKey, bl ? this.getSecureRandom() : null);
            signature2.initVerify(publicKey);
            return new JcaVerifyingStreamSigner(signature, signature2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsFatalAlert(80, (Throwable)generalSecurityException);
        }
    }

    protected Boolean isSupportedEncryptionAlgorithm(int n) {
        try {
            switch (n) {
                case 21: {
                    this.helper.createCipher("ChaCha7539");
                    this.helper.createMac("Poly1305");
                    return Boolean.TRUE;
                }
                case 7: {
                    this.helper.createCipher("DESede/CBC/NoPadding");
                    return Boolean.TRUE;
                }
                case 8: 
                case 9: {
                    this.helper.createCipher("AES/CBC/NoPadding");
                    return Boolean.TRUE;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    this.helper.createCipher("AES/CCM/NoPadding");
                    return Boolean.TRUE;
                }
                case 10: 
                case 11: {
                    this.helper.createCipher("AES/GCM/NoPadding");
                    return Boolean.TRUE;
                }
                case 22: 
                case 23: {
                    this.helper.createCipher("ARIA/CBC/NoPadding");
                    return Boolean.TRUE;
                }
                case 24: 
                case 25: {
                    this.helper.createCipher("ARIA/GCM/NoPadding");
                    return Boolean.TRUE;
                }
                case 12: 
                case 13: {
                    this.helper.createCipher("Camellia/CBC/NoPadding");
                    return Boolean.TRUE;
                }
                case 19: 
                case 20: {
                    this.helper.createCipher("Camellia/GCM/NoPadding");
                    return Boolean.TRUE;
                }
                case 14: {
                    this.helper.createCipher("SEED/CBC/NoPadding");
                    return Boolean.TRUE;
                }
                case 0: {
                    return Boolean.TRUE;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return Boolean.FALSE;
                }
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            return Boolean.FALSE;
        }
        return null;
    }

    protected Boolean isSupportedNamedGroup(int n) {
        try {
            if (NamedGroup.refersToAnXDHCurve(n)) {
                switch (n) {
                    case 29: {
                        this.helper.createKeyAgreement("X25519");
                        return Boolean.TRUE;
                    }
                    case 30: {
                        this.helper.createKeyAgreement("X448");
                        return Boolean.TRUE;
                    }
                }
            } else {
                if (NamedGroup.refersToAnECDSACurve(n)) {
                    return ECUtil.isCurveSupported(this, NamedGroup.getName(n));
                }
                if (NamedGroup.refersToASpecificFiniteField(n)) {
                    return Boolean.TRUE;
                }
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            return Boolean.FALSE;
        }
        return null;
    }

    public JcaJceHelper getHelper() {
        return this.helper;
    }

    private TlsBlockCipher createAESCipher(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, tlsCryptoParameters, this.createCBCBlockOperator(tlsCryptoParameters, "AES", true, n), this.createCBCBlockOperator(tlsCryptoParameters, "AES", false, n), this.createMAC(tlsCryptoParameters, n2), this.createMAC(tlsCryptoParameters, n2), n);
    }

    private TlsBlockCipher createARIACipher(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, tlsCryptoParameters, this.createCBCBlockOperator(tlsCryptoParameters, "ARIA", true, n), this.createCBCBlockOperator(tlsCryptoParameters, "ARIA", false, n), this.createMAC(tlsCryptoParameters, n2), this.createMAC(tlsCryptoParameters, n2), n);
    }

    private TlsBlockCipher createCamelliaCipher(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, tlsCryptoParameters, this.createCBCBlockOperator(tlsCryptoParameters, "Camellia", true, n), this.createCBCBlockOperator(tlsCryptoParameters, "Camellia", false, n), this.createMAC(tlsCryptoParameters, n2), this.createMAC(tlsCryptoParameters, n2), n);
    }

    private TlsBlockCipher createDESedeCipher(TlsCryptoParameters tlsCryptoParameters, int n) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, tlsCryptoParameters, this.createCBCBlockOperator(tlsCryptoParameters, "DESede", true, 24), this.createCBCBlockOperator(tlsCryptoParameters, "DESede", false, 24), this.createMAC(tlsCryptoParameters, n), this.createMAC(tlsCryptoParameters, n), 24);
    }

    private TlsBlockCipher createSEEDCipher(TlsCryptoParameters tlsCryptoParameters, int n) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, tlsCryptoParameters, this.createCBCBlockOperator(tlsCryptoParameters, "SEED", true, 16), this.createCBCBlockOperator(tlsCryptoParameters, "SEED", false, 16), this.createMAC(tlsCryptoParameters, n), this.createMAC(tlsCryptoParameters, n), 16);
    }

    private TlsBlockCipherImpl createCBCBlockOperator(TlsCryptoParameters tlsCryptoParameters, String string, boolean bl, int n) throws GeneralSecurityException {
        String string2 = string + "/CBC/NoPadding";
        if (TlsImplUtils.isTLSv11(tlsCryptoParameters)) {
            return this.createBlockCipher(string2, string, n, bl);
        }
        return this.createBlockCipherWithCBCImplicitIV(string2, string, n, bl);
    }

    private TlsCipher createChaCha20Poly1305(TlsCryptoParameters tlsCryptoParameters) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(tlsCryptoParameters, new JceChaCha20Poly1305(this.helper, true), new JceChaCha20Poly1305(this.helper, false), 32, 16, 2);
    }

    private TlsAEADCipher createCipher_AES_CCM(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(tlsCryptoParameters, this.createAEADCipher("AES/CCM/NoPadding", "AES", n, true), this.createAEADCipher("AES/CCM/NoPadding", "AES", n, false), n, n2, 1);
    }

    private TlsAEADCipher createCipher_AES_GCM(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(tlsCryptoParameters, this.createAEADCipher("AES/GCM/NoPadding", "AES", n, true), this.createAEADCipher("AES/GCM/NoPadding", "AES", n, false), n, n2, 3);
    }

    private TlsAEADCipher createCipher_ARIA_GCM(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(tlsCryptoParameters, this.createAEADCipher("ARIA/GCM/NoPadding", "ARIA", n, true), this.createAEADCipher("ARIA/GCM/NoPadding", "ARIA", n, false), n, n2, 3);
    }

    private TlsAEADCipher createCipher_Camellia_GCM(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(tlsCryptoParameters, this.createAEADCipher("Camellia/GCM/NoPadding", "Camellia", n, true), this.createAEADCipher("Camellia/GCM/NoPadding", "Camellia", n, false), n, n2, 3);
    }

    String getDigestName(short s) {
        String string;
        switch (s) {
            case 1: {
                string = "MD5";
                break;
            }
            case 2: {
                string = "SHA-1";
                break;
            }
            case 3: {
                string = "SHA-224";
                break;
            }
            case 4: {
                string = "SHA-256";
                break;
            }
            case 5: {
                string = "SHA-384";
                break;
            }
            case 6: {
                string = "SHA-512";
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid HashAlgorithm: " + HashAlgorithm.getText(s));
            }
        }
        return string;
    }
}

