/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.dependencies.maven;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ErrorHandlingKt;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.dependencies.ExternalDependenciesResolver;
import kotlin.script.experimental.dependencies.RepositoryCoordinates;
import kotlin.script.experimental.dependencies.impl.ResolverNamedOptionsKt;
import kotlin.script.experimental.dependencies.impl.ResolverUtilsKt;
import kotlin.script.experimental.dependencies.maven.MavenRepositoryCoordinates;
import kotlin.script.experimental.dependencies.maven.impl.AetherKt;
import kotlin.script.experimental.dependencies.maven.impl.AetherResolveSession;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.DefaultArtifact;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.DependencyResolutionException;
import org.jetbrains.kotlin.org.eclipse.aether.util.repository.AuthenticationBuilder;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J7\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001b0\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000fH\u0002J\u000e\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020\u000fH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\""}, d2={"Lkotlin/script/experimental/dependencies/maven/MavenDependenciesResolver;", "Lkotlin/script/experimental/dependencies/ExternalDependenciesResolver;", "()V", "localRepo", "Ljava/io/File;", "getLocalRepo", "()Ljava/io/File;", "repos", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/org/eclipse/aether/repository/RemoteRepository;", "getRepos", "()Ljava/util/ArrayList;", "acceptsArtifact", "", "artifactCoordinates", "", "acceptsRepository", "repositoryCoordinates", "Lkotlin/script/experimental/dependencies/RepositoryCoordinates;", "addRepository", "Lkotlin/script/experimental/api/ResultWithDiagnostics;", "options", "Lkotlin/script/experimental/dependencies/ExternalDependenciesResolver$Options;", "sourceCodeLocation", "Lkotlin/script/experimental/api/SourceCode$LocationWithId;", "remoteRepositories", "resolve", "", "(Ljava/lang/String;Lkotlin/script/experimental/dependencies/ExternalDependenciesResolver$Options;Lkotlin/script/experimental/api/SourceCode$LocationWithId;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryResolveEnvironmentVariable", "str", "toMavenArtifact", "Lorg/jetbrains/kotlin/org/eclipse/aether/artifact/DefaultArtifact;", "Companion", "kotlin-scripting-dependencies-maven"})
public final class MavenDependenciesResolver
implements ExternalDependenciesResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File localRepo;
    @NotNull
    private final ArrayList<RemoteRepository> repos;
    @NotNull
    private static final Regex FORBIDDEN_CHARS = new Regex("[/\\\\:<>\"|?*]");

    public MavenDependenciesResolver() {
        String string = System.getProperty("user.home");
        Intrinsics.checkNotNull((Object)string);
        this.localRepo = new File(new File(string, ".m2"), "repository");
        this.repos = new ArrayList();
    }

    @Override
    public boolean acceptsArtifact(@NotNull String artifactCoordinates) {
        Intrinsics.checkNotNullParameter((Object)artifactCoordinates, (String)"artifactCoordinates");
        return this.toMavenArtifact(artifactCoordinates) != null;
    }

    @Override
    public boolean acceptsRepository(@NotNull RepositoryCoordinates repositoryCoordinates) {
        Intrinsics.checkNotNullParameter((Object)repositoryCoordinates, (String)"repositoryCoordinates");
        return ResolverUtilsKt.toRepositoryUrlOrNull(repositoryCoordinates) != null;
    }

    @NotNull
    public final File getLocalRepo() {
        return this.localRepo;
    }

    @NotNull
    public final ArrayList<RemoteRepository> getRepos() {
        return this.repos;
    }

    private final ArrayList<RemoteRepository> remoteRepositories() {
        ArrayList arrayList;
        if (this.repos.isEmpty()) {
            Object[] objectArray = new RemoteRepository[]{AetherKt.getMavenCentral()};
            arrayList = CollectionsKt.arrayListOf((Object[])objectArray);
        } else {
            arrayList = this.repos;
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final DefaultArtifact toMavenArtifact(String $this$toMavenArtifact) {
        if (StringsKt.isBlank((CharSequence)$this$toMavenArtifact)) return null;
        boolean bl = true;
        if (!bl) return null;
        CharSequence $this$count$iv = $this$toMavenArtifact;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl2 = false;
            if (!(it == ':')) continue;
            ++count$iv;
        }
        if (count$iv < 2) return null;
        DefaultArtifact defaultArtifact = new DefaultArtifact($this$toMavenArtifact);
        return defaultArtifact;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object resolve(@NotNull String artifactCoordinates, @NotNull ExternalDependenciesResolver.Options options, @Nullable SourceCode.LocationWithId sourceCodeLocation, @NotNull Continuation<? super ResultWithDiagnostics<? extends List<? extends File>>> $completion) {
        ResultWithDiagnostics resultWithDiagnostics;
        DefaultArtifact defaultArtifact = this.toMavenArtifact(artifactCoordinates);
        Intrinsics.checkNotNull((Object)defaultArtifact);
        DefaultArtifact artifactId = defaultArtifact;
        try {
            void $this$mapTo$iv$iv;
            List list = ResolverNamedOptionsKt.getDependencyScopes(options);
            if (list == null) {
                Object[] objectArray = new String[]{"compile", "runtime"};
                list = CollectionsKt.listOf((Object[])objectArray);
            }
            List dependencyScopes = list;
            Boolean bl = ResolverNamedOptionsKt.getTransitive(options);
            boolean transitive = bl != null ? bl : true;
            List<Artifact> deps = new AetherResolveSession(this.localRepo, (List<RemoteRepository>)this.remoteRepositories()).resolve(artifactId, CollectionsKt.joinToString$default((Iterable)dependencyScopes, (CharSequence)",", null, null, (int)0, null, null, (int)62, null), transitive, null);
            Iterable $this$map$iv = deps;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Artifact artifact = (Artifact)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getFile());
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 2;
            List list2 = null;
            List list3 = (List)destination$iv$iv;
            resultWithDiagnostics = new ResultWithDiagnostics.Success(list3, list2, n, defaultConstructorMarker);
        }
        catch (DependencyResolutionException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "unknown error";
            }
            resultWithDiagnostics = ResolverUtilsKt.makeResolveFailureResult(string, sourceCodeLocation);
        }
        return resultWithDiagnostics;
    }

    private final String tryResolveEnvironmentVariable(String str) {
        String string;
        if (StringsKt.startsWith$default((String)str, (String)"$", (boolean)false, (int)2, null)) {
            String string2 = str.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            string = System.getenv(string2);
            if (string == null) {
                string = str;
            }
        } else {
            string = str;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ResultWithDiagnostics<Boolean> addRepository(@NotNull RepositoryCoordinates repositoryCoordinates, @NotNull ExternalDependenciesResolver.Options options, @Nullable SourceCode.LocationWithId sourceCodeLocation) {
        String string;
        String string2;
        String string3;
        String string4;
        String p0;
        void var18_18;
        void $this$addRepository_u24lambda_u2d6_u24lambda_u2d5;
        String string5;
        String username;
        AuthenticationBuilder authenticationBuilder;
        Intrinsics.checkNotNullParameter((Object)repositoryCoordinates, (String)"repositoryCoordinates");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        URL uRL = ResolverUtilsKt.toRepositoryUrlOrNull(repositoryCoordinates);
        if (uRL == null) {
            return ErrorHandlingKt.asSuccess$default(false, null, 1, null);
        }
        URL url = uRL;
        CharSequence charSequence = repositoryCoordinates.getString();
        Object object = FORBIDDEN_CHARS;
        String string6 = "_";
        String repoId = object.replace(charSequence, string6);
        Object $this$addRepository_u24lambda_u2d6 = object = new RemoteRepository.Builder(repoId, "default", url.toString());
        boolean bl = false;
        AuthenticationBuilder authenticationBuilder2 = authenticationBuilder = new AuthenticationBuilder();
        Object object2 = $this$addRepository_u24lambda_u2d6;
        boolean bl2 = false;
        MavenRepositoryCoordinates mavenRepo = repositoryCoordinates instanceof MavenRepositoryCoordinates ? (MavenRepositoryCoordinates)repositoryCoordinates : null;
        String string7 = ResolverNamedOptionsKt.getUsername(options);
        if (string7 == null) {
            MavenRepositoryCoordinates mavenRepositoryCoordinates = mavenRepo;
            string7 = username = mavenRepositoryCoordinates != null ? mavenRepositoryCoordinates.getUsername() : null;
        }
        if ((string5 = ResolverNamedOptionsKt.getPassword(options)) == null) {
            MavenRepositoryCoordinates mavenRepositoryCoordinates = mavenRepo;
            string5 = mavenRepositoryCoordinates != null ? mavenRepositoryCoordinates.getPassword() : null;
        }
        String password = string5;
        void v5 = $this$addRepository_u24lambda_u2d6_u24lambda_u2d5;
        String string8 = username;
        if (string8 != null) {
            String string9 = string8;
            var18_18 = v5;
            boolean bl3 = false;
            string4 = this.tryResolveEnvironmentVariable(p0);
            v5 = var18_18;
        } else {
            string4 = null;
        }
        v5.addUsername(string4);
        void v8 = $this$addRepository_u24lambda_u2d6_u24lambda_u2d5;
        String string10 = password;
        if (string10 != null) {
            p0 = string10;
            var18_18 = v8;
            boolean bl4 = false;
            string3 = this.tryResolveEnvironmentVariable(p0);
            v8 = var18_18;
        } else {
            string3 = null;
        }
        v8.addPassword(string3);
        void v11 = $this$addRepository_u24lambda_u2d6_u24lambda_u2d5;
        String string11 = ResolverNamedOptionsKt.getPrivateKeyFile(options);
        if (string11 != null) {
            void p02;
            String bl4 = string11;
            var18_18 = v11;
            boolean bl5 = false;
            string2 = this.tryResolveEnvironmentVariable((String)p02);
            v11 = var18_18;
        } else {
            string2 = null;
        }
        String string12 = ResolverNamedOptionsKt.getPrivateKeyPassphrase(options);
        if (string12 != null) {
            String p02 = string12;
            String string13 = string2;
            var18_18 = v11;
            boolean bl6 = false;
            String string14 = this.tryResolveEnvironmentVariable(p02);
            v11 = var18_18;
            string2 = string13;
            string = string14;
        } else {
            string = null;
        }
        v11.addPrivateKey(string2, string);
        ((RemoteRepository.Builder)object2).setAuthentication(authenticationBuilder.build());
        RemoteRepository repo = ((RemoteRepository.Builder)object).build();
        this.repos.add(repo);
        return ErrorHandlingKt.asSuccess$default(true, null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lkotlin/script/experimental/dependencies/maven/MavenDependenciesResolver$Companion;", "", "()V", "FORBIDDEN_CHARS", "Lkotlin/text/Regex;", "kotlin-scripting-dependencies-maven"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

