/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.SubstitutorsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeStubTypeForTypeVariableInSubtyping;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeVariable;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001al\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\t2\u0012\b\u0002\u0010\r\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\t2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u00a8\u0006\u0012"}, d2={"checkUpperBoundViolated", "", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "typeParameters", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "typeArguments", "", "typeArgumentRefsAndSources", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirTypeRefSource;", "isTypeAlias", "", "isIgnoreTypeParameters", "checkers"})
public final class FirUpperBoundViolatedHelpersKt {
    /*
     * WARNING - void declaration
     */
    public static final void checkUpperBoundViolated(@Nullable FirTypeRef typeRef, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @Nullable List<FirTypeParameterSymbol> typeParameters2, @Nullable List<? extends Object> typeArguments2, @Nullable List<FirTypeRefSource> typeArgumentRefsAndSources, boolean isTypeAlias, boolean isIgnoreTypeParameters) {
        List<FirTypeParameterSymbol> typeParameterSymbols;
        int typeArgumentsCount;
        Object object;
        block36: {
            block35: {
                Intrinsics.checkNotNullParameter(context2, "context");
                Intrinsics.checkNotNullParameter(reporter, "reporter");
                if (!(typeArguments2 == null || typeArgumentRefsAndSources == null)) {
                    boolean $i$a$-require-FirUpperBoundViolatedHelpersKt$checkUpperBoundViolated$22 = false;
                    String $i$a$-require-FirUpperBoundViolatedHelpersKt$checkUpperBoundViolated$22 = "Only one of those arguments can be not null";
                    throw new IllegalArgumentException($i$a$-require-FirUpperBoundViolatedHelpersKt$checkUpperBoundViolated$22.toString());
                }
                object = typeRef;
                if (object == null) break block35;
                FirTypeRef $this$coneTypeSafe$iv = object;
                boolean $i$f$coneTypeSafe = false;
                FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                Object object2 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                if (!(object2 instanceof ConeKotlinType)) {
                    object2 = object = null;
                }
                if (object2 != null) break block36;
            }
            return;
        }
        Object type2 = object;
        List<? extends Object> list2 = typeArguments2;
        int n = typeArgumentsCount = list2 != null ? list2.size() : ((ConeKotlinType)type2).getTypeArguments().length;
        if (typeArgumentsCount == 0) {
            return;
        }
        List<FirTypeParameterSymbol> list3 = typeParameters2;
        if (list3 == null) {
            if (type2 instanceof ConeClassLikeType) {
                ConeClassLikeType fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)type2, context2.getSession(), null, 2, null);
                FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(fullyExpandedType2.getLookupTag(), context2.getSession());
                FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
                if (firRegularClassSymbol == null) {
                    return;
                }
                FirRegularClassSymbol prototypeClassSymbol = firRegularClassSymbol;
                if (!Intrinsics.areEqual(type2, fullyExpandedType2)) {
                    FirUpperBoundViolatedHelpersKt.checkUpperBoundViolated(typeRef, context2, reporter, prototypeClassSymbol.getTypeParameterSymbols(), ArraysKt.toList(fullyExpandedType2.getTypeArguments()), null, true, isIgnoreTypeParameters);
                    return;
                }
                list3 = prototypeClassSymbol.getTypeParameterSymbols();
            } else {
                list3 = CollectionsKt.emptyList();
            }
        }
        if ((typeParameterSymbols = list3).isEmpty()) {
            return;
        }
        int count = Math.min(typeParameterSymbols.size(), typeArgumentsCount);
        Map substitution = new LinkedHashMap();
        for (int index2 = 0; index2 < count; ++index2) {
            List<? extends Object> list4 = typeArguments2;
            if (list4 == null || (list4 = list4.get(index2)) == null) {
                list4 = ((ConeKotlinType)type2).getTypeArguments()[index2];
            }
            List<? extends Object> typeArgument = list4;
            FirTypeParameterSymbol typeParameterSymbol = typeParameterSymbols.get(index2);
            if (typeArgument instanceof FirTypeProjectionWithVariance) {
                substitution.put(typeParameterSymbol, FirTypeUtilsKt.getConeType(((FirTypeProjectionWithVariance)((Object)typeArgument)).getTypeRef()));
                continue;
            }
            if (typeArgument instanceof ConeKotlinType) {
                substitution.put(typeParameterSymbol, ((ConeKotlinType)((Object)typeArgument)).getType());
                continue;
            }
            if (!(typeArgument instanceof ConeTypeProjection)) continue;
            ConeKotlinType typeArgumentType = ConeTypesKt.getType((ConeTypeProjection)((Object)typeArgument));
            if (typeArgumentType != null) {
                substitution.put(typeParameterSymbol, typeArgumentType);
                continue;
            }
            substitution.put(typeParameterSymbol, new ConeStubTypeForTypeVariableInSubtyping(new ConeTypeVariable("", typeParameterSymbol.toLookupTag()), ConeNullability.NOT_NULL));
        }
        ConeSubstitutor substitutor2 = SubstitutorsKt.substitutorByMap(substitution, context2.getSession());
        ConeInferenceContext typeSystemContext2 = TypeComponentsKt.getTypeContext(context2.getSession());
        for (int index3 = 0; index3 < count; ++index3) {
            Object extractedTypeArgumentRefAndSource;
            Object typeArgumentRefAndSource;
            Object localTypeArgument;
            ConeKotlinType typeArgument = null;
            FirTypeRef typeArgumentTypeRef = null;
            KtSourceElement typeArgumentSource = null;
            if (typeArguments2 != null) {
                localTypeArgument = typeArguments2.get(index3);
                if (localTypeArgument instanceof FirTypeProjectionWithVariance) {
                    typeArgumentTypeRef = ((FirTypeProjectionWithVariance)localTypeArgument).getTypeRef();
                    typeArgument = FirTypeUtilsKt.getConeType(typeArgumentTypeRef);
                    typeArgumentSource = ((FirTypeProjectionWithVariance)localTypeArgument).getSource();
                } else if (localTypeArgument instanceof ConeKotlinType) {
                    typeArgument = (ConeKotlinType)localTypeArgument;
                    typeArgumentSource = typeRef.getSource();
                }
            } else {
                localTypeArgument = ((ConeKotlinType)type2).getTypeArguments()[index3];
                if (localTypeArgument instanceof ConeKotlinType) {
                    typeArgument = (ConeKotlinType)localTypeArgument;
                } else if (localTypeArgument instanceof ConeKotlinTypeProjection) {
                    typeArgument = ((ConeKotlinTypeProjection)localTypeArgument).getType();
                }
                List<FirTypeRefSource> list5 = typeArgumentRefsAndSources;
                Object object3 = typeArgumentRefAndSource = list5 != null ? CollectionsKt.getOrNull(list5, index3) : null;
                if (typeArgumentRefAndSource != null) {
                    typeArgumentTypeRef = ((FirTypeRefSource)typeArgumentRefAndSource).getTypeRef();
                    typeArgumentSource = ((FirTypeRefSource)typeArgumentRefAndSource).getSource();
                } else {
                    extractedTypeArgumentRefAndSource = FirHelpersKt.extractArgumentTypeRefAndSource(typeRef, index3);
                    if (extractedTypeArgumentRefAndSource != null) {
                        typeArgumentTypeRef = ((FirTypeRefSource)extractedTypeArgumentRefAndSource).getTypeRef();
                        typeArgumentSource = ((FirTypeRefSource)extractedTypeArgumentRefAndSource).getSource();
                    }
                }
            }
            if (typeArgument == null || typeArgumentSource == null) continue;
            if (!isIgnoreTypeParameters || typeArgument.getTypeArguments().length == 0 && !(typeArgument instanceof ConeTypeParameterType)) {
                ConeKotlinType intersection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                extractedTypeArgumentRefAndSource = typeParameterSymbols.get(index3).getResolvedBounds();
                ConeInferenceContext coneInferenceContext = typeSystemContext2;
                boolean $i$f$map = false;
                void var23_28 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(FirTypeUtilsKt.getConeType((FirTypeRef)it));
                }
                typeArgumentRefAndSource = coneInferenceContext.intersectTypes((List)destination$iv$iv);
                ConeKotlinType coneKotlinType = intersection = typeArgumentRefAndSource instanceof ConeKotlinType ? (ConeKotlinType)typeArgumentRefAndSource : null;
                if (intersection != null) {
                    ConeKotlinType upperBound = substitutor2.substituteOrSelf(intersection);
                    if (!AbstractTypeChecker.INSTANCE.isSubtypeOf(typeSystemContext2, (KotlinTypeMarker)typeArgument.getType(), (KotlinTypeMarker)upperBound, true)) {
                        KtDiagnosticFactory2<ConeKotlinType, ConeKotlinType> factory2 = isTypeAlias ? FirErrors.INSTANCE.getUPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION() : FirErrors.INSTANCE.getUPPER_BOUND_VIOLATED();
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeArgumentSource, factory2, (Object)upperBound, (Object)typeArgument.getType(), (DiagnosticContext)context2, null, 32, null);
                        if (isTypeAlias) {
                            return;
                        }
                    }
                }
            }
            FirUpperBoundViolatedHelpersKt.checkUpperBoundViolated$default(typeArgumentTypeRef, context2, reporter, null, null, null, false, isIgnoreTypeParameters, 120, null);
        }
    }

    public static /* synthetic */ void checkUpperBoundViolated$default(FirTypeRef firTypeRef, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, List list2, List list3, List list4, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            list2 = null;
        }
        if ((n & 0x10) != 0) {
            list3 = null;
        }
        if ((n & 0x20) != 0) {
            list4 = null;
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        if ((n & 0x80) != 0) {
            bl2 = false;
        }
        FirUpperBoundViolatedHelpersKt.checkUpperBoundViolated(firTypeRef, checkerContext, diagnosticReporter, list2, list3, list4, bl, bl2);
    }
}

