/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.transformers.PhaseUtilsKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractOverrideChecker;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractOverrideCheckerKt;
import org.jetbrains.kotlin.fir.symbols.FirPhaseManagerKt;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0014J \u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J0\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\bH\u0002J$\u0010\u0017\u001a\u00020\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J \u0010\u001a\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u001e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\bJ\u0018\u0010 \u001a\u00020\r2\u0006\u0010\t\u001a\u00020!2\u0006\u0010\u000b\u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirStandardOverrideChecker;", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirAbstractOverrideChecker;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "context", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "buildTypeParametersSubstitutorIfCompatible", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "overrideCandidate", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "baseDeclaration", "isCompatibleTypeParameters", "", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRef;", "substitutor", "isEqualBound", "overrideBound", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "baseBound", "overrideTypeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "baseTypeParameter", "isEqualReceiverTypes", "candidateTypeRef", "baseTypeRef", "isEqualTypes", "substitutedCandidateType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "substitutedBaseType", "candidateType", "baseType", "isOverriddenFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "isOverriddenProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "maybeEqualErrorTypes", "ref1", "Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "ref2", "providers"})
public final class FirStandardOverrideChecker
extends FirAbstractOverrideChecker {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ConeInferenceContext context;

    public FirStandardOverrideChecker(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(session2, "session");
        this.session = session2;
        this.context = TypeComponentsKt.getTypeContext(this.session);
    }

    private final boolean isEqualTypes(ConeKotlinType substitutedCandidateType, ConeKotlinType substitutedBaseType) {
        boolean candidateIsFlexible;
        ConeInferenceContext $this$isEqualTypes_u24lambda_u2d0 = this.context;
        boolean bl = false;
        boolean baseIsFlexible = $this$isEqualTypes_u24lambda_u2d0.isFlexible(substitutedBaseType);
        if (baseIsFlexible == (candidateIsFlexible = $this$isEqualTypes_u24lambda_u2d0.isFlexible(substitutedCandidateType))) {
            return AbstractTypeChecker.equalTypes$default(AbstractTypeChecker.INSTANCE, this.context, substitutedCandidateType, substitutedBaseType, false, 8, null);
        }
        SimpleTypeMarker lowerBound = null;
        SimpleTypeMarker upperBound = null;
        KotlinTypeMarker type2 = null;
        if (baseIsFlexible) {
            lowerBound = $this$isEqualTypes_u24lambda_u2d0.lowerBoundIfFlexible(substitutedBaseType);
            upperBound = $this$isEqualTypes_u24lambda_u2d0.upperBoundIfFlexible(substitutedBaseType);
            type2 = substitutedCandidateType;
        } else {
            lowerBound = $this$isEqualTypes_u24lambda_u2d0.lowerBoundIfFlexible(substitutedCandidateType);
            upperBound = $this$isEqualTypes_u24lambda_u2d0.upperBoundIfFlexible(substitutedCandidateType);
            type2 = substitutedBaseType;
        }
        return AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, this.context, (KotlinTypeMarker)lowerBound, type2, false, 8, null) && AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, this.context, type2, (KotlinTypeMarker)upperBound, false, 8, null);
    }

    private final boolean isEqualTypes(ConeKotlinType candidateType, ConeKotlinType baseType2, ConeSubstitutor substitutor2) {
        ConeKotlinType substitutedCandidateType = substitutor2.substituteOrSelf(candidateType);
        ConeKotlinType substitutedBaseType = substitutor2.substituteOrSelf(baseType2);
        return this.isEqualTypes(substitutedCandidateType, substitutedBaseType);
    }

    public final boolean isEqualTypes(@NotNull FirTypeRef candidateTypeRef, @NotNull FirTypeRef baseTypeRef, @NotNull ConeSubstitutor substitutor2) {
        Intrinsics.checkNotNullParameter(candidateTypeRef, "candidateTypeRef");
        Intrinsics.checkNotNullParameter(baseTypeRef, "baseTypeRef");
        Intrinsics.checkNotNullParameter(substitutor2, "substitutor");
        PhaseUtilsKt.ensureResolvedTypeDeclaration(candidateTypeRef, this.session, FirResolvePhase.TYPES);
        PhaseUtilsKt.ensureResolvedTypeDeclaration(baseTypeRef, this.session, FirResolvePhase.TYPES);
        if (candidateTypeRef instanceof FirErrorTypeRef && baseTypeRef instanceof FirErrorTypeRef) {
            return this.maybeEqualErrorTypes((FirErrorTypeRef)candidateTypeRef, (FirErrorTypeRef)baseTypeRef);
        }
        return this.isEqualTypes(FirTypeUtilsKt.getConeType(candidateTypeRef), FirTypeUtilsKt.getConeType(baseTypeRef), substitutor2);
    }

    private final boolean maybeEqualErrorTypes(FirErrorTypeRef ref1, FirErrorTypeRef ref2) {
        boolean bl;
        block6: {
            FirTypeRef firTypeRef = ref1.getDelegatedTypeRef();
            FirUserTypeRef firUserTypeRef = firTypeRef instanceof FirUserTypeRef ? (FirUserTypeRef)firTypeRef : null;
            if (firUserTypeRef == null) {
                return false;
            }
            FirUserTypeRef delegated1 = firUserTypeRef;
            FirTypeRef firTypeRef2 = ref2.getDelegatedTypeRef();
            FirUserTypeRef firUserTypeRef2 = firTypeRef2 instanceof FirUserTypeRef ? (FirUserTypeRef)firTypeRef2 : null;
            if (firUserTypeRef2 == null) {
                return false;
            }
            FirUserTypeRef delegated2 = firUserTypeRef2;
            if (delegated1.getQualifier().size() != delegated2.getQualifier().size()) {
                return false;
            }
            Iterable $this$all$iv = CollectionsKt.zip((Iterable)delegated1.getQualifier(), (Iterable)delegated2.getQualifier());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    FirQualifierPart l = (FirQualifierPart)pair.component1();
                    FirQualifierPart r = (FirQualifierPart)pair.component2();
                    if (Intrinsics.areEqual(l.getName(), r.getName())) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEqualBound(FirTypeRef overrideBound, FirTypeRef baseBound, FirTypeParameter overrideTypeParameter, FirTypeParameter baseTypeParameter, ConeSubstitutor substitutor2) {
        Object element$iv;
        FirTypeRef bound;
        ConeKotlinType substitutedBaseType;
        ConeKotlinType substitutedOverrideType = substitutor2.substituteOrSelf(FirTypeUtilsKt.getConeType(overrideBound));
        if (this.isEqualTypes(substitutedOverrideType, substitutedBaseType = substitutor2.substituteOrSelf(FirTypeUtilsKt.getConeType(baseBound)))) {
            return true;
        }
        Iterable $this$any$iv = overrideTypeParameter.getBounds();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            element$iv = iterator2.next();
            bound = (FirTypeRef)element$iv;
            boolean bl = false;
        } while (!this.isEqualTypes(FirTypeUtilsKt.getConeType(bound), substitutedBaseType, substitutor2));
        boolean bl = true;
        if (!bl) return false;
        $this$any$iv = baseTypeParameter.getBounds();
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            element$iv = iterator2.next();
            bound = (FirTypeRef)element$iv;
            boolean bl2 = false;
        } while (!this.isEqualTypes(FirTypeUtilsKt.getConeType(bound), substitutedOverrideType, substitutor2));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCompatibleTypeParameters(FirTypeParameterRef overrideCandidate, FirTypeParameterRef baseDeclaration, ConeSubstitutor substitutor2) {
        boolean bl;
        block6: {
            void $this$all$iv;
            if (Intrinsics.areEqual(overrideCandidate.getSymbol(), baseDeclaration.getSymbol())) {
                return true;
            }
            if (!(overrideCandidate instanceof FirTypeParameter) || !(baseDeclaration instanceof FirTypeParameter)) {
                return false;
            }
            if (((FirTypeParameter)overrideCandidate).getBounds().size() != ((FirTypeParameter)baseDeclaration).getBounds().size()) {
                return false;
            }
            Iterable iterable = CollectionsKt.zip((Iterable)((FirTypeParameter)overrideCandidate).getBounds(), (Iterable)((FirTypeParameter)baseDeclaration).getBounds());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirTypeRef bBound;
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    FirTypeRef aBound = (FirTypeRef)pair.component1();
                    if (this.isEqualBound(aBound, bBound = (FirTypeRef)pair.component2(), (FirTypeParameter)overrideCandidate, (FirTypeParameter)baseDeclaration, substitutor2)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    protected ConeSubstitutor buildTypeParametersSubstitutorIfCompatible(@NotNull FirCallableDeclaration overrideCandidate, @NotNull FirCallableDeclaration baseDeclaration) {
        Intrinsics.checkNotNullParameter(overrideCandidate, "overrideCandidate");
        Intrinsics.checkNotNullParameter(baseDeclaration, "baseDeclaration");
        FirPhaseManagerKt.ensureResolved(overrideCandidate, FirResolvePhase.TYPES);
        FirPhaseManagerKt.ensureResolved(baseDeclaration, FirResolvePhase.TYPES);
        ConeSubstitutor coneSubstitutor = FirAbstractOverrideCheckerKt.buildSubstitutorForOverridesCheck(overrideCandidate, baseDeclaration, this.session);
        if (coneSubstitutor == null) {
            return null;
        }
        ConeSubstitutor substitutor2 = coneSubstitutor;
        if (!((Collection)overrideCandidate.getTypeParameters()).isEmpty()) {
            boolean bl;
            block6: {
                Iterable $this$any$iv = CollectionsKt.zip((Iterable)overrideCandidate.getTypeParameters(), (Iterable)baseDeclaration.getTypeParameters());
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirTypeParameterRef base;
                        Pair pair = (Pair)element$iv;
                        boolean bl2 = false;
                        FirTypeParameterRef override = (FirTypeParameterRef)pair.component1();
                        if (!(!this.isCompatibleTypeParameters(override, base = (FirTypeParameterRef)pair.component2(), substitutor2))) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return null;
            }
        }
        return substitutor2;
    }

    private final boolean isEqualReceiverTypes(FirTypeRef candidateTypeRef, FirTypeRef baseTypeRef, ConeSubstitutor substitutor2) {
        return candidateTypeRef != null && baseTypeRef != null ? this.isEqualTypes(candidateTypeRef, baseTypeRef, substitutor2) : candidateTypeRef == null && baseTypeRef == null;
    }

    @Override
    public boolean isOverriddenFunction(@NotNull FirSimpleFunction overrideCandidate, @NotNull FirSimpleFunction baseDeclaration) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter(overrideCandidate, "overrideCandidate");
            Intrinsics.checkNotNullParameter(baseDeclaration, "baseDeclaration");
            FirMemberDeclaration $this$visibility$iv = baseDeclaration;
            boolean $i$f$getVisibility = false;
            if (Visibilities.INSTANCE.isPrivate($this$visibility$iv.getStatus().getVisibility())) {
                return false;
            }
            if (overrideCandidate.getValueParameters().size() != baseDeclaration.getValueParameters().size()) {
                return false;
            }
            ConeSubstitutor coneSubstitutor = this.buildTypeParametersSubstitutorIfCompatible(overrideCandidate, baseDeclaration);
            if (coneSubstitutor == null) {
                return false;
            }
            ConeSubstitutor substitutor2 = coneSubstitutor;
            FirPhaseManagerKt.ensureResolved(overrideCandidate, FirResolvePhase.TYPES);
            FirPhaseManagerKt.ensureResolved(baseDeclaration, FirResolvePhase.TYPES);
            if (!this.isEqualReceiverTypes(overrideCandidate.getReceiverTypeRef(), baseDeclaration.getReceiverTypeRef(), substitutor2)) {
                return false;
            }
            Iterable $this$all$iv = CollectionsKt.zip((Iterable)overrideCandidate.getValueParameters(), (Iterable)baseDeclaration.getValueParameters());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    FirValueParameter memberParam = (FirValueParameter)pair.component1();
                    FirValueParameter selfParam = (FirValueParameter)pair.component2();
                    if (this.isEqualTypes(memberParam.getReturnTypeRef(), selfParam.getReturnTypeRef(), substitutor2)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean isOverriddenProperty(@NotNull FirCallableDeclaration overrideCandidate, @NotNull FirProperty baseDeclaration) {
        Intrinsics.checkNotNullParameter(overrideCandidate, "overrideCandidate");
        Intrinsics.checkNotNullParameter(baseDeclaration, "baseDeclaration");
        FirMemberDeclaration $this$visibility$iv = baseDeclaration;
        boolean $i$f$getVisibility = false;
        if (Visibilities.INSTANCE.isPrivate($this$visibility$iv.getStatus().getVisibility())) {
            return false;
        }
        if (!(overrideCandidate instanceof FirProperty)) {
            return false;
        }
        ConeSubstitutor coneSubstitutor = this.buildTypeParametersSubstitutorIfCompatible(overrideCandidate, baseDeclaration);
        if (coneSubstitutor == null) {
            return false;
        }
        ConeSubstitutor substitutor2 = coneSubstitutor;
        FirPhaseManagerKt.ensureResolved(overrideCandidate, FirResolvePhase.TYPES);
        FirPhaseManagerKt.ensureResolved(baseDeclaration, FirResolvePhase.TYPES);
        return this.isEqualReceiverTypes(overrideCandidate.getReceiverTypeRef(), baseDeclaration.getReceiverTypeRef(), substitutor2);
    }
}

