/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.declarations.persistent;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.persistent.PersistentIrFactory;
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.Carrier;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0002J\b\u0010\u0019\u001a\u00020\u001aH&J\r\u0010\u001b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001aH\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\u00020\u0005X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u0007\"\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00020\u0005X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\u000fR \u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0014X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/ir/declarations/persistent/PersistentIrElementBase;", "T", "Lorg/jetbrains/kotlin/ir/declarations/persistent/carriers/Carrier;", "Lorg/jetbrains/kotlin/ir/IrElement;", "createdOn", "", "getCreatedOn", "()I", "factory", "Lorg/jetbrains/kotlin/ir/declarations/persistent/PersistentIrFactory;", "getFactory", "()Lorg/jetbrains/kotlin/ir/declarations/persistent/PersistentIrFactory;", "lastModified", "getLastModified", "setLastModified", "(I)V", "loweredUpTo", "getLoweredUpTo", "setLoweredUpTo", "values", "", "getValues", "()[Lorg/jetbrains/kotlin/ir/declarations/persistent/carriers/Carrier;", "setValues", "([Lorg/jetbrains/kotlin/ir/declarations/persistent/carriers/Carrier;)V", "ensureLowered", "", "getCarrier", "()Lorg/jetbrains/kotlin/ir/declarations/persistent/carriers/Carrier;", "setCarrier", "ir.tree.persistent"})
public interface PersistentIrElementBase<T extends Carrier>
extends IrElement,
Carrier {
    @NotNull
    public PersistentIrFactory getFactory();

    @Override
    public int getLastModified();

    public void setLastModified(int var1);

    public int getLoweredUpTo();

    public void setLoweredUpTo(int var1);

    @Nullable
    public Carrier[] getValues();

    public void setValues(@Nullable Carrier[] var1);

    public int getCreatedOn();

    public void ensureLowered();

    @NotNull
    public T getCarrier();

    public void setCarrier();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static <T extends Carrier> T getCarrier(@NotNull PersistentIrElementBase<T> this_) {
            int stage = this_.getFactory().getStageController().getCurrentStage();
            boolean bl = false;
            this_.ensureLowered();
            if (stage >= this_.getLastModified()) {
                return (T)this_;
            }
            if (stage < this_.getCreatedOn()) {
                throw new IllegalStateException("Access before creation".toString());
            }
            Carrier[] carrierArray = this_.getValues();
            if (carrierArray == null) {
                throw new IllegalStateException("How come?".toString());
            }
            Carrier[] v = carrierArray;
            int l = -1;
            int r = v.length;
            while (r - l > 1) {
                int m = (l + r) / 2;
                if (v[m].getLastModified() <= stage) {
                    l = m;
                    continue;
                }
                r = m;
            }
            if (l < 0) {
                throw new IllegalStateException("access before creation".toString());
            }
            return (T)v[l];
        }

        public static <T extends Carrier> void setCarrier(@NotNull PersistentIrElementBase<T> this_) {
            int stage = this_.getFactory().getStageController().getCurrentStage();
            this_.ensureLowered();
            if (!this_.getFactory().getStageController().canModify(this_)) {
                throw new IllegalStateException("Cannot modify this element!".toString());
            }
            if (this_.getLoweredUpTo() > stage) {
                throw new IllegalStateException("retrospective modification".toString());
            }
            if (stage == this_.getLastModified()) {
                return;
            }
            Carrier[] carrierArray = this_.getValues();
            if (carrierArray == null) {
                boolean $i$f$emptyArray = false;
                carrierArray = (Carrier[])((Object[])new Carrier[0]);
            }
            this_.setValues((Carrier[])ArraysKt.plus(carrierArray, this_.clone()));
            this_.setLastModified(stage);
        }

        @NotNull
        public static <T extends Carrier, D> IrElement transform(@NotNull PersistentIrElementBase<T> this_, @NotNull IrElementTransformer<? super D> transformer2, D data) {
            Intrinsics.checkNotNullParameter(transformer2, "transformer");
            return IrElement.DefaultImpls.transform(this_, transformer2, data);
        }
    }
}

