/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.konan.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ResolveUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.konan.diagnostics.ErrorsNative;
import org.jetbrains.kotlin.resolve.konan.diagnostics.NativeThreadLocalCheckerKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeThreadLocalChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "threadLocalFqName", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.native"})
public final class NativeThreadLocalChecker
implements DeclarationChecker {
    @NotNull
    public static final NativeThreadLocalChecker INSTANCE = new NativeThreadLocalChecker();
    @NotNull
    private static final FqName threadLocalFqName = new FqName("kotlin.native.concurrent.ThreadLocal");

    private NativeThreadLocalChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        NativeThreadLocalCheckerKt.check(this, threadLocalFqName, declaration2, descriptor2, context2, ErrorsNative.INAPPLICABLE_THREAD_LOCAL, (Function1<? super DeclarationDescriptor, Boolean>)new Function1<DeclarationDescriptor, Boolean>(descriptor2, context2, declaration2){
            final /* synthetic */ DeclarationDescriptor $descriptor;
            final /* synthetic */ DeclarationCheckerContext $context;
            final /* synthetic */ KtDeclaration $declaration;
            {
                this.$descriptor = $descriptor;
                this.$context = $context;
                this.$declaration = $declaration;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull DeclarationDescriptor it) {
                Intrinsics.checkNotNullParameter(it, "it");
                boolean isVariable = this.$descriptor instanceof VariableDescriptor;
                boolean hasBackingField = this.$descriptor instanceof PropertyDescriptor && ResolveUtilKt.hasBackingField((PropertyDescriptor)this.$descriptor, this.$context.getTrace().getBindingContext());
                boolean hasDelegate = this.$declaration instanceof KtProperty && ((KtProperty)this.$declaration).getDelegate() != null;
                return isVariable && (hasBackingField || hasDelegate) || this.$descriptor instanceof ClassDescriptor && ((ClassDescriptor)this.$descriptor).getKind() == ClassKind.OBJECT;
            }
        });
        NativeThreadLocalCheckerKt.check(this, threadLocalFqName, declaration2, descriptor2, context2, ErrorsNative.INAPPLICABLE_THREAD_LOCAL_TOP_LEVEL, (Function1<? super DeclarationDescriptor, Boolean>)new Function1<DeclarationDescriptor, Boolean>(descriptor2){
            final /* synthetic */ DeclarationDescriptor $descriptor;
            {
                this.$descriptor = $descriptor;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull DeclarationDescriptor it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return DescriptorUtils.isTopLevelDeclaration(this.$descriptor) || this.$descriptor instanceof ClassDescriptor && ((ClassDescriptor)this.$descriptor).getKind() == ClassKind.OBJECT;
            }
        });
    }
}

