/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.tagged;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.micrometer.tagged.AbstractMetrics;
import io.github.resilience4j.micrometer.tagged.CircuitBreakerMetricNames;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

abstract class AbstractCircuitBreakerMetrics
extends AbstractMetrics {
    private static final String KIND_STATE = "state";
    private static final String KIND_FAILED = "failed";
    private static final String KIND_SUCCESSFUL = "successful";
    private static final String KIND_IGNORED = "ignored";
    private static final String KIND_NOT_PERMITTED = "not_permitted";
    protected final CircuitBreakerMetricNames names;

    protected AbstractCircuitBreakerMetrics(CircuitBreakerMetricNames names) {
        this.names = Objects.requireNonNull(names);
    }

    @Deprecated
    protected AbstractCircuitBreakerMetrics(MetricNames names) {
        this.names = Objects.requireNonNull(names);
    }

    protected void addMetrics(MeterRegistry meterRegistry, CircuitBreaker circuitBreaker) {
        List<Tag> customTags = this.mapToTagsList(circuitBreaker.getTags().toJavaMap());
        this.registerMetrics(meterRegistry, circuitBreaker, customTags);
    }

    private void registerMetrics(MeterRegistry meterRegistry, CircuitBreaker circuitBreaker, List<Tag> customTags) {
        CircuitBreaker.State[] states;
        this.removeMetrics(meterRegistry, circuitBreaker.getName());
        HashSet<Meter.Id> idSet = new HashSet<Meter.Id>();
        for (CircuitBreaker.State state : states = CircuitBreaker.State.values()) {
            idSet.add(Gauge.builder((String)this.names.getStateMetricName(), (Object)circuitBreaker, cb -> cb.getState() == state ? 1.0 : 0.0).description("The states of the circuit breaker").tag("name", circuitBreaker.getName()).tag(KIND_STATE, state.name().toLowerCase()).tags(customTags).register(meterRegistry).getId());
        }
        idSet.add(Gauge.builder((String)this.names.getBufferedCallsMetricName(), (Object)circuitBreaker, cb -> cb.getMetrics().getNumberOfFailedCalls()).description("The number of buffered failed calls stored in the ring buffer").tag("name", circuitBreaker.getName()).tag("kind", KIND_FAILED).tags(customTags).register(meterRegistry).getId());
        idSet.add(Gauge.builder((String)this.names.getBufferedCallsMetricName(), (Object)circuitBreaker, cb -> cb.getMetrics().getNumberOfSuccessfulCalls()).description("The number of buffered successful calls stored in the ring buffer").tag("name", circuitBreaker.getName()).tag("kind", KIND_SUCCESSFUL).tags(customTags).register(meterRegistry).getId());
        idSet.add(Gauge.builder((String)this.names.getSlowCallsMetricName(), (Object)circuitBreaker, cb -> cb.getMetrics().getNumberOfSlowSuccessfulCalls()).description("The number of slow successful which were slower than a certain threshold").tag("name", circuitBreaker.getName()).tag("kind", KIND_SUCCESSFUL).tags(customTags).register(meterRegistry).getId());
        idSet.add(Gauge.builder((String)this.names.getSlowCallsMetricName(), (Object)circuitBreaker, cb -> cb.getMetrics().getNumberOfSlowFailedCalls()).description("The number of slow failed calls which were slower than a certain threshold").tag("name", circuitBreaker.getName()).tag("kind", KIND_FAILED).tags(customTags).register(meterRegistry).getId());
        idSet.add(Gauge.builder((String)this.names.getFailureRateMetricName(), (Object)circuitBreaker, cb -> cb.getMetrics().getFailureRate()).description("The failure rate of the circuit breaker").tag("name", circuitBreaker.getName()).tags(customTags).register(meterRegistry).getId());
        idSet.add(Gauge.builder((String)this.names.getSlowCallRateMetricName(), (Object)circuitBreaker, cb -> cb.getMetrics().getSlowCallRate()).description("The slow call of the circuit breaker").tag("name", circuitBreaker.getName()).tags(customTags).register(meterRegistry).getId());
        Timer successfulCalls = Timer.builder((String)this.names.getCallsMetricName()).description("Total number of successful calls").tag("name", circuitBreaker.getName()).tag("kind", KIND_SUCCESSFUL).tags(customTags).register(meterRegistry);
        Timer failedCalls = Timer.builder((String)this.names.getCallsMetricName()).description("Total number of failed calls").tag("name", circuitBreaker.getName()).tag("kind", KIND_FAILED).tags(customTags).register(meterRegistry);
        Timer ignoredFailedCalls = Timer.builder((String)this.names.getCallsMetricName()).description("Total number of calls which failed but the exception was ignored").tag("name", circuitBreaker.getName()).tag("kind", KIND_IGNORED).tags(customTags).register(meterRegistry);
        Counter notPermittedCalls = Counter.builder((String)this.names.getNotPermittedCallsMetricName()).description("Total number of not permitted calls").tag("name", circuitBreaker.getName()).tag("kind", KIND_NOT_PERMITTED).tags(customTags).register(meterRegistry);
        idSet.add(successfulCalls.getId());
        idSet.add(failedCalls.getId());
        idSet.add(ignoredFailedCalls.getId());
        idSet.add(notPermittedCalls.getId());
        circuitBreaker.getEventPublisher().onIgnoredError(event -> ignoredFailedCalls.record(event.getElapsedDuration())).onCallNotPermitted(event -> notPermittedCalls.increment()).onSuccess(event -> successfulCalls.record(event.getElapsedDuration())).onError(event -> failedCalls.record(event.getElapsedDuration()));
        this.meterIdMap.put(circuitBreaker.getName(), idSet);
    }

    @Deprecated
    public static class MetricNames
    extends CircuitBreakerMetricNames {
    }
}

