/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.TransferHandler;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

class RetainLineBreakTransferHandler
extends TransferHandler {
    RetainLineBreakTransferHandler() {
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        JEditorPane pane = (JEditorPane)c;
        String htmlText = pane.getText();
        String plainText = this.extractText(new StringReader(htmlText));
        return new MyTransferable(plainText, htmlText);
    }

    private String extractText(Reader reader) {
        final StringBuilder result = new StringBuilder();
        HTMLEditorKit.ParserCallback parserCallback = new HTMLEditorKit.ParserCallback(){

            @Override
            public void handleText(char[] data, int pos) {
                result.append(data);
            }

            @Override
            public void handleStartTag(HTML.Tag tag, MutableAttributeSet attribute, int pos) {
            }

            @Override
            public void handleEndTag(HTML.Tag tag, int pos) {
            }

            @Override
            public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet a, int pos) {
                if (tag.equals(HTML.Tag.BR)) {
                    result.append('\n');
                }
            }

            @Override
            public void handleComment(char[] data, int pos) {
            }

            @Override
            public void handleError(String errMsg, int pos) {
            }
        };
        try {
            new ParserDelegator().parse(reader, parserCallback, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result.toString();
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
        if (action == 1) {
            clip.setContents(this.createTransferable(comp), null);
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    static class MyTransferable
    implements Transferable {
        private static final DataFlavor[] supportedFlavors;
        private final String plainData;
        private final String htmlData;

        MyTransferable(String plainData, String htmlData) {
            this.plainData = plainData;
            this.htmlData = htmlData;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return supportedFlavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            for (DataFlavor supportedFlavor : supportedFlavors) {
                if (supportedFlavor != flavor) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (flavor.equals(supportedFlavors[0])) {
                return this.htmlData;
            }
            if (flavor.equals(supportedFlavors[1])) {
                return this.plainData;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        static {
            try {
                supportedFlavors = new DataFlavor[]{new DataFlavor("text/html;class=java.lang.String"), new DataFlavor("text/plain;class=java.lang.String")};
            }
            catch (ClassNotFoundException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }
}

