/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterreplica;

import io.lettuce.core.models.role.RedisNodeDescription;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

class TopologyComparators {
    TopologyComparators() {
    }

    static enum SortAction {
        BY_LATENCY{

            @Override
            void sort(List<RedisNodeDescription> nodes, Comparator<? super RedisNodeDescription> latencyComparator) {
                nodes.sort(latencyComparator);
            }
        }
        ,
        NONE{

            @Override
            void sort(List<RedisNodeDescription> nodes, Comparator<? super RedisNodeDescription> latencyComparator) {
            }
        }
        ,
        RANDOMIZE{

            @Override
            void sort(List<RedisNodeDescription> nodes, Comparator<? super RedisNodeDescription> latencyComparator) {
                Collections.shuffle(nodes);
            }
        };


        abstract void sort(List<RedisNodeDescription> var1, Comparator<? super RedisNodeDescription> var2);

        static SortAction getSortAction() {
            String sortAction = System.getProperty("io.lettuce.core.topology.sort", BY_LATENCY.name());
            for (SortAction action : SortAction.values()) {
                if (!sortAction.equalsIgnoreCase(action.name())) continue;
                return action;
            }
            return BY_LATENCY;
        }
    }

    static class LatencyComparator
    implements Comparator<RedisNodeDescription> {
        private final Map<RedisNodeDescription, Long> latencies;

        public LatencyComparator(Map<RedisNodeDescription, Long> latencies) {
            this.latencies = latencies;
        }

        @Override
        public int compare(RedisNodeDescription o1, RedisNodeDescription o2) {
            Long latency1 = this.latencies.get(o1);
            Long latency2 = this.latencies.get(o2);
            if (latency1 != null && latency2 != null) {
                return latency1.compareTo(latency2);
            }
            if (latency1 != null) {
                return -1;
            }
            if (latency2 != null) {
                return 1;
            }
            return 0;
        }
    }
}

