/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.languagetool.language.LanguageIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastText {
    private static final Logger logger = LoggerFactory.getLogger(FastText.class);
    private static final int K_HIGHEST_SCORES = 5;
    private static final int BUFFER_SIZE = 4096;
    private final Process fasttextProcess;
    private final Reader fasttextIn;
    private final Writer fasttextOut;

    public FastText(File modelPath, File binaryPath) throws IOException {
        this.fasttextProcess = new ProcessBuilder(binaryPath.getPath(), "predict-prob", modelPath.getPath(), "-", "5").start();
        this.fasttextIn = new InputStreamReader(this.fasttextProcess.getInputStream(), StandardCharsets.UTF_8);
        this.fasttextOut = new OutputStreamWriter(this.fasttextProcess.getOutputStream(), StandardCharsets.UTF_8);
    }

    FastText() {
        this.fasttextProcess = null;
        this.fasttextIn = null;
        this.fasttextOut = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Double> runFasttext(String text, List<String> additionalLanguageCodes) throws IOException {
        String joined = text.replace("\n", " ").toLowerCase(Locale.ROOT);
        char[] cbuf = new char[4096];
        FastText fastText = this;
        synchronized (fastText) {
            this.fasttextOut.write(joined + System.lineSeparator());
            this.fasttextOut.flush();
            long read = this.fasttextIn.read(cbuf);
            if (read <= 0L) {
                try {
                    logger.warn("fasttextIn.read() returned no data, trying again after short delay");
                    Thread.sleep(10L);
                    read = this.fasttextIn.read(cbuf);
                    if (read == -1L) {
                        logger.warn("fasttextIn.read() returned no data again");
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.fasttextIn.ready()) {
                logger.warn("More input to read from Fasttext, this should not happen; language detection results might be mixed up");
            }
        }
        return this.parseBuffer(new String(cbuf), additionalLanguageCodes);
    }

    @NotNull
    Map<String, Double> parseBuffer(String buffer, List<String> additionalLanguageCodes) {
        String[] values = buffer.trim().split("\\s+");
        if (!buffer.startsWith("__label__")) {
            throw new FastTextException("FastText output is expected to start with '__label__': ''" + buffer + "'", true);
        }
        if (values.length % 2 != 0) {
            throw new FastTextException("Error while parsing fasttext output, expected pairs of '__label_xx' and float: '" + buffer + "'", true);
        }
        if (buffer.trim().contains("\n")) {
            logger.warn("Got multiple lines to read from Fasttext, this should not happen: '" + buffer + "'");
        }
        HashMap<String, Double> probabilities = new HashMap<String, Double>();
        for (int i = 0; i < values.length; i += 2) {
            String lang = values[i];
            String langCode = lang.substring(lang.lastIndexOf("__") + 2);
            String prob = values[i + 1];
            Double probValue = Double.parseDouble(prob);
            if (!LanguageIdentifier.canLanguageBeDetected(langCode, additionalLanguageCodes)) continue;
            probabilities.put(langCode, probValue);
        }
        return probabilities;
    }

    void destroy() {
        this.fasttextProcess.destroy();
    }

    public static class FastTextException
    extends RuntimeException {
        private final boolean disabled;

        public FastTextException(String message, boolean disabled) {
            super(message);
            this.disabled = disabled;
        }

        public boolean isDisabled() {
            return this.disabled;
        }
    }
}

