/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.util.Locale;
import org.languagetool.Language;
import org.languagetool.rules.patterns.Match;
import org.languagetool.tools.StringTools;

public final class CaseConversionHelper {
    private CaseConversionHelper() {
    }

    public static String convertCase(Match.CaseConversion conversion, String s, String sample, Language lang) {
        if (StringTools.isEmpty(s)) {
            return s;
        }
        String token = s;
        switch (conversion) {
            case NONE: {
                break;
            }
            case PRESERVE: {
                if (!StringTools.startsWithUppercase(sample)) break;
                if (StringTools.isAllUppercase(sample)) {
                    token = token.toUpperCase(Locale.ENGLISH);
                    break;
                }
                token = StringTools.uppercaseFirstChar(token, lang);
                break;
            }
            case STARTLOWER: {
                token = token.substring(0, 1).toLowerCase() + token.substring(1);
                break;
            }
            case STARTUPPER: {
                token = StringTools.uppercaseFirstChar(token, lang);
                break;
            }
            case ALLUPPER: {
                token = token.toUpperCase(Locale.ENGLISH);
                break;
            }
            case FIRSTUPPER: {
                token = token.toLowerCase();
                token = StringTools.uppercaseFirstChar(token, lang);
                break;
            }
            case ALLLOWER: {
                token = token.toLowerCase();
                break;
            }
        }
        return token;
    }
}

