/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis;

import gnu.trove.THashSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tools.MostlySingularMultiMap;
import org.languagetool.tools.StringTools;

public final class ManualSynthesizer {
    private final MostlySingularMultiMap<TaggedWord, String> mapping;
    private final Set<String> possibleTags;
    private static final String DEFAULT_SEPARATOR = "\t";

    public ManualSynthesizer(InputStream inputStream) throws IOException {
        THashSet tags = new THashSet();
        this.mapping = new MostlySingularMultiMap<TaggedWord, String>(ManualSynthesizer.loadMapping(inputStream, (Set<String>)tags));
        tags.trimToSize();
        this.possibleTags = Collections.unmodifiableSet(tags);
    }

    public Set<String> getPossibleTags() {
        return this.possibleTags;
    }

    @Nullable
    public List<String> lookup(String lemma, String posTag) {
        return this.mapping.getList(new TaggedWord(lemma, posTag));
    }

    private static Map<TaggedWord, List<String>> loadMapping(InputStream inputStream, Set<String> outTags) throws IOException {
        HashMap internedStrings = new HashMap();
        HashMap<TaggedWord, List<String>> mapping = new HashMap<TaggedWord, List<String>>();
        HashMap interned = new HashMap();
        try (Scanner scanner = new Scanner(inputStream, "utf8");){
            String separator = DEFAULT_SEPARATOR;
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if ((line = line.trim()).startsWith("#separatorRegExp=")) {
                    separator = line.replace("#separatorRegExp=", "");
                }
                if (StringTools.isEmpty(line) || line.charAt(0) == '#') continue;
                String[] parts = (line = StringUtils.substringBefore((String)line, (String)"#").trim()).split(separator);
                if (parts.length != 3) {
                    throw new IOException("Unknown line format when loading manual synthesizer dictionary, expected 3 parts separated by '" + separator + "', found " + parts.length + ": '" + line + "'");
                }
                String form = parts[0];
                String lemma = parts[1];
                if (form.equals(lemma)) {
                    form = lemma;
                }
                lemma = (String)interned.computeIfAbsent(lemma, Function.identity());
                String posTag = (String)internedStrings.computeIfAbsent(parts[2], Function.identity());
                mapping.computeIfAbsent(new TaggedWord(lemma, posTag), __ -> new ArrayList()).add(form);
                outTags.add(posTag);
            }
        }
        return mapping;
    }
}

