/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.crf.crfpp;

public class Mcsrch {
    public static final double ftol = 1.0E-4;
    public static final double xtol = 1.0E-16;
    public static final double eps = 1.0E-7;
    public static final double lb3_1_gtol = 0.9;
    public static final double lb3_1_stpmin = 1.0E-20;
    public static final double lb3_1_stpmax = 1.0E20;
    public static final int lb3_1_mp = 6;
    public static final int lb3_1_lp = 6;
    int infoc = 0;
    boolean stage1 = false;
    boolean brackt = false;
    double finit = 0.0;
    double dginit = 0.0;
    double dgtest = 0.0;
    double width = 0.0;
    double width1 = 0.0;
    double stx = 0.0;
    double fx = 0.0;
    double dgx = 0.0;
    double sty = 0.0;
    double fy = 0.0;
    double dgy = 0.0;
    double stmin = 0.0;
    double stmax = 0.0;

    public static double sigma(double x) {
        if (x > 0.0) {
            return 1.0;
        }
        if (x < 0.0) {
            return -1.0;
        }
        return 0.0;
    }

    public double pi(double x, double y) {
        return Mcsrch.sigma(x) == Mcsrch.sigma(y) ? x : 0.0;
    }

    public static void daxpy_(int n, double da, double[] dx, int offsetX, double[] dy, int offsetY) {
        for (int i = 0; i < n; ++i) {
            int n2 = i + offsetY;
            dy[n2] = dy[n2] + da * dx[i + offsetX];
        }
    }

    public static double ddot_(int size, double[] dx, int offsetX, double[] dy, int offsetY) {
        double res = 0.0;
        for (int i = 0; i < size; ++i) {
            res += dx[i + offsetX] * dy[i + offsetY];
        }
        return res;
    }

    public static void mcstep(double[] stx, double[] fx, double[] dx, double[] sty, double[] fy, double[] dy, double[] stp, double fp, double dp, boolean[] brackt, double stpmin, double stpmax, int[] info) {
        double stpf;
        double d1;
        boolean bound = true;
        info[0] = 0;
        if (brackt[0] && (stp[0] <= Math.min(stx[0], sty[0]) || stp[0] >= Math.max(stx[0], sty[0]) || dx[0] * (stp[0] - stx[0]) >= 0.0 || stpmax < stpmin)) {
            return;
        }
        double sgnd = dp * (dx[0] / Math.abs(dx[0]));
        if (fp > fx[0]) {
            info[0] = 1;
            bound = true;
            double theta = (fx[0] - fp) * 3.0 / (stp[0] - stx[0]) + dx[0] + dp;
            d1 = Math.abs(theta);
            double d2 = Math.abs(dx[0]);
            d1 = Math.max(d1, d2);
            d2 = Math.abs(dp);
            double s = Math.max(d1, d2);
            d1 = theta / s;
            double gamma = s * Math.sqrt(d1 * d1 - dx[0] / s * (dp / s));
            if (stp[0] < stx[0]) {
                gamma = -gamma;
            }
            double p = gamma - dx[0] + theta;
            double q = gamma - dx[0] + gamma + dp;
            double r = p / q;
            double stpc = stx[0] + r * (stp[0] - stx[0]);
            double stpq = stx[0] + dx[0] / ((fx[0] - fp) / (stp[0] - stx[0]) + dx[0]) / 2.0 * (stp[0] - stx[0]);
            d1 = stpc - stx[0];
            d2 = stpq - stx[0];
            stpf = Math.abs(d1) < Math.abs(d2) ? stpc : stpc + (stpq - stpc) / 2.0;
            brackt[0] = true;
        } else if (sgnd < 0.0) {
            info[0] = 2;
            bound = false;
            double theta = (fx[0] - fp) * 3.0 / (stp[0] - stx[0]) + dx[0] + dp;
            d1 = Math.abs(theta);
            double d2 = Math.abs(dx[0]);
            d1 = Math.max(d1, d2);
            d2 = Math.abs(dp);
            double s = Math.max(d1, d2);
            d1 = theta / s;
            double gamma = s * Math.sqrt(d1 * d1 - dx[0] / s * (dp / s));
            if (stp[0] > stx[0]) {
                gamma = -gamma;
            }
            double p = gamma - dp + theta;
            double q = gamma - dp + gamma + dx[0];
            double r = p / q;
            double stpc = stp[0] + r * (stx[0] - stp[0]);
            double stpq = stp[0] + dp / (dp - dx[0]) * (stx[0] - stp[0]);
            d1 = stpc - stp[0];
            d2 = stpq - stp[0];
            stpf = Math.abs(d1) > Math.abs(d2) ? stpc : stpq;
            brackt[0] = true;
        } else if (Math.abs(dp) < Math.abs(dx[0])) {
            double q;
            double p;
            double r;
            info[0] = 3;
            bound = true;
            double theta = (fx[0] - fp) * 3.0 / (stp[0] - stx[0]) + dx[0] + dp;
            d1 = Math.abs(theta);
            double d2 = Math.abs(dx[0]);
            d1 = Math.max(d1, d2);
            d2 = Math.abs(dp);
            double s = Math.max(d1, d2);
            double d3 = theta / s;
            d1 = 0.0;
            d2 = d3 * d3 - dx[0] / s * (dp / s);
            double gamma = s * Math.sqrt(Math.max(d1, d2));
            if (stp[0] > stx[0]) {
                gamma = -gamma;
            }
            double stpc = (r = (p = gamma - dp + theta) / (q = gamma + (dx[0] - dp) + gamma)) < 0.0 && gamma != 0.0 ? stp[0] + r * (stx[0] - stp[0]) : (stp[0] > stx[0] ? stpmax : stpmin);
            double stpq = stp[0] + dp / (dp - dx[0]) * (stx[0] - stp[0]);
            if (brackt[0]) {
                d1 = stp[0] - stpc;
                d2 = stp[0] - stpq;
                stpf = Math.abs(d1) < Math.abs(d2) ? stpc : stpq;
            } else {
                d1 = stp[0] - stpc;
                d2 = stp[0] - stpq;
                stpf = Math.abs(d1) > Math.abs(d2) ? stpc : stpq;
            }
        } else {
            info[0] = 4;
            bound = false;
            if (brackt[0]) {
                double stpc;
                double theta = (fp - fy[0]) * 3.0 / (sty[0] - stp[0]) + dy[0] + dp;
                d1 = Math.abs(theta);
                double d2 = Math.abs(dy[0]);
                d1 = Math.max(d1, d2);
                d2 = Math.abs(dp);
                double s = Math.max(d1, d2);
                d1 = theta / s;
                double gamma = s * Math.sqrt(d1 * d1 - dy[0] / s * (dp / s));
                if (stp[0] > sty[0]) {
                    gamma = -gamma;
                }
                double p = gamma - dp + theta;
                double q = gamma - dp + gamma + dy[0];
                double r = p / q;
                stpf = stpc = stp[0] + r * (sty[0] - stp[0]);
            } else {
                stpf = stp[0] > stx[0] ? stpmax : stpmin;
            }
        }
        if (fp > fx[0]) {
            sty[0] = stp[0];
            fy[0] = fp;
            dy[0] = dp;
        } else {
            if (sgnd < 0.0) {
                sty[0] = stx[0];
                fy[0] = fx[0];
                dy[0] = dx[0];
            }
            stx[0] = stp[0];
            fx[0] = fp;
            dx[0] = dp;
        }
        stpf = Math.min(stpmax, stpf);
        stp[0] = stpf = Math.max(stpmin, stpf);
        if (brackt[0] && bound) {
            if (sty[0] > stx[0]) {
                d1 = stx[0] + (sty[0] - stx[0]) * 0.66;
                stp[0] = Math.min(d1, stp[0]);
            } else {
                d1 = stx[0] + (sty[0] - stx[0]) * 0.66;
                stp[0] = Math.max(d1, stp[0]);
            }
        }
    }

    void mcsrch(int size, double[] x, double f, double[] g, double[] s, int startOffset, double[] stp, int[] info, int[] nfev, double[] wa) {
        double p5 = 0.5;
        double p66 = 0.66;
        double xtrapf = 4.0;
        int maxfev = 20;
        if (info[0] != -1) {
            this.infoc = 1;
            if (size <= 0 || stp[0] <= 0.0) {
                return;
            }
            this.dginit = Mcsrch.ddot_(size, g, 0, s, startOffset);
            if (this.dginit >= 0.0) {
                return;
            }
            this.brackt = false;
            this.stage1 = true;
            nfev[0] = 0;
            this.finit = f;
            this.dgtest = 1.0E-4 * this.dginit;
            this.width = 1.0E20;
            this.width1 = this.width / p5;
            for (int j = 0; j < size; ++j) {
                wa[j] = x[j];
            }
            this.stx = 0.0;
            this.fx = this.finit;
            this.dgx = this.dginit;
            this.sty = 0.0;
            this.fy = this.finit;
            this.dgy = this.dginit;
        }
        boolean firstLoop = true;
        while (true) {
            if (!firstLoop || firstLoop && info[0] != -1) {
                if (this.brackt) {
                    this.stmin = Math.min(this.stx, this.sty);
                    this.stmax = Math.max(this.stx, this.sty);
                } else {
                    this.stmin = this.stx;
                    this.stmax = stp[0] + xtrapf * (stp[0] - this.stx);
                }
                stp[0] = Math.max(stp[0], 1.0E-20);
                stp[0] = Math.min(stp[0], 1.0E20);
                if (this.brackt && (stp[0] <= this.stmin || stp[0] >= this.stmax || nfev[0] >= maxfev - 1 || this.infoc == 0) || this.brackt && this.stmax - this.stmin <= 1.0E-16 * this.stmax) {
                    stp[0] = this.stx;
                }
                for (int j = 0; j < size; ++j) {
                    x[j] = wa[j] + stp[0] * s[startOffset + j];
                }
                info[0] = -1;
                return;
            }
            info[0] = 0;
            nfev[0] = nfev[0] + 1;
            double dg = Mcsrch.ddot_(size, g, 0, s, startOffset);
            double ftest1 = this.finit + stp[0] * this.dgtest;
            if (this.brackt && (stp[0] <= this.stmin || stp[0] >= this.stmax || this.infoc == 0)) {
                info[0] = 6;
            }
            if (stp[0] == 1.0E20 && f <= ftest1 && dg <= this.dgtest) {
                info[0] = 5;
            }
            if (stp[0] == 1.0E-20 && (f > ftest1 || dg >= this.dgtest)) {
                info[0] = 4;
            }
            if (nfev[0] >= maxfev) {
                info[0] = 3;
            }
            if (this.brackt && this.stmax - this.stmin <= 1.0E-16 * this.stmax) {
                info[0] = 2;
            }
            if (f <= ftest1 && Math.abs(dg) <= 0.9 * -this.dginit) {
                info[0] = 1;
            }
            if (info[0] != 0) {
                return;
            }
            if (this.stage1 && f <= ftest1 && dg >= Math.min(1.0E-4, 0.9) * this.dginit) {
                this.stage1 = false;
            }
            if (this.stage1 && f <= this.fx && f > ftest1) {
                double fm = f - stp[0] * this.dgtest;
                double fxm = this.fx - this.stx * this.dgtest;
                double fym = this.fy - this.sty * this.dgtest;
                double dgm = dg - this.dgtest;
                double dgxm = this.dgx - this.dgtest;
                double dgym = this.dgy - this.dgtest;
                double[] stxArr = new double[]{this.stx};
                double[] fxmArr = new double[]{fxm};
                double[] dgxmArr = new double[]{dgxm};
                double[] styArr = new double[]{this.sty};
                double[] fymArr = new double[]{fym};
                double[] dgymArr = new double[]{dgym};
                boolean[] bracktArr = new boolean[]{this.brackt};
                int[] infocArr = new int[]{this.infoc};
                Mcsrch.mcstep(stxArr, fxmArr, dgxmArr, styArr, fymArr, dgymArr, stp, fm, dgm, bracktArr, this.stmin, this.stmax, infocArr);
                this.stx = stxArr[0];
                fxm = fxmArr[0];
                dgxm = dgxmArr[0];
                this.sty = styArr[0];
                fym = fymArr[0];
                dgym = dgymArr[0];
                this.brackt = bracktArr[0];
                this.infoc = infocArr[0];
                this.fx = fxm + this.stx * this.dgtest;
                this.fy = fym + this.sty * this.dgtest;
                this.dgx = dgxm + this.dgtest;
                this.dgy = dgym + this.dgtest;
            } else {
                double[] stxArr = new double[]{this.stx};
                double[] fxArr = new double[]{this.fx};
                double[] dgxArr = new double[]{this.dgx};
                double[] styArr = new double[]{this.sty};
                double[] fyArr = new double[]{this.fy};
                double[] dgyArr = new double[]{this.dgy};
                boolean[] bracktArr = new boolean[]{this.brackt};
                int[] infocArr = new int[]{this.infoc};
                Mcsrch.mcstep(stxArr, fxArr, dgxArr, styArr, fyArr, dgyArr, stp, f, dg, bracktArr, this.stmin, this.stmax, infocArr);
                this.stx = stxArr[0];
                this.fx = fxArr[0];
                this.dgx = dgxArr[0];
                this.sty = styArr[0];
                this.fy = fyArr[0];
                this.dgy = dgyArr[0];
                this.brackt = bracktArr[0];
                this.infoc = infocArr[0];
            }
            if (this.brackt) {
                double d1 = this.sty - this.stx;
                if (Math.abs(d1) >= p66 * this.width1) {
                    stp[0] = this.stx + p5 * (this.sty - this.stx);
                }
                this.width1 = this.width;
                d1 = this.sty - this.stx;
                this.width = Math.abs(d1);
            }
            firstLoop = false;
        }
    }
}

