/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene49;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.UndeadNormsProducer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.BlockPackedReader;
import org.apache.lucene.util.packed.PackedInts;

@Deprecated
final class Lucene49NormsProducer
extends NormsProducer {
    static final byte DELTA_COMPRESSED = 0;
    static final byte TABLE_COMPRESSED = 1;
    static final byte CONST_COMPRESSED = 2;
    static final byte UNCOMPRESSED = 3;
    static final int BLOCK_SIZE = 16384;
    private final Map<String, NormsEntry> norms;
    private final IndexInput data;
    final Map<String, NumericDocValues> instances;
    final Map<String, Accountable> instancesInfo;
    private final int maxDoc;
    private final AtomicLong ramBytesUsed;
    private final AtomicInteger activeCount;
    private final boolean merging;

    Lucene49NormsProducer(Lucene49NormsProducer original) {
        this.norms = new HashMap<String, NormsEntry>();
        this.instances = new HashMap<String, NumericDocValues>();
        this.instancesInfo = new HashMap<String, Accountable>();
        this.activeCount = new AtomicInteger();
        assert (Thread.holdsLock((Object)original));
        this.norms.putAll(original.norms);
        this.data = original.data.clone();
        this.instances.putAll(original.instances);
        this.instancesInfo.putAll(original.instancesInfo);
        this.maxDoc = original.maxDoc;
        this.ramBytesUsed = new AtomicLong(original.ramBytesUsed.get());
        this.activeCount.set(original.activeCount.get());
        this.merging = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene49NormsProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        int version;
        block20: {
            this.norms = new HashMap<String, NormsEntry>();
            this.instances = new HashMap<String, NumericDocValues>();
            this.instancesInfo = new HashMap<String, Accountable>();
            this.activeCount = new AtomicInteger();
            this.maxDoc = state.segmentInfo.maxDoc();
            this.merging = false;
            String metaName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)metaExtension);
            this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOfInstance(((Object)((Object)this)).getClass()));
            version = -1;
            try (ChecksumIndexInput in = state.directory.openChecksumInput(metaName, state.context);){
                Throwable priorE = null;
                try {
                    version = CodecUtil.checkHeader((DataInput)in, (String)metaCodec, (int)0, (int)0);
                    this.readFields((IndexInput)in, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block20;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter((ChecksumIndexInput)in, (Throwable)priorE);
                    }
                }
                CodecUtil.checkFooter((ChecksumIndexInput)in, (Throwable)priorE);
            }
        }
        String dataName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        boolean success = false;
        try {
            int version2 = CodecUtil.checkHeader((DataInput)this.data, (String)dataCodec, (int)0, (int)0);
            if (version != version2) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + version + ",data=" + version2, (DataInput)this.data);
            }
            CodecUtil.retrieveChecksum((IndexInput)this.data);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data});
            throw throwable;
        }
    }

    private void readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, (DataInput)meta);
            }
            if (!info.hasNorms()) {
                throw new CorruptIndexException("Invalid field: " + info.name, (DataInput)meta);
            }
            NormsEntry entry = new NormsEntry();
            entry.format = meta.readByte();
            entry.offset = meta.readLong();
            switch (entry.format) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new CorruptIndexException("Unknown format: " + entry.format, (DataInput)meta);
                }
            }
            this.norms.put(info.name, entry);
            fieldNumber = meta.readVInt();
        }
    }

    public synchronized NumericDocValues getNorms(FieldInfo field) throws IOException {
        if (UndeadNormsProducer.isUndead(field)) {
            return DocValues.emptyNumeric();
        }
        NumericDocValues instance = this.instances.get(field.name);
        if (instance == null) {
            instance = this.loadNorms(field);
            if (!this.merging) {
                this.instances.put(field.name, instance);
                this.activeCount.incrementAndGet();
            }
        }
        return instance;
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed.get();
    }

    public synchronized Collection<Accountable> getChildResources() {
        return Accountables.namedAccountables((String)"field", this.instancesInfo);
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.data);
    }

    private NumericDocValues loadNorms(FieldInfo field) throws IOException {
        NormsEntry entry = this.norms.get(field.name);
        switch (entry.format) {
            case 2: {
                if (!this.merging) {
                    this.instancesInfo.put(field.name, Accountables.namedAccountable((String)"constant", (long)8L));
                    this.ramBytesUsed.addAndGet(8L);
                }
                final long v = entry.offset;
                return new NumericDocValues(){

                    public long get(int docID) {
                        return v;
                    }
                };
            }
            case 3: {
                this.data.seek(entry.offset);
                final byte[] bytes = new byte[this.maxDoc];
                this.data.readBytes(bytes, 0, bytes.length);
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf((byte[])bytes));
                    this.instancesInfo.put(field.name, Accountables.namedAccountable((String)"byte array", (long)this.maxDoc));
                }
                return new NumericDocValues(){

                    public long get(int docID) {
                        return bytes[docID];
                    }
                };
            }
            case 0: {
                this.data.seek(entry.offset);
                int packedIntsVersion = this.data.readVInt();
                int blockSize = this.data.readVInt();
                BlockPackedReader reader = new BlockPackedReader(this.data, packedIntsVersion, blockSize, (long)this.maxDoc, false);
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(reader.ramBytesUsed());
                    this.instancesInfo.put(field.name, Accountables.namedAccountable((String)"delta compressed", (Accountable)reader));
                }
                return reader;
            }
            case 1: {
                this.data.seek(entry.offset);
                int packedVersion = this.data.readVInt();
                int size = this.data.readVInt();
                if (size > 256) {
                    throw new CorruptIndexException("TABLE_COMPRESSED cannot have more than 256 distinct values, got=" + size, (DataInput)this.data);
                }
                final long[] decode = new long[size];
                for (int i = 0; i < decode.length; ++i) {
                    decode[i] = this.data.readLong();
                }
                int formatID = this.data.readVInt();
                int bitsPerValue = this.data.readVInt();
                final PackedInts.Reader ordsReader = PackedInts.getReaderNoHeader((DataInput)this.data, (PackedInts.Format)PackedInts.Format.byId((int)formatID), (int)packedVersion, (int)this.maxDoc, (int)bitsPerValue);
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf((long[])decode) + ordsReader.ramBytesUsed());
                    this.instancesInfo.put(field.name, Accountables.namedAccountable((String)"table compressed", (Accountable)ordsReader));
                }
                return new NumericDocValues(){

                    public long get(int docID) {
                        return decode[(int)ordsReader.get(docID)];
                    }
                };
            }
        }
        throw new AssertionError();
    }

    public void close() throws IOException {
        this.data.close();
    }

    public synchronized NormsProducer getMergeInstance() throws IOException {
        return new Lucene49NormsProducer(this);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(fields=" + this.norms.size() + ",active=" + this.activeCount.get() + ")";
    }

    static class NormsEntry {
        byte format;
        long offset;

        NormsEntry() {
        }
    }
}

