/* FPrintUtils.c generated by valac 0.56.0, the Vala compiler
 * generated from FPrintUtils.vala, do not modify */

/*
 * Copyright 2018 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authors: Corentin Noël <corentin@elementary.io>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_SWIPE,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_SWIPE_AGAIN,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_SWIPE_TOO_SHORT,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_NOT_CENTERED,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_REMOVE,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_PLACE,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_PLACE_AGAIN,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_NO_MATCH,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_TIMEOUT,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_ERROR,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FAILED,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_OTHER
} GreeterFPrintUtilsMessageText;

#define GREETER_FPRINT_UTILS_TYPE_MESSAGE_TEXT (greeter_fprint_utils_message_text_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

VALA_EXTERN GType greeter_fprint_utils_message_text_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* greeter_fprint_utils_fprintd_message (const gchar* message);
VALA_EXTERN GreeterFPrintUtilsMessageText greeter_fprint_utils_string_to_messagetext (const gchar* text);
VALA_EXTERN gboolean greeter_fprint_utils_check_fprintd_string (const gchar* text,
                                                    const gchar* action,
                                                    const gchar* position);

static GType
greeter_fprint_utils_message_text_get_type_once (void)
{
	static const GEnumValue values[] = {{GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_SWIPE, "GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_SWIPE", "fprint-swipe"}, {GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_SWIPE_AGAIN, "GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_SWIPE_AGAIN", "fprint-swipe-again"}, {GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_SWIPE_TOO_SHORT, "GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_SWIPE_TOO_SHORT", "fprint-swipe-too-short"}, {GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_NOT_CENTERED, "GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_NOT_CENTERED", "fprint-not-centered"}, {GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_REMOVE, "GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_REMOVE", "fprint-remove"}, {GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_PLACE, "GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_PLACE", "fprint-place"}, {GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_PLACE_AGAIN, "GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_PLACE_AGAIN", "fprint-place-again"}, {GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_NO_MATCH, "GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_NO_MATCH", "fprint-no-match"}, {GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_TIMEOUT, "GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_TIMEOUT", "fprint-timeout"}, {GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_ERROR, "GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_ERROR", "fprint-error"}, {GREETER_FPRINT_UTILS_MESSAGE_TEXT_FAILED, "GREETER_FPRINT_UTILS_MESSAGE_TEXT_FAILED", "failed"}, {GREETER_FPRINT_UTILS_MESSAGE_TEXT_OTHER, "GREETER_FPRINT_UTILS_MESSAGE_TEXT_OTHER", "other"}, {0, NULL, NULL}};
	GType greeter_fprint_utils_message_text_type_id;
	greeter_fprint_utils_message_text_type_id = g_enum_register_static ("GreeterFPrintUtilsMessageText", values);
	return greeter_fprint_utils_message_text_type_id;
}

GType
greeter_fprint_utils_message_text_get_type (void)
{
	static volatile gsize greeter_fprint_utils_message_text_type_id__once = 0;
	if (g_once_init_enter (&greeter_fprint_utils_message_text_type_id__once)) {
		GType greeter_fprint_utils_message_text_type_id;
		greeter_fprint_utils_message_text_type_id = greeter_fprint_utils_message_text_get_type_once ();
		g_once_init_leave (&greeter_fprint_utils_message_text_type_id__once, greeter_fprint_utils_message_text_type_id);
	}
	return greeter_fprint_utils_message_text_type_id__once;
}

inline gchar*
greeter_fprint_utils_fprintd_message (const gchar* message)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (message != NULL, NULL);
	_tmp0_ = g_strdup (message);
	result = _tmp0_;
	return result;
}

GreeterFPrintUtilsMessageText
greeter_fprint_utils_string_to_messagetext (const gchar* text)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	GreeterFPrintUtilsMessageText result;
	g_return_val_if_fail (text != NULL, 0);
	_tmp0_ = greeter_fprint_utils_fprintd_message ("An unknown error occured");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (text, _tmp1_) == 0;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		result = GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_ERROR;
		return result;
	} else {
		gchar* _tmp3_;
		gchar* _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = greeter_fprint_utils_fprintd_message ("An unknown error occurred");
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strcmp0 (text, _tmp4_) == 0;
		_g_free0 (_tmp4_);
		if (_tmp5_) {
			result = GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_ERROR;
			return result;
		} else {
			if (greeter_fprint_utils_check_fprintd_string (text, "Swipe", "across")) {
				result = GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_SWIPE;
				return result;
			} else {
				gchar* _tmp6_;
				gchar* _tmp7_;
				gboolean _tmp8_;
				_tmp6_ = greeter_fprint_utils_fprintd_message ("Swipe your finger again");
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strcmp0 (text, _tmp7_) == 0;
				_g_free0 (_tmp7_);
				if (_tmp8_) {
					result = GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_SWIPE_AGAIN;
					return result;
				} else {
					gchar* _tmp9_;
					gchar* _tmp10_;
					gboolean _tmp11_;
					_tmp9_ = greeter_fprint_utils_fprintd_message ("Swipe was too short, try again");
					_tmp10_ = _tmp9_;
					_tmp11_ = g_strcmp0 (text, _tmp10_) == 0;
					_g_free0 (_tmp10_);
					if (_tmp11_) {
						result = GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_SWIPE_TOO_SHORT;
						return result;
					} else {
						gchar* _tmp12_;
						gchar* _tmp13_;
						gboolean _tmp14_;
						_tmp12_ = greeter_fprint_utils_fprintd_message ("Your finger was not centered, try swiping your finger again");
						_tmp13_ = _tmp12_;
						_tmp14_ = g_strcmp0 (text, _tmp13_) == 0;
						_g_free0 (_tmp13_);
						if (_tmp14_) {
							result = GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_NOT_CENTERED;
							return result;
						} else {
							gchar* _tmp15_;
							gchar* _tmp16_;
							gboolean _tmp17_;
							_tmp15_ = greeter_fprint_utils_fprintd_message ("Remove your finger, and try swiping your finger again");
							_tmp16_ = _tmp15_;
							_tmp17_ = g_strcmp0 (text, _tmp16_) == 0;
							_g_free0 (_tmp16_);
							if (_tmp17_) {
								result = GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_REMOVE;
								return result;
							} else {
								if (greeter_fprint_utils_check_fprintd_string (text, "Place", "on")) {
									result = GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_PLACE;
									return result;
								} else {
									gchar* _tmp18_;
									gchar* _tmp19_;
									gboolean _tmp20_;
									_tmp18_ = greeter_fprint_utils_fprintd_message ("Place your finger on the reader again");
									_tmp19_ = _tmp18_;
									_tmp20_ = g_strcmp0 (text, _tmp19_) == 0;
									_g_free0 (_tmp19_);
									if (_tmp20_) {
										result = GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_PLACE_AGAIN;
										return result;
									} else {
										gchar* _tmp21_;
										gchar* _tmp22_;
										gboolean _tmp23_;
										_tmp21_ = greeter_fprint_utils_fprintd_message ("Failed to match fingerprint");
										_tmp22_ = _tmp21_;
										_tmp23_ = g_strcmp0 (text, _tmp22_) == 0;
										_g_free0 (_tmp22_);
										if (_tmp23_) {
											result = GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_NO_MATCH;
											return result;
										} else {
											gchar* _tmp24_;
											gchar* _tmp25_;
											gboolean _tmp26_;
											_tmp24_ = greeter_fprint_utils_fprintd_message ("Verification timed out");
											_tmp25_ = _tmp24_;
											_tmp26_ = g_strcmp0 (text, _tmp25_) == 0;
											_g_free0 (_tmp25_);
											if (_tmp26_) {
												result = GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_TIMEOUT;
												return result;
											} else {
												if (g_strcmp0 (text, "Login failed") == 0) {
													result = GREETER_FPRINT_UTILS_MESSAGE_TEXT_FAILED;
													return result;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = GREETER_FPRINT_UTILS_MESSAGE_TEXT_OTHER;
	return result;
}

gboolean
greeter_fprint_utils_check_fprintd_string (const gchar* text,
                                           const gchar* action,
                                           const gchar* position)
{
	static const gchar* FINGERS[11] = {"finger", "left thumb", "left index finger", "left middle finger", "left ring finger", "left little finger", "right thumb", "right index finger", "right middle finger", "right ring finger", "right little finger"};
	gboolean result;
	g_return_val_if_fail (text != NULL, FALSE);
	g_return_val_if_fail (action != NULL, FALSE);
	g_return_val_if_fail (position != NULL, FALSE);
	{
		const gchar** finger_collection = NULL;
		gint finger_collection_length1 = 0;
		gint _finger_collection_size_ = 0;
		gint finger_it = 0;
		finger_collection = FINGERS;
		finger_collection_length1 = G_N_ELEMENTS (FINGERS);
		for (finger_it = 0; finger_it < finger_collection_length1; finger_it = finger_it + 1) {
			const gchar* finger = NULL;
			finger = finger_collection[finger_it];
			{
				gchar* english_string = NULL;
				const gchar* _tmp0_;
				gchar* _tmp1_;
				gboolean _tmp2_ = FALSE;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gboolean _tmp6_;
				_tmp0_ = finger;
				_tmp1_ = g_strconcat (action, " your ", _tmp0_, " ", position, " %s", NULL);
				english_string = _tmp1_;
				_tmp3_ = english_string;
				_tmp4_ = greeter_fprint_utils_fprintd_message (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_str_has_prefix (text, _tmp5_);
				_g_free0 (_tmp5_);
				if (_tmp6_) {
					_tmp2_ = TRUE;
				} else {
					const gchar* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp7_ = english_string;
					_tmp8_ = g_strdup_printf (_tmp7_, "the fingerprint reader");
					_tmp9_ = _tmp8_;
					_tmp10_ = greeter_fprint_utils_fprintd_message (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp2_ = g_str_has_prefix (text, _tmp11_);
					_g_free0 (_tmp11_);
					_g_free0 (_tmp9_);
				}
				if (_tmp2_) {
					result = TRUE;
					_g_free0 (english_string);
					return result;
				}
				_g_free0 (english_string);
			}
		}
	}
	result = FALSE;
	return result;
}

