package Lire::Config::CommandSpec;

use strict;

=pod

=head1 Lire::Config::CommandSpec

Type that represents a UNIX command or program.
A path lookup is done to canonicalize it, if appropriate.

=cut

use base qw/Lire::Config::ScalarSpec/;

use File::Spec;

sub is_valid {
    my ( $self, $val ) = @_;

    return !$self->required() unless defined $val;

    my $file = $self->normalize( $val );

    return ( defined $file && -x $file );
}

sub normalize {
    my ( $self, $val ) = @_;

    return undef unless defined $val;

    return File::Spec->canonpath($val)
        if index($val, '/') >= 0;

    foreach (split(':', $ENV{'PATH'})) {
        $_ = '.' if $_ eq '';
        my $p = File::Spec->canonpath("$_/$val");
        return $p if -x $p && -f _;
    }
    return undef;
}

1;
__END__

=pod

=head1 VERSION

$Id: CommandSpec.pm,v 1.4 2006/07/23 13:16:30 vanbaal Exp $

=head1 AUTHORS

Francis J. Lacoste <flacoste@logreport.org>
Wessel Dankers <wsl@logreport.org>
Wolfgang Sourdeau <wolfgang@logreport.org>

=head1 COPYRIGHT

Copyright (C) 2002-2004  Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html.

=cut
