/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.javafx;

import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;

public class TextInputControlMatcherEditor<E>
extends TextMatcherEditor<E> {
    private final TextInputControl textControl;
    private boolean live;
    private final FilterHandler filterHandler = new FilterHandler();

    public TextInputControlMatcherEditor(TextInputControl textControl, TextFilterator<? super E> textFilterator) {
        this(textControl, textFilterator, true);
    }

    public TextInputControlMatcherEditor(TextInputControl textControl, TextFilterator<? super E> textFilterator, boolean live) {
        super(textFilterator);
        if (textControl == null) {
            throw new IllegalArgumentException("TextInputControl is undefined");
        }
        this.textControl = textControl;
        this.live = live;
        this.registerListeners(live);
        this.refilter();
    }

    public boolean isLive() {
        return this.live;
    }

    public void setLive(boolean live) {
        if (live == this.live) {
            return;
        }
        this.deregisterListeners(this.live);
        this.live = live;
        this.registerListeners(this.live);
    }

    private void registerListeners(boolean live) {
        if (live) {
            this.textControl.textProperty().addListener(this.filterHandler);
        } else {
            if (!(this.textControl instanceof TextField)) {
                throw new IllegalArgumentException("Non-live filtering supported only for TextField (argument class " + this.textControl.getClass().getName() + ")");
            }
            TextField textField = (TextField)this.textControl;
            textField.onActionProperty().set(this.filterHandler);
        }
    }

    private void deregisterListeners(boolean live) {
        if (live) {
            this.textControl.textProperty().removeListener(this.filterHandler);
        } else {
            TextField textField = (TextField)this.textControl;
            textField.onActionProperty().set(null);
        }
    }

    public TextInputControl getTextControl() {
        return this.textControl;
    }

    public void dispose() {
        this.deregisterListeners(this.live);
    }

    private void refilter() {
        String[] filters;
        int mode = this.getMode();
        String text = this.textControl.getText();
        if (mode == 0) {
            filters = text.split("[ \t]");
        } else if (mode == 1 || mode == 2 || mode == 3) {
            filters = new String[]{text};
        } else {
            throw new IllegalStateException("Unknown mode: " + mode);
        }
        this.setFilterText(filters);
    }

    private class FilterHandler
    implements ChangeListener<String>,
    EventHandler<ActionEvent> {
        private FilterHandler() {
        }

        @Override
        public void changed(ObservableValue<? extends String> paramObservableValue, String paramT1, String paramT2) {
            TextInputControlMatcherEditor.this.refilter();
        }

        @Override
        public void handle(ActionEvent paramT) {
            TextInputControlMatcherEditor.this.refilter();
        }
    }
}

