/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;

public class TextCopyPasteHandler<T extends JTextComponent> {
    private final T textComponent;
    private final Action cutAction;
    private final Action copyAction;
    private final Action pasteAction;
    private final Action undoAction;
    private final Action selectAllAction;
    private final JPopupMenu popup = new JPopupMenu();
    private String savedString = "";
    private Actions lastActionSelected;

    public TextCopyPasteHandler(T component) {
        this.textComponent = component;
        this.undoAction = new AbstractAction("Widerrufen"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ((JTextComponent)TextCopyPasteHandler.this.textComponent).setText("");
                ((JTextComponent)TextCopyPasteHandler.this.textComponent).replaceSelection(TextCopyPasteHandler.this.savedString);
                TextCopyPasteHandler.this.lastActionSelected = Actions.UNDO;
            }
        };
        this.popup.add(this.undoAction);
        this.popup.addSeparator();
        this.cutAction = new AbstractAction("Ausschneiden"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TextCopyPasteHandler.this.lastActionSelected = Actions.CUT;
                TextCopyPasteHandler.this.savedString = ((JTextComponent)TextCopyPasteHandler.this.textComponent).getText();
                ((JTextComponent)TextCopyPasteHandler.this.textComponent).cut();
            }
        };
        this.popup.add(this.cutAction);
        this.copyAction = new AbstractAction("Kopieren"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TextCopyPasteHandler.this.lastActionSelected = Actions.COPY;
                ((JTextComponent)TextCopyPasteHandler.this.textComponent).copy();
            }
        };
        this.popup.add(this.copyAction);
        this.pasteAction = new AbstractAction("Einf\u00fcgen"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TextCopyPasteHandler.this.lastActionSelected = Actions.PASTE;
                TextCopyPasteHandler.this.savedString = ((JTextComponent)TextCopyPasteHandler.this.textComponent).getText();
                ((JTextComponent)TextCopyPasteHandler.this.textComponent).paste();
            }
        };
        this.popup.add(this.pasteAction);
        this.popup.addSeparator();
        this.selectAllAction = new AbstractAction("Alles markieren"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TextCopyPasteHandler.this.lastActionSelected = Actions.SELECT_ALL;
                ((JTextComponent)TextCopyPasteHandler.this.textComponent).selectAll();
            }
        };
        this.popup.add(this.selectAllAction);
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                boolean enabled = ((Component)TextCopyPasteHandler.this.textComponent).isEnabled();
                boolean editable = ((JTextComponent)TextCopyPasteHandler.this.textComponent).isEditable();
                boolean nonempty = ((JTextComponent)TextCopyPasteHandler.this.textComponent).getText() != null && !((JTextComponent)TextCopyPasteHandler.this.textComponent).getText().isEmpty();
                boolean marked = ((JTextComponent)TextCopyPasteHandler.this.textComponent).getSelectedText() != null;
                boolean pasteAvailable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).isDataFlavorSupported(DataFlavor.stringFlavor);
                ((JComponent)TextCopyPasteHandler.this.textComponent).requestFocus();
                TextCopyPasteHandler.this.undoAction.setEnabled(enabled && editable && (TextCopyPasteHandler.this.lastActionSelected == Actions.CUT || TextCopyPasteHandler.this.lastActionSelected == Actions.PASTE));
                TextCopyPasteHandler.this.cutAction.setEnabled(enabled && editable && marked);
                TextCopyPasteHandler.this.copyAction.setEnabled(enabled && marked);
                TextCopyPasteHandler.this.pasteAction.setEnabled(enabled && editable && pasteAvailable);
                TextCopyPasteHandler.this.selectAllAction.setEnabled(enabled && nonempty);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    public JPopupMenu getPopupMenu() {
        return this.popup;
    }

    private static enum Actions {
        UNDO,
        CUT,
        COPY,
        PASTE,
        SELECT_ALL;

    }
}

