export declare const supportedVersionTargets: string[];
export declare const doctorHelpText = "Usage: ncu --doctor [-u] [options]\n\nIteratively installs upgrades and runs tests to identify breaking upgrades. Add \"-u\" to execute (modifies your package file, lock file, and node_modules).\n\nTo be more precise:\n1. Runs \"npm install\" and \"npm test\" to ensure tests are currently passing.\n2. Runs \"ncu -u\" to optimistically upgrade all dependencies.\n3. If tests pass, hurray!\n4. If tests fail, restores package file and lock file.\n5. For each dependency, install upgrade and run tests.\n6. Prints broken upgrades with test error.\n7. Saves working upgrades to package.json.\n\nExample:\n\n$ ncu --doctor -u\nRunning tests before upgrading\nnpm install\nnpm run test\nUpgrading all dependencies and re-running tests\nncu -u\nnpm install\nnpm run test\nTests failed\nIdentifying broken dependencies\nnpm install\nnpm install --no-save react@16.0.0\nnpm run test\n  \u2713 react 15.0.0 \u2192 16.0.0\nnpm install --no-save react-redux@7.0.0\nnpm run test\n  \u2717 react-redux 6.0.0 \u2192 7.0.0\n\n/projects/myproject/test.js:13\n  throw new Error('Test failed!')\n  ^\n\nnpm install --no-save react-dnd@11.1.3\nnpm run test\n  \u2713 react-dnd 10.0.0 \u2192 11.1.3\nSaving partially upgraded package.json\n";
export declare const deepPatternPrefix = "**/";
