/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.processors;

import io.swagger.models.Model;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.RefParameter;
import io.swagger.parser.ResolverCache;
import io.swagger.parser.processors.ModelProcessor;
import java.util.ArrayList;
import java.util.List;

public class ParameterProcessor {
    private final ResolverCache cache;
    private final ModelProcessor modelProcessor;

    public ParameterProcessor(ResolverCache cache, Swagger swagger) {
        this.cache = cache;
        this.modelProcessor = new ModelProcessor(cache, swagger);
    }

    public List<Parameter> processParameters(List<Parameter> parameters) {
        if (parameters == null) {
            return null;
        }
        ArrayList<Parameter> processedPathLevelParameters = new ArrayList<Parameter>();
        ArrayList<Parameter> refParameters = new ArrayList<Parameter>();
        for (Parameter parameter : parameters) {
            if (parameter instanceof RefParameter) {
                RefParameter refParameter = (RefParameter)parameter;
                Parameter resolvedParameter = this.cache.loadRef(refParameter.get$ref(), refParameter.getRefFormat(), Parameter.class);
                if (resolvedParameter == null) {
                    processedPathLevelParameters.add(refParameter);
                    continue;
                }
                boolean matched = false;
                for (Parameter param : processedPathLevelParameters) {
                    if (param.getName() == null || !param.getName().equals(resolvedParameter.getName())) continue;
                    matched = true;
                    break;
                }
                for (Parameter param : parameters) {
                    if (param.getName() == null || !param.getName().equals(resolvedParameter.getName())) continue;
                    matched = true;
                    break;
                }
                if (resolvedParameter instanceof BodyParameter) {
                    BodyParameter bodyParameter = (BodyParameter)resolvedParameter;
                    Model schema = bodyParameter.getSchema();
                    this.modelProcessor.processModel(schema);
                }
                if (matched) {
                    refParameters.add(resolvedParameter);
                    continue;
                }
                processedPathLevelParameters.add(resolvedParameter);
                continue;
            }
            if (parameter instanceof BodyParameter) {
                BodyParameter bodyParameter = (BodyParameter)parameter;
                Model schema = bodyParameter.getSchema();
                this.modelProcessor.processModel(schema);
            }
            processedPathLevelParameters.add(parameter);
        }
        block3: for (Parameter resolvedParameter : refParameters) {
            int pos = 0;
            for (Parameter param : processedPathLevelParameters) {
                if (param.getName().equals(resolvedParameter.getName())) {
                    processedPathLevelParameters.set(pos, resolvedParameter);
                    continue block3;
                }
                ++pos;
            }
        }
        return processedPathLevelParameters;
    }
}

