/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.compare;

import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import java.util.LinkedHashMap;
import java.util.List;
import org.openapitools.openapidiff.core.compare.MapKeyDiff;
import org.openapitools.openapidiff.core.compare.OpenApiDiff;
import org.openapitools.openapidiff.core.model.ChangedContent;
import org.openapitools.openapidiff.core.model.ChangedMediaType;
import org.openapitools.openapidiff.core.model.ChangedSchema;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.deferred.DeferredBuilder;
import org.openapitools.openapidiff.core.model.deferred.DeferredChanged;
import org.openapitools.openapidiff.core.utils.ChangedUtils;

public class ContentDiff {
    private final OpenApiDiff openApiDiff;

    public ContentDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
    }

    public DeferredChanged<ChangedContent> diff(Content left, Content right, DiffContext context) {
        DeferredBuilder builder = new DeferredBuilder();
        MapKeyDiff<String, MediaType> mediaTypeDiff = MapKeyDiff.diff(left, right);
        List<String> sharedMediaTypes = mediaTypeDiff.getSharedKey();
        LinkedHashMap changedMediaTypes = new LinkedHashMap();
        sharedMediaTypes.stream().forEach(mediaTypeKey -> {
            MediaType oldMediaType = (MediaType)left.get(mediaTypeKey);
            MediaType newMediaType = (MediaType)right.get(mediaTypeKey);
            ChangedMediaType changedMediaType = new ChangedMediaType(oldMediaType.getSchema(), newMediaType.getSchema(), context);
            builder.with(this.openApiDiff.getSchemaDiff().diff(oldMediaType.getSchema(), newMediaType.getSchema(), context.copyWithRequired(true))).ifPresent(value -> {
                changedMediaType.setSchema((ChangedSchema)value);
                if (!ChangedUtils.isUnchanged(changedMediaType)) {
                    changedMediaTypes.put(mediaTypeKey, changedMediaType);
                }
            });
        });
        return builder.build().mapOptional(value -> ChangedUtils.isChanged(new ChangedContent(left, right, context).setIncreased(mediaTypeDiff.getIncreased()).setMissing(mediaTypeDiff.getMissing()).setChanged(changedMediaTypes)));
    }
}

