/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.buffer;

import org.apache.mina.core.buffer.IoBuffer;

class IoBufferHexDumper {
    private static final byte[] highDigits;
    private static final byte[] lowDigits;

    IoBufferHexDumper() {
    }

    public static String getHexdump(IoBuffer in, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length: " + length + " must be non-negative number");
        }
        int pos = in.position();
        int rem = in.limit() - pos;
        int items = Math.min(rem, length);
        if (items == 0) {
            return "";
        }
        int lim = pos + items;
        StringBuilder out = new StringBuilder(items * 3 + 6);
        int byteValue = in.get(pos++) & 0xFF;
        out.append((char)highDigits[byteValue]);
        out.append((char)lowDigits[byteValue]);
        while (pos < lim) {
            out.append(' ');
            byteValue = in.get(pos++) & 0xFF;
            out.append((char)highDigits[byteValue]);
            out.append((char)lowDigits[byteValue]);
        }
        if (items != rem) {
            out.append("...");
        }
        return out.toString();
    }

    static {
        byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        byte[] high = new byte[256];
        byte[] low = new byte[256];
        for (int i = 0; i < 256; ++i) {
            high[i] = digits[i >>> 4];
            low[i] = digits[i & 0xF];
        }
        highDigits = high;
        lowDigits = low;
    }
}

