/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.Collection;
import java.util.Set;
import net.sourceforge.plantuml.AlignmentParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FloatingNote;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UGraphicInterceptorUDrawable;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.UGraphicForSnake;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.utils.MathUtils;

public class FtileGroup
extends AbstractFtile {
    private final double diffYY2 = 20.0;
    private final Ftile inner;
    private final TextBlock name;
    private final TextBlock headerNote;
    private final HColor borderColor;
    private final HColor backColor;
    private final double shadowing;
    private final UStroke stroke;
    private final USymbol type;
    private final double roundCorner;
    private FtileGeometry cachedInnerDimension;

    public final StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.partition);
    }

    public FtileGroup(Ftile inner, Display title, Display displayNote, HColor arrowColor, HColor backColor, HColor titleColor, ISkinParam skinParam, HColor borderColor, USymbol type, double roundCorner) {
        super(inner.skinParam());
        this.roundCorner = roundCorner;
        this.type = type;
        this.inner = FtileUtils.addHorizontalMargin(inner, 10.0);
        Style style = this.getStyleSignature().getMergedStyle(skinParam.getCurrentStyleBuilder());
        FontConfiguration fc = style.getFontConfiguration(skinParam.getThemeStyle(), this.getIHtmlColorSet());
        this.shadowing = style.value(PName.Shadowing).asDouble();
        this.backColor = backColor == null ? style.value(PName.BackGroundColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet()) : backColor;
        this.borderColor = borderColor == null ? style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet()) : borderColor;
        UStroke thickness = style.getStroke();
        this.name = title == null ? TextBlockUtils.empty(0.0, 0.0) : title.create(fc, HorizontalAlignment.LEFT, skinParam);
        this.headerNote = Display.isNull(displayNote) ? TextBlockUtils.empty(0.0, 0.0) : new FloatingNote(displayNote, skinParam);
        this.stroke = thickness == null ? new UStroke(2.0) : thickness;
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return this.inner.getMyChildren();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.inner.getInLinkRendering();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.inner.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.inner.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.inner.getSwimlaneOut();
    }

    private double diffHeightTitle(StringBounder stringBounder) {
        Dimension2D dimTitle = this.name.calculateDimension(stringBounder);
        return Math.max(25.0, dimTitle.getHeight() + 20.0);
    }

    private UTranslate getTranslate(StringBounder stringBounder) {
        double suppWidth = this.suppWidth(stringBounder);
        return new UTranslate(suppWidth / 2.0, this.diffHeightTitle(stringBounder) + this.headerNoteHeight(stringBounder));
    }

    private MinMax getInnerMinMax(StringBounder stringBounder) {
        LimitFinder limitFinder = LimitFinder.create(stringBounder, false);
        UGraphicForSnake interceptor = new UGraphicForSnake(limitFinder);
        UGraphicInterceptorUDrawable interceptor2 = new UGraphicInterceptorUDrawable(interceptor);
        this.inner.drawU(interceptor2);
        interceptor2.flushUg();
        return limitFinder.getMinMax();
    }

    public double suppWidth(StringBounder stringBounder) {
        FtileGeometry orig = this.getInnerDimension(stringBounder);
        Dimension2D dimTitle = this.name.calculateDimension(stringBounder);
        Dimension2D dimHeaderNote = this.headerNote.calculateDimension(stringBounder);
        double suppWidth = MathUtils.max(orig.getWidth(), dimTitle.getWidth() + 20.0, dimHeaderNote.getWidth() + 20.0) - orig.getWidth();
        return suppWidth;
    }

    private FtileGeometry getInnerDimension(StringBounder stringBounder) {
        if (this.cachedInnerDimension == null) {
            this.cachedInnerDimension = this.getInnerDimensionSlow(stringBounder);
        }
        return this.cachedInnerDimension;
    }

    private FtileGeometry getInnerDimensionSlow(StringBounder stringBounder) {
        FtileGeometry orig = this.inner.calculateDimension(stringBounder);
        MinMax minMax = this.getInnerMinMax(stringBounder);
        double missingWidth = minMax.getMaxX() - orig.getWidth();
        if (missingWidth > 0.0) {
            return orig.addDim(missingWidth + 5.0, 0.0);
        }
        return orig;
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        FtileGeometry orig = this.getInnerDimension(stringBounder);
        double suppWidth = this.suppWidth(stringBounder);
        double width = orig.getWidth() + suppWidth;
        double height = orig.getHeight() + this.diffHeightTitle(stringBounder) + 20.0 + this.headerNoteHeight(stringBounder);
        double titleAndHeaderNoteHeight = this.diffHeightTitle(stringBounder) + this.headerNoteHeight(stringBounder);
        if (orig.hasPointOut()) {
            return new FtileGeometry(width, height, orig.getLeft() + suppWidth / 2.0, orig.getInY() + titleAndHeaderNoteHeight, orig.getOutY() + titleAndHeaderNoteHeight);
        }
        return new FtileGeometry(width, height, orig.getLeft() + suppWidth / 2.0, orig.getInY() + titleAndHeaderNoteHeight);
    }

    private double headerNoteHeight(StringBounder stringBounder) {
        return this.headerNote.calculateDimension(stringBounder).getHeight();
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        FtileGeometry dimTotal = this.calculateDimension(stringBounder);
        SymbolContext symbolContext = new SymbolContext(this.backColor, this.borderColor).withShadow(this.shadowing).withStroke(this.stroke).withCorner(this.roundCorner, 0.0);
        HorizontalAlignment align = this.inner.skinParam().getHorizontalAlignment(AlignmentParam.packageTitleAlignment, null, false, null);
        this.type.asBig(this.name, align, TextBlockUtils.empty(0.0, 0.0), ((Dimension2D)dimTotal).getWidth(), ((Dimension2D)dimTotal).getHeight(), symbolContext, this.skinParam().getStereotypeAlignment()).drawU(ug);
        Dimension2D dimHeaderNote = this.headerNote.calculateDimension(stringBounder);
        this.headerNote.drawU(ug.apply(new UTranslate(((Dimension2D)dimTotal).getWidth() - dimHeaderNote.getWidth() - 10.0, this.diffHeightTitle(ug.getStringBounder()) - 10.0)));
        ug.apply(this.getTranslate(stringBounder)).draw(this.inner);
    }
}

