/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.SkinParamColors;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.gtile.AbstractGtile;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorNone;

public class GtileBox
extends AbstractGtile {
    private final ClockwiseTopRightBottomLeft padding;
    private final ClockwiseTopRightBottomLeft margin;
    private final TextBlock tb;
    private double roundCorner = 25.0;
    private final double shadowing;
    private final HorizontalAlignment horizontalAlignment;
    private double minimumWidth = 0.0;
    private final LinkRendering inRendering;
    private final BoxStyle boxStyle;
    private final HColor borderColor;
    private final HColor backColor;
    private final Style style;
    private final String print;

    public static StyleSignatureBasic getDefaultStyleDefinitionActivity() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity);
    }

    public static StyleSignatureBasic getDefaultStyleDefinitionArrow() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    public final LinkRendering getInLinkRendering() {
        return this.inRendering;
    }

    public static GtileBox create(StringBounder stringBounder, ISkinParam skinParam, Display label, Swimlane swimlane, BoxStyle boxStyle, Stereotype stereotype) {
        Style style = GtileBox.getDefaultStyleDefinitionActivity().withTOBECHANGED(stereotype).getMergedStyle(skinParam.getCurrentStyleBuilder());
        Style styleArrow = GtileBox.getDefaultStyleDefinitionArrow().getMergedStyle(skinParam.getCurrentStyleBuilder());
        return new GtileBox(stringBounder, skinParam, label, swimlane, boxStyle, style, styleArrow);
    }

    private GtileBox(StringBounder stringBounder, ISkinParam skinParam, Display label, Swimlane swimlane, BoxStyle boxStyle, Style style, Style styleArrow) {
        super(stringBounder, skinParam, swimlane);
        Colors specBack = null;
        if (skinParam instanceof SkinParamColors) {
            specBack = ((SkinParamColors)skinParam).getColors();
        }
        this.style = style = style.eventuallyOverride(specBack);
        this.boxStyle = boxStyle;
        this.inRendering = LinkRendering.create(Rainbow.build(styleArrow, this.getIHtmlColorSet(), skinParam.getThemeStyle()));
        this.borderColor = style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet());
        this.backColor = style.value(PName.BackGroundColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet());
        FontConfiguration fc = style.getFontConfiguration(skinParam.getThemeStyle(), this.getIHtmlColorSet());
        this.horizontalAlignment = style.getHorizontalAlignment();
        this.padding = style.getPadding();
        this.margin = style.getMargin();
        this.roundCorner = style.value(PName.RoundCorner).asDouble();
        this.shadowing = style.value(PName.Shadowing).asDouble();
        LineBreakStrategy wrapWidth = style.wrapWidth();
        this.minimumWidth = style.value(PName.MinimumWidth).asDouble();
        Sheet sheet = Parser.build(fc, skinParam.getDefaultTextAlignment(this.horizontalAlignment), skinParam, CreoleMode.FULL).createSheet(label);
        this.tb = new SheetBlock2(new SheetBlock1(sheet, wrapWidth, skinParam.getPadding()), new MyStencil(), new UStroke(1.0));
        this.print = label.toString();
    }

    public String toString() {
        return this.print;
    }

    @Override
    protected void drawUInternal(UGraphic ug) {
        Dimension2D dimTotal = this.calculateDimension(ug.getStringBounder());
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        UDrawable shape = this.boxStyle.getUDrawable(widthTotal, heightTotal, this.shadowing, this.roundCorner);
        UStroke thickness = this.style.getStroke();
        ug = this.borderColor == null ? ug.apply(new HColorNone()) : ug.apply(this.borderColor);
        ug = this.backColor == null ? ug.apply(new HColorNone().bg()) : ug.apply(this.backColor.bg());
        ug = ug.apply(thickness);
        shape.drawU(ug);
        if (this.horizontalAlignment == HorizontalAlignment.LEFT) {
            this.tb.drawU(ug.apply(new UTranslate(this.padding.getLeft(), this.padding.getTop())));
        } else if (this.horizontalAlignment == HorizontalAlignment.RIGHT) {
            Dimension2D dimTb = this.tb.calculateDimension(ug.getStringBounder());
            this.tb.drawU(ug.apply(new UTranslate(dimTotal.getWidth() - dimTb.getWidth() - this.padding.getRight(), this.padding.getBottom())));
        } else if (this.horizontalAlignment == HorizontalAlignment.CENTER) {
            Dimension2D dimTb = this.tb.calculateDimension(ug.getStringBounder());
            this.tb.drawU(ug.apply(new UTranslate((dimTotal.getWidth() - dimTb.getWidth()) / 2.0, this.padding.getBottom())));
        }
    }

    @Override
    public final Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimRaw = this.tb.calculateDimension(stringBounder);
        dimRaw = Dimension2DDouble.delta(dimRaw, this.padding.getLeft() + this.padding.getRight(), this.padding.getBottom() + this.padding.getTop());
        dimRaw = Dimension2DDouble.atLeast(dimRaw, this.minimumWidth, 0.0);
        return new FtileGeometry(dimRaw.getWidth() + this.boxStyle.getShield(), dimRaw.getHeight(), dimRaw.getWidth() / 2.0, 0.0, dimRaw.getHeight());
    }

    class MyStencil
    implements Stencil {
        MyStencil() {
        }

        @Override
        public double getStartingX(StringBounder stringBounder, double y) {
            return -GtileBox.this.padding.getLeft();
        }

        @Override
        public double getEndingX(StringBounder stringBounder, double y) {
            Dimension2D dim = GtileBox.this.calculateDimension(stringBounder);
            return dim.getWidth() - GtileBox.this.padding.getRight();
        }
    }
}

