/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.EnumMap;
import java.util.Objects;
import net.sourceforge.plantuml.AlignmentParam;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.CornerParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.cucadiagram.BodyFactory;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekLine;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.UGroupType;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageNote
extends AbstractEntityImage
implements Stencil {
    private final HColor noteBackgroundColor;
    private final HColor borderColor;
    private final double shadowing;
    private final int marginX1 = 6;
    private final int marginX2 = 15;
    private final int marginY = 5;
    private final boolean withShadow;
    private final ISkinParam skinParam;
    private final Style style;
    private final TextBlock textBlock;
    private SvekLine opaleLine;
    private SvekNode node;
    private SvekNode other;

    public EntityImageNote(ILeaf entity, ISkinParam skinParam, UmlDiagramType umlDiagramType) {
        super(entity, EntityImageNote.getSkin(EntityImageNote.getISkinParam(skinParam, entity), entity));
        HorizontalAlignment horizontalAlignment;
        FontConfiguration fontConfiguration;
        this.skinParam = EntityImageNote.getISkinParam(skinParam, entity);
        this.withShadow = this.getSkinParam().shadowing(this.getEntity().getStereotype());
        Display strings = entity.getDisplay();
        Rose rose = new Rose();
        if (UseStyle.useBetaStyle()) {
            this.style = this.getDefaultStyleDefinition(umlDiagramType.getStyleName()).getMergedStyle(skinParam.getCurrentStyleBuilder());
            this.noteBackgroundColor = entity.getColors().getColor(ColorType.BACK) == null ? this.style.value(PName.BackGroundColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet()) : entity.getColors().getColor(ColorType.BACK);
            this.borderColor = this.style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
            this.shadowing = this.style.value(PName.Shadowing).asDouble();
            fontConfiguration = this.style.getFontConfiguration(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
            horizontalAlignment = this.style.getHorizontalAlignment();
        } else {
            this.style = null;
            this.shadowing = skinParam.shadowing(this.getEntity().getStereotype()) ? 4.0 : 0.0;
            this.noteBackgroundColor = entity.getColors().getColor(ColorType.BACK) == null ? rose.getHtmlColor(this.getSkinParam(), ColorParam.noteBackground) : entity.getColors().getColor(ColorType.BACK);
            this.borderColor = SkinParamUtils.getColor(this.getSkinParam(), null, ColorParam.noteBorder);
            fontConfiguration = FontConfiguration.create(this.getSkinParam(), FontParam.NOTE, null);
            horizontalAlignment = skinParam.getHorizontalAlignment(AlignmentParam.noteTextAlignment, null, false, null);
        }
        this.textBlock = strings.size() == 1 && strings.get(0).length() == 0 ? new TextBlockEmpty() : BodyFactory.create3(strings, FontParam.NOTE, this.getSkinParam(), horizontalAlignment, fontConfiguration, this.getSkinParam().wrapWidth(), this.style);
    }

    private static ISkinParam getISkinParam(ISkinParam skinParam, IEntity entity) {
        if (entity.getColors() != null) {
            return entity.getColors().mute(skinParam);
        }
        return skinParam;
    }

    static ISkinParam getSkin(ISkinParam skinParam, IEntity entity) {
        Stereotype stereotype = entity.getStereotype();
        HColor back = entity.getColors().getColor(ColorType.BACK);
        if (back != null) {
            return new SkinParamBackcolored(skinParam, back);
        }
        back = EntityImageNote.getColorStatic(skinParam, ColorParam.noteBackground, stereotype);
        if (back != null) {
            return new SkinParamBackcolored(skinParam, back);
        }
        return skinParam;
    }

    private static HColor getColorStatic(ISkinParam skinParam, ColorParam colorParam, Stereotype stereo) {
        Rose rose = new Rose();
        return rose.getHtmlColor(skinParam, stereo, colorParam);
    }

    public final double getPreferredWidth(StringBounder stringBounder) {
        double result = this.getTextWidth(stringBounder);
        return result;
    }

    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder);
    }

    private Dimension2D getSize(StringBounder stringBounder, TextBlock textBlock) {
        return textBlock.calculateDimension(stringBounder);
    }

    protected final double getTextHeight(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        Dimension2D size = this.getSize(stringBounder, textBlock);
        return size.getHeight() + 10.0;
    }

    protected final TextBlock getTextBlock() {
        return this.textBlock;
    }

    protected final double getPureTextWidth(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        Dimension2D size = this.getSize(stringBounder, textBlock);
        return size.getWidth();
    }

    public final double getTextWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder) + 6.0 + 15.0;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double height = this.getPreferredHeight(stringBounder);
        double width = this.getPreferredWidth(stringBounder);
        return new Dimension2DDouble(width, height);
    }

    private StyleSignatureBasic getDefaultStyleDefinition(SName sname) {
        return StyleSignatureBasic.of(SName.root, SName.element, sname, SName.note);
    }

    @Override
    public final void drawU(UGraphic ug) {
        Url url = this.getEntity().getUrl99();
        EnumMap<UGroupType, String> typeIDent = new EnumMap<UGroupType, String>(UGroupType.class);
        typeIDent.put(UGroupType.CLASS, "elem " + this.getEntity().getCode() + " selected");
        typeIDent.put(UGroupType.ID, "elem_" + this.getEntity().getCode());
        ug.startGroup(typeIDent);
        if (url != null) {
            ug.startUrl(url);
        }
        UGraphic ug2 = UGraphicStencil.create(ug, this, new UStroke());
        if (this.opaleLine == null || !this.opaleLine.isOpale()) {
            this.drawNormal(ug2);
        } else {
            StringBounder stringBounder = ug.getStringBounder();
            DotPath path = this.opaleLine.getDotPath();
            path.moveSvek(-this.node.getMinX(), -this.node.getMinY());
            Point2D p1 = path.getStartPoint();
            Point2D p2 = path.getEndPoint();
            double textWidth = this.getTextWidth(stringBounder);
            double textHeight = this.getTextHeight(stringBounder);
            Point2D.Double center = new Point2D.Double(textWidth / 2.0, textHeight / 2.0);
            if (p1.distance(center) > p2.distance(center)) {
                path = path.reverse();
                p1 = path.getStartPoint();
            }
            Direction strategy = this.getOpaleStrategy(textWidth, textHeight, p1);
            Point2D pp1 = path.getStartPoint();
            Point2D pp2 = path.getEndPoint();
            Point2D newRefpp2 = EntityImageNote.move(pp2, this.node.getMinX(), this.node.getMinY());
            Point2D projection = EntityImageNote.move(this.other.projection(newRefpp2, stringBounder), -this.node.getMinX(), -this.node.getMinY());
            Opale opale = new Opale(this.shadowing, this.borderColor, this.noteBackgroundColor, this.textBlock, true, this.getStroke());
            opale.setRoundCorner(this.getRoundCorner());
            opale.setOpale(strategy, pp1, projection);
            UGraphic stroked = this.applyStroke(ug2);
            opale.drawU(Colors.applyStroke(stroked, this.getEntity().getColors()));
        }
        if (url != null) {
            ug.closeUrl();
        }
        ug.closeGroup();
    }

    private double getRoundCorner() {
        return this.skinParam.getRoundCorner(CornerParam.DEFAULT, null);
    }

    private static Point2D move(Point2D pt, double dx, double dy) {
        return new Point2D.Double(pt.getX() + dx, pt.getY() + dy);
    }

    private void drawNormal(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        UPath polygon = Opale.getPolygonNormal(this.getTextWidth(stringBounder), this.getTextHeight(stringBounder), this.getRoundCorner());
        double shadow = 0.0;
        if (UseStyle.useBetaStyle()) {
            shadow = this.shadowing;
        } else if (this.withShadow) {
            shadow = 4.0;
        }
        polygon.setDeltaShadow(shadow);
        ug = ug.apply(this.noteBackgroundColor.bg()).apply(this.borderColor);
        UGraphic stroked = this.applyStroke(ug);
        stroked.draw(polygon);
        ug.draw(Opale.getCorner(this.getTextWidth(stringBounder), this.getRoundCorner()));
        this.getTextBlock().drawU(ug.apply(new UTranslate(6.0, 5.0)));
    }

    private UGraphic applyStroke(UGraphic ug) {
        if (UseStyle.useBetaStyle()) {
            return ug.apply(this.style.getStroke());
        }
        UStroke stroke = this.skinParam.getThickness(LineParam.noteBorder, null);
        if (stroke == null) {
            return ug;
        }
        return ug.apply(stroke);
    }

    private UStroke getStroke() {
        if (UseStyle.useBetaStyle()) {
            return this.style.getStroke();
        }
        return this.skinParam.getThickness(LineParam.noteBorder, null);
    }

    private Direction getOpaleStrategy(double width, double height, Point2D pt) {
        double d1 = EntityImageNote.getOrthoDistance(new Line2D.Double(width, 0.0, width, height), pt);
        double d2 = EntityImageNote.getOrthoDistance(new Line2D.Double(0.0, height, width, height), pt);
        double d3 = EntityImageNote.getOrthoDistance(new Line2D.Double(0.0, 0.0, 0.0, height), pt);
        double d4 = EntityImageNote.getOrthoDistance(new Line2D.Double(0.0, 0.0, width, 0.0), pt);
        if (d3 <= d1 && d3 <= d2 && d3 <= d4) {
            return Direction.LEFT;
        }
        if (d1 <= d2 && d1 <= d3 && d1 <= d4) {
            return Direction.RIGHT;
        }
        if (d4 <= d1 && d4 <= d2 && d4 <= d3) {
            return Direction.UP;
        }
        if (d2 <= d1 && d2 <= d3 && d2 <= d4) {
            return Direction.DOWN;
        }
        return null;
    }

    private static double getOrthoDistance(Line2D.Double seg, Point2D pt) {
        if (EntityImageNote.isHorizontal(seg)) {
            return Math.abs(seg.getP1().getY() - pt.getY());
        }
        if (EntityImageNote.isVertical(seg)) {
            return Math.abs(seg.getP1().getX() - pt.getX());
        }
        throw new IllegalArgumentException();
    }

    private static boolean isHorizontal(Line2D.Double seg) {
        return seg.getP1().getY() == seg.getP2().getY();
    }

    private static boolean isVertical(Line2D.Double seg) {
        return seg.getP1().getX() == seg.getP2().getX();
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public void setOpaleLine(SvekLine line, SvekNode node, SvekNode other) {
        this.opaleLine = line;
        this.node = node;
        this.other = Objects.requireNonNull(other);
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return 0.0;
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.calculateDimension(stringBounder).getWidth();
    }
}

