/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.math.BigDecimal;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingFormat;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.graphic.IntricatedPoint;
import net.sourceforge.plantuml.timingdiagram.graphic.PlayerFrame;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class PlayerClock
extends Player {
    private final int period;
    private final int pulse;
    private final int offset;
    private final double ymargin = 8.0;
    private final boolean displayTitle;

    public PlayerClock(String title, ISkinParam skinParam, TimingRuler ruler, int period, int pulse, int offset, boolean compact) {
        super(title, skinParam, ruler, compact);
        this.displayTitle = title.length() > 0;
        this.period = period;
        this.pulse = pulse;
        this.offset = offset;
        this.suggestedHeight = 30;
    }

    @Override
    public double getFullHeight(StringBounder stringBounder) {
        return (double)this.suggestedHeight + this.getTitleHeight(stringBounder);
    }

    private double getLineHeight(StringBounder stringBounder) {
        return (double)this.suggestedHeight - 16.0;
    }

    private double getTitleHeight(StringBounder stringBounder) {
        if (this.displayTitle) {
            return this.getTitle().calculateDimension(stringBounder).getHeight();
        }
        return 0.0;
    }

    @Override
    protected SymbolContext getContextLegacy() {
        return new SymbolContext(HColorUtils.COL_D7E0F2, HColorUtils.COL_038048).withStroke(new UStroke(1.5));
    }

    @Override
    protected StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.timingDiagram, SName.clock);
    }

    @Override
    public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick tick) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addNote(TimeTick now, Display note, Position position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void defineState(String stateCode, String label) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setState(TimeTick now, String comment, Colors color, String ... states) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createConstraint(TimeTick tick1, TimeTick tick2, String message) {
        throw new UnsupportedOperationException();
    }

    public final int getPeriod() {
        return this.period;
    }

    @Override
    public TextBlock getPart1(double fullAvailableWidth, double specialVSpace) {
        if (this.displayTitle) {
            return new AbstractTextBlock(){

                @Override
                public void drawU(UGraphic ug) {
                    new PlayerFrame(PlayerClock.this.getTitle(), PlayerClock.this.skinParam).drawFrameTitle(ug);
                }

                @Override
                public Dimension2D calculateDimension(StringBounder stringBounder) {
                    return PlayerClock.this.getTitle().calculateDimension(stringBounder);
                }
            };
        }
        return TextBlockUtils.empty(0.0, 0.0);
    }

    @Override
    public UDrawable getPart2() {
        return new UDrawable(){

            private void drawHline(UGraphic ug, double value1, double value2) {
                double x1 = this.getX(value1);
                double x2 = Math.min(PlayerClock.this.ruler.getWidth(), this.getX(value2));
                ULine hline = ULine.hline(x2 - x1);
                ug.apply(UTranslate.dx(x1)).draw(hline);
            }

            private void drawVline(UGraphic ug, ULine vline, double value) {
                ug.apply(new UTranslate(this.getX(value), 8.0)).draw(vline);
            }

            private double getX(double value) {
                return PlayerClock.this.ruler.getPosInPixel(new TimeTick(new BigDecimal(value), TimingFormat.DECIMAL));
            }

            @Override
            public void drawU(UGraphic ug) {
                ug = PlayerClock.this.getContext().apply(ug);
                ug = ug.apply(UTranslate.dy(PlayerClock.this.getTitleHeight(ug.getStringBounder())));
                ULine vline = ULine.vline(PlayerClock.this.getLineHeight(ug.getStringBounder()));
                double value = 0.0;
                if (PlayerClock.this.offset != 0) {
                    this.drawHline(ug.apply(UTranslate.dy(8.0 + vline.getDY())), value, PlayerClock.this.offset);
                    value += (double)PlayerClock.this.offset;
                }
                if (this.getX(value) > PlayerClock.this.ruler.getWidth()) {
                    return;
                }
                this.drawVline(ug, vline, value);
                double vpulse = PlayerClock.this.pulse == 0 ? (double)PlayerClock.this.period / 2.0 : (double)PlayerClock.this.pulse;
                double remain = (double)PlayerClock.this.period - vpulse;
                for (int i = 0; i < 1000; ++i) {
                    this.drawHline(ug.apply(UTranslate.dy(8.0)), value, value + vpulse);
                    value += vpulse;
                    if (this.getX(value) > PlayerClock.this.ruler.getWidth()) {
                        return;
                    }
                    this.drawVline(ug, vline, value);
                    this.drawHline(ug.apply(UTranslate.dy(8.0 + vline.getDY())), value, value + remain);
                    value += remain;
                    if (this.getX(value) > PlayerClock.this.ruler.getWidth()) {
                        return;
                    }
                    this.drawVline(ug, vline, value);
                }
            }
        };
    }
}

