/*
 * Decompiled with CFR 0.152.
 */
package de.tuberlin.polymake.common.io;

import de.tuberlin.polymake.common.SelectorThread;
import de.tuberlin.polymake.common.SharedMemoryMatrixException;
import de.tuberlin.polymake.common.geometry.PointSet;
import de.tuberlin.polymake.common.geometry.PolymakePoint;
import de.tuberlin.polymake.common.io.PolymakeParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class SimpleGeometryParser
extends PolymakeParser {
    public SimpleGeometryParser(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void parse(BufferedReader bufferedReader, PointSet pointSet) throws IOException, SharedMemoryMatrixException {
        Object object;
        Object object2;
        String string;
        this.error = null;
        this.warning = null;
        Vector<PolymakePoint[]> vector = new Vector<PolymakePoint[]>();
        boolean bl = false;
        this.clearParams();
        block11: while (!bl && (string = bufferedReader.readLine()) != null) {
            if (System.getProperty("polymake.debug") != null && System.getProperty("polymake.debug").equalsIgnoreCase("max")) {
                SelectorThread.newErr.println(string);
            }
            string.trim();
            switch (string.charAt(0)) {
                case 'n': {
                    this.name = string.substring(2);
                    pointSet.setName(this.name);
                    continue block11;
                }
                case 'e': {
                    this.error = string.substring(2);
                    continue block11;
                }
                case 'w': {
                    this.warning = string.substring(2);
                    continue block11;
                }
                case 'p': {
                    object2 = SimpleGeometryParser.parsePoint(string.substring(2));
                    vector.add((PolymakePoint[])object2);
                    continue block11;
                }
                case 'P': {
                    int n = Integer.parseInt(string.substring(2));
                    if (pointSet.getSMM() == null) {
                        pointSet.initSMM(n);
                    }
                    pointSet.readFromSMM();
                    continue block11;
                }
                case 'f': {
                    this.parameters.setProperty("facet", string.substring(2));
                    continue block11;
                }
                case 's': {
                    object2 = new StringTokenizer(string.substring(2));
                    object = ((StringTokenizer)object2).nextToken();
                    if (!this.parameters.keySet().contains(object)) continue block11;
                    this.parameters.setProperty((String)object, ((StringTokenizer)object2).nextToken());
                    continue block11;
                }
                case 'i': {
                    object2 = new StringTokenizer(string.substring(2));
                    object = ((StringTokenizer)object2).nextToken();
                    if (!this.parameters.keySet().contains(object)) continue block11;
                    this.iparameters.setProperty((String)object, ((StringTokenizer)object2).nextToken());
                    continue block11;
                }
                case 'x': {
                    bl = true;
                    continue block11;
                }
            }
        }
        if (vector.size() != 0) {
            object2 = new PolymakePoint[vector.size()];
            object = vector.iterator();
            for (int i = 0; i < ((PolymakePoint[])object2).length; ++i) {
                PolymakePoint polymakePoint;
                object2[i] = polymakePoint = (PolymakePoint)object.next();
            }
            pointSet.setPoints((PolymakePoint[])object2);
        }
    }

    private void clearParams() {
        for (String string : this.parameters.keySet()) {
            this.parameters.setProperty(string, "null");
        }
    }

    public Vector getFacet() {
        return SimpleGeometryParser.parseFacet(this.parameters.getProperty("facet"));
    }

    public static PolymakePoint parsePoint(String string) throws NumberFormatException {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Vector<Double> vector = new Vector<Double>();
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (((String)object).equals("l")) {
                string2 = stringTokenizer.nextToken();
                continue;
            }
            vector.add(new Double((String)object));
        }
        object = new double[vector.size()];
        int n = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            object[n++] = d;
        }
        return new PolymakePoint((double[])object, string2);
    }

    public static Vector parseFacet(String string) throws NumberFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Vector<Integer> vector = new Vector<Integer>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(new Integer(stringTokenizer.nextToken()));
        }
        return vector;
    }

    /*
     * WARNING - void declaration
     */
    public static String write(PointSet pointSet, Properties properties) {
        Object object;
        String string = new String();
        if (pointSet != null) {
            string = string + "n " + pointSet.getName() + "\n";
            try {
                if (pointSet.getSMM() != null) {
                    pointSet.getSMM().setCoords(pointSet);
                    string = string + "P " + pointSet.getSMM().getAddr() + "\n";
                } else {
                    void string2;
                    PolymakePoint[] polymakePointArray = pointSet.getPoints();
                    boolean i = false;
                    while (string2 < polymakePointArray.length) {
                        object = polymakePointArray[string2].getCoords();
                        string = string + "p";
                        for (int j = 0; j < ((Object)object).length; ++j) {
                            string = string + " " + (double)object[j];
                        }
                        if (polymakePointArray[string2].getLabel() != null) {
                            string = string + " l " + polymakePointArray[string2].getLabel();
                        }
                        string = string + "\n";
                        ++string2;
                    }
                }
            }
            catch (SharedMemoryMatrixException sharedMemoryMatrixException) {
                sharedMemoryMatrixException.printStackTrace(SelectorThread.newErr);
            }
        }
        if (properties != null) {
            for (String string2 : properties.keySet()) {
                object = properties.getProperty(string2);
                if (object == null) continue;
                string = string + "s " + string2 + " " + (String)object + "\n";
            }
        }
        string = string + "x\n";
        return string;
    }

    public static String write(String string, Properties properties) {
        String string2 = new String();
        string2 = string2 + "n " + string + "\n";
        if (properties != null) {
            for (String string3 : properties.keySet()) {
                String string4 = properties.getProperty(string3);
                if (string4 == null) continue;
                string2 = string2 + "s " + string3 + " " + string4 + "\n";
            }
        }
        string2 = string2 + "x\n";
        return string2;
    }

    public static String write(String string, int n) {
        String string2 = new String();
        string2 = string2 + "n " + string + "\n";
        string2 = string2 + "p " + n + "\n";
        string2 = string2 + "x\n";
        return string2;
    }

    public static String write(String string, String string2, double d) {
        String string3 = new String();
        string3 = string3 + "n " + string + "\n";
        string3 = string3 + "s " + string2 + " " + d + "\n";
        string3 = string3 + "x\n";
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    public static String write(PointSet pointSet, Vector vector, Properties properties) {
        String string = new String();
        try {
            Object object;
            if (pointSet != null) {
                Object object2;
                string = string + "n " + pointSet.getName() + "\n";
                if (pointSet.getSMM() != null) {
                    pointSet.writeToSMM();
                    string = string + "P " + pointSet.getSMM().getAddr() + "\n";
                } else {
                    void string2;
                    object2 = pointSet.getPoints();
                    boolean i = false;
                    while (string2 < ((PolymakePoint[])object2).length) {
                        object = object2[string2].getCoords();
                        string = string + "p";
                        for (int j = 0; j < ((Object)object).length; ++j) {
                            string = string + " " + (double)object[j];
                        }
                        if (((PolymakePoint)object2[string2]).getLabel() != null) {
                            string = string + " l " + ((PolymakePoint)object2[string2]).getLabel();
                        }
                        string = string + "\n";
                        ++string2;
                    }
                }
                string = string + "f ";
                object2 = vector.iterator();
                while (object2.hasNext()) {
                    string = string + (String)object2.next() + " ";
                }
                string = string + "\n";
            }
            if (properties != null) {
                for (String string2 : properties.keySet()) {
                    object = properties.getProperty(string2);
                    if (object == null) continue;
                    string = string + "s " + string2 + " " + (String)object + "\n";
                }
            }
        }
        catch (SharedMemoryMatrixException sharedMemoryMatrixException) {
            sharedMemoryMatrixException.printStackTrace(SelectorThread.newErr);
        }
        string = string + "x\n";
        return string;
    }

    public static String writeFacet(String string, Vector vector) {
        String string2 = new String();
        string2 = string2 + "n " + string + "\n";
        string2 = string2 + "f ";
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            string2 = string2 + (String)iterator.next() + " ";
        }
        string2 = string2 + "\nx\n";
        return string2;
    }

    public static String writeTransformationMatrix(double[] dArray) {
        String string = "T";
        for (int i = 0; i < 16; ++i) {
            string = string + " " + dArray[i];
        }
        return string;
    }
}

