/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.deprecation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.conf.IRIExpander;
import org.protege.editor.owl.model.conf.valueset.ValueSet;
import org.semanticweb.owlapi.model.IRI;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DeprecationCode {
    @Nonnull
    private final String property;
    @Nonnull
    private final ValueSet valueSet;

    @JsonCreator
    public DeprecationCode(@Nonnull @JsonProperty(value="property") String property, @Nonnull @JsonProperty(value="valueSet") ValueSet valueSet) {
        this.property = (String)Preconditions.checkNotNull((Object)property);
        this.valueSet = (ValueSet)Preconditions.checkNotNull((Object)valueSet);
    }

    @Nonnull
    public IRI getPropertyIri() {
        return IRIExpander.expand(this.property).orElseThrow(() -> new RuntimeException("property not supplied"));
    }

    @Nonnull
    public ValueSet getValueSet() {
        return this.valueSet;
    }
}

