/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.protege.editor.owl.model.hierarchy.AbstractOWLObjectHierarchyProvider;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProviderListener;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.OWLObjectVisitorExAdapter;

public class OWLPropertyHierarchyProvider
extends AbstractOWLObjectHierarchyProvider<OWLEntity> {
    private OWLObjectHierarchyProvider<OWLObjectProperty> objectPropertyHierarchyProvider;
    private OWLObjectHierarchyProvider<OWLDataProperty> dataPropertyHierarchyProvider;
    private OWLObjectHierarchyProvider<OWLAnnotationProperty> annotationPropertyHierarchyProvider;

    public OWLPropertyHierarchyProvider(OWLOntologyManager owlOntologyManager, OWLObjectHierarchyProvider<OWLObjectProperty> objectPropertyHierarchyProvider, OWLObjectHierarchyProvider<OWLDataProperty> dataPropertyHierarchyProvider, OWLObjectHierarchyProvider<OWLAnnotationProperty> annotationPropertyHierarchyProvider) {
        super(owlOntologyManager);
        this.annotationPropertyHierarchyProvider = annotationPropertyHierarchyProvider;
        this.dataPropertyHierarchyProvider = dataPropertyHierarchyProvider;
        this.objectPropertyHierarchyProvider = objectPropertyHierarchyProvider;
        annotationPropertyHierarchyProvider.addListener(new OWLObjectHierarchyProviderListener<OWLAnnotationProperty>(){

            @Override
            public void nodeChanged(OWLAnnotationProperty node) {
                OWLPropertyHierarchyProvider.this.fireNodeChanged(node);
            }

            @Override
            public void hierarchyChanged() {
                OWLPropertyHierarchyProvider.this.fireHierarchyChanged();
            }
        });
        dataPropertyHierarchyProvider.addListener(new OWLObjectHierarchyProviderListener<OWLDataProperty>(){

            @Override
            public void nodeChanged(OWLDataProperty node) {
                OWLPropertyHierarchyProvider.this.fireNodeChanged(node);
            }

            @Override
            public void hierarchyChanged() {
                OWLPropertyHierarchyProvider.this.fireHierarchyChanged();
            }
        });
        objectPropertyHierarchyProvider.addListener(new OWLObjectHierarchyProviderListener<OWLObjectProperty>(){

            @Override
            public void nodeChanged(OWLObjectProperty node) {
                OWLPropertyHierarchyProvider.this.fireNodeChanged(node);
            }

            @Override
            public void hierarchyChanged() {
                OWLPropertyHierarchyProvider.this.fireHierarchyChanged();
            }
        });
    }

    @Override
    public boolean containsReference(OWLEntity object) {
        return (Boolean)object.accept((OWLObjectVisitorEx)new OWLObjectVisitorExAdapter<Boolean>(Boolean.valueOf(false)){

            public Boolean visit(OWLAnnotationProperty property) {
                return OWLPropertyHierarchyProvider.this.annotationPropertyHierarchyProvider.containsReference(property);
            }

            public Boolean visit(OWLDataProperty property) {
                return OWLPropertyHierarchyProvider.this.dataPropertyHierarchyProvider.containsReference(property);
            }

            public Boolean visit(OWLObjectProperty property) {
                return OWLPropertyHierarchyProvider.this.objectPropertyHierarchyProvider.containsReference(property);
            }
        });
    }

    @Override
    public void setOntologies(Set<OWLOntology> ontologies) {
        this.annotationPropertyHierarchyProvider.setOntologies(ontologies);
        this.dataPropertyHierarchyProvider.setOntologies(ontologies);
        this.objectPropertyHierarchyProvider.setOntologies(ontologies);
    }

    @Override
    public Set<OWLEntity> getRoots() {
        LinkedHashSet<OWLEntity> roots = new LinkedHashSet<OWLEntity>();
        roots.addAll(this.objectPropertyHierarchyProvider.getRoots());
        roots.addAll(this.dataPropertyHierarchyProvider.getRoots());
        roots.addAll(this.annotationPropertyHierarchyProvider.getRoots());
        return roots;
    }

    @Override
    public Set<OWLEntity> getUnfilteredChildren(OWLEntity object) {
        Set result = (Set)object.accept((OWLObjectVisitorEx)new OWLObjectVisitorExAdapter<Set<? extends OWLEntity>>(Collections.emptySet()){

            public Set<? extends OWLEntity> visit(OWLAnnotationProperty property) {
                return OWLPropertyHierarchyProvider.this.annotationPropertyHierarchyProvider.getChildren(property);
            }

            public Set<? extends OWLEntity> visit(OWLDataProperty property) {
                return OWLPropertyHierarchyProvider.this.dataPropertyHierarchyProvider.getChildren(property);
            }

            public Set<? extends OWLEntity> visit(OWLObjectProperty property) {
                return OWLPropertyHierarchyProvider.this.objectPropertyHierarchyProvider.getChildren(property);
            }
        });
        return result;
    }

    @Override
    public Set<OWLEntity> getParents(OWLEntity object) {
        Set result = (Set)object.accept((OWLObjectVisitorEx)new OWLObjectVisitorExAdapter<Set<? extends OWLEntity>>(Collections.emptySet()){

            public Set<? extends OWLEntity> visit(OWLAnnotationProperty property) {
                return OWLPropertyHierarchyProvider.this.annotationPropertyHierarchyProvider.getParents(property);
            }

            public Set<? extends OWLEntity> visit(OWLDataProperty property) {
                return OWLPropertyHierarchyProvider.this.dataPropertyHierarchyProvider.getParents(property);
            }

            public Set<? extends OWLEntity> visit(OWLObjectProperty property) {
                return OWLPropertyHierarchyProvider.this.objectPropertyHierarchyProvider.getParents(property);
            }
        });
        return result;
    }

    @Override
    public Set<OWLEntity> getEquivalents(OWLEntity object) {
        Set result = (Set)object.accept((OWLObjectVisitorEx)new OWLObjectVisitorExAdapter<Set<? extends OWLEntity>>(Collections.emptySet()){

            public Set<? extends OWLEntity> visit(OWLAnnotationProperty property) {
                return OWLPropertyHierarchyProvider.this.annotationPropertyHierarchyProvider.getEquivalents(property);
            }

            public Set<? extends OWLEntity> visit(OWLDataProperty property) {
                return OWLPropertyHierarchyProvider.this.dataPropertyHierarchyProvider.getEquivalents(property);
            }

            public Set<? extends OWLEntity> visit(OWLObjectProperty property) {
                return OWLPropertyHierarchyProvider.this.objectPropertyHierarchyProvider.getEquivalents(property);
            }
        });
        return result;
    }
}

