/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.protege.editor.core.util.Recommendation;
import org.protege.editor.owl.model.hierarchy.tabbed.CreateHierarchyChangeGenerator;
import org.protege.editor.owl.model.hierarchy.tabbed.HierarchyNodeCreator;
import org.protege.editor.owl.model.hierarchy.tabbed.MakeSiblingsDisjointChangeGenerator;
import org.protege.editor.owl.model.util.DefinedClassPredicate;
import org.protege.editor.owl.ui.action.SelectedOWLClassAction;
import org.protege.editor.owl.ui.hierarchy.creation.CreateHierarchyExecutor;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;

public class CreateSubClassHierarchyAction
extends SelectedOWLClassAction {
    @Override
    protected void initialiseAction() throws Exception {
    }

    public void actionPerformed(ActionEvent e) {
        OWLClass rootClass = this.getOWLClass();
        if (rootClass == null) {
            return;
        }
        Set<OWLOntology> activeOntologies = this.getOWLEditorKit().getOWLModelManager().getActiveOntologies();
        OWLDataFactory df = this.getOWLDataFactory();
        CreateHierarchyChangeGenerator<OWLClass> hierarchyChangeGenerator = new CreateHierarchyChangeGenerator<OWLClass>(new HierarchyNodeCreator<OWLClass>(rootClass, EntityType.CLASS, this.getOWLModelManager().getOWLEntityFinder(), this.getOWLModelManager().getOWLEntityFactory()), (child, parent) -> parent.isOWLThing() ? Optional.empty() : Optional.of(df.getOWLSubClassOfAxiom((OWLClassExpression)child, (OWLClassExpression)parent)), this.getOWLModelManager().getActiveOntology());
        MakeSiblingsDisjointChangeGenerator<OWLClass> disjointsChangeGenerator = new MakeSiblingsDisjointChangeGenerator<OWLClass>(this.getOWLModelManager().getOWLHierarchyManager().getOWLClassHierarchyProvider(), sourceSiblings -> sourceSiblings.stream().filter(DefinedClassPredicate.isNotDefinedIn(activeOntologies)).collect(Collectors.toSet()), siblings -> df.getOWLDisjointClassesAxiom(siblings), this.getOWLModelManager().getActiveOntology());
        CreateHierarchyExecutor<OWLClass> createClassHierarchyExecutor = new CreateHierarchyExecutor<OWLClass>(this.getOWLEditorKit(), EntityType.CLASS, Optional.of(Recommendation.RECOMMENDED), hierarchyChangeGenerator, disjointsChangeGenerator);
        createClassHierarchyExecutor.showWizardAndCreateHierarchy();
    }
}

