info = {
    "name": "ta",
    "date_order": "DMY",
    "january": [
        "ஜன",
        "ஜனவரி"
    ],
    "february": [
        "பிப்",
        "பிப்ரவரி"
    ],
    "march": [
        "மார்",
        "மார்ச்"
    ],
    "april": [
        "ஏப்",
        "ஏப்ரல்"
    ],
    "may": [
        "மே"
    ],
    "june": [
        "ஜூன்"
    ],
    "july": [
        "ஜூலை"
    ],
    "august": [
        "ஆக",
        "ஆகஸ்ட்"
    ],
    "september": [
        "செப்",
        "செப்டம்பர்"
    ],
    "october": [
        "அக்",
        "அக்டோபர்"
    ],
    "november": [
        "நவ",
        "நவம்பர்"
    ],
    "december": [
        "டிச",
        "டிசம்பர்"
    ],
    "monday": [
        "திங்",
        "திங்கள்"
    ],
    "tuesday": [
        "செவ்",
        "செவ்வாய்"
    ],
    "wednesday": [
        "புத",
        "புதன்"
    ],
    "thursday": [
        "வியா",
        "வியாழன்"
    ],
    "friday": [
        "வெள்",
        "வெள்ளி"
    ],
    "saturday": [
        "சனி"
    ],
    "sunday": [
        "ஞாயி",
        "ஞாயிறு"
    ],
    "am": [
        "முற்பகல்"
    ],
    "pm": [
        "பிற்பகல்"
    ],
    "year": [
        "ஆ",
        "ஆண்டு"
    ],
    "month": [
        "மா",
        "மாத",
        "மாதம்"
    ],
    "week": [
        "வா",
        "வாரம்"
    ],
    "day": [
        "நா",
        "நாள்"
    ],
    "hour": [
        "ம",
        "மணி"
    ],
    "minute": [
        "நிமி",
        "நிமிடம்"
    ],
    "second": [
        "வி",
        "விநா",
        "விநாடி"
    ],
    "relative-type": {
        "0 day ago": [
            "இன்று"
        ],
        "0 hour ago": [
            "இந்த ஒரு மணிநேரத்தில்"
        ],
        "0 minute ago": [
            "இந்த ஒரு நிமிடத்தில்"
        ],
        "0 month ago": [
            "இந்த மாதம்"
        ],
        "0 second ago": [
            "இப்போது"
        ],
        "0 week ago": [
            "இந்த வாரம்"
        ],
        "0 year ago": [
            "இந்த ஆண்டு"
        ],
        "1 day ago": [
            "நேற்று"
        ],
        "1 month ago": [
            "கடந்த மாதம்"
        ],
        "1 week ago": [
            "கடந்த வாரம்"
        ],
        "1 year ago": [
            "கடந்த ஆண்டு"
        ],
        "in 1 day": [
            "நாளை"
        ],
        "in 1 month": [
            "அடுத்த மாதம்"
        ],
        "in 1 week": [
            "அடுத்த வாரம்"
        ],
        "in 1 year": [
            "அடுத்த ஆண்டு"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+) நா முன்",
            "(\\d+) நாட்களுக்கு முன்",
            "(\\d+) நாளுக்கு முன்"
        ],
        "\\1 hour ago": [
            "(\\d+) ம முன்",
            "(\\d+) மணி முன்",
            "(\\d+) மணிநேரம் முன்"
        ],
        "\\1 minute ago": [
            "(\\d+) நி முன்",
            "(\\d+) நிமி முன்",
            "(\\d+) நிமிடங்களுக்கு முன்",
            "(\\d+) நிமிடத்திற்கு முன்"
        ],
        "\\1 month ago": [
            "(\\d+) மா முன்",
            "(\\d+) மாத முன்",
            "(\\d+) மாதங்களுக்கு முன்",
            "(\\d+) மாதத்துக்கு முன்"
        ],
        "\\1 second ago": [
            "(\\d+) வி முன்",
            "(\\d+) விநா முன்",
            "(\\d+) விநாடிகளுக்கு முன்",
            "(\\d+) விநாடிக்கு முன்"
        ],
        "\\1 week ago": [
            "(\\d+) வா முன்",
            "(\\d+) வார முன்",
            "(\\d+) வாரங்களுக்கு முன்",
            "(\\d+) வாரத்திற்கு முன்பு"
        ],
        "\\1 year ago": [
            "(\\d+) ஆ முன்",
            "(\\d+) ஆண்டிற்கு முன்",
            "(\\d+) ஆண்டுகளுக்கு முன்"
        ],
        "in \\1 day": [
            "(\\d+) நா",
            "(\\d+) நாட்களில்",
            "(\\d+) நாளில்"
        ],
        "in \\1 hour": [
            "(\\d+) ம",
            "(\\d+) மணி",
            "(\\d+) மணிநேரத்தில்"
        ],
        "in \\1 minute": [
            "(\\d+) நி",
            "(\\d+) நிமி",
            "(\\d+) நிமிடங்களில்",
            "(\\d+) நிமிடத்தில்"
        ],
        "in \\1 month": [
            "(\\d+) மா",
            "(\\d+) மாத",
            "(\\d+) மாதங்களில்",
            "(\\d+) மாதத்தில்"
        ],
        "in \\1 second": [
            "(\\d+) வி",
            "(\\d+) விநா",
            "(\\d+) விநாடிகளில்",
            "(\\d+) விநாடியில்"
        ],
        "in \\1 week": [
            "(\\d+) வா",
            "(\\d+) வார",
            "(\\d+) வாரங்களில்",
            "(\\d+) வாரத்தில்"
        ],
        "in \\1 year": [
            "(\\d+) ஆ",
            "(\\d+) ஆண்டில்",
            "(\\d+) ஆண்டுகளில்"
        ]
    },
    "locale_specific": {
        "ta-LK": {
            "name": "ta-LK"
        },
        "ta-MY": {
            "name": "ta-MY"
        },
        "ta-SG": {
            "name": "ta-SG"
        }
    },
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
