﻿
# game/tutorial_atl.rpy:205
translate schinese tutorial_positions_a09a3fd1:

    # e "In this tutorial, I'll teach you how Ren'Py positions things on the screen. But before that, let's learn a little bit about how Python handles numbers."
    e "在本教程中，我会教你Ren'Py如何在界面上定位。在此之前，让我们了解一下Python如何处理数字。"

# game/tutorial_atl.rpy:207
translate schinese tutorial_positions_ba39aabc:

    # e "There are two main kinds of numbers in Python: integers and floating point numbers. An integer consists entirely of digits, while a floating point number has a decimal point."
    e "Python中主要有两种数字：整数和浮点数。整数完全由数字组成，而浮点数有小数点。"

# game/tutorial_atl.rpy:209
translate schinese tutorial_positions_a60b775d:

    # e "For example, 100 is an integer, while 0.5 is a floating point number, or float for short. In this system, there are two zeros: 0 is an integer, and 0.0 is a float."
    e "例如，100是整数，而0.5是浮点数。在这个系统中，有两种零：0是整数，而0.0是浮点数。"

# game/tutorial_atl.rpy:211
translate schinese tutorial_positions_7f1a560c:

    # e "Ren'Py uses integers to represent absolute coordinates, and floats to represent fractions of an area with known size."
    e "Ren'Py使用整数表示绝对坐标，而float表示已知大小区域的比例。"

# game/tutorial_atl.rpy:213
translate schinese tutorial_positions_8e7d3e52:

    # e "When we're positioning something, the area is usually the entire screen."
    e "当我们定位某个东西时，这个区域通常是整个界面。"

# game/tutorial_atl.rpy:215
translate schinese tutorial_positions_fdcf9d8b:

    # e "Let me get out of the way, and I'll show you where some positions are."
    e "我先让开，给你看一些位置。"

# game/tutorial_atl.rpy:229
translate schinese tutorial_positions_76d7a5bf:

    # e "The origin is the upper-left corner of the screen. That's where the x position (xpos) and the y position (ypos) are both zero."
    e "原点是界面的左上角。那里x坐标（xpos）和y坐标（ypos）都是0。"

# game/tutorial_atl.rpy:235
translate schinese tutorial_positions_be14c7c3:

    # e "When we increase xpos, we move to the right. So here's an xpos of .5, meaning half the width across the screen."
    e "增加xpos，则向右移动。xpos为.5，意味着界面宽度的一半。"

# game/tutorial_atl.rpy:240
translate schinese tutorial_positions_9b91be6c:

    # e "Increasing xpos to 1.0 moves us to the right-hand border of the screen."
    e "xpos增加到1.0，则移动到界面的右边界。"

# game/tutorial_atl.rpy:246
translate schinese tutorial_positions_2b293304:

    # e "We can also use an absolute xpos, which is given in an absolute number of pixels from the left side of the screen. For example, since this window is 1280 pixels across, using an xpos of 640 will return the target to the center of the top row."
    e "我们也可以使用绝对的xpos，它是以距离界面左侧的像素数的绝对值。例如，由于此窗口的宽度为1280像素，因此使用640的xpo将使目标位于顶行的中心。"

# game/tutorial_atl.rpy:248
translate schinese tutorial_positions_c4d18c0a:

    # e "The y-axis position, or ypos works the same way. Right now, we have a ypos of 0.0."
    e "y轴位置，即ypos，以同样的方式起作用。现在，我们的ypos为0.0。"

# game/tutorial_atl.rpy:254
translate schinese tutorial_positions_16933a61:

    # e "Here's a ypos of 0.5."
    e "ypos为0.5。"

# game/tutorial_atl.rpy:259
translate schinese tutorial_positions_6eb36777:

    # e "A ypos of 1.0 specifies a position at the bottom of the screen. If you look carefully, you can see the position indicator spinning below the text window."
    e "若ypos为1.0，则位于界面底部。仔细看，位置指示器在文本窗口下面旋转。"

# game/tutorial_atl.rpy:261
translate schinese tutorial_positions_a423050f:

    # e "Like xpos, ypos can also be an integer. In this case, ypos would give the total number of pixels from the top of the screen."
    e "与xpos一样，ypos也可以是整数。在本例中，ypos是距离界面顶部的像素总数。"

# game/tutorial_atl.rpy:267
translate schinese tutorial_positions_bc7a809a:

    # e "Can you guess where this position is, relative to the screen?" nointeract
    e "你能猜出这个位置相对于界面的位置吗？" nointeract

# game/tutorial_atl.rpy:273
translate schinese tutorial_positions_6f926e18:

    # e "Sorry, that's wrong. The xpos is .75, and the ypos is .25."
    e "对不起，那是错的。xpos是.75，ypos是.25。"

# game/tutorial_atl.rpy:275
translate schinese tutorial_positions_5d5feb98:

    # e "In other words, it's 75%% of the way from the left side, and 25%% of the way from the top."
    e "换言之，距离左侧75%%的距离，距离顶部25%%的距离。"

# game/tutorial_atl.rpy:279
translate schinese tutorial_positions_77b45218:

    # e "Good job! You got that position right."
    e "干得好！你选择了正确的位置。"

# game/tutorial_atl.rpy:283
translate schinese tutorial_positions_6f926e18_1:

    # e "Sorry, that's wrong. The xpos is .75, and the ypos is .25."
    e "对不起，那是错的。xpos是.75，ypos是.25。"

# game/tutorial_atl.rpy:285
translate schinese tutorial_positions_5d5feb98_1:

    # e "In other words, it's 75%% of the way from the left side, and 25%% of the way from the top."
    e "换言之，距离左侧75%%的距离，距离顶部25%%的距离。"

# game/tutorial_atl.rpy:299
translate schinese tutorial_positions_e4380a83:

    # e "The second position we care about is the anchor. The anchor is a spot on the thing being positioned."
    e "我们关心的第二个位置是锚点（anchor）。锚点是被定位物体上的一个点。"

# game/tutorial_atl.rpy:301
translate schinese tutorial_positions_d1db1246:

    # e "For example, here we have an xanchor of 0.0 and a yanchor of 0.0. It's in the upper-left corner of the logo image."
    e "例如，这里的xanchor为0.0，yanchor为0.0。它在logo图像的左上角。"

# game/tutorial_atl.rpy:306
translate schinese tutorial_positions_6056873f:

    # e "When we increase the xanchor to 1.0, the anchor moves to the right corner of the image."
    e "当xanchor增加到1.0时，锚点移动到图像的右上角。"

# game/tutorial_atl.rpy:311
translate schinese tutorial_positions_7cdb8dcc:

    # e "Similarly, when both xanchor and yanchor are 1.0, the anchor is the bottom-right corner."
    e "类似的，当xanchor和yanchor都为1.0时，锚点位于右下角。"

# game/tutorial_atl.rpy:318
translate schinese tutorial_positions_03a07da8:

    # e "To place an image on the screen, we need both the position and the anchor."
    e "要在界面上放置图像，位置和锚点都需要。"

# game/tutorial_atl.rpy:326
translate schinese tutorial_positions_8945054f:

    # e "We then line them up, so that both the position and anchor are at the same point on the screen."
    e "如果我们把它们对齐，这样位置和锚点都在界面上同一点。"

# game/tutorial_atl.rpy:336
translate schinese tutorial_positions_2b184a93:

    # e "When we place both in the upper-left corner, the image moves to the upper-left corner of the screen."
    e "当我们把两者都放在左上角时，图像会移到界面的左上角。"

# game/tutorial_atl.rpy:345
translate schinese tutorial_positions_5aac4f3f:

    # e "With the right combination of position and anchor, any place on the screen can be specified, without even knowing the size of the image."
    e "位置和锚点的正确组合，可以指定界面上的任意位置，甚至不需要知道图像的大小。"

# game/tutorial_atl.rpy:357
translate schinese tutorial_positions_3b59b797:

    # e "It's often useful to set xpos and xanchor to the same value. We call that xalign, and it gives a fractional position on the screen."
    e "通常，将xpos和xanchor设置为相同的值非常有用。我们称之为xalign，可以指定界面上的相对位置。"

# game/tutorial_atl.rpy:362
translate schinese tutorial_positions_b8ebf9fe:

    # e "For example, when we set xalign to 0.0, things are aligned to the left side of the screen."
    e "例如，当我们将xalign设置为0.0时，物体将与界面左侧对齐。"

# game/tutorial_atl.rpy:367
translate schinese tutorial_positions_8ce35d52:

    # e "When we set it to 1.0, then we're aligned to the right side of the screen."
    e "当我们将其设置为1.0时，物体将与界面的右侧对齐。"

# game/tutorial_atl.rpy:372
translate schinese tutorial_positions_6745825f:

    # e "And when we set it to 0.5, we're back to the center of the screen."
    e "当我们把它设置为0.5时，物体回到界面的中心。"

# game/tutorial_atl.rpy:374
translate schinese tutorial_positions_64428a07:

    # e "Setting yalign is similar, except along the y-axis."
    e "设置yalign与此类似，只不过是沿y轴。"

# game/tutorial_atl.rpy:376
translate schinese tutorial_positions_cfb77d42:

    # e "Remember that xalign is just setting xpos and xanchor to the same value, and yalign is just setting ypos and yanchor to the same value."
    e "记住，xalign只是将xpos和xanchor设置为相同的值，yallign只是将ypos和yanchor设置为相同的值。"

# game/tutorial_atl.rpy:381
translate schinese tutorial_positions_cfc1723e:

    # e "The xcenter and ycenter properties position the center of the image. Here, with xcenter set to .75, the center of the image is three-quarters of the way to the right side of the screen."
    e "xcenter和ycenter属性定位图像的中心。这里，将xcenter设置为.75，图像的中心在到界面右侧的路上的四分之三。"

# game/tutorial_atl.rpy:386
translate schinese tutorial_positions_7728dbf9:

    # e "The difference between xalign and xcenter is more obvious when xcenter is 1.0, and the image is halfway off the right side of the screen."
    e "当xcenter为1.0时，xalign和xcenter之间的差异更为明显，图像有一般超出离右边界。"

# game/tutorial_atl.rpy:394
translate schinese tutorial_positions_1b1cedc6:

    # e "There are the xoffset and yoffset properties, which are applied after everything else, and offset things to the right or bottom, respectively."
    e "xoffset和yoffset属性，应用于所有其他属性之后，分别让物体向右或向下偏移。"

# game/tutorial_atl.rpy:399
translate schinese tutorial_positions_e6da2798:

    # e "Of course, you can use negative numbers to offset things to the left and top."
    e "当然，你可以用负数来让物体向左或向上偏移。"

# game/tutorial_atl.rpy:404
translate schinese tutorial_positions_e0fe2d81:

    # e "Lastly, I'll mention that there are combined properties like align, pos, anchor, and center. Align takes a pair of numbers, and sets xalign to the first and yalign to the second. The others are similar."
    e "最后，我会提到一些组合属性，如align、pos、anchor和center。align接受一对数字，并将xalign的值设置为第一个，yalign设置为第二个。其他的也差不多。"

# game/tutorial_atl.rpy:411
translate schinese tutorial_positions_0f4ca2b6:

    # e "Once you understand positions, you can use transformations to move things around the Ren'Py screen."
    e "一旦你理解位置，就可以使变换在Ren'Py界面上移动物体。"

# game/tutorial_atl.rpy:418
translate schinese tutorial_atl_d5d6b62a:

    # e "Ren'Py uses transforms to animate, manipulate, and place images. We've already seen the very simplest of transforms in use:"
    e "Ren'Py使用变换来设置动画、操作和放置图像。我们已经在使用中见过最简单的变换："

# game/tutorial_atl.rpy:425
translate schinese tutorial_atl_7e853c9d:

    # e "Transforms can be very simple affairs that place the image somewhere on the screen, like the right transform."
    e "变换可以是将图像放在界面上某个地方这样非常简单的事情，像是右边的变换。"

# game/tutorial_atl.rpy:429
translate schinese tutorial_atl_87a6ecbd:

    # e "But transforms can also be far more complicated affairs, that introduce animation and effects into the mix. To demonstrate, let's have a Gratuitous Rock Concert!"
    e "但是变换也可以是远比这复杂的事情，将动画和特效引入并混合。为了演示，让我们来个免费的摇滚音乐会吧！"

# game/tutorial_atl.rpy:437
translate schinese tutorial_atl_65badef3:

    # e "But first, let's have... a Gratuitous Rock Concert!"
    e "但首先，让我们来个……免费的摇滚音乐会！"

# game/tutorial_atl.rpy:445
translate schinese tutorial_atl_e0d3c5ec:

    # e "That was a lot of work, but it was built out of small parts."
    e "这是一个大工程，但它是由小部分组成的。"

# game/tutorial_atl.rpy:447
translate schinese tutorial_atl_f2407514:

    # e "Most transforms in Ren'Py are built using the Animation and Transform Language, or ATL for short."
    e "Ren'Py中的大多数变换都是使用动画和变换语言（Animation and Transform Language, ATL）构建的。"

# game/tutorial_atl.rpy:449
translate schinese tutorial_atl_1f22f875:

    # e "There are currently three places where ATL can be used in Ren'Py."
    e "目前Ren'Py中有三个地方可以使用ATL。"

# game/tutorial_atl.rpy:454
translate schinese tutorial_atl_fd036bdf:

    # e "The first place ATL can be used is as part of an image statement. Instead of a displayable, an image may be defined as a block of ATL code."
    e "ATL的第一个用处是作为image语句的一部分。图像可以定义为ATL代码块，而不是可视组件。"

# game/tutorial_atl.rpy:456
translate schinese tutorial_atl_7cad2ab9:

    # e "When used in this way, we have to be sure that ATL includes one or more displayables to actually show."
    e "当以这种方式使用时，我们必须确保ATL包含一个或多个实际显示的可视组件。"

# game/tutorial_atl.rpy:461
translate schinese tutorial_atl_c78b2a1e:

    # e "The second way is through the use of the transform statement. This assigns the ATL block to a python variable, allowing it to be used in at clauses and inside other transforms."
    e "第二种方式是使用transform语句。将ATL块赋予python变量，允许用于at从句和其他变换内部。"

# game/tutorial_atl.rpy:473
translate schinese tutorial_atl_da7a7759:

    # e "Finally, an ATL block can be used as part of a show statement, instead of the at clause."
    e "最后，ATL块可以用作show语句的一部分，而不是at从句。"

# game/tutorial_atl.rpy:480
translate schinese tutorial_atl_1dd345c6:

    # e "When ATL is used as part of a show statement, values of properties exist even when the transform is changed. So even though your click stopped the motion, the image remains in the same place."
    e "当ATL用作show语句的一部分时，即使变换已更改，属性值也存在。所以即使你用点击停止图像的运动，它仍然保持在原来的位置。"

# game/tutorial_atl.rpy:488
translate schinese tutorial_atl_98047789:

    # e "The key to ATL is what we call composability. ATL is made up of relatively simple commands, which can be combined together to create complicated transforms."
    e "ATL的关键是我们称为可组合性的东西。ATL由相对简单的命令组成，这些命令可以组合在一起以创建复杂的变换。"

# game/tutorial_atl.rpy:490
translate schinese tutorial_atl_ed82983f:

    # e "Before I explain how ATL works, let me explain what animation and transformation are."
    e "在我解释ATL如何工作之前，让我解释一下什么是动画和变换。"

# game/tutorial_atl.rpy:495
translate schinese tutorial_atl_2807adff:

    # e "Animation is when the displayable being shown changes. For example, right now I am changing my expression."
    e "动画是可视组件正在显示变化。例如，现在我正在改变我的表情。"

# game/tutorial_atl.rpy:522
translate schinese tutorial_atl_3eec202b:

    # e "Transformation involves moving or distorting an image. This includes placing it on the screen, zooming it in and out, rotating it, and changing its opacity."
    e "变换包括移动或扭曲图像。这包括放置、缩放、旋转和改变不透明度。"

# game/tutorial_atl.rpy:530
translate schinese tutorial_atl_fbc9bf83:

    # e "To introduce ATL, let's start by looking at at a simple animation. Here's one that consists of five lines of ATL code, contained within an image statement."
    e "为了介绍ATL，让我们先看一个简单的动画。这有五行ATL代码，包含在一个image语句中。"

# game/tutorial_atl.rpy:532
translate schinese tutorial_atl_bf92d973:

    # e "To change a displayable, simply mention it on a line of ATL. Here, we're switching back and forth between two images."
    e "要更改一个可视组件，只需在一行ATL中提到它。这里，我们在两个图像之间来回切换。"

# game/tutorial_atl.rpy:534
translate schinese tutorial_atl_51a41db4:

    # e "Since we're defining an image, the first line of ATL must give a displayable. Otherwise, there would be nothing to show."
    e "因为我们要定义一个图像，ATL的第一行必须给出可视组件。否则，就没有什么可显示。"

# game/tutorial_atl.rpy:536
translate schinese tutorial_atl_3d065074:

    # e "The second and fourth lines are pause statements, which cause ATL to wait half a second each before continuing. That's how we give the delay between images."
    e "第二行和第四行是pause语句，它们使ATL在继续之前各等待半秒。这就是如何在图像之间设置延迟。"

# game/tutorial_atl.rpy:538
translate schinese tutorial_atl_60f2a5e8:

    # e "The final line is a repeat statement. This causes the current block of ATL to be restarted. You can only have one repeat statement per block."
    e "最后一行是repeat语句。这使当前的ATL块重新启动。每一块只能有一个repeat语句。"

# game/tutorial_atl.rpy:543
translate schinese tutorial_atl_146cf4c4:

    # e "If we were to write repeat 2 instead, the animation would loop twice, then stop."
    e "如果我们改为repeat 2，动画将循环两次，然后停止。"

# game/tutorial_atl.rpy:548
translate schinese tutorial_atl_d90b1838:

    # e "Omitting the repeat statement means that the animation stops once we reach the end of the block of ATL code."
    e "省略repeat语句意味着，当ATL代码运行到块的末尾，动画就会停止。"

# game/tutorial_atl.rpy:554
translate schinese tutorial_atl_e5872360:

    # e "By default, displayables are replaced instantaneously. We can also use a with clause to give a transition between displayables."
    e "可视组件默认立即替换。我们也可以使用with从句在可视组件之间进行转场。"

# game/tutorial_atl.rpy:561
translate schinese tutorial_atl_2e9d63ea:

    # e "With animation done, we'll see how we can use ATL to transform images, starting with positioning an image on the screen."
    e "动画完成后，我们将了解如何使用ATL来变换图像，从在界面上定位图像开始。"

# game/tutorial_atl.rpy:570
translate schinese tutorial_atl_ddc55039:

    # e "The simplest thing we can to is to statically position an image. This is done by giving the names of the position properties, followed by the property values."
    e "我们能做的最简单的事情就是静态定位图像。先给出位置属性的名称，然后是属性值。"

# game/tutorial_atl.rpy:575
translate schinese tutorial_atl_43516492:

    # e "With a few more statements, we can move things around on the screen."
    e "再加上一些语句，我们就可以在界面上移动物体。"

# game/tutorial_atl.rpy:577
translate schinese tutorial_atl_fb979287:

    # e "This example starts the image off at the top-right of the screen, and waits a second. It then moves it to the left side, waits another second, and repeats."
    e "本例图像开始在界面右上角，等待一秒。然后将它移到左边，再等一秒，重复。"

# game/tutorial_atl.rpy:579
translate schinese tutorial_atl_7650ec09:

    # e "The pause and repeat statements are the same statements we used in our animations. They work throughout ATL code."
    e "pause和repeat语句与我们在动画中使用的相同。它们贯穿ATL代码。"

# game/tutorial_atl.rpy:584
translate schinese tutorial_atl_d3416d4f:

    # e "Having the image jump around on the screen isn't all that useful. That's why ATL has the interpolation statement."
    e "让图像在界面上跳来跳去并没有那么有用。这就是为什么ATL有插值（interpolation）语句。"

# game/tutorial_atl.rpy:586
translate schinese tutorial_atl_4e7512ec:

    # e "The interpolation statement allows you to smoothly vary the value of a transform property, from an old to a new value."
    e "插值语句允许您将属性值平滑地从旧的变成新的。"

# game/tutorial_atl.rpy:588
translate schinese tutorial_atl_685eeeaa:

    # e "Here, we have an interpolation statement on the second ATL line. It starts off with the name of a time function, in this case linear."
    e "这里，我们在第二行ATL有一个插值语句。以时间函数名开始，在本例中是linear。"

# game/tutorial_atl.rpy:590
translate schinese tutorial_atl_c5cb49de:

    # e "That's followed by an amount of time, in this case three seconds. It ends with a list of properties, each followed by its new value."
    e "后面是时长，在本例中是三秒。以属性列表结束，每个属性后面都是新的值。"

# game/tutorial_atl.rpy:592
translate schinese tutorial_atl_04b8bc1d:

    # e "The value of each property is interpolated from its value when the statement starts to the value at the end of the statement. This is done once per frame, allowing smooth animation."
    e "每个属性的插值从语句开始时的值到语句末尾的值。每帧执行一次，以实现平滑动画。"

# game/tutorial_atl.rpy:603
translate schinese tutorial_atl_2958f397:

    # e "ATL supports more complicated move types, like circle and spline motion. But I won't be showing those here."
    e "ATL支持更复杂的移动类型，如圆和螺旋线运动。但我不会在这里展示。"

# game/tutorial_atl.rpy:607
translate schinese tutorial_atl_d08fe8d9:

    # e "Apart from displayables, pause, interpolation, and repeat, there are a few other statements we can use as part of ATL."
    e "除了可视组件、pause、插值和repeat之外，还有一些其他语句可以用作ATL的一部分。"

# game/tutorial_atl.rpy:619
translate schinese tutorial_atl_84b22ac0:

    # e "ATL transforms created using the statement become ATL statements themselves. Since the default positions are also transforms, this means that we can use left, right, and center inside of an ATL block."
    e "使用该语句创建的ATL变换本身成为ATL语句。由于默认位置也是变换，所以我们可以在ATL块内部使用左（left）、右（right）和中心（center）。"

# game/tutorial_atl.rpy:635
translate schinese tutorial_atl_331126c1:

    # e "Here, we have two new statements. The block statement allows you to include a block of ATL code. Since the repeat statement applies to blocks, this lets you repeat only part of an ATL transform."
    e "这里，我们有两个新的语句。block语句允许包含ATL代码块。由于repeat语句应用于块，所以允许只重复ATL变换的一部分。"

# game/tutorial_atl.rpy:637
translate schinese tutorial_atl_24f67b67:

    # e "We also have the time statement, which runs after the given number of seconds have elapsed from the start of the block. It will run even if another statement is running, stopping the other statement."
    e "我们还有time语句，它在给定的秒数之后开始运行块。即使另一个语句正在运行，它也会运行，而那个语句停止。"

# game/tutorial_atl.rpy:639
translate schinese tutorial_atl_b7709507:

    # e "So this example bounces the image back and forth for eleven and a half seconds, and then moves it to the right side of the screen."
    e "这个例子在11.5秒的时间里来回反射图像，然后将其移动到界面的右侧。"

# game/tutorial_atl.rpy:653
translate schinese tutorial_atl_f903bc3b:

    # e "The parallel statement lets us run two blocks of ATL code at the same time."
    e "parallel语句允许我们同时运行两个ATL代码块。"

# game/tutorial_atl.rpy:655
translate schinese tutorial_atl_5d0f8f9d:

    # e "Here, the top block move the image in the horizontal direction, and the bottom block moves it in the vertical direction. Since they're moving at different speeds, it looks like the image is bouncing on the screen."
    e "在这里，顶部块沿水平方向移动图像，底部块在垂直方向移动图像。因为它们以不同的速度移动，所以看起来像是在界面上反弹。"

# game/tutorial_atl.rpy:669
translate schinese tutorial_atl_28a7d27e:

    # e "Finally, the choice statement makes Ren'Py randomly pick a block of ATL code. This allows you to add some variation as to what Ren'Py shows."
    e "最后，choice语句使Ren'Py随机选择一个ATL代码块。这允许您给Ren'Py显示内容增加一些变化。"

# game/tutorial_atl.rpy:675
translate schinese tutorial_atl_2265254b:

    # e "This tutorial game has only scratched the surface of what you can do with ATL. For example, we haven't even covered the on and event statements. For more information, you might want to check out {a=https://renpy.org/doc/html/atl.html}the ATL chapter in the reference manual{/a}."
    e "关于ATL可以做什么，这个教程游戏只触及表面。例如，我们甚至没有讨论on和event语句。更多信息，请查看{a=https://renpy.org/doc/html/atl.html}参考手册中的ATL章节{/a}。（{a=https://renpy.cn/doc/atl.html}中文文档{/a}）"

# game/tutorial_atl.rpy:684
translate schinese transform_properties_391169cf:

    # e "Ren'Py has quite a few transform properties that can be used with ATL, the Transform displayable, and the add Screen Language statement."
    e "Ren'Py有不少可以与ATL、Transform可视组件和add界面语言语句一起使用的变换属性。"

# game/tutorial_atl.rpy:685
translate schinese transform_properties_fc895a1f:

    # e "Here, we'll show them off so you can see them in action and get used to what each does."
    e "这里，我们将展示它们，这样你就可以看到它们的实际效果，并习惯每一个的作用。"

# game/tutorial_atl.rpy:701
translate schinese transform_properties_88daf990:

    # e "First off, all of the position properties are also transform properties. These include the pos, anchor, align, center, and offset properties."
    e "首先，所有位置属性也是变换属性。这些包括pos、anchor、align、center和offset属性。"

# game/tutorial_atl.rpy:719
translate schinese transform_properties_d7a487f1:

    # e "The position properties can also be used to pan over a displayable larger than the screen, by giving xpos and ypos negative values."
    e "position属性还可以通过赋予xpos和ypos负值，在比界面更大的可视组件上平移。"

# game/tutorial_atl.rpy:729
translate schinese transform_properties_89e0d7c2:

    # "The subpixel property controls how things are lined up with the screen. When False, images can be pixel-perfect, but there can be pixel jumping."
    "subpixel属性控制图像如何与界面对齐。如果为False，图像可以是像素完美的，但也可能存在像素跳跃。"

# game/tutorial_atl.rpy:736
translate schinese transform_properties_4194527e:

    # "When it's set to True, movement is smoother at the cost of blurring images a little."
    "当设置为True时，移动更平滑，但图像会模糊一点。"

# game/tutorial_atl.rpy:755
translate schinese transform_properties_35934e77:

    # e "Transforms also support polar coordinates. The around property sets the center of the coordinate system to coordinates given in pixels."
    e "变换也支持极坐标。around属性将坐标系的中心设置为以像素为单位的坐标。"

# game/tutorial_atl.rpy:763
translate schinese transform_properties_605ebd0c:

    # e "The angle property gives the angle in degrees. Angles run clockwise, with the zero angle at the top of the screen."
    e "angle属性以度（degree）表示角度。角度按顺时针计算，零度在界面顶部。"

# game/tutorial_atl.rpy:772
translate schinese transform_properties_6d4555ed:

    # e "The radius property gives the distance in pixels from the anchor of the displayable to the center of the coordinate system."
    e "radius属性给出从可视组件的锚点到坐标系中心的像素距离。"

# game/tutorial_atl.rpy:786
translate schinese transform_properties_7af037a5:

    # e "There are several ways to resize a displayable. The zoom property lets us scale a displayable by a factor, making it bigger and smaller."
    e "有几种方法可以调整可视组件的大小。zoom属性允许按倍数缩放可视组件，使其变大变小。"

# game/tutorial_atl.rpy:799
translate schinese transform_properties_b6527546:

    # e "The xzoom and yzoom properties allow the displayable to be scaled in the X and Y directions independently."
    e "xzoom和yzoom属性允许可视组件独立地在X和Y方向上缩放。"

# game/tutorial_atl.rpy:809
translate schinese transform_properties_b98b780b:

    # e "By making xzoom or yzoom a negative number, we can flip the image horizontally or vertically."
    e "通过将xzoom或yzoom设为负数，我们可以水平或垂直翻转图像。"

# game/tutorial_atl.rpy:819
translate schinese transform_properties_74d542ff:

    # e "Instead of zooming by a scale factor, the size transform property can be used to scale a displayable to a size in pixels."
    e "与按比例倍数缩放不同，size变换属性可用于将可视组件缩放缩放到指定的像素大小。"

# game/tutorial_atl.rpy:834
translate schinese transform_properties_438ed776:

    # e "The alpha property is used to change the opacity of a displayable. This can make it appear and disappear."
    e "alpha属性用于更改可视组件的不透明度。这可以使图像出现和消失。"

# game/tutorial_atl.rpy:847
translate schinese transform_properties_aee19f86:

    # e "The rotate property rotates a displayable."
    e "rotate属性旋转可视组件。"

# game/tutorial_atl.rpy:858
translate schinese transform_properties_57b3235a:

    # e "By default, when a displayable is rotated, Ren'Py will include extra space on all four sides, so the size doesn't change as it rotates. Here, you can see the extra space on the left and top, and it's also there on the right and bottom."
    e "默认情况下，可视组件旋转时，Ren'Py会在全部四个边上包含额外的空间，因此旋转时大小不会改变。这里，你能看到左侧和顶部的额外空间，以及右侧和底部也有。"

# game/tutorial_atl.rpy:870
translate schinese transform_properties_66d29ee8:

    # e "By setting rotate_pad to False, we can get rid of the space, at the cost of the size of the displayable changing as it rotates."
    e "通过将rotate_pad设置为False，我们可以去除空间，但代价是可视组件的大小随着旋转而改变。"

# game/tutorial_atl.rpy:881
translate schinese transform_properties_7f32e8ad:

    # e "The tile transform properties, xtile and ytile, repeat the displayable multiple times."
    e "tile变换属性，xtile和ytile，重复可视组件数次。"

# game/tutorial_atl.rpy:891
translate schinese transform_properties_207b7fc8:

    # e "The crop property crops a rectangle out of a displayable, showing only part of it."
    e "crop属性从可视组件中裁剪一个矩形，仅显示一部分。"

# game/tutorial_atl.rpy:905
translate schinese transform_properties_e7e22d28:

    # e "When used together, crop and size can be used to focus in on specific parts of an image."
    e "当crop和size一起使用时，可用于聚焦图像的特定部分。"

# game/tutorial_atl.rpy:917
translate schinese transform_properties_f34abd82:

    # e "The xpan and ypan properties can be used to pan over a displayable, given an angle in degrees, with 0 being the center."
    e "xpan和ypan属性可用于在给定角度（以度为单位）上平移可视组件，0为中心。"

# game/tutorial_atl.rpy:924
translate schinese transform_properties_bfa3b139:

    # e "Those are all the transform properties we have to work with. By putting them together in the right order, you can create complex things."
    e "这些都是我们必须知道的变换属性。把它们按正确的顺序放在一起，你就能创造出复杂的东西。"

translate schinese strings:

    # game/tutorial_atl.rpy:267
    old "xpos 1.0 ypos .5"
    new "xpos 1.0 ypos .5"

    # game/tutorial_atl.rpy:267
    old "xpos .75 ypos .25"
    new "xpos .75 ypos .25"

    # game/tutorial_atl.rpy:267
    old "xpos .25 ypos .33"
    new "xpos .25 ypos .33"
