/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.ivy.util.url.URLHandler;

public abstract class AbstractURLHandler
implements URLHandler {
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("%25([0-9a-fA-F][0-9a-fA-F])");
    private static int requestMethod = 2;

    @Override
    public void setRequestMethod(int n) {
        requestMethod = n;
    }

    public int getRequestMethod() {
        return requestMethod;
    }

    protected String normalizeToString(URL uRL) throws IOException {
        if (!"http".equals(uRL.getProtocol()) && !"https".equals(uRL.getProtocol())) {
            return uRL.toExternalForm();
        }
        try {
            URI uRI = new URI(uRL.getProtocol(), uRL.getAuthority(), uRL.getPath(), uRL.getQuery(), uRL.getRef());
            String string = uRI.normalize().toASCIIString();
            string = string.replaceAll("\\+", "%2B");
            return ESCAPE_PATTERN.matcher(string).replaceAll("%$1");
        }
        catch (URISyntaxException uRISyntaxException) {
            MalformedURLException malformedURLException = new MalformedURLException("Couldn't convert '" + uRL.toString() + "' to a valid URI");
            malformedURLException.initCause(uRISyntaxException);
            throw malformedURLException;
        }
    }

    protected URL normalizeToURL(URL uRL) throws IOException {
        if (!"http".equals(uRL.getProtocol()) && !"https".equals(uRL.getProtocol())) {
            return uRL;
        }
        return new URL(this.normalizeToString(uRL));
    }

    protected InputStream getDecodingInputStream(String object, InputStream inputStream) throws IOException {
        if ("gzip".equals(object) || "x-gzip".equals(object)) {
            object = new GZIPInputStream(inputStream);
        } else if ("deflate".equals(object)) {
            inputStream = new BufferedInputStream(inputStream);
            ((BufferedInputStream)inputStream).mark(100);
            object = new byte[100];
            int n = ((FilterInputStream)inputStream).read((byte[])object);
            ((BufferedInputStream)inputStream).reset();
            Inflater inflater = new Inflater();
            inflater.setInput((byte[])object, 0, n);
            try {
                inflater.inflate(new byte[1000]);
                object = new InflaterInputStream(inputStream);
            }
            catch (DataFormatException dataFormatException) {
                object = new InflaterInputStream(inputStream, new Inflater(true));
            }
            finally {
                inflater.end();
            }
        } else {
            object = inputStream;
        }
        return object;
    }
}

