/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.diagram;

import java.util.HashSet;
import java.util.Set;

public enum LifelineFlag {
    ANONYMOUS('a'),
    ROLE('r'),
    PROCESS('p'),
    THREAD('t'),
    AUTOMATIC('x'),
    EXTERNAL('e'),
    VARIABLE('v');

    private char c;

    private LifelineFlag(char c) {
        this.c = c;
    }

    public static Set<LifelineFlag> getFlags(String str) {
        if (str == null) {
            return null;
        }
        HashSet<LifelineFlag> flags = new HashSet<LifelineFlag>();
        for (int i = 0; i < str.length(); ++i) {
            for (LifelineFlag flag : LifelineFlag.values()) {
                if (flag.c != str.charAt(i)) continue;
                flags.add(flag);
            }
        }
        return flags;
    }

    public boolean in(Set<LifelineFlag> flags) {
        if (flags == null) {
            return false;
        }
        return flags.contains((Object)this);
    }

    public static String toString(Set<LifelineFlag> flags) {
        String str = "";
        for (LifelineFlag flag : flags) {
            str = str + flag.c;
        }
        return str;
    }
}

