/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.AsyncHandlerInterceptor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class HandlerExecutionChain {
    private static final Log logger = LogFactory.getLog(HandlerExecutionChain.class);
    private final Object handler;
    @Nullable
    private HandlerInterceptor[] interceptors;
    @Nullable
    private List<HandlerInterceptor> interceptorList;
    private int interceptorIndex = -1;

    public HandlerExecutionChain(Object handler) {
        this(handler, null);
    }

    public HandlerExecutionChain(Object handler, HandlerInterceptor ... interceptors) {
        if (handler instanceof HandlerExecutionChain) {
            HandlerExecutionChain originalChain = (HandlerExecutionChain)handler;
            this.handler = originalChain.getHandler();
            this.interceptorList = new ArrayList<HandlerInterceptor>();
            CollectionUtils.mergeArrayIntoCollection((Object)originalChain.getInterceptors(), this.interceptorList);
            CollectionUtils.mergeArrayIntoCollection((Object)interceptors, this.interceptorList);
        } else {
            this.handler = handler;
            this.interceptors = interceptors;
        }
    }

    public Object getHandler() {
        return this.handler;
    }

    public void addInterceptor(HandlerInterceptor interceptor) {
        this.initInterceptorList().add(interceptor);
    }

    public void addInterceptor(int index, HandlerInterceptor interceptor) {
        this.initInterceptorList().add(index, interceptor);
    }

    public void addInterceptors(HandlerInterceptor ... interceptors) {
        if (!ObjectUtils.isEmpty((Object[])interceptors)) {
            CollectionUtils.mergeArrayIntoCollection((Object)interceptors, this.initInterceptorList());
        }
    }

    private List<HandlerInterceptor> initInterceptorList() {
        if (this.interceptorList == null) {
            this.interceptorList = new ArrayList<HandlerInterceptor>();
            if (this.interceptors != null) {
                CollectionUtils.mergeArrayIntoCollection((Object)this.interceptors, this.interceptorList);
            }
        }
        this.interceptors = null;
        return this.interceptorList;
    }

    @Nullable
    public HandlerInterceptor[] getInterceptors() {
        if (this.interceptors == null && this.interceptorList != null) {
            this.interceptors = this.interceptorList.toArray(new HandlerInterceptor[0]);
        }
        return this.interceptors;
    }

    boolean applyPreHandle(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object[] interceptors = this.getInterceptors();
        if (!ObjectUtils.isEmpty((Object[])interceptors)) {
            int i2 = 0;
            while (i2 < interceptors.length) {
                Object interceptor = interceptors[i2];
                if (!interceptor.preHandle(request, response, this.handler)) {
                    this.triggerAfterCompletion(request, response, null);
                    return false;
                }
                this.interceptorIndex = i2++;
            }
        }
        return true;
    }

    void applyPostHandle(HttpServletRequest request, HttpServletResponse response, @Nullable ModelAndView mv) throws Exception {
        Object[] interceptors = this.getInterceptors();
        if (!ObjectUtils.isEmpty((Object[])interceptors)) {
            for (int i2 = interceptors.length - 1; i2 >= 0; --i2) {
                Object interceptor = interceptors[i2];
                interceptor.postHandle(request, response, this.handler, mv);
            }
        }
    }

    void triggerAfterCompletion(HttpServletRequest request, HttpServletResponse response, @Nullable Exception ex) throws Exception {
        Object[] interceptors = this.getInterceptors();
        if (!ObjectUtils.isEmpty((Object[])interceptors)) {
            for (int i2 = this.interceptorIndex; i2 >= 0; --i2) {
                Object interceptor = interceptors[i2];
                try {
                    interceptor.afterCompletion(request, response, this.handler, ex);
                    continue;
                }
                catch (Throwable ex2) {
                    logger.error((Object)"HandlerInterceptor.afterCompletion threw exception", ex2);
                }
            }
        }
    }

    void applyAfterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response) {
        Object[] interceptors = this.getInterceptors();
        if (!ObjectUtils.isEmpty((Object[])interceptors)) {
            for (int i2 = interceptors.length - 1; i2 >= 0; --i2) {
                Object interceptor = interceptors[i2];
                if (!(interceptor instanceof AsyncHandlerInterceptor)) continue;
                try {
                    AsyncHandlerInterceptor asyncInterceptor = (AsyncHandlerInterceptor)interceptor;
                    asyncInterceptor.afterConcurrentHandlingStarted(request, response, this.handler);
                    continue;
                }
                catch (Throwable ex) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error((Object)("Interceptor [" + interceptor + "] failed in afterConcurrentHandlingStarted"), ex);
                }
            }
        }
    }

    public String toString() {
        Object handler = this.getHandler();
        StringBuilder sb = new StringBuilder();
        sb.append("HandlerExecutionChain with [").append(handler).append("] and ");
        if (this.interceptorList != null) {
            sb.append(this.interceptorList.size());
        } else if (this.interceptors != null) {
            sb.append(this.interceptors.length);
        } else {
            sb.append(0);
        }
        return sb.append(" interceptors").toString();
    }
}

