/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;

public abstract class HighlightingPluginBase
implements SolrInfoBean,
SolrMetricProducer {
    protected Counter numRequests;
    protected SolrParams defaults;
    protected Set<String> metricNames = ConcurrentHashMap.newKeySet(1);
    protected MetricRegistry registry;
    protected SolrMetricManager metricManager;
    protected String registryName;

    public void init(NamedList args) {
        Object o;
        if (args != null && (o = args.get("defaults")) != null && o instanceof NamedList) {
            this.defaults = ((NamedList)o).toSolrParams();
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public abstract String getDescription();

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.HIGHLIGHTER;
    }

    @Override
    public Set<String> getMetricNames() {
        return this.metricNames;
    }

    @Override
    public MetricRegistry getMetricRegistry() {
        return this.registry;
    }

    @Override
    public void initializeMetrics(SolrMetricManager manager, String registryName, String tag, String scope) {
        this.registryName = registryName;
        this.metricManager = manager;
        this.registry = manager.registry(registryName);
        this.numRequests = manager.counter(this, registryName, "requests", this.getCategory().toString(), scope);
    }
}

