/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.util.function.BooleanConsumer;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.common.SolrException;

class StreamEqualFunction
extends BooleanValueStream.AbstractBooleanValueStream {
    private final AnalyticsValue baseExpr;
    private final AnalyticsValueStream compExpr;
    public static final String name = "equal";
    private final String funcStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public StreamEqualFunction(AnalyticsValue baseExpr, AnalyticsValueStream compExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.compExpr = compExpr;
        this.funcStr = AnalyticsValueStream.createExpressionString(name, baseExpr, compExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, baseExpr, compExpr);
    }

    @Override
    public void streamBooleans(BooleanConsumer cons) {
        Object baseValue = this.baseExpr.getObject();
        if (this.baseExpr.exists()) {
            this.compExpr.streamObjects(compValue -> cons.accept(baseValue.equals(compValue)));
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.funcStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

