/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import java.util.function.UnaryOperator;
import org.apache.solr.analytics.function.ReductionFunction;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.function.reduction.data.SortedListCollector;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;

class DateMedianFunction
extends DateValue.AbstractDateValue
implements ReductionFunction {
    private SortedListCollector.SortedLongListCollector collector;
    public static final String name = "median";
    private final String exprStr;

    public DateMedianFunction(DateValueStream param) {
        this.collector = new SortedListCollector.SortedLongListCollector(param);
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
    }

    @Override
    public long getLong() {
        int size = this.collector.size();
        if (size == 0) {
            return 0L;
        }
        if (size % 2 == 0) {
            return ((Long)this.collector.get(size / 2) + (Long)this.collector.get(size / 2 - 1)) / 2L;
        }
        return (Long)this.collector.get(size / 2);
    }

    @Override
    public boolean exists() {
        return this.collector.size() > 0;
    }

    @Override
    public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
        this.collector = (SortedListCollector.SortedLongListCollector)sync.apply(this.collector);
        this.collector.calcMedian();
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return AnalyticsValueStream.ExpressionType.REDUCTION;
    }
}

