/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.jetty;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jetty.JettyServerThreadPoolMetrics;
import java.util.Collections;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.embedded.jetty.JettyWebServer;
import org.springframework.boot.web.server.WebServer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

public class JettyServerThreadPoolMetricsBinder
implements ApplicationListener<ApplicationStartedEvent> {
    private final MeterRegistry meterRegistry;
    private final Iterable<Tag> tags;

    public JettyServerThreadPoolMetricsBinder(MeterRegistry meterRegistry) {
        this(meterRegistry, Collections.emptyList());
    }

    public JettyServerThreadPoolMetricsBinder(MeterRegistry meterRegistry, Iterable<Tag> tags) {
        this.meterRegistry = meterRegistry;
        this.tags = tags;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        ThreadPool threadPool = this.findThreadPool((ApplicationContext)applicationContext);
        if (threadPool != null) {
            new JettyServerThreadPoolMetrics(threadPool, this.tags).bindTo(this.meterRegistry);
        }
    }

    private ThreadPool findThreadPool(ApplicationContext applicationContext) {
        WebServer webServer;
        if (applicationContext instanceof WebServerApplicationContext && (webServer = ((WebServerApplicationContext)applicationContext).getWebServer()) instanceof JettyWebServer) {
            return ((JettyWebServer)webServer).getServer().getThreadPool();
        }
        return null;
    }
}

