/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.suggest.DocumentDictionary;
import org.apache.lucene.search.suggest.InputIterator;

public class DocumentValueSourceDictionary
extends DocumentDictionary {
    private final LongValuesSource weightsValueSource;

    public DocumentValueSourceDictionary(IndexReader reader, String field, LongValuesSource weightsValueSource, String payload, String contexts) {
        super(reader, field, null, payload, contexts);
        this.weightsValueSource = weightsValueSource;
    }

    public DocumentValueSourceDictionary(IndexReader reader, String field, LongValuesSource weightsValueSource, String payload) {
        super(reader, field, null, payload);
        this.weightsValueSource = weightsValueSource;
    }

    public DocumentValueSourceDictionary(IndexReader reader, String field, LongValuesSource weightsValueSource) {
        super(reader, field, null, null);
        this.weightsValueSource = weightsValueSource;
    }

    @Override
    public InputIterator getEntryIterator() throws IOException {
        return new DocumentValueSourceInputIterator(this.payloadField != null, this.contextsField != null);
    }

    final class DocumentValueSourceInputIterator
    extends DocumentDictionary.DocumentInputIterator {
        private LongValues currentWeightValues;
        private final List<LeafReaderContext> leaves;
        private final int[] starts;
        private int currentLeafIndex;

        public DocumentValueSourceInputIterator(boolean hasPayloads, boolean hasContexts) throws IOException {
            super(hasPayloads, hasContexts);
            this.currentLeafIndex = 0;
            this.leaves = DocumentValueSourceDictionary.this.reader.leaves();
            this.starts = new int[this.leaves.size() + 1];
            for (int i = 0; i < this.leaves.size(); ++i) {
                this.starts[i] = this.leaves.get((int)i).docBase;
            }
            this.starts[this.leaves.size()] = DocumentValueSourceDictionary.this.reader.maxDoc();
            this.currentWeightValues = this.leaves.size() > 0 ? DocumentValueSourceDictionary.this.weightsValueSource.getValues(this.leaves.get(this.currentLeafIndex), null) : null;
        }

        @Override
        protected long getWeight(Document doc, int docId) throws IOException {
            if (this.currentWeightValues == null) {
                return 0L;
            }
            int subIndex = ReaderUtil.subIndex((int)docId, (int[])this.starts);
            if (subIndex != this.currentLeafIndex) {
                this.currentLeafIndex = subIndex;
                this.currentWeightValues = DocumentValueSourceDictionary.this.weightsValueSource.getValues(this.leaves.get(this.currentLeafIndex), null);
            }
            if (this.currentWeightValues.advanceExact(docId - this.starts[subIndex])) {
                return this.currentWeightValues.longValue();
            }
            return 0L;
        }
    }
}

