/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUnaryBiVisitor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LogicVisitor
extends RexUnaryBiVisitor<RelOptUtil.Logic> {
    private final RexNode seek;
    private final Collection<RelOptUtil.Logic> logicCollection;

    private LogicVisitor(RexNode seek, Collection<RelOptUtil.Logic> logicCollection) {
        super(true);
        this.seek = seek;
        this.logicCollection = logicCollection;
    }

    public static RelOptUtil.Logic find(RelOptUtil.Logic logic, List<RexNode> nodes, RexNode seek) {
        EnumSet<RelOptUtil.Logic> set = EnumSet.noneOf(RelOptUtil.Logic.class);
        LogicVisitor visitor = new LogicVisitor(seek, set);
        for (RexNode node : nodes) {
            node.accept(visitor, logic);
        }
        if (set.remove((Object)RelOptUtil.Logic.FALSE)) {
            set.add(RelOptUtil.Logic.UNKNOWN_AS_TRUE);
        }
        switch (set.size()) {
            case 0: {
                throw new IllegalArgumentException("not found: " + seek);
            }
            case 1: {
                return (RelOptUtil.Logic)((Object)Iterables.getOnlyElement(set));
            }
        }
        return RelOptUtil.Logic.TRUE_FALSE_UNKNOWN;
    }

    public static void collect(RexNode node, RexNode seek, RelOptUtil.Logic logic, List<RelOptUtil.Logic> logicList) {
        node.accept(new LogicVisitor(seek, logicList), logic);
        Collections.replaceAll(logicList, RelOptUtil.Logic.FALSE, RelOptUtil.Logic.UNKNOWN_AS_TRUE);
    }

    @Override
    public @Nullable RelOptUtil.Logic visitCall(RexCall call, @Nullable RelOptUtil.Logic logic) {
        RelOptUtil.Logic arg0 = logic;
        switch (call.getKind()) {
            case IS_NOT_NULL: 
            case IS_NULL: {
                logic = RelOptUtil.Logic.TRUE_FALSE_UNKNOWN;
                break;
            }
            case IS_TRUE: 
            case IS_NOT_TRUE: {
                logic = RelOptUtil.Logic.UNKNOWN_AS_FALSE;
                break;
            }
            case IS_FALSE: 
            case IS_NOT_FALSE: {
                logic = RelOptUtil.Logic.UNKNOWN_AS_TRUE;
                break;
            }
            case NOT: {
                logic = Objects.requireNonNull(logic, "logic").negate2();
                break;
            }
            case CASE: {
                logic = RelOptUtil.Logic.TRUE_FALSE_UNKNOWN;
                break;
            }
        }
        block7 : switch (Objects.requireNonNull(logic, "logic")) {
            case TRUE: {
                switch (call.getKind()) {
                    case AND: {
                        break block7;
                    }
                }
                logic = RelOptUtil.Logic.TRUE_FALSE_UNKNOWN;
                break;
            }
        }
        for (RexNode operand : call.operands) {
            operand.accept(this, logic);
        }
        return this.end((RexNode)call, arg0);
    }

    @Override
    protected @Nullable RelOptUtil.Logic end(RexNode node, @Nullable RelOptUtil.Logic arg) {
        if (node.equals(this.seek)) {
            this.logicCollection.add(Objects.requireNonNull(arg, "arg"));
        }
        return arg;
    }

    @Override
    public @Nullable RelOptUtil.Logic visitOver(RexOver over, @Nullable RelOptUtil.Logic arg) {
        return this.end((RexNode)over, arg);
    }

    @Override
    public @Nullable RelOptUtil.Logic visitFieldAccess(RexFieldAccess fieldAccess, @Nullable RelOptUtil.Logic arg) {
        return this.end((RexNode)fieldAccess, arg);
    }

    @Override
    public @Nullable RelOptUtil.Logic visitSubQuery(RexSubQuery subQuery, @Nullable RelOptUtil.Logic arg) {
        if (!subQuery.getType().isNullable() && arg == RelOptUtil.Logic.TRUE_FALSE_UNKNOWN) {
            arg = RelOptUtil.Logic.TRUE_FALSE;
        }
        return this.end((RexNode)subQuery, arg);
    }
}

