/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Static;

public class SqlWithinGroupOperator
extends SqlBinaryOperator {
    public SqlWithinGroupOperator() {
        super("WITHIN GROUP", SqlKind.WITHIN_GROUP, 100, true, ReturnTypes.ARG0, null, (SqlOperandTypeChecker)OperandTypes.ANY_IGNORE);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() == 2);
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.keyword("WITHIN GROUP");
        SqlWriter.Frame orderFrame = writer.startList(SqlWriter.FrameTypeEnum.ORDER_BY_LIST, "(", ")");
        writer.keyword("ORDER BY");
        ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
        writer.endList(orderFrame);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        assert (call.getOperator() == this);
        assert (call.operandCount() == 2);
        SqlValidatorUtil.FlatAggregate flat = SqlValidatorUtil.flatten(call);
        if (!flat.aggregateCall.getOperator().isAggregator()) {
            throw validator.newValidationError(call, Static.RESOURCE.withinGroupNotAllowed(flat.aggregateCall.getOperator().getName()));
        }
        for (SqlNode order : Objects.requireNonNull(flat.orderList)) {
            Objects.requireNonNull(validator.deriveType(scope, order));
        }
        validator.validateAggregateParams(flat.aggregateCall, flat.filter, flat.distinctList, flat.orderList, scope);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        return this.validateOperands(validator, scope, call);
    }
}

